// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
//
// End prologue.

#include <bdep/init-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // cmd_init_options
  //

  cmd_init_options::
  cmd_init_options ()
  : empty_ (),
    config_add_ (),
    config_add_specified_ (false),
    config_create_ (),
    config_create_specified_ (false),
    no_sync_ (),
    sys_no_query_ (),
    sys_install_ (),
    sys_no_fetch_ (),
    sys_no_stub_ (),
    sys_yes_ (),
    sys_sudo_ ("sudo"),
    sys_sudo_specified_ (false),
    create_host_config_ (),
    create_build2_config_ ()
  {
  }

  bool cmd_init_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_init_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_init_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_init_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_init_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_init_options::
  merge (const cmd_init_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // configuration_add_options base
    //
    ::bdep::configuration_add_options::merge (a);

    // project_options base
    //
    ::bdep::project_options::merge (a);

    if (a.empty_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->empty_, a.empty_);
    }

    if (a.config_add_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->config_add_, a.config_add_);
      this->config_add_specified_ = true;
    }

    if (a.config_create_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->config_create_, a.config_create_);
      this->config_create_specified_ = true;
    }

    if (a.no_sync_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_sync_, a.no_sync_);
    }

    if (a.sys_no_query_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_no_query_, a.sys_no_query_);
    }

    if (a.sys_install_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_install_, a.sys_install_);
    }

    if (a.sys_no_fetch_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_no_fetch_, a.sys_no_fetch_);
    }

    if (a.sys_no_stub_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_no_stub_, a.sys_no_stub_);
    }

    if (a.sys_yes_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_yes_, a.sys_yes_);
    }

    if (a.sys_sudo_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->sys_sudo_, a.sys_sudo_);
      this->sys_sudo_specified_ = true;
    }

    if (a.create_host_config_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->create_host_config_, a.create_host_config_);
    }

    if (a.create_build2_config_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->create_build2_config_, a.create_build2_config_);
    }
  }

  ::bdep::cli::usage_para cmd_init_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mINIT OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--empty\033[0m|\033[1m-E\033[0m                Initialize an empty build configuration set." << ::std::endl;

    os << std::endl
       << "\033[1m--config-add\033[0m|\033[1m-A\033[0m \033[4mdir\033[0m       Add an existing build configuration \033[4mdir\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--config-create\033[0m|\033[1m-C\033[0m \033[4mdir\033[0m    Create a new build configuration in \033[4mdir\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--no-sync\033[0m                 Enter the project into the database but do not" << ::std::endl
       << "                          initialize it in the build configurations. The" << ::std::endl
       << "                          initialization can be finished later with an explicit" << ::std::endl
       << "                          \033[1mbdep-sync(1)\033[0m command." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-query\033[0m            Do not query the system package manager for the" << ::std::endl
       << "                          installed versions of packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme. See the corresponding \033[1mbpkg-pkg-build(1)\033[0m" << ::std::endl
       << "                          option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-install\033[0m             Instruct the system package manager to install" << ::std::endl
       << "                          available versions of packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme that are not already installed. See the" << ::std::endl
       << "                          corresponding \033[1mbpkg-pkg-build(1)\033[0m option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-fetch\033[0m            Do not fetch the system package manager metadata" << ::std::endl
       << "                          before querying for available versions of packages" << ::std::endl
       << "                          specified with the \033[1msys\033[0m scheme. See the corresponding" << ::std::endl
       << "                          \033[1mbpkg-pkg-build(1)\033[0m option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-stub\033[0m             Do no require a stub for packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme. See the corresponding \033[1mbpkg-pkg-build(1)\033[0m" << ::std::endl
       << "                          option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-yes\033[0m                 Assume the answer to the system package manager" << ::std::endl
       << "                          prompts is \033[1myes\033[0m. See the corresponding" << ::std::endl
       << "                          \033[1mbpkg-pkg-build(1)\033[0m option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-sudo\033[0m \033[4mprog\033[0m           The \033[1msudo\033[0m program to use for system package manager" << ::std::endl
       << "                          interactions that normally require administrative" << ::std::endl
       << "                          privileges (fetch package metadata, install packages," << ::std::endl
       << "                          etc). See the corresponding \033[1mbpkg-pkg-build(1)\033[0m option" << ::std::endl
       << "                          for details." << ::std::endl;

    os << std::endl
       << "\033[1m--create-host-config\033[0m      Create a configuration for build-time dependencies" << ::std::endl
       << "                          without prompt (see \033[1mbdep-sync(1)\033[0m for details)." << ::std::endl;

    os << std::endl
       << "\033[1m--create-build2-config\033[0m    Create a configuration for build system module" << ::std::endl
       << "                          dependencies without prompt (see \033[1mbdep-sync(1)\033[0m for" << ::std::endl
       << "                          details)." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // configuration_add_options base
    //
    p = ::bdep::configuration_add_options::print_usage (os, p);

    // project_options base
    //
    p = ::bdep::project_options::print_usage (os, p);

    return p;
  }

  struct _cli_cmd_init_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_init_options_desc_type ()
    {
      ::bdep::cmd_init_options::fill (*this);
    }
  };

  void cmd_init_options::
  fill (::bdep::cli::options& os)
  {
    // configuration_add_options base
    //
    ::bdep::configuration_add_options::fill (os);

    // project_options base
    //
    ::bdep::project_options::fill (os);

    // --empty
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-E");
      std::string dv;
      ::bdep::cli::option o ("--empty", a, true, dv);
      os.push_back (o);
    }

    // --config-add
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-A");
      std::string dv;
      ::bdep::cli::option o ("--config-add", a, false, dv);
      os.push_back (o);
    }

    // --config-create
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-C");
      std::string dv;
      ::bdep::cli::option o ("--config-create", a, false, dv);
      os.push_back (o);
    }

    // --no-sync
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-sync", a, true, dv);
      os.push_back (o);
    }

    // --sys-no-query
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-no-query", a, true, dv);
      os.push_back (o);
    }

    // --sys-install
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-install", a, true, dv);
      os.push_back (o);
    }

    // --sys-no-fetch
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-no-fetch", a, true, dv);
      os.push_back (o);
    }

    // --sys-no-stub
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-no-stub", a, true, dv);
      os.push_back (o);
    }

    // --sys-yes
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-yes", a, true, dv);
      os.push_back (o);
    }

    // --sys-sudo
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("sudo");
      ::bdep::cli::option o ("--sys-sudo", a, false, dv);
      os.push_back (o);
    }

    // --create-host-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--create-host-config", a, true, dv);
      os.push_back (o);
    }

    // --create-build2-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--create-build2-config", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_init_options::
  description ()
  {
    static _cli_cmd_init_options_desc_type _cli_cmd_init_options_desc_;
    return _cli_cmd_init_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_init_options&, ::bdep::cli::scanner&)>
  _cli_cmd_init_options_map;

  static _cli_cmd_init_options_map _cli_cmd_init_options_map_;

  struct _cli_cmd_init_options_map_init
  {
    _cli_cmd_init_options_map_init ()
    {
      _cli_cmd_init_options_map_["--empty"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::empty_ >;
      _cli_cmd_init_options_map_["-E"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::empty_ >;
      _cli_cmd_init_options_map_["--config-add"] =
      &::bdep::cli::thunk< cmd_init_options, dir_path, &cmd_init_options::config_add_,
        &cmd_init_options::config_add_specified_ >;
      _cli_cmd_init_options_map_["-A"] =
      &::bdep::cli::thunk< cmd_init_options, dir_path, &cmd_init_options::config_add_,
        &cmd_init_options::config_add_specified_ >;
      _cli_cmd_init_options_map_["--config-create"] =
      &::bdep::cli::thunk< cmd_init_options, dir_path, &cmd_init_options::config_create_,
        &cmd_init_options::config_create_specified_ >;
      _cli_cmd_init_options_map_["-C"] =
      &::bdep::cli::thunk< cmd_init_options, dir_path, &cmd_init_options::config_create_,
        &cmd_init_options::config_create_specified_ >;
      _cli_cmd_init_options_map_["--no-sync"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::no_sync_ >;
      _cli_cmd_init_options_map_["--sys-no-query"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::sys_no_query_ >;
      _cli_cmd_init_options_map_["--sys-install"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::sys_install_ >;
      _cli_cmd_init_options_map_["--sys-no-fetch"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::sys_no_fetch_ >;
      _cli_cmd_init_options_map_["--sys-no-stub"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::sys_no_stub_ >;
      _cli_cmd_init_options_map_["--sys-yes"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::sys_yes_ >;
      _cli_cmd_init_options_map_["--sys-sudo"] =
      &::bdep::cli::thunk< cmd_init_options, string, &cmd_init_options::sys_sudo_,
        &cmd_init_options::sys_sudo_specified_ >;
      _cli_cmd_init_options_map_["--create-host-config"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::create_host_config_ >;
      _cli_cmd_init_options_map_["--create-build2-config"] =
      &::bdep::cli::thunk< cmd_init_options, &cmd_init_options::create_build2_config_ >;
    }
  };

  static _cli_cmd_init_options_map_init _cli_cmd_init_options_map_init_;

  bool cmd_init_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_init_options_map::const_iterator i (_cli_cmd_init_options_map_.find (o));

    if (i != _cli_cmd_init_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // configuration_add_options base
    //
    if (::bdep::configuration_add_options::_parse (o, s))
      return true;

    // project_options base
    //
    if (::bdep::project_options::_parse (o, s))
      return true;

    return false;
  }

  bool cmd_init_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_init_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep init\033[0m [\033[4moptions\033[0m] [\033[4mpkg-spec\033[0m] [\033[4mcfg-spec\033[0m] [\033[4mpkg-args\033[0m]" << ::std::endl
       << "\033[1mbdep init\033[0m [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[1m--empty|-E\033[0m" << ::std::endl
       << "\033[1mbdep init\033[0m [\033[4moptions\033[0m] [\033[4mpkg-spec\033[0m] \033[1m--config-add|-A\033[0m \033[4mcfg-dir\033[0m [\033[1m@\033[0m\033[4mcfg-name\033[0m]" << ::std::endl
       << "          [\033[4mpkg-args\033[0m]" << ::std::endl
       << "\033[1mbdep init\033[0m [\033[4moptions\033[0m] [\033[4mpkg-spec\033[0m] \033[1m--config-create|-C\033[0m \033[4mcfg-dir\033[0m [\033[1m@\033[0m\033[4mcfg-name\033[0m]" << ::std::endl
       << "          [\033[4mcfg-args\033[0m] [\033[1m--\033[0m \033[4mpkg-args\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mcfg-spec\033[0m = (\033[1m@\033[0m\033[4mcfg-name\033[0m | \033[1m--config\033[0m|\033[1m-c\033[0m \033[4mcfg-dir\033[0m)... | \033[1m--all\033[0m|\033[1m-a\033[0m" << ::std::endl
       << "\033[4mpkg-spec\033[0m = (\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mpkg-dir\033[0m)... | \033[4mprj-spec\033[0m" << ::std::endl
       << "\033[4mprj-spec\033[0m = \033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mprj-dir\033[0m" << ::std::endl
       << "\033[4mpkg-args\033[0m = (\033[1m?\033[0m\033[4mpkg\033[0m | \033[4mcfg-var\033[0m)..." << ::std::endl
       << "\033[4mcfg-args\033[0m = [\033[1m--\033[0m [\033[4mbpkg-options\033[0m]] [\033[1m--existing\033[0m|\033[1m-e\033[0m | (\033[4mmodule\033[0m | \033[4mcfg-var\033[0m)...]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1minit\033[0m command initializes a project in one or more build configurations. The" << ::std::endl
       << "first form initializes the specified project packages (\033[4mpkg-spec\033[0m), or, if the" << ::std::endl
       << "project itself is specified (\033[4mprj-spec\033[0m), all its available packages, in one or" << ::std::endl
       << "more build configurations (\033[4mcfg-spec\033[0m) that have already been associated with the" << ::std::endl
       << "project (\033[1mbdep-config(1)\033[0m)." << ::std::endl
       << ::std::endl
       << "If no project directory is specified, then the current working directory is" << ::std::endl
       << "assumed. If no configuration is specified, then the default configuration is" << ::std::endl
       << "assumed (failing if multiple default configurations are present). See" << ::std::endl
       << "\033[1mbdep-projects-configs(1)\033[0m for details on specifying projects and configurations." << ::std::endl
       << "Optional \033[4mpkg-args\033[0m are the additional dependency packages and/or configuration" << ::std::endl
       << "variables to pass to the underlying \033[1mbpkg-pkg-build(1)\033[0m command." << ::std::endl
       << ::std::endl
       << "The second form (\033[1m--empty\033[0m is specified) initializes an empty project database" << ::std::endl
       << "that can later be used to first add build configurations (\033[1mbdep-config(1)\033[0m) and" << ::std::endl
       << "then initialize project packages using the first form." << ::std::endl
       << ::std::endl
       << "The third (\033[1m--config-add\033[0m) and fourth (\033[1m--config-create\033[0m) forms are shortcuts to" << ::std::endl
       << "first adding an existing or newly created build configuration and then" << ::std::endl
       << "initializing project packages in that configuration. Semantically they are" << ::std::endl
       << "equivalent to first performing the \033[1mconfig add\033[0m or \033[1mconfig create\033[0m commands" << ::std::endl
       << "(\033[1mbdep-config(1)\033[0m), respectively, followed by the first form. Optional \033[4mcfg-args\033[0m" << ::std::endl
       << "in the fourth form are the additional arguments to the underlying" << ::std::endl
       << "\033[1mbpkg-cfg-create(1)\033[0m command. Note that in this case to specify \033[4mpkg-args\033[0m without" << ::std::endl
       << "specifying \033[4mcfg-args\033[0m you have to use two \033[1m--\033[0m separators, for example:" << ::std::endl
       << ::std::endl
       << "$ bdep init -C ../prj-gcc @gcc -- -- ?sys:libsqlite3/*" << ::std::endl
       << ::std::endl
       << "Configuration variables can be specified to only apply to specific packages in" << ::std::endl
       << "\033[4mpkg-args\033[0m using the argument grouping mechanism (\033[1mbdep-argument-grouping(1)\033[0m)." << ::std::endl
       << "Additionally, such packages can be placed into specific linked configurations" << ::std::endl
       << "by specifying the configuration with one of the \033[1m--config*\033[0m options (or \033[1m@\033[0m" << ::std::endl
       << "notation) using the same grouping mechanism. For example (assuming \033[1mgcc\033[0m is" << ::std::endl
       << "linked to \033[1mcommon\033[0m):" << ::std::endl
       << ::std::endl
       << "$ bdep init @gcc { @common config.liblarge.extra=true }+ ?liblarge" << ::std::endl
       << ::std::endl
       << "\033[1mEXAMPLES\033[0m" << ::std::endl
       << ::std::endl
       << "As an example, consider project \033[1mprj\033[0m with two packages, \033[1mfoo\033[0m and \033[1mlibfoo\033[0m:" << ::std::endl
       << ::std::endl
       << "prj/" << ::std::endl
       << "|-- foo/" << ::std::endl
       << "`-- libfoo/" << ::std::endl
       << ::std::endl
       << "The following invocations illustrate the common \033[1minit\033[0m use cases (the current" << ::std::endl
       << "working directory is shown before the shell prompt)." << ::std::endl
       << ::std::endl
       << "Create new build configuration in \033[1m../prj-gcc\033[0m, call it \033[1mgcc\033[0m, and initialize" << ::std::endl
       << "project packages \033[1mfoo\033[0m and \033[1mlibfoo\033[0m in this configuration:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep init -C ../prj-gcc @gcc cc config.cxx=g++" << ::std::endl
       << ::std::endl
       << "Create new build configuration in \033[1m../prj-clang\033[0m using \033[1mbpkg-cfg-create(1)\033[0m. Then" << ::std::endl
       << "add it calling it \033[1mclang\033[0m and initialize project package \033[1mfoo\033[0m in this" << ::std::endl
       << "configuration:" << ::std::endl
       << ::std::endl
       << "prj/$ bpkg create -d ../prj-clang cc config.cxx=clang++" << ::std::endl
       << "prj/$ cd foo" << ::std::endl
       << "foo/$ bdep init -A ../../prj-clang @clang" << ::std::endl
       << ::std::endl
       << "Initialize project package \033[1mlibfoo\033[0m in the build configuration \033[1mclang\033[0m:" << ::std::endl
       << ::std::endl
       << "foo/$ cd .." << ::std::endl
       << "prj/$ bdep init -d libfoo @clang" << ::std::endl
       << ::std::endl
       << "The following set of invocations achieves the same end result but using the" << ::std::endl
       << "\033[1mbdep-config(1)\033[0m command to manage configuration." << ::std::endl
       << ::std::endl
       << "Initialize an empty project database:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep init --empty" << ::std::endl
       << ::std::endl
       << "Create new build configuration in \033[1m../prj-gcc\033[0m, call it \033[1mgcc\033[0m:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep config create ../prj-gcc @gcc cc config.cxx=g++" << ::std::endl
       << ::std::endl
       << "Add existing build configuration in \033[1m../prj-clang\033[0m, call it \033[1mclang\033[0m." << ::std::endl
       << ::std::endl
       << "prj/$ bdep config add ../prj-clang @clang" << ::std::endl
       << ::std::endl
       << "Initialize project packages \033[1mfoo\033[0m and \033[1mlibfoo\033[0m in build configurations \033[1mgcc\033[0m and" << ::std::endl
       << "\033[1mclang\033[0m." << ::std::endl
       << ::std::endl
       << "prj/$ bdep init @gcc @clang" << ::std::endl
       << ::std::endl
       << "Or, alternatively, in all the build configurations:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep init -a" << ::std::endl;

    p = ::bdep::cmd_init_options::print_usage (os, ::bdep::cli::usage_para::text);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbdep-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1minit\033[0m command the search start directory is the project directory. The" << ::std::endl
       << "following options files are searched for in each directory and, if found," << ::std::endl
       << "loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bdep.options" << ::std::endl
       << "bdep-{config config-add}.options                # if --config-add|-A" << ::std::endl
       << "bdep-{config config-add config-create}.options  # if --config-create|-C" << ::std::endl
       << "bdep-init.options" << ::std::endl
       << ::std::endl
       << "The following \033[1minit\033[0m command options cannot be specified in the default options" << ::std::endl
       << "files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl
       << "--config-add|-A" << ::std::endl
       << "--config-create|-C" << ::std::endl
       << "--wipe" << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

