/*
 *
 * description of data file
 *
 * N max_grp max_mem
 * G num yomi kanji
 * M num grp secret yomi kanji phone
 * #, balnk line : comment
 * delimiter is TAB
 */
#include "config.h"

#ifdef DEBUG
/*
  #define DPRI(args...) fprintf(stderr, ## args)
*/
#define DPRI1(a) fprintf(stderr, a)
#define DPRI2(a,b) fprintf(stderr, a,b)
#define DPRI3(a,b,c) fprintf(stderr, a,b,c)
#define DPRI4(a,b,c,d) fprintf(stderr, a,b,c,d)
#define DOUT(x) (void) fprintf x
#else
/*
  #define DPRI(args...)
*/
#define DPRI(a)
#define DPRI1(a)
#define DPRI2(a,b)
#define DPRI3(a,b,c)
#define DPRI4(a,b,c,d)
#define DOUT(x)
#endif

#define MSG(x) if (verbose) fprintf x
#define MSG1(a) if (verbose) fprintf(stderr, a)
#define MSG2(a,b) if (verbose) fprintf(stderr, a,b)
#define MSG3(a,b,c) if (verbose) fprintf(stderr, a,b,c)

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <setjmp.h>
#include <unistd.h>
#include <sys/stat.h>
#include <time.h>

#if USE_TERMIO
#include <termio.h>
#define TERMIO struct termio
#endif

#if USE_TERMIOS
#include <termios.h>
#define TERMIO struct termios
#endif

#if HPUX
#include <sys/modem.h>
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
# define Va_start(a,b) va_start(a,b)
#else
# include <varargs.h>
# define Va_start(a,b) va_start(a)
#endif

#include "switchopt2.h"

#ifndef DEVICE
#define DEVICE "/dev/ttyS0"
#endif

#define BUFSIZE 16384
#define NUM_LEN 25
#define ARGSIZE 1000

#define KIND_NUM 1
#define KIND_506G	1

#define IGNORE_CF 1

#define SUM_BYTE 0
#define SUM_STR 1

int sum_mode = SUM_BYTE;

typedef struct stkind {
    char *str;
    int num;
} kind_t;

kind_t cel_kind[] =
    {
	{"506g", KIND_506G},
    };
int kind = 0;

#define MAX_GRP 50
#define MAX_MEM 1000
#define STRLEN 100

#define ID_CELRW "CELRW"

#define MAX_BYTE 255
#define LEN_MEM_YOMI  MAX_BYTE
#define LEN_MEM_KANJI MAX_BYTE
#define LEN_GRP_YOMI  MAX_BYTE
#define LEN_GRP_KANJI MAX_BYTE

enum operation_mode {MODE_READ, MODE_WRITE,
		     MODE_VODA_SMS_READ, MODE_VODA_SMS_READ2,
		     MODE_VODA_SMS_WRITE,
		     MODE_VODA_SEND_FILE,
		     MODE_KDDI_BIN_READ,
		     MODE_KDDI_BIN_WRITE,
		     MODE_KDDI_SEND_FILE,
		     MODE_SCRIPT,};

#define EOL -1

/* 8 bit */
/* even parity, stop bit = 1 */
/* 600 bps */
#define CLEAR_BITS ~(CSIZE | PARODD | CSTOPB)
#define SET_BITS   (CS8 | PARENB)

#define UCHAR unsigned char

#define ALARMW set_action(); alarm(timeout); if (setjmp(jump_env) == 0)
#define ALARMWT(x) set_action(); alarm(x); if (setjmp(jump_env) == 0)
#define ELSE else


void h_signal();


int timeout = 1;
jmp_buf jump_env;

char rcv_num_tbl[] = {'D', '1', '2', '3', '4', '5', '6', '7', '8', '9',
		      '0', '*', '#', 'A', 'B', 'C'};
char rev_num_tbl[] = {0x0a, 0x01, 0x02, 0x03, 0x04, 0x05,
		      0x06, 0x07, 0x08, 0x09};

int valid_baud[] = {600, 2400, 4800, 9600, 19200, 38400, 57600, 115200,};
#define NUM_BAUD (sizeof(valid_baud)/sizeof(int))


TERMIO pmode;
#if HPUX
mflag mmode;
#endif

int mfd;
int baud;
int force_baud = 0;
char *device = DEVICE;

static UCHAR buf[BUFSIZE];
static unsigned char dummy[MAX_BYTE];

/* counter for send memory */
int n_grp = 0;
int n_mem = 0;

int nogroup = 0; /* 1: Group is not supported */

int max_grp, max_mem;
int file_grp_num[MAX_GRP];
UCHAR file_grp_yomi[MAX_GRP][STRLEN];
UCHAR file_grp_kanji[MAX_GRP][STRLEN];

int secret;
int file_mem_num[MAX_MEM];
int file_mem_grp[MAX_MEM];
int file_mem_secret[MAX_MEM];
UCHAR file_mem_yomi[MAX_MEM][STRLEN];
UCHAR file_mem_kanji[MAX_MEM][STRLEN];
UCHAR file_mem_phone[MAX_MEM][STRLEN];
UCHAR file_mem_email[MAX_MEM][STRLEN];

int read_grp_num = 0, read_mem_num = 0;
int read_line;

int verbose = 1;

int yomi_len = 0;
int kanji_len = 0;
int ignore_group = 0;
int kanjicode = 0;

int mail_sum = 0;
unsigned int cksum = 0;

#define KDDI_ENTRY_NUM 32
unsigned char kddi_entry[KDDI_ENTRY_NUM][256];
int kddi_buf_size, kddi_ptr;

char *binary_fname;
unsigned char str_dial[256];

#if PORTWAIT
#include <sys/time.h>

void mwait(msec)
     int msec;
{
    struct timeval tv_;
    struct timezone tz_;
    double d1,d2,d3;
    double w = msec * 1000.;

    (void) gettimeofday(&tv_,&tz_);
    d1 = tv_.tv_sec;
    d2 = tv_.tv_usec;

    do{
	(void) gettimeofday(&tv_,&tz_);
	d3 = (double) (tv_.tv_sec - d1) * 1000000.
	    + (double) (tv_.tv_usec - d2);
    }while ( d3 < w );
}
#endif /* PORTWAIT */

void reset_mail_sum()
{
    mail_sum = 0;
}

int char2hex(c)
     char c;
{
    if (c >= '0' && c<='9') {
	c -= '0';
    } else if (c>='A' && c<='F') {
	c = c - 'A' + 10;
    } else if (c>='a' && c<='f') {
	c = c - 'a' + 10;
    } else {
	(void) fprintf(stderr,"invalid character [%c]\n", c);
    }

    return (int) c;
}

int ascii2hex(str)
     char *str;
{
    int c;

    c = char2hex(*str++)<<4;
    c += char2hex(*str++);
}

void Tcgeta(fd,tios)
     int fd;
     TERMIO *tios;
{
#if USE_TERMIO
    if (ioctl(fd, TCGETA, tios) < 0)
#endif
#if USE_TERMIOS
	if (tcgetattr(fd, tios) < 0)
#endif
	    {
		perror("TCGETA");
		exit(-1);
	    }
}

void Tcseta(fd,tios)
     int fd;
     TERMIO *tios;
{
#if USE_TERMIO
    if (ioctl(fd, TCSETAF, tios)< 0)
#endif
#if USE_TERMIOS
	if (tcsetattr(fd, TCSAFLUSH, tios) < 0)
#endif
	    {
		perror("TCSETAF");
		exit(1);
	    }
}

void Tcsetaw(fd,tios)
     int fd;
     TERMIO *tios;
{
#if USE_TERMIO
    if (ioctl(fd, TCSETAW, tios)< 0)
#endif
#if USE_TERMIOS
	if (tcsetattr(fd, TCSADRAIN, tios) < 0)
#endif
	    {
		perror("TCSETAW");
		exit(1);
	    }
}

void Flush()
{
    Tcgeta(mfd, &pmode);
    Tcsetaw(mfd, &pmode);
}

void change_baud(b)
     int b;
{
    Tcgeta(mfd,&pmode);

#if USE_TERMIO
    pmode.c_cflag &= ~CBAUD;
    pmode.c_cflag |= b;
#endif
#if USE_TERMIOS
    cfsetospeed(&pmode, b);
    cfsetispeed(&pmode, b);
#endif

    Tcseta(mfd, &pmode);
}

void OpenDevice()
{
    int temp;

#ifdef __OpenBSD__
    if ((mfd = open(device, O_RDWR)) < 0)
#else
	if ((mfd = open(device, O_RDWR | O_NDELAY)) < 0)
#endif
	    {
		perror("Can't open device");
		exit(-1);
	    }

#if HPUX
    if (ioctl(mfd, MCGETA, &mmode) == -1) {
	perror("MCGETA:");
	exit(1);
    }
    mmode |= (MDTR | MRTS);
    if (ioctl(mfd, MCSETAF, &mmode) == -1) {
	perror("MCSETAF:");
	exit(1);
    }
#endif

    Tcgeta(mfd, &pmode);

    pmode.c_cflag &= ~(HUPCL);
    pmode.c_cflag |= CLOCAL;
    pmode.c_iflag = IGNBRK ;
    pmode.c_oflag = pmode.c_lflag = 0;
    pmode.c_cc[VMIN] = 1;
    pmode.c_cc[VTIME] = 0;

    pmode.c_iflag &= ~(IXON | IXOFF | IXANY);
    /*
      pmode.c_iflag |= IXON | IXOFF | IXANY;
    */

    Tcseta(mfd, &pmode);

    temp = mfd;
#ifndef __OpenBSD__
    if ((mfd = open(device, O_RDWR)) < 0){
	perror("Can't open device part2 ");
	exit(-1);
    }
    close(temp);
#endif

    change_baud(B600);

    pmode.c_cflag &= CLEAR_BITS;
    pmode.c_cflag |= SET_BITS;

    Tcseta(mfd, &pmode);
}


void CloseDevice()
{
    Tcgeta(mfd, &pmode);

    pmode.c_cflag &= ~CLOCAL;
    pmode.c_cflag |= B0 | HUPCL;

    Tcseta(mfd, &pmode);

#if HPUX
    if (ioctl(mfd, MCGETA, &mmode) == -1) {
	perror("MCGETA:");
	exit(1);
    }
    mmode &= ~(MDTR | MRTS);
    if (ioctl(mfd, MCSETAF, &mmode) == -1) {
	perror("MCSETAF:");
	exit(1);
    }
#endif

    close(mfd);
}

#ifdef HAVE_STDARG_H
void VaSendHex(int h, ...)
#else
     void VaSendHex(va_alist)
     va_dcl
#endif
{
    va_list ap;
    unsigned char c;
#ifdef HAVE_STDARG_H
    Va_start(ap, h);
#else
    int h;
    Va_start(ap, h);
    h = (int) va_arg(ap, long);
#endif

    DPRI1("VaSendHex:");
    while (h != (int) EOL) {
	c = (unsigned char) h;

	if (write(mfd, &c , 1) < 0) {
	    perror("VaSendHex:write");
	    h_signal();
	}
	DPRI2(" %02x",c);

	h = (int) va_arg(ap, long);
    }

    va_end(ap);
    DPRI1("\n");
}

void h_signal()
{
    signal(SIGINT, SIG_IGN);
    /* reset DoCoMo */
    VaSendHex (0x1f, 0x07, 0x0d, EOL);
    CloseDevice();
    (void) fprintf(stderr,"\n");
    exit(-1);
}

void change_baud_code(b)
     int b;
{
    sleep(1);
    switch(b){
     case 115200:
	 DOUT((stderr, "** 115200 baud **\n"));
	 change_baud(B115200);
	 break;

     case 57600:
	 DOUT((stderr, "** 57600 baud **\n"));
	 change_baud(B57600);
	 break;

     case 38400:
	 DOUT((stderr, "** 38400 baud **\n"));
	 change_baud(B38400);
	 break;

     case 0x0f:
     case 19200:
	 DOUT((stderr, "** 19200 baud **\n"));
	 change_baud(B19200);
	 break;

     case 7: /* 9600 */
     case 9600:
     case 5: /* 4800 */
     case 4800:
	 DPRI1("** 9600 baud **\n");
	 change_baud(B9600);
	 break;
#if 0
	 DPRI1("** 4800 baud **\n");
	 change_baud(B4800);
	 break;
#endif
     case 3: /* 2400 */
     case 2400:
	 DPRI1("** 2400 baud **\n");
	 change_baud(B2400);
	 break;
     case 1: /* 600 */
     case 600:
	 DPRI1("** 600 baud **\n");
	 change_baud(B600);
	 break;
     default: /* ??? */
	 (void) fprintf(stderr,"code [%d] is unknown baud.\n",b);
	 h_signal();
	 break;
    }
}

int baud_code(b)
     int b;
{
    int x;

    switch (baud) {
     case 600:
	 x = 0x01;
	 break;
     case 2400:
	 x = 0x03;
	 break;
     case 4800:
	 x = 0x05;
	 break;
     case 9600:
	 x = 0x07;
	 break;
    }
    return(x);
}

void error_line()
{
    (void) fprintf(stderr,"error: line %d.\n",read_line);
    exit(-1);
}

/*
 * err: 2: do not warn
 *      1: exit if encountered unexpected end of line
 *      3: return if end of line detected
 * return value: 0=found separator
 *               1=found cr/lf
 */

int file_get_token(fp,err)
     FILE *fp;
     int err;
{
    UCHAR *p,c;
    int done;
    int ret = 0;
    int i = 0;

    /* skip TAB, comment, linefeed */
    done = 0;
    do {
	c = fgetc(fp);
	switch(c){
	 case 0x09:
	 case 0x0a:
	 case 0x0d:
	     if (err == 3) {
		 *buf = '\0';
		 return 1;
	     }
	     break;

#if 0
	 case '#':
	     for(;fgetc(fp) != 0x0a && !feof(fp);) {
		 if (err && feof(fp)) {
		     error_line();
		 }
	     }
	     break;
#endif

	 default:
	     done = 1;
	     break;
	}
    } while(done == 0);

    p = buf;

    if (feof(fp)) {
	*p = '\0';
	if (err == 3 || err == 1) {
	    ret = 1;
	}
	return ret;
    }

    done = 0;
    /* get one token : delimiter=TAB, linefeed */
    do {
	*p++ = c;

	c = fgetc(fp);
	switch (c) {
	 case 0x09:
	     done = 1;
	     break;

	 case 0x0a:
	 case 0x0d:
	     done = 1;
	     ret = 1;
	     if (err == 1) {
		 error_line();
	     }
	     break;
	}

	if (err && feof(fp)) {
	    error_line();
	}

	if (i++ > BUFSIZE-2) {
	    done = 1;
	}
    } while(done == 0);

    *p = '\0';

    if(!strcmp((char *) buf,"*NONE*")){
	*buf = '\0';
    }

    return ret;
}

void read_file(fname)
     char *fname;
{
    FILE *fp;
    int eol = 0;

    if ((fp = fopen(fname,"r")) == NULL){
	(void) fprintf(stderr,"Can't open [%s].\n", fname);
	exit(1);
    }

    read_line = 0; /* line num */
    read_grp_num = 0;
    read_mem_num = 0;
    while (!feof(fp)){
	(void) file_get_token(fp,0); /* command , ignore error(EOF) */
	switch (buf[0]){
	 case 'N': /* max nums */
	     file_get_token(fp,1); /* max group,with error */
	     (void) sscanf((char *) buf,"%d", &max_grp);
	     file_get_token(fp,2); /* max memory,with error */
	     (void) sscanf((char *) buf,"%d", &max_mem);
	     read_line++;
	     break;

	 case 'G': /* group name */
	     file_get_token(fp,1); /* group num,with error */
	     (void) sscanf((char *) buf,"%d", &file_grp_num[read_grp_num]);
	     file_get_token(fp,1); /* yomi ,with error */
	     (void) strcpy((char *) file_grp_yomi[read_grp_num],(char *) buf);
	     file_get_token(fp,2); /* kanji ,with error */
	     (void) strcpy((char *) file_grp_kanji[read_grp_num],(char *) buf);

	     read_grp_num++;
	     read_line++;
	     break;

	 case 'M': /* memory name */
	     file_get_token(fp,1); /* memory num,with error */
	     (void) sscanf((char *) buf,"%d", &file_mem_num[read_mem_num]);
	     file_get_token(fp,1); /* group num,with error */
	     (void) sscanf((char *) buf,"%d", &file_mem_grp[read_mem_num]);
	     file_get_token(fp,1); /* secret */
	     (void) sscanf((char *) buf,"%d", &file_mem_secret[read_mem_num]);
	     file_get_token(fp,1); /* yomi ,with error */
	     (void) strcpy((char *) file_mem_yomi[read_mem_num],(char *) buf);
	     file_get_token(fp,1); /* kanji ,with error */
	     (void) strcpy((char *) file_mem_kanji[read_mem_num],(char *) buf);
	     eol = file_get_token(fp,3); /* phone ,with error */
	     (void) strcpy((char *) file_mem_phone[read_mem_num], (char *) buf);

	     if (!eol) {
		 eol = file_get_token(fp,3); /* email addr */
		 (void) strcpy((char *) file_mem_email[read_mem_num], (char *) buf);
	     } else {
		 file_mem_email[read_mem_num][0] = 0;
	     }

	     read_mem_num++;
	     read_line++;
	     break;
	}
    }

    (void) fclose(fp);
}

void RcvSwapNum(p, col, even)
     UCHAR *p;
     int col,even;
{
    UCHAR c1,c2;
    int i;
    int r;

    DOUT((stderr, "RcvSwapNum:"));
    for(i=0; i<col - 1; i++){
	if (read(mfd, &c1, 1) < 0) {
	    perror("RcvSwapNum:");
	    h_signal();
	}
	if (read(mfd, &c2, 1) < 0) {
	    perror("RcvSwapNum:");
	    h_signal();
	}
	DOUT((stderr, " %02x %02x",c1,c2));

	mail_sum += (c1<<4)+c2;

	*p++ = rcv_num_tbl[c2];
	*p++ = rcv_num_tbl[c1];
    }
    DOUT((stderr, "\n"));
    *p = '\0';

    if (even) {
	--p;
	*p = '\0';
    }
}

void ReceiveMsg(n,d)
     int n;
     unsigned char d;
{
    unsigned char c = 0;
    int i=0;
    int ok = 0;

    DPRI1("recv:");
    while(ok == 0){
	if (read(mfd, &c, 1) < 0) {
	    perror("ReceiveMsg:read");
	    h_signal();
	}
	DPRI2(" %02x",c);
	(void) fflush(stdout);
	if (c == d) {
	    ok = 1;
	}
    }
    i++;

    while (i<n || n==0) {
	if (read(mfd, &c, 1) < 0) {
	    perror("ReceiveMsg:read");
	    h_signal();
	}
	DPRI2(" %02x",c);
	fflush(stdout);
	i++;
    }

    DPRI1("\n");
}

void RcvMsgMask(n,d,mask)
     int n;
     unsigned char d,mask;
{
    unsigned char c = 0;
    int i=0;
    int ok = 0;

    DPRI1("recv:");
    while(ok == 0){
	if (read(mfd, &c, 1) < 0) {
	    perror("ReceiveMsg:read");
	    h_signal();
	}
	DPRI2(" %02x",c);
	(void) fflush(stdout);
	if ((c & mask) == (d & mask)) {
	    ok = 1;
	}
    }
    i++;

    while (i<n || n==0) {
	if (read(mfd, &c, 1) < 0) {
	    perror("ReceiveMsg:read");
	    h_signal();
	}
	DPRI2(" %02x",c);
	fflush(stdout);
	i++;
    }

    DPRI1("\n");
}

int rcv_digit()
{
    UCHAR c1, c2;
    int ret;

    DOUT((stderr, "rcv_digit:"));

    if (read(mfd, &c1, 1) < 0) {
	perror("rcv_digit:read");
	h_signal();
    }
    if (read(mfd, &c2, 1) < 0) {
	perror("rcv_digit:read");
	h_signal();
    }

    DOUT((stderr, " %02x %02x\n", c1, c2));

    ret = c1*10 + c2;

    return ret;
}

int rcv_half()
{
    UCHAR c1;
    int ret;

    DOUT((stderr, "rcv_half:"));

    if (read(mfd, &c1, 1) < 0) {
	perror("rcv_half:read");
	h_signal();
    }

    DOUT((stderr, " %02x\n", c1));

    return c1;
}

void rcv_buf(n,ignore)
     int n;
     int ignore;
{
    UCHAR c = 0;
    int i=0;

    DOUT((stderr, "rcv_buf:"));
    while ((i<n || n==0) && n < BUFSIZE) {
	if (read(mfd, &c, 1) < 0) {
	    perror("rcv_buf:read");
	    h_signal();
	}
	DOUT((stderr, " %02x",c));
	if (!ignore || c<0xc0 || c>0xcf) {
	    buf[i] = c;

	    if (i%2 == 1) {
		mail_sum += (buf[i-1]<<4)+c;
	    }
	    i++;
	}
    }
    DOUT((stderr, "\n"));
}

void RcvBuf(n)
     int n;
{
    UCHAR c = 0;
    int i=0;

    DOUT((stderr, "RcvBuf:"));
    while ((i<n || n==0) && n < BUFSIZE) {
	if (read(mfd, &c, 1) < 0) {
	    perror("RcvBuf:read");
	    h_signal();
	}
	DOUT((stderr, " %02x",c));
	buf[i] = c;

	if (i%2 == 1) {
	    mail_sum += (buf[i-1]<<4)+c;
	}
	i++;
    }
    DOUT((stderr, "\n"));
}

void RcvBufVerify(n,d)
     int n;
     UCHAR d;
{
    UCHAR c = 0;
    int i=0;
    int ok = 0;

    DPRI1("RcvBufVerify:");
    while(ok == 0){
	if (read(mfd, &c, 1) < 0) {
	    perror("RcvBufVerify:read");
	    h_signal();
	}
	DPRI2(" %02x",c);
	(void) fflush(stdout);
	if (c == d) {
	    ok = 1;
	}
    }
    buf[i] = c;
    i++;

    while ((i<n || n==0) && n<BUFSIZE) {
	if (read(mfd, &c, 1) < 0) {
	    perror("RcvBufVerify:read");
	    h_signal();
	}
	DPRI2(" %02x",c);
	buf[i] = c;
	i++;
    }
    DPRI1("\n");
}

/*
 * received string = SJIS
 */
void RcvStr(n,str)
     int n;
     unsigned char *str;
{
    unsigned char c1 = 0, c2 = 0;
    unsigned char *p = str;
    int i=0;

    DPRI1("RecvStr:");

    while (i<n || n==0) {
	if (read(mfd, &c1, 1) < 0) {
	    perror("RcvStr:read");
	    h_signal();
	}
	if (read(mfd, &c2, 1) < 0) {
	    perror("RcvStr:read");
	    h_signal();
	}

	*p = (c1 << 4) | c2;
	i++;
	DPRI2("%02x ",*p);
	p++;
    }
    *p = '\0';

    DPRI1("\n");
}

void rcv_id(str)
     unsigned char *str;
{
    unsigned char c1 = 0, c2 = 0;
    unsigned char *p = str;
    int i;

    DOUT((stderr,"rcv_id:"));
    for(i=0; i<5; i++){
	(void) read(mfd, &c1, 1);
	(void) read(mfd, &c2, 1);
	*p++ = (c1 << 4) | c2;
	DOUT((stderr, "%02x %02x ",c1,c2));
    }

    for(i=0; i<6; i++){
	(void) read(mfd, &c1, 1);
	(void) sprintf(p, "%02x", c1);
	p+=2;
    }
    *p = '\0';

    DOUT((stderr,"id=[%s]\n", str));
}

int rcv_long()
{
    unsigned char c = 0;
    int i;
    int ret = 0;

    DOUT((stderr, "rcv_long: "));

    for(i=0; i<4; i++){
	if (read(mfd, &c, 1) < 0) {
	    perror("rcv_long:read");
	    h_signal();
	}
	ret = (ret<<8)+c;
	DOUT((stderr, "%02x ",c));
    }

    DOUT((stderr, "[%d]\n",ret));

    return ret;
}

int RcvShort()
{
    unsigned char c1 = 0, c2 = 0;
    int ret;

    if (read(mfd, &c1, 1) < 0) {
	perror("RcvShort:read");
	h_signal();
    }
    if (read(mfd, &c2, 1) < 0) {
	perror("RcvShort:read");
	h_signal();
    }

    DOUT((stderr, "RcvShort: %02x %02x\n",c1,c2));

    ret = (c1 << 8) + c2;

    mail_sum += c1 + c2;

    return ret;
}


int RcvByte()
{
    unsigned char c1 = 0, c2 = 0;
    int ret;

    if (read(mfd, &c1, 1) < 0) {
	perror("RcvByte:read");
	h_signal();
    }
    if (read(mfd, &c2, 1) < 0) {
	perror("RcvByte:read");
	h_signal();
    }

    DOUT((stderr, "RcvByte: %02x %02x\n",c1,c2));

    ret = (c1 << 4) + c2;

    mail_sum += ret;

    return ret;
}

int RcvNumber()
{
    unsigned char c1 = 0, c2 = 0;
    int ret;

    if (read(mfd, &c1, 1) < 0) {
	perror("RcvNumber:read");
	h_signal();
    }
    if (read(mfd, &c2, 1) < 0) {
	perror("RcvNumber:read");
	h_signal();
    }

    DOUT((stderr, "RcvNumber: %02x %02x\n",c1,c2));

    if (c1 == 0x08) {
	secret = 1;
    } else {
	secret = 0;
    }

    c1 = RcvByte();
    ret = c2 * 100 + c1;

    /* c1 already add by RcvByte */
    mail_sum += c2;

    return ret;
}

int RcvStrLen(p)
     UCHAR *p;
{
    int len;

    len = RcvByte();
    if (len) {
	RcvStr(len, p);
    } else {
	(void)strcpy((char *) p,"*NONE*");
    }

    return len;
}

void SendStrNum(s)
     unsigned char *s;
{
    unsigned char *p;
    unsigned char c;

    DPRI1("sending ");
    p = s;
    while(*p != '\0') {
	if (*p < '0' && *p > '9') {
	    (void) fprintf(stderr, "SendStrNum:illegal char [%c]\n", *p);
	    h_signal();
	}
	c = rev_num_tbl[*p - '0'] + 0x90;
	if (write(mfd, &c , 1) < 0) {
	    perror("SendStrNum:write");
	    h_signal();
	}
	DPRI2("%02x ",c);
	p++;
    }
    DPRI1("\n");
}

void SendDial(s)
     unsigned char *s;
{
    unsigned char c;

    SendStrNum(s);

    c = 0xaa;
    write(mfd, &c, 1);
    DPRI2("%02x : done\n",c);
}

void SendSwapNum(s,col)
     UCHAR *s;
     int col;
{
    UCHAR *p, *q;
    UCHAR c;
    int i;

    /* initialize */
    for(i=0; i<BUFSIZE; i++){
	buf[i] = 0;
    }

    /* swap */
    p = s;
    q = buf;
    while(*p != '\0') {
	*(q+1) = *p++;
	if (*p != '\0') {
	    *q = *p++;
	}
	q+=2;
    }

    DPRI1("sendSwapNum:");
    p = buf;
    i=0;
    for(i=0; i<col; i++){
	if (!((*p >= '0' && *p <= '9') || (*p >= 'A' && *p <= 'D') ||
	      (*p == '*') || (*p == '#') || (*p == '\0'))) {
	    (void) fprintf(stderr, "SendStrNum:illegal char [%c]\n", *p);
	    h_signal();
	}
	if (*p == '\0') {
	    c = 0;
	} else if (*p >= 'A' && *p <= 'C') {
	    c = *p - 'A' + 0x0d;
	} else if (*p == 'D') {
	    c = 0;
	} else if (*p == '#') {
	    c = 0x0c;
	} else if (*p == '*') {
	    c = 0x0b;
	} else {
	    c = rev_num_tbl[*p - '0'];
	}
	if (write(mfd, &c , 1) < 0) {
	    perror("SendSwapNum:write");
	    h_signal();
	}
	DPRI2("%02x ",c);
	p++;
    }
    DPRI1("\n");
}

int get_file_size()
{
    struct stat st;

    if (stat(binary_fname, &st) < 0) {
	(void) fprintf(stderr,"Can't stat [%s].\n", binary_fname);
	exit(1);
    }

    return st.st_size;
}

void SendHex(h)
     int h;
{
    unsigned char c;

    c = (unsigned char) h;

    if (write(mfd, &c , 1) < 0) {
	perror("SendHex:write");
	h_signal();
    }
    DPRI2("sendhex:%02x\n",c);
}

void rev_cksum()
{
    unsigned int a;

    a = 0xffff - cksum;
    SendHex(a>>8);
    SendHex(a&0xff);
}


void SendShort(s)
     unsigned short s;
{
    unsigned int i1, i2;
    unsigned char c1, c2;

    i1 = (s>>8) & 0xff;
    i2 = s & 0xff;
    c1 = (UCHAR) i1;
    c2 = (UCHAR) i2;

    if (write(mfd, &c1 , 1) < 0) {
	perror("SendShort:write");
	h_signal();
    }
    if (write(mfd, &c2 , 1) < 0) {
	perror("SendShort:write");
	h_signal();
    }
    DPRI3("SendShort :%02x %02x\n",c1,c2);
}

void SendByte(s)
     UCHAR s;
{
    unsigned int i1, i2;
    unsigned char c1, c2;

    i1 = (s>>4) & 0xf;
    i2 = s & 0xf;
    c1 = (UCHAR) i1;
    c2 = (UCHAR) i2;

    if (write(mfd, &c1 , 1) < 0) {
	perror("SendByte:write");
	h_signal();
    }
    if (write(mfd, &c2 , 1) < 0) {
	perror("SendByte:write");
	h_signal();
    }
    DPRI3("SendByte :%02x %02x\n",c1,c2);
}

void SendNumber(n)
     int n;
{
    int i1,i2;

    i1 = n / 100;
    i2 = n - i1*100;

    SendByte((UCHAR) i1);
    SendByte((UCHAR) i2);
}

void SendNumberSec(n,sec)
     int n,sec;
{
    int i1,i2;

    i1 = n / 100;
    i2 = n - i1*100;

    SendHex((UCHAR) sec * 0x08);
    SendHex((UCHAR) i1);
    SendByte((UCHAR) i2);
}

void SendChar(c)
     unsigned char c;
{
    unsigned char c1, c2;

    c1 = (c>>4) & 0xf;
    c2 = c & 0xf;

    if (write(mfd, &c1 , 1) < 0) {
	perror("SendChar:write");
	h_signal();
    }
    if (write(mfd, &c2 , 1) < 0) {
	perror("SendChar:write");
	h_signal();
    }
    DPRI3("SendChar :%02x %02x\n",c1,c2);
}

void SendStr(p)
     unsigned char *p;
{
    SendByte(strlen((char *) p));

    while(*p != '\0'){
	SendChar(*p++);
    }
}

int chk_kanji_2nd_byte(p,n)
     unsigned char *p;
     int n;
{
    int i;
    int in = 0;

    if (n>strlen(p)){
	n = strlen(p);
    }

    for(i=0; i<n; i++, p++){
	if (!in && *p>=0x80) {
	    in = 1;
	} else {
	    in = 0;
	}
    }

    return in;
}

void SendStrN(p,len)
     unsigned char *p;
     int len;
{
    int n;

    if (len) {
	n = len;
    } else {
	n = strlen((char *) p);
    }
    DPRI3("SendStrN:max(%d),req(%d)\n",len,n);

    if (chk_kanji_2nd_byte(p,n)) {
	n--;
    }

    SendByte(n);
    while(n--){
	SendChar(*p++);
    }
}

void SendStrNoLen(p)
     unsigned char *p;
{
    while(*p != '\0'){
	cksum += *p;
	SendChar(*p++);
    }
}

void send_raw_str(p)
     unsigned char *p;
{
    unsigned char *q = p;

    DOUT((stderr,"send_raw_str:"));
    while (*q) {
	if (write(mfd, q , 1) < 0) {
	    perror("send_raw_str:write");
	    h_signal();
	}
	DOUT((stderr,"%02x ", *q));
	cksum += *q;
	q++;
    }
    DOUT((stderr,"\n"));
}

void send_short(len)
     int len;
{
    int a;

    a = len>>8;
    SendHex(a);
    cksum += a;

    a = len&0xff;
    SendHex(a);
    cksum += a;
}

void send_long(len)
     int len;
{
    int i;
    int a;

    for(i=0; i<4; i++){
	a = (len & 0xff000000)>>24;
	SendHex(a);
	cksum += a;
	len <<= 8;
    }
}

void send_hexs(p)
     unsigned char *p;
{
    unsigned char c;
    unsigned char q = 0;
    int valid;
    int two_digit = 0;
    int str_second = 0;
    int str_byte;

    DOUT((stderr,"send_hexs:"));
    while(*p){
	c = *p++;
	valid = 1;
	if (c>='0' && c<='9') {
	    q += c-'0';
	} else if (c>='A' && c<='F') {
	    q += c-'A'+10;
	} else if (c>='a' && c<='f') {
	    q += c-'a'+10;
	} else {
	    if (two_digit) {
		if (write(mfd, &q , 1) < 0) {
		    perror("send_hexs:write");
		    h_signal();
		}
		DOUT((stderr, " %02x", q));
		if (sum_mode == SUM_STR) {
		    if (!str_second) {
			str_byte = q<<4;
		    } else {
			str_byte += q;
			cksum += str_byte;
		    }
		} else {
		    cksum += q;
		}
		str_second = 1-str_second;
	    }
	    q = 0;
	    valid = 0;
	    two_digit = 0;
	}
	if (valid) {
	    if (two_digit) {
		if (write(mfd, &q , 1) < 0) {
		    perror("send_hexs:write");
		    h_signal();
		}
		DOUT((stderr, " %02x", q));
		if (sum_mode == SUM_STR) {
		    if (!str_second) {
			str_byte = q<<4;
		    } else {
			str_byte += q;
			cksum += str_byte;
		    }
		} else {
		    cksum += q;
		}
		str_second = 1-str_second;
		q = 0;
	    } else {
		q<<=4;
	    }
	    two_digit = 1-two_digit;
	}
    }
    DOUT((stderr, "\n"));
}

int comparen(p,q,n)
     unsigned char *p, *q;
     int n;
{
    int ret = 0;
    int i;

    for(i=0; i<n; i++){
	ret += (*p++ != *q++);
    }

    return ret;
}

void WaitHex(n,q)
     int n;
     unsigned char *q;
{
    unsigned char c, *p;
    int i = 0;

    p = (unsigned char *) malloc(sizeof(char)*n);
    for(i=0; i<n; i++){
	if (read(mfd, &c, 1) < 0) {
	    perror("VaCompMsg:read");
	    h_signal();
	}
	p[i] = c;
	DOUT((stderr," %02x",c));
    }

    while(comparen(p,q,n)) {
	for(i=0; i<n-1; i++){
	    p[i] = p[i+1];
	}
	if (read(mfd, &c, 1) < 0) {
	    perror("VaCompMsg:read");
	    h_signal();
	}
	p[n-1] = c;
	DOUT((stderr," %02x",c));
    }

    DOUT((stderr,"\n"));
}

#ifdef HAVE_STDARG_H
void VaWait(int n, ...)
#else
     void VaWait(va_alist)
     va_dcl
#endif
{
    va_list ap;
    unsigned char *q;
    int i = 0;

#ifdef HAVE_STDARG_H
    Va_start(ap, n);
#else
    int n;
    Va_start(ap, n);
    n = (int) va_arg(ap, long);
#endif

    DOUT((stderr,"VaWait n=%d:", n));

    q = (unsigned char *) malloc(sizeof(char)*n);

    for(i=0; i<n; i++){
	q[i] = (unsigned char) va_arg(ap, long);
    }
    va_end(ap);

    WaitHex(n, q);
}

#ifdef HAVE_STDARG_H
int VaCompMsg(int n, ...)
#else
     int VaCompMsg(va_alist)
     va_dcl
#endif
{
    va_list ap;
    unsigned char c,d;
    int ret = 1;
    int i = 0;

#ifdef HAVE_STDARG_H
    Va_start(ap, n);
#else
    int n;
    Va_start(ap, n);
    n = (int) va_arg(ap, long);
#endif

    DPRI1("VaCompMsg:");

    while (i < n) {
	if (read(mfd, &c, 1) < 0) {
	    perror("VaCompMsg:read");
	    h_signal();
	}
	d = (unsigned char) va_arg(ap, long);
	DPRI3(" read[%02x]=%02x?", c, d);

	if (c != d) {
	    ret = 0;
	}
	i++;
    }

    va_end(ap);
    DPRI1("\n");

    return(ret);
}

#ifdef HAVE_STDARG_H
int msg_wait_compare(int n, ...)
#else
     int msg_wait_compare(va_alist)
     va_dcl
#endif
{
    va_list ap;
    unsigned char c,d;
    int ret = 1;
    int i = 0;

#ifdef HAVE_STDARG_H
    Va_start(ap, n);
#else
    int n;
    Va_start(ap, n);
    n = (int) va_arg(ap, long);
#endif

    DPRI1("msg_wait_compare:");

    d = (unsigned char) va_arg(ap, long);
    VaWait(1, d);
    i++;

    while (i < n) {
	if (read(mfd, &c, 1) < 0) {
	    perror("msg_wait_compare:read");
	    h_signal();
	}
	d = (unsigned char) va_arg(ap, long);
	DPRI3(" read[%02x]=%02x?", c, d);

	if (c != d) {
	    ret = 0;
	}
	i++;
    }

    va_end(ap);
    DPRI1("\n");

    return(ret);
}
void SendPasswdSuccess()
{
    DOUT((stderr, "password success: "));
    VaSendHex(0x6c, 0x03, EOL);
}

void SendMaxGroup(cmd, max_mem, max_grp)
     int cmd, max_mem, max_grp;
{
    DPRI1("SendMaxGroup\n");
    VaSendHex(cmd, 0x0d, 0x00, 0x02, EOL);
    /*
     * 00 00 : NO YOMI & KANJI
     * 00 01 : YOMI ONLY
     * 00 02 : KANJI ONLY
     * 00 03 : YOMI & KANJI
     */
    VaSendHex(0x00, 0x07, EOL);
    SendNumber(max_mem); /* max memory */

    VaSendHex(0x00, 0x07, EOL);   /* enable kanji */
    SendByte(LEN_MEM_YOMI);
    SendByte(LEN_MEM_KANJI);

    SendByte(max_grp); /* max group */
    SendByte(LEN_GRP_YOMI);
    SendByte(LEN_GRP_KANJI);

    SendStrNoLen(ID_CELRW);
    send_hexs("09 09 09 09 09 09");
}

void SendGroupName(num, yomi, kanji)
     int num;
     UCHAR *yomi, *kanji;
{
    MSG2("sending group #%d\n",num);

    VaSendHex(0x6c, 0x0a, EOL);
    SendByte(num);
    VaSendHex(0x00, 0x01, EOL);
    SendStr(yomi);

    VaSendHex(0x00, 0x03, EOL);
    SendStr(kanji);
}

void SendMemory(num, grp, sec, yomi, kanji, phone)
     int num,grp,sec;
     UCHAR *yomi, *kanji, *phone;
{
    int col;
    int i,j;

    MSG2("sending memory #%d\n",num);
    DPRI4("%s %s %s\n", yomi, kanji, phone);

    /*
     * send memory dial
     */
    if (*phone) {
	VaSendHex(0x6c, 0x06, EOL);
	SendNumberSec(num,sec);
	VaSendHex(0x00, 0x01, EOL);
	if (*yomi) {
	    DPRI3("yomi_len=%d len=%d\n", yomi_len, strlen(yomi));
	    if (yomi_len && (strlen(yomi)>yomi_len)) {
		SendStrN(yomi,yomi_len);
	    } else {
		SendStr(yomi);
	    }
	} else {
	    VaSendHex(0x00, 0x00, EOL);
	}

	col = strlen((char *) phone);
	i = (col + 1) / 2 +1;
	j = (i-1)*2 - col;
	SendShort((unsigned short)i);
	if (col) {
	    SendHex(j*8);
	    SendHex(0x00);

	    SendSwapNum(phone,(i-1)*2);
	}
	SendByte(grp);

	if (kanjicode) {
	    VaSendHex(0x00, kanjicode, EOL);
	} else {
	    VaSendHex(0x00, 0x03, EOL);
	}

	if (*kanji) {
	    if (kanji_len && (strlen(kanji) > kanji_len)) {
		SendStrN(kanji, kanji_len);
	    } else {
		SendStr(kanji);
	    }
	} else {
	    VaSendHex(0x00, 0x00, EOL);
	}
    }
}

void SendEndOfGroup()
{
    VaSendHex(0x6c, 0x0c, EOL);
}

int SendOneGroup()
{
    int ret = 0;

    /* skip no_data area */
    while(n_grp<read_grp_num &&
	  *file_grp_yomi[n_grp] == 0 &&
	  *file_grp_kanji[n_grp] == 0
	  ) {
	n_grp++;
    }
    if (n_grp < read_grp_num) {
	SendGroupName(file_grp_num[n_grp],file_grp_yomi[n_grp],file_grp_kanji[n_grp]);
	n_grp++;
    } else {
	SendEndOfGroup();
	ret = 1;
    }

    return ret;
}

void SendEndOfMemory()
{
    VaSendHex(0x6c, 0x08, EOL);
}

int SendOneMemory()
{
    int ret = 0;

    /* skip no_data area */
    while(n_mem<read_mem_num &&
	  *file_mem_phone[n_mem] == 0) {
	n_mem++;
    }

    if (n_mem < read_mem_num) {
	SendMemory(file_mem_num[n_mem],file_mem_grp[n_mem],
		   file_mem_secret[n_mem],
		   file_mem_yomi[n_mem],file_mem_kanji[n_mem],
		   file_mem_phone[n_mem]);
	n_mem++;
    } else {
	SendEndOfMemory();
	ret = 1;
    }

    return ret;
}

#ifdef HAVE_STDARG_H
void SendAck(int h, ...)
#else
     void SendAck(va_alist)
     va_dcl
#endif
{
    va_list ap;
    unsigned char c;
    static UCHAR sendbuf[BUFSIZE];
    int i = 0, j , differ;
    UCHAR *p, *q;
#ifdef HAVE_STDARG_H
    Va_start(ap, h);
#else
    int h;
    Va_start(ap, h);
    h = (int) va_arg(ap, long);
#endif

    q = sendbuf;

    DPRI1("SendAck:");
    while (h != (int) EOL) {
	c = (unsigned char) h;
	*q++ = c;
	i++;

	if (write(mfd, &c , 1) < 0) {
	    perror("SendAck:write");
	    h_signal();
	}
	DPRI2(" %02x",c);

	h = (int) va_arg(ap, long);
    }

    va_end(ap);
    DPRI1("\n");

    RcvBuf(i);

    differ = 0;
    DPRI1("Verify :");
    for(j=1, p=buf+1, q=sendbuf+1; j<i; j++, p++, q++){
	DPRI2(" %02x",*p);
	if (*p != *q) {
	    differ = 1;
	}
    }
    DPRI1("\n");
    if (differ) {
	(void) fprintf(stderr,"Ack Error!\n");
	h_signal();
    }
}

void GetMaxNum(cmd,num,grp)
     int cmd;
     int *num, *grp;
{
    int flag;
    int len_yomi, len_kanji;
    int len_tel, len_grp;

    DPRI1("GetMaxNum\n");
    ReceiveMsg(4,cmd);
    flag = RcvShort();
#ifdef DEBUG
    if (flag & 0x0001) {
	(void) fprintf(stderr,"YOMI enabled\n");
    }
    if (flag & 0x0002) {
	(void) fprintf(stderr,"KANJI enabled\n");
    }
    if (flag & 0x0004) {
	(void) fprintf(stderr,"group enabled\n");
    }
#endif
    *num = RcvNumber();

    flag = RcvByte();
#ifdef DEBUG
    if (flag & 0x0001) {
	(void) fprintf(stderr,"JIS8\n");
    }
    if (flag & 0x0002) {
	(void) fprintf(stderr,"SJIS\n");
    }
    if (flag & 0x0004) {
	(void) fprintf(stderr,"???\n");
    }
#endif

    len_yomi = RcvByte();
    len_tel = RcvByte();
    DPRI3("mem: len #yomi=%d #tel=%d\n", len_yomi, len_tel);

    if (!yomi_len) {
	yomi_len = len_yomi;
    }

    *grp = RcvByte();
    len_grp = RcvByte();
    len_kanji = RcvByte();
    DPRI3("grp: len #grp=%d #kanji=%d\n", len_grp, len_kanji);

    if (!kanji_len) {
	kanji_len = len_kanji;
    }

    /* cellular ID */
    DOUT((stderr, "cellular ID:"));
    RcvStr(5, dummy);
    RcvStr(3, &dummy[11]);
    DOUT((stderr, "ID=%s", dummy));
    DOUT((stderr, "%02x%02x%02x\n", dummy[11], dummy[12], dummy[13]));
}


int GetGroup()
{
    static char kana[MAX_BYTE], kanji[MAX_BYTE];
    int grp_num;
    int len;

    /*
     * send 64 07 : get group
     * result
     * 6c 0a : group exists
     * 6c 0c : group end
     */
    VaSendHex(0x64, 0x07, EOL);

#if PORTWAIT
    mwait(400);
#endif
    if (msg_wait_compare(2,0x6c,0x0c)) {
	DPRI1("***** group end.\n");
	return 0;
    }

    grp_num = RcvByte();
    DPRI2("* group number:%d\n",grp_num);
    MSG2("getting group #%d\n",grp_num);

    ReceiveMsg(2,0x00);
    len = RcvStrLen(kana);
    DPRI2("kana=[%s]\n",kana);

    ReceiveMsg(2,0x00);
    len += RcvStrLen(kanji);
    DPRI2("kanji=[%s]\n",kanji);

    if (len) {
	(void) printf("G\t%d\t%s\t%s\n",
		      grp_num, kana, kanji);
    }

    return 1;
}


int GetMemory()
{
    static char kana[MAX_BYTE], kanji[MAX_BYTE], phone[MAX_BYTE];
    int grp_num;
    int mem_num;
    int col,even;

    /*
     * send 64 06 : read memory dial
     */
    VaSendHex(0x64, 0x06, EOL);

#if PORTWAIT
    mwait(600);
#endif
    /*
     * 6c 06 : memory exists
     * 6c 08 : memory end
     */
    if (msg_wait_compare(2,0x6c,0x08)) {
	DPRI1("***** memory end.\n");
	return 0;
    }

    mem_num = RcvNumber();
    DPRI3("* memory number:%d secret=%d\n",mem_num,secret);
    MSG2("getting memory #%d\n",mem_num);

    ReceiveMsg(2, 0x00);

    RcvStrLen(kana);
    DPRI2("furigana=[%s]\n",kana);

    col = RcvShort();
    if (col) {
	RcvBuf(2);
	even = buf[0];

	RcvSwapNum(phone, col, even);
	DPRI2("phone=[%s]\n",phone);
    } else {
	(void) strcpy(phone, "*NONE*");
    }

    if (!nogroup) {
	grp_num = RcvByte();
	DPRI2("group number:%d\n",grp_num);

	ReceiveMsg(2, 0x00);
	RcvStrLen(kanji);
	DPRI2("kanji=[%s]\n",kanji);
    } else {
	RcvBuf(2);
	(void) strcpy(kanji, "*NONE*");
    }

    if (col) {
	(void) printf("M\t%d\t%d\t%d\t%s\t%s\t%s\n",
		      mem_num,grp_num,secret, kana, kanji, phone);
    }

    return 1;
}

void RecvAck6c()
{
}

void RecvAck64()
{
    static UCHAR ackbuf[BUFSIZE];
    int i = 0;

    RcvBuf(1);
    switch(buf[0]){
     case 0x01:
	 switch (kind) {
	  case KIND_506G:
	      sleep(1);
	      break;
	 }
	 VaSendHex(0x6c, buf[0], EOL);
	 break;

     case 0x02:
     case 0x0e:
	 ackbuf[i++] = buf[0];
	 RcvBuf(1);
	 VaSendHex(0x6c, ackbuf[0], buf[0], EOL);
	 break;
    }
}

void cb_timeout(sig)
     int sig;
{
    /*
      signal(sig,SIG_IGN);
    */

    (void) fprintf(stderr,"alarm catch\n");

    longjmp(jump_env,1);
}

void set_action()
{
#ifdef HAVE_SIGACTION
    struct sigaction new_action;

    new_action.sa_handler = cb_timeout;
    sigemptyset (&new_action.sa_mask);
    new_action.sa_flags = SA_NODEFER;

    (void) sigaction(SIGALRM, &new_action, NULL);
#else
    signal(SIGALRM,cb_timeout);
#endif
}

void ign_action()
{
#ifdef HAVE_SIGACTIOON
    struct sigaction new_action;

    new_action.sa_handler = SIG_IGN;
    sigemptyset (&new_action.sa_mask);
    new_action.sa_flags = SA_NODEFER;

    (void) sigaction(SIGALRM, &new_action, NULL);
#else
    signal(SIGALRM,SIG_IGN);
#endif
}

void RecvAck()
{
    int done = 0;

    while(!done){
	RcvBuf(1);
	switch(buf[0]){
	 case 0x6c: /* extend mode 1 */
	     RecvAck6c();
	     done=1;
	     break;
	 case 0x64: /* extend mode 2 */
	     RecvAck64();
	     done=1;
	     break;
	 case 0x60:
	     ign_action();
	     VaSendHex(0x61, EOL);
	     SendStrNoLen(ID_CELRW);
	     SendStrNoLen("           ");
	     RcvBuf(2); /* 64 08 */
	     VaSendHex(0x6c, 0x0b, 0x00, 0x00, EOL);
	     RcvBuf(4); /* 6c 0c 64 05 */
	     VaSendHex(0x6c, 0x05, 0x00, 0x03, 0x00, 0x00, EOL);

	     nogroup=1;
	     done=1;
	     break;
	}
    }
}

int SendMemoryAck(code)
     int code;
{
    int ret = 1;
    unsigned char c;

    if (read(mfd, &c, 1) < 0) {
	perror("SendMemoryAck:read");
	h_signal();
    }
    if (c != 0x64) {
	ret = 0;
    }
    DOUT((stderr, "required:64, received:%02x\n", c));

    if (read(mfd, &c, 1) < 0) {
	perror("SendMemoryAck:read");
	h_signal();
    }
    if (c == 0x0b) {
	ret = 0;
    }
    if (c != code && c != 0x0b && c != 0x00) { /* ok nor incomplete */
	ret = 0;
    }
    DPRI3("required:%02x, received:%02x\n", code, c);

    return(ret);
}

void establish_connection()
{
    MSG1("establishing connection ...");
    /* make connection */
    SendHex(0xa8);
    sleep(2);
    SendHex(0xa8);

#if PORTWAIT
    mwait(200);
#endif

    /* recv 64 01 */
    /* send 6c 01 */
    RecvAck();
    MSG1("done\n");

}

void StoreCellular()
{
    int temp_mem = 999, temp_grp = 99;
    int x;
    int eog;

    establish_connection();

    sleep(2);

    ALARMW {
	RcvMsgMask(1,0xa3,0x7f);
    }

    /* enter passcode on cellular */
    (void) fprintf(stderr,"Input your pass code into cellular\n");

    /*
      sleep(2);
    */
    /* recv 64 02 xx: set baud rate */
    /* send 6c 02 xx: set baud rate */
    RcvBufVerify(3,0x64);

    /* request speed */
    if (force_baud) {
	x = baud_code(baud);
    } else {
	x = buf[2];
    }
    VaSendHex(0x6c, 0x02, x, EOL);

    /* change baud */
    change_baud_code(x);

    /* any 4 digit */
    (void) fprintf(stderr,"Input any 4 digit into cellular\n");

    /* recv: 64 03 9a 9a 9a 9a 64 04 */
    RcvBuf(8);

    /* send: 6c 03 */
    SendPasswdSuccess();

    /* recv 64 0e 02 & ack*/
    /* send 6c 0e 02 */
    ALARMW {
	RecvAck();
    } ELSE {
	ALARMW {
	    /* for HD-50S */
	    VaSendHex(0x64, 0x0e, 0x03, 0x01, 0x00, EOL);
	    ReceiveMsg(5,0x6c);
	} ELSE {
	    /* for J-PE02 */
	    RecvAck();
	}
    }

    /* send max grp and num */

    if (!nogroup) {
	/* group num and memory num to send are identical with that of read */
	ALARMW {
	    GetMaxNum(0x64, &temp_mem, &temp_grp);
	    SendMaxGroup(0x6c, temp_mem, temp_grp);
	}
	ign_action();

	DPRI3("cel: grp=%d, mem=%d\n", temp_grp, temp_mem);

	if (!ignore_group) {
	    /* send multiple group */
	    eog = 0;
	    while(eog == 0){
		/* 64 07 : get group */
		if (!SendMemoryAck(0x07)) {
		    eog=1;
		} else {
		    eog = SendOneGroup();
		}
	    }
	} else {
	    /* recv 64 07 */
	    RcvBuf(2);
	    SendEndOfGroup();
	}
    }

    /* send multiple memory */
    eog = 0;
    while(eog == 0){
	/* 64 06 : get memory */
	if (!SendMemoryAck(0x06)) {
	    eog=1;
	    n_mem--;
	    (void) fprintf(stderr, "Write error occurred while sending memory\n");
	    (void) fprintf(stderr,"%d\t%d\t%d\t%s\t%s\t%s.\n",
			   file_mem_num[n_mem],
			   file_mem_grp[n_mem],
			   file_mem_secret[n_mem],
			   file_mem_yomi[n_mem],
			   file_mem_kanji[n_mem],
			   file_mem_phone[n_mem]);
	} else {
	    eog = SendOneMemory();
	}
    }

    sleep(2);
    /* memory copy done */
    VaSendHex(0xa8, EOL);

    (void) fprintf(stderr,"send memory done.\n");
}

void ReadCellular(passwd)
     char *passwd;
{
    int x;
    unsigned char next;

    establish_connection();

    /*
      sleep(2);
    */
    ALARMW {
	RcvMsgMask(1,0xa3,0x7f);
    }

    sleep(2);

    /* request speed */
    /* send 64 02 xx */
    /* recv 6c 02 xx */

    x = baud_code(baud);
    VaSendHex(0x64, 0x02, x, EOL);
#if PORTWAIT
    mwait(200);
#endif
    RcvBufVerify(3,0x6c);

    /* change baud */
    change_baud_code(buf[2]);

    sleep(2);

    /* send passwd  */
    MSG1("sending password\n");
    VaSendHex(0x64, 0x03, EOL);
    SendStrNum(passwd);
    VaSendHex(0x64, 0x04, EOL);

#if PORTWAIT
    mwait(200);
#endif

    /*
     * recv 6c 03 => success
     * recv 6c 04 => fail
     */
    if (msg_wait_compare(2,0x6c,0x03)) {
	(void) fprintf(stderr,"passwd OK\n");
    } else {
	(void) fprintf(stderr,"invalid passwd\n");
	h_signal();
    }

    /*
     * read group
     * send 64 0e 02
     * recv 6c 0e 02
     */
    VaSendHex(0x64, 0x0e, 0x02, EOL);
#if PORTWAIT
    mwait(200);
#endif
    /* for HD-50S hack */
    ALARMW {
	/* for HD-50S hack */
	/*
	  ReceiveMsg(3,0x6c);
	*/
	RcvBuf(1);
	switch(buf[0]){
	 case 0x6c:
	     RcvBuf(1);
	     if (buf[0] != 0x07) {
		 RcvBuf(1);
	     }
	     break;
	 case 0x64:
	     /* for HD-50S */
	     RcvBuf(4);
	     VaSendHex(0x6c, buf[0], buf[1], buf[2], buf[3], EOL);
	     break;
	}
    } ELSE {
	/* DP144 */
	VaSendHex(0x60, EOL);
	RcvBuf(1);
	RcvStr(8, dummy);
	DOUT((stderr,"str=[%s]\n",dummy));
	ALARMW {
	    RcvStr(8, dummy);
	    DOUT((stderr,"additional str=[%s]\n",dummy));
	} ELSE {
	}
	VaSendHex(0x64, 0x08, EOL);
	RcvBuf(4); /* 6c 0b 00 00 */
	VaSendHex(0x6c, 0x0c, 0x64, 0x05, EOL);
	RcvBuf(6); /* 6c 05 00 03 00 00 */

	nogroup = 1;
    }

    /*
     * send max group num
     * send 64 0d
     */
    SendMaxGroup(0x64, 999, 99);

#if PORTWAIT
    mwait(1000);
#endif

    ALARMW {
	GetMaxNum(0x6c, &max_mem, &max_grp);
	DPRI3("max_mem=%d max_grp=%d\n",
	      max_mem, max_grp);
    } ELSE {
	max_mem = 999;
	max_grp = 99;
    }
    ign_action();
    (void) printf("N\t%d\t%d\n",
		  max_mem, max_grp);

    /* get groups */
    if (!nogroup) {
	while(GetGroup());
    }

    /* get memory */
    while(GetMemory());
}

int GetOneMail()
{
    int ret = 1;
    int len;
    int num;

    /* request mail data */
    VaSendHex(0x14, EOL);

    /* 0x15:read memory, 0x18:data end */
    RcvBuf(1);

    if (buf[0] == 0x15) {
	/* read memory */

	(void) printf("M\t");

	/* 00 00 */
	num = RcvNumber();
	(void) printf("%d\t0\t0\t",num);
	DOUT((stderr,"number:%d\n", num));
	MSG((stderr,"getting memory #%d\n",num));

	/* kana */
	len = RcvByte();
	if (len) {
	    RcvStr(len, buf);
	    (void) printf("%s\t",buf);
	    DOUT((stderr,"kana:%s\n", buf));
	} else {
	    (void) printf("???\t");
	}

	/* kanji */
	len = RcvByte();
	if (len) {
	    RcvStr(len, buf);
	    (void) printf("%s\t",buf);
	    DOUT((stderr,"kanji:%s\n", buf));
	} else {
	    (void) printf("???\t");
	}

	/* address */
	len = RcvByte();
	if (len) {
	    RcvStr(len, buf);
	    (void) printf("000\t%s",buf);
	    DOUT((stderr,"address:%s\n", buf));
	} else {
	    (void) printf("000\t???");
	}
	(void) printf("\n");
	/* 00 00 00 00 00 00 */
	RcvBuf(6);
	/* check sum */
	RcvBuf(2);
	/* 00 00 */
	RcvBuf(2);
    } else {
	ret = 0;
    }

    return ret;
}

void read_mail_spool()
{
    char dummy[256];
    int col, even;
    int len;
    int num;
    int email01, email02;
    int priority, privacy, haisin_verify;
    int pin, polling;
    int year, month, day, hour, min, temp;

    DOUT((stderr, "\nread_mail_spool()\n"));

    reset_mail_sum();

    /* 00 03 0b 00 04 00 01(mail start) */
    RcvBuf(7);
    num = RcvNumber();
    DOUT((stderr,"mail number=%d\n", num));

    /* from number */
    col = RcvShort();

    /* 00 09(number start) */
    RcvBuf(2);

    even = col%2;
    RcvSwapNum(dummy, col/2+1+even, even);

    DOUT((stderr, "from phone=%s\n", dummy));

    /* skip dummy ff */
    RcvBuf(20 - (col + even));


    /* to number */
    col = RcvShort();

    /* 00 09(cellular) 09 03(email)*/
    RcvBuf(2);

    even = col%2;
    RcvSwapNum(dummy, col/2+1+even, even);

    DOUT((stderr, "to phone=%s\n", dummy));

    /* skip dummy ff */
    RcvBuf(20 - (col + even));

    /* skip to mail body */
    DOUT((stderr, "skip to mail body\n"));
    RcvBuf(4);

    /* 0x61:sokutatu, 0x21:normal */
    priority = RcvByte();
    DOUT((stderr, "priority = %s\n", (priority == 0x61)?"sokutatu":"normal"));

    /* 00 09: skymail , 00 0a: email */
    email01 = RcvByte();
    DOUT((stderr, "email?=%d\n", (email01 == 0x0a)?"email":"sky mail"));

    /* 1:verify 0:no verify */
    haisin_verify = RcvByte();
    DOUT((stderr, "haisin_verify=%d\n", haisin_verify));

    /* 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 */
    RcvBuf(24);

    /* 1: not polling 2: polling */
    polling = RcvByte();
    DOUT((stderr, "polling=%d\n", polling));

    /* privacy level:1-4 */
    privacy = RcvByte();
    DOUT((stderr, "privacy=%d\n", privacy));

    pin = rcv_half()*1000 + rcv_half()*100 + rcv_half()*10 + rcv_half();
    DOUT((stderr, "pin=%d\n", pin));

    /* 00 00 0f 0f 0f 0f 0f 0f */
    RcvBuf(8);

    /* 3f:sky mail 12:email */
    email02 = RcvByte();
    DOUT((stderr, "email?=%d\n", (email02 == 0x12)?"email":"sky mail"));

    /* 00 00 00 00 00 00 00 00 00 00 */
    RcvBuf(10);

    DOUT((stderr,"sum=%x\n", mail_sum - 0xb3));
    RcvBuf(2);

    len = RcvByte();
    /* dummy 00 00 */
    RcvBuf(2);
    RcvStr(len-1, dummy);
    dummy[len] = 0;
    DOUT((stderr, "mail:%s\n", dummy));

    /* date */
    year = rcv_digit();
    month = rcv_digit();
    day = rcv_digit();
    hour = rcv_digit();
    min = rcv_digit();

    DOUT((stderr,"date: %02d/%02d/%02d %02d:%02d\n",
	  year, month, day, hour, min));

    /* 00 00 00 09 00 00 */
    RcvBuf(6);

    temp = rcv_digit();
    DOUT((stderr,"temp=%02d\n", temp));
}

void read_sms_group()
{
    int num, len, sum;

    /* 00 00 01 */
    RcvBuf(1);
    num = RcvByte();
    /* 00 00 */
    RcvBuf(2);
    len = RcvByte();
    if (len) {
	RcvStr(len, buf);
	DOUT((stderr,"group name:%s\n", buf));
    }
    sum = RcvByte();

    DOUT((stderr,"mail group:%d\n", num));
}

void ReadMail(passwd)
     char *passwd;
{
    int x;

    /* rcv: 30 */
    RcvBuf(1);

    VaSendHex(0x24, EOL);

    /* 25: mail group */
    RcvBuf(1);
    while(buf[0] == 0x25) {
	if (buf[0] == 0x25) {
	    /* J-T03 mail group data */
	    read_sms_group();
	}

	VaSendHex(0x24, EOL);
	RcvBuf(1);
    }

    /* rcv: 18 (separator: email addressed) */

    while(GetOneMail());


    /* request mail spool */
    DOUT((stderr, "request mail spool\n"));
    VaSendHex(0x16, EOL);

    /* rcv 17: mail spool
     *      18: abort
     */
    RcvBuf(1);
    while (buf[0] == 0x17) {
	read_mail_spool();
	/* request mail spool */
	VaSendHex(0x16, EOL);
	RcvBuf(1);
    }

    VaSendHex(0x1b, EOL);
    RcvBuf(1);

    VaSendHex(0x1d, EOL);
    RcvBuf(1);

    /* polling data */
    DOUT((stderr, "\nrequest polling data.\n"));
    VaSendHex(0x1f, EOL);
#if 0
    RcvBuf(60);

    VaSendHex(0x18, EOL);
    RcvBuf(0);

    VaSendHex(0x28, EOL);

    RcvBuf(0);
#endif
}

UCHAR calc_sum(str)
     UCHAR *str;
{
    UCHAR *p = str;
    int sum = 0;
    int temp;

    while(*p){
	sum += *p;
	p++;
    }

    temp = sum % 256;

    return (UCHAR) temp;
}

void send_one_mail_addr(num, yomi, kanji, email)
     int num;
     UCHAR *yomi, *kanji, *email;
{
    UCHAR sum;

    MSG((stderr, "sending email data #%d\n", num));

    /* request mail data */
    /* rcv 14 */
    RcvBuf(1);

    /* send memory start */
    VaSendHex(0x15, EOL);

    /* 00 00 */
    SendNumber(num);

    if (*yomi) {
	DPRI3("yomi_len=%d len=%d\n", yomi_len, strlen(yomi));
	if (yomi_len && (strlen(yomi)>yomi_len)) {
	    SendStrN(yomi,yomi_len);
	} else {
	    SendStr(yomi);
	}
    } else {
	VaSendHex(0x00, 0x00, EOL);
    }

    if (*kanji) {
	if (kanji_len && (strlen(kanji) > kanji_len)) {
	    SendStrN(kanji, kanji_len);
	} else {
	    SendStr(kanji);
	}
    } else {
	VaSendHex(0x00, 0x00, EOL);
    }

    SendStr(email);

    VaSendHex( 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, EOL);

    sum = calc_sum(email);

    SendChar(sum);

    VaSendHex(0x00, 0x00, EOL);
}

void WriteMail()
{
    int x;
    int i;

    VaSendHex(0x30, EOL);

    /* rcv 24 */
    RcvBuf(1);

#if 0
    /* J-T03 mail group data */
    /* 25 */
    VaSendHex(0x25, EOL);
    /* 00 00 01 00 00 00 00 00 00 */
    VaSendHex(0x00, 0x00, 0x01, 0x00, 0x00,
	      0x00, 0x06,
	      0x08, 0x02, 0x0b, 0x00, 0x08, 0x02, 0x0e, 0x09, 0x08, 0x02, 0x05, 0x00,
	      0x06, 0x0f, EOL);
    /* Rcv: 24 */
    RcvBuf(1);
    RcvBuf(0);
#endif

    /* email */
    VaSendHex(0x18, EOL);

    /* send name & address data */
    for(i=0; i<read_mem_num; i++){
	if (file_mem_email[i][0]){
	    DOUT((stderr, "i=%d[%c]\n", i, file_mem_email[i][0]));
	    send_one_mail_addr(file_mem_num[i],file_mem_yomi[i],
			       file_mem_kanji[i], file_mem_email[i]);
	}
    }

    /* rcv 14 */
    RcvBuf(1);

    /* end email address */
    VaSendHex(0x18,EOL);

    /* rcv 16: mail spool request */
    RcvBuf(1);

    /* do not send mail spool */
    /*
      VaSendHex(0x17,EOL);
      VaSendHex(0x00, 0x03, 0x0b, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x09, 0x09, 0x0a, 0x01, 0x0a, 0x05, 0x07, 0x07, 0x03, 0x0a, 0x0a, 0x0a, 0x09, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x05, 0x00, 0x09, 0x02, 0x01, 0x04, 0x03, 0x09, 0x05, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x03, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x09, 0x00, 0x07, 0x00, 0x00, 0x08, 0x02, 0x0a, 0x00, 0x08, 0x02, 0x0d, 0x09, 0x08, 0x02, 0x0c, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x0d, 0x0a, EOL);
    */


    VaSendHex(0x18,EOL);

    /* rcv 1b */
    RcvBuf(1);
    VaSendHex(0x18, EOL);

    /* rcv 1d */
    RcvBuf(1);
    VaSendHex(0x18, EOL);

    /* rcv 1f: send polling data */
    RcvBuf(1);
    VaSendHex(0x20, 0x00, 0x00, 0x08, 0x08, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x09, 0x00, 0x00, 0x09, 0x06, 0x01, 0x01, 0x00, 0x00, 0x08, 0x0c, 0x06, 0x06, 0x08, 0x0e, 0x0a, 0x06, 0x09, 0x04, 0x0c, 0x02, 0x00, 0x0e, 0x04, 0x03, 0x05, 0x0e, 0x03, 0x00, 0x04, 0x00, 0x00, 0x0f, 0x08, 0x02, 0x0c, 0x08, 0x08, 0x02, 0x0b, 0x05, 0x03, 0x0c, EOL);

    /* rcv 18 */
    RcvBuf(1);
}

void sms_init()
{
    int x;

    establish_connection();

    ALARMW {
	RcvMsgMask(1,0xa3,0x7f);
    }

    sleep(2);

    /* send: break; 6c 07 */
    VaSendHex(0x6c, 0x07, EOL);

    (void) fprintf(stderr, "push cellular for SMS transfer.\n");

    /* wait 1c 0e 0c 0d */
    VaWait(4, 0x1c, 0x0e, 0x0c, 0x0d, EOL);

    VaSendHex(0x1c, 0x0e, 0x0c, 0x0d, EOL);

    /* baud rate */
    RcvBufVerify(2,0x25);
    x = buf[1];
    VaSendHex(0x25, x, EOL);
    change_baud_code(x);

    sleep(1);

    (void) fprintf(stderr, "enter passcode on cellular\n");
    /* rcv passcode(07) : 10 9a 9a 9a 9a aa */
    /* (0f): 90 9b 1b */
    RcvBuf(6);

    /* cellular info */
    /*
    VaSendHex(0x11, 0x13, 0x00, 0x02, 0x05, 0x00, 0x00, 0x01, 0x04, 0x01, 0x04, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x08, EOL);
    */
    /* J-D03 */
    VaSendHex(0x11, 0x13, 0x00, 0x02, 0x0a, 0x00, 0x00, 0x01, 0x08, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x06, 0x03, 0x0f, 0x06, 0x03, 0x00, 0x07, EOL);

    SendStrNoLen(ID_CELRW);
    send_hexs("09 09 09 09 09 09");

    VaSendHex(0x00, 0x00, 0x03, 0x0a, EOL);

    /* rcv 13...0a */
    RcvBuf(24);
    RcvStr(6, dummy);
    RcvBuf(4);
    DPRI2("remote id=[%s]\n",
	  dummy);
    RcvBuf(4);
}


void force_sms_init(passwd)
{
    int x;

    establish_connection();

    ALARMW {
	RcvMsgMask(1,0xa3,0x7f);
    }

    sleep(2);

    /* send: break; 6c 07 */
    VaSendHex(0x6c, 0x07, EOL);


    VaSendHex(0x1c, 0x0e, 0x0c, 0x0d, EOL);
    /* wait 1c 0e 0c 0d */
    VaWait(4, 0x1c, 0x0e, 0x0c, 0x0d, EOL);

    /* baud rate */
    VaSendHex(0x25, 0x0f, EOL);
    RcvBufVerify(2,0x25);
    x = buf[1];
    change_baud_code(x);

    sleep(1);

    /* send passcode */
    VaSendHex(0x10, EOL);
    SendStrNum(passwd);
    VaSendHex(0xaa, EOL);

    /* rcv 13...0a */
    RcvBuf(24);
    RcvStr(6, dummy);
    RcvBuf(4);
    DPRI2("remote id=[%s]\n",
	  dummy);
    RcvBuf(4);

    /* cellular info */
    VaSendHex(0x11, 0x13, 0x00, 0x02, 0x05, 0x00, 0x00, 0x01, 0x04, 0x01, 0x04, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00, 0x08, EOL);
    SendStrNoLen(ID_CELRW);
    send_hexs("09 09 09 09 09 09");

    VaSendHex(0x00, 0x00, 0x03, 0x0a, EOL);

}

void WriteMail2()
{
    sms_init();

    WriteMail();
}

void ReadMail2(passwd)
     char *passwd;
{
    force_sms_init(passwd);
    ReadMail();
}

void ReadMail3(passwd)
     char *passwd;
{
    sms_init();
    ReadMail();
}

void read_dial()
{
    unsigned char c = 0;
    unsigned char *p = str_dial;

    DOUT((stderr, "read_dial:"));
    do {
	if (read(mfd, &c, 1) < 0) {
	    perror("read_dial");
	    h_signal();
	}
	if (c < 0xc0) {
	    DOUT((stderr, "%02x ", c));
	    if (c==0x9a) {
		*p++ = c - 0x6a;
	    } else {
		*p++ = c - 0x60;
	    }
	}
    } while (c != 0xaa);
    DOUT((stderr, "\n"));
    *p = 0;
}

void establish_connection2()
{
    send_hexs("8e");
    sleep(1);
    read_dial();
    send_hexs("8e");
    sleep(1);
    read_dial();
}

void kddi_display_info()
{
    int num;

    num = (kddi_entry[0x0b][0]<<8)+kddi_entry[0x0b][1];
    (void) fprintf(stdout,"M\t%d\t%d\t0\t%s\t%s\t%s\t%s\n",
		   num,
		   kddi_entry[10][1],kddi_entry[2],kddi_entry[1],
		   kddi_entry[3],kddi_entry[5]);
}

void kddi_read_cluster()
{
    rcv_buf(2,0); // 01 80
    kddi_buf_size = RcvShort();
    DOUT((stderr,"kddi_buf_size=%d\n", kddi_buf_size));
    rcv_buf(kddi_buf_size,0); // 02
    kddi_ptr = 1;
}

unsigned char kddi_buf()
{
    unsigned char ret;

    ret = buf[kddi_ptr++];
    if (kddi_ptr >= kddi_buf_size-3) {
	send_hexs("06");
	if (buf[kddi_ptr] == 0x03) {
	    kddi_buf_size = 0;
	} else {
	    kddi_read_cluster();
	}
    }

    return ret;
}

void kddi_cmd_begin()
{
    cksum = 0;
    send_hexs("01 00");
}

void kddi_bin_begin()
{
    send_hexs("02");
}

void kddi_bin_end()
{
    send_hexs("03");
}

void kddi_change_baud(b)
     int b;
{
    kddi_cmd_begin();
    send_short(10);
    kddi_bin_begin();
    send_hexs("00 01"); // specify baud rate
    send_long(b);
    kddi_bin_end();
    rev_cksum();
}

void kddi_negociate_baud_rate()
{
    int i = NUM_BAUD-1;

    do {
	kddi_change_baud(valid_baud[i]);
	rcv_buf(1,IGNORE_CF); // 06
	if (buf[0] == 0x06) {
	    change_baud_code(valid_baud[i]);
	    break;
	}
	i--;
    } while (i>=0);

    if (i<0) {
	(void) fprintf(stderr,"cant set baud rate.\n");
	h_signal();
    }
}

void kddi_bin_connection(passwd)
     char *passwd;
{
    int num;
    int temp_mem = 999, temp_grp = 99;
    int frame_size;

    establish_connection2();

    send_hexs("b3 0e 02");
    rcv_buf(3, IGNORE_CF); // 6c 0e 02

    SendMaxGroup(0xb3, temp_mem, temp_grp);
    GetMaxNum(0x6c, &temp_mem, &temp_grp);

    send_hexs("d0 01 05");
    rcv_buf(3, IGNORE_CF); // d0 01 06

    sleep(1);

    send_hexs("05");
    rcv_buf(1,IGNORE_CF); // 06
    // 00 00: SetProtocolVersion
    // 00 01 00 00: protol version = 010000h
    send_hexs("01 00 00 0a 02 00 00 00 01 00 00 03 ff ee");
    rcv_buf(1,IGNORE_CF); // 06

    frame_size = 0x00001000;
    do {
	cksum = 0;
	kddi_cmd_begin();
	send_short(10);
	kddi_bin_begin();
	send_hexs("00 03"); // SetFrameSize
	send_long(frame_size);
	send_hexs("03");
	rev_cksum();

	rcv_buf(1,IGNORE_CF); // 06

	frame_size /= 2;
    } while (buf[0] != 0x06);

    kddi_negociate_baud_rate();

    sleep(1);

    // 02 04: GetProfile , 00 00 Generic Profile
    send_hexs("01 00 00 08 02 02 04 00 00 03 ff eb");
    rcv_buf(1,IGNORE_CF); // 06

    rcv_buf(2,0); // 01 80
    num = RcvShort(); // 00 40
    rcv_buf(num, 0);

    send_hexs("06");

    // 02 04: GetProfile , 01 00 Extended Profile
    send_hexs("01 00 00 08 02 02 04 01 00 03 ff ea");

    rcv_buf(1,IGNORE_CF); // 06
    rcv_buf(2,0); // 01 80
    num = RcvShort(); // 00 4a
    rcv_buf(num, 0);

    send_hexs("06");

    // authorize password
    sum_mode = SUM_BYTE;
    cksum = 0;
    send_hexs("01 00 00 0a 02 00 21"); // 00 21:SetLockNo
    send_raw_str(passwd);
    send_hexs("03");
    rev_cksum();

    rcv_buf(1,IGNORE_CF); // 06
}

void kddi_bin_read(passwd)
     char *passwd;
{
    int x;
    unsigned char next;
    int i,num;
    unsigned char *q, c;
    unsigned char cmd;
    int stored;

    kddi_bin_connection(passwd);

    // get memory
    send_hexs("01 00 00 0a 02 02 20 01 03 00 00 03 ff c9");
    do {
	rcv_buf(1,IGNORE_CF); // 06
    } while(buf[0] != 0x06);

    stored = 0;

    kddi_read_cluster();
    do {
	c = kddi_buf();

	switch (c) {
	 case 0x1c: // line start
	     if (stored) {
		 kddi_display_info();
	     }
	     for(i=0; i<KDDI_ENTRY_NUM; i++){
		 kddi_entry[i][0] = 0;
	     }
	     stored = 0;
	     break;

	 case 0x1e: // entry start
	     /*
	      * 01: kanji
	      * 02: kana
	      * 03: phone number
	      * 04: 0x10
	      * 05: email
	      * 06: 0x17
	      * 07: 0x01
	      * 0a: group
	      * 0b: number
	      * 10: date
	      */
	     cmd = kddi_buf();
	     switch (cmd) {
	      case 0x01:
	      case 0x02:
	      case 0x03:
	      case 0x05:
	      case 0x0a:
		  stored = 1;
		  break;
	     }
	     num = (kddi_buf()<<8) + kddi_buf();
	     kddi_entry[cmd][num] = 0;
	     q = kddi_entry[cmd];
	     for(i=0; i<num; i++){
		 *q++ = kddi_buf();
	     }
	     if (cmd == 0x0b) {
		 num = (kddi_entry[0x0b][0]<<8)+kddi_entry[0x0b][1];
		 MSG((stderr,"getting memory #%d\n",num));
	     }
	     break;
	}
    } while (kddi_buf_size);

    if (stored) {
	kddi_display_info();
    }

    send_hexs("04");

    sleep(1);
}

int kddi_send_memory()
{
    /* skip no_data area */
    while(n_mem<read_mem_num &&
	  *file_mem_phone[n_mem] == 0) {
	n_mem++;
    }

    if (n_mem < read_mem_num) {
	int bytes;
	// estimate data bytes
	bytes = 2+4+strlen(file_mem_kanji[n_mem]) +
	    4 + strlen(file_mem_yomi[n_mem]) +
	    4 + strlen(file_mem_phone[n_mem]) +
	    5 +
	    4 + strlen(file_mem_email[n_mem]) +
	    5+5+6+6+1+2;

	cksum = 0;
	send_hexs("01 80"); // data

	send_short(bytes);
	send_hexs("02");
	send_hexs("1c");

	send_hexs("1e 01");
	send_short(strlen(file_mem_kanji[n_mem]));
	send_raw_str(file_mem_kanji[n_mem]);

	send_hexs("1e 02");
	send_short(strlen(file_mem_yomi[n_mem]));
	send_raw_str(file_mem_yomi[n_mem]);

	send_hexs("1e 03");
	send_short(strlen(file_mem_phone[n_mem]));
	send_raw_str(file_mem_phone[n_mem]);

	send_hexs("1e 04 00 01 10");

	send_hexs("1e 05");
	send_short(strlen(file_mem_email[n_mem]));
	send_raw_str(file_mem_email[n_mem]);

	send_hexs("1e 06 00 01 17");
	send_hexs("1e 07 00 01 01");

	send_hexs("1e 0a 00 02");
	send_short(file_mem_grp[n_mem]);

	send_hexs("1e 0b 00 02");
	send_short(file_mem_num[n_mem]);

	n_mem++;
	if (n_mem < read_mem_num) {
	    send_hexs("17");
	} else {
	    send_hexs("03");
	}
	rev_cksum();

	do {
	    rcv_buf(1,IGNORE_CF); // 06
	} while (buf[0] != 0x06);

    } else {
	return 1;
    }

    return 0;
}

void kddi_bin_write(passwd)
     char *passwd;
{
    int x;
    unsigned char next;
    int i,num;
    unsigned char *q, c;
    unsigned char cmd;
    int stored;

    kddi_bin_connection(passwd);

    // put memory
    cksum = 0;
    send_hexs("01 00 00 0a 02 01 20 01 03 00 00 03");
    rev_cksum();
    rcv_buf(1,IGNORE_CF); // 06

    while(!kddi_send_memory());

    send_hexs("04");

    sleep(1);
}

void send_raw_file(fsize)
     int fsize;
{
    FILE *fp;
    unsigned char c, *p;
    int size;
    unsigned int a;
    int i;

    // send each 01fc bytes
    // 02:start, 17:continue, 03:last
    if ((fp = fopen(binary_fname,"r")) == NULL){
	(void) fprintf(stderr,"Can't open [%s].\n", binary_fname);
	exit(1);
    }

    while (fsize) {
	size = fread(buf,1,0x01fc-4,fp);
	fsize -= size;

	cksum=0;
	send_hexs("01 80");

	a = size + 4;
	SendHex(a>>8);
	SendHex(a&0xff);
	cksum += (a>>8) + (a&0xff);

	send_hexs("02");
	p = buf;
	for(i=0; i<size; i++){
	    SendHex(*p);
	    cksum += *p;
	    p++;
	}

	if (size == 0x01fc-4) {
	    send_hexs("17");
	} else {
	    send_hexs("03");
	}
	rev_cksum();

	do {
	    rcv_buf(1,IGNORE_CF); // TUKA 07 06, AU 06
	} while(buf[0] != 0x06);
    }

    (void) fclose(fp);
}

void kddi_file(passwd)
     char *passwd;
{
    int x;
    unsigned char next, *p;
    unsigned int a;
    unsigned char c;
    int num;
    int size;

    kddi_bin_connection(passwd);

    // filename
    p = strrchr(binary_fname, '/');
    if (!p) {
	p = binary_fname;
    } else {
	p++;
    }
    size = strlen(p) + 3+3+2+1+2;
    cksum=0;
    kddi_cmd_begin();
    send_short(size);
    kddi_bin_begin();
    send_hexs("01 10"); // PutFile
    send_raw_str(p);

    size = get_file_size();
    send_hexs("00");
    send_long(size);

    kddi_bin_end();
    rev_cksum();

    rcv_buf(1,IGNORE_CF); // 06

    // file
    send_raw_file(size);

    send_hexs("04");

    sleep(1);
}

void voda_send_binary_file()
{
    FILE *fp;
    unsigned char c;
    int size;

    if ((fp = fopen(binary_fname,"r")) == NULL){
	(void) fprintf(stderr,"Can't open [%s].\n", binary_fname);
	exit(1);
    }

    do {
	size = fread(&c,1,1,fp);
	if (size>0) {
	    SendChar(c);
	    cksum += c;
	}
    } while(!feof(fp));

    (void) fclose(fp);
}

void voda_file(passwd)
     char *passwd;
{
    int x;
    unsigned char next, *p, *q, *r;
    int temp_mem = 999, temp_grp = 99;
    time_t t;
    unsigned int a;
    unsigned char c;

    establish_connection2();

    send_hexs("b3 0e 02");
    rcv_buf(3, IGNORE_CF); // 6c 0e 02

    SendMaxGroup(0xb3, temp_mem, temp_grp);
    GetMaxNum(0x6c, &temp_mem, &temp_grp);

    send_hexs("1c 0e 0e 0d");
    rcv_buf(4, IGNORE_CF); // 1c 0e 0e 0d

    sleep(1);

    send_hexs("25 0f");
    do {
	rcv_buf(1,IGNORE_CF); // 25 03
    } while (buf[0] != 0x25);

    rcv_buf(1,IGNORE_CF);
    switch (buf[0]) {
     case 3:
	 DOUT((stderr, "change baud to 9600\n"));
	 change_baud(B9600);
	 break;
     case 7:
	 DOUT((stderr, "change baud to 19200\n"));
	 change_baud(B19200);
	 break;
     case 0x0f:
	 DOUT((stderr, "change baud to 38400\n"));
	 change_baud(B38400);
	 break;
     default:
	 (void) fprintf(stderr, "unsupported baud code [%02x]\n", buf[0]);
	 break;
    }

    sleep(1);

    // authorize password
    send_hexs("10");
    SendStrNum(passwd);
    send_hexs("aa");

    rcv_buf(1,IGNORE_CF); // 51=success, 30=fail
    if (buf[0] != 0x51) {
	MSG((stderr, "invalid password\n"));
	h_signal();
    }

    // filename
    p = strrchr(binary_fname, '/');
    if (!p) {
	p = binary_fname;
    } else {
	p++;
    }

    // filetype
    q = strrchr(binary_fname, '.');
    if (!p) {
	q = "mmf";
    } else {
	q++;
    }

    // mail body
    send_hexs("53");
    cksum = 0;
    sum_mode = SUM_STR;
    SendStrNoLen("LMLSUB\r\n");
    SendStrNoLen("VER:2\r\n");
    SendStrNoLen("ADD:hoge\r\n");
    SendStrNoLen("FWD:L\r\n");
    SendStrNoLen("DTID:MS\r\n");
    if (!strcmp(q, "mmf")) {
	r = "application/x-smaf";
    } else if  (!strcmp(q, "smd")) {
	r = "audio/smd";
    } else if  (!strcmp(q, "jpg")) {
	r = "image/jpeg";
    } else if  (!strcmp(q, "png")) {
	r = "image/png";
    } else {
	(void) fprintf(stderr,"Unsupported file type.\n");
	exit(-1);
    }
    SendStrNoLen("CNT:");
    SendStrNoLen(r);
    SendStrNoLen(";name=\"");
    SendStrNoLen(p);
    SendStrNoLen("\"\r\n");


    SendStrNoLen("TO:");
    SendStrNoLen(p);
    SendStrNoLen("\r\n");

    SendStrNoLen("DATE:");
    t = time(NULL);
    strcpy(buf, ctime(&t));
    buf[strlen(buf)-1]=0;
    SendStrNoLen(buf);
    SendStrNoLen("\r\n");

    SendStrNoLen("SUBJ:");
    SendStrNoLen(p);
    SendStrNoLen("\r\n");

    SendStrNoLen("\r\n");
    DOUT((stderr,"sending binary file\n"));
    voda_send_binary_file();
    DOUT((stderr,"send binary file end\n"));
    SendStrNoLen("\r\n");
    SendStrNoLen(".\r\n");
    DOUT((stderr,"\nsum=%x\n", cksum));
    a = cksum & 0xff;
    SendChar((unsigned char) a);
    send_hexs("15");

    DOUT((stderr,"Result:\n"));
    rcv_buf(1,IGNORE_CF); // 53

    c=0;
    a = 0;
    do {
	if (read(mfd, &c, 1) < 0) {
	    perror("voda_file");
	    h_signal();
	}
	if (c<0x10){
	    if (!a) {
		x = c<<4;
	    } else {
		x += c;
		DOUT((stderr,"%c", x));
	    }
	    a = 1-a;
	} else {
	    DOUT((stderr,"%02x ",c));
	}
    } while (c != 0x15);
    DOUT((stderr,"\n"));

    send_hexs("1c 02 08 0d");
    rcv_buf(4,IGNORE_CF); //CEL:1c 02 08 0d 
}

UCHAR *input_passwd()
{
    TERMIO sg0, sg1;
    int i;
    UCHAR c;
    static UCHAR b[10];

    Tcgeta(0, &sg0);
    Tcgeta(0, &sg1);

    sg1.c_lflag &= ~(ECHO|ICANON);
    sg1.c_lflag |= ISIG;

    Tcseta(0, &sg1);

    (void) fprintf(stderr,"input passwd : ");
    (void) fflush(stderr);

    for(i=0; i<4; i++){
	c = (UCHAR) getchar();
	(void) fprintf(stderr,"*");
	(void) fflush(stderr);
	b[i] = c;
    }
    b[4] = '\0';
    (void) fprintf(stderr,"\n");

    Tcseta(0, &sg0);

    return(b);
}

void ListKind()
{
    int i;

    (void) fprintf(stderr,"Supported non-generic cellulars are:\n");
    for(i=0; i<KIND_NUM; i++){
	(void) fprintf(stderr,"\t%s\n",cel_kind[i].str);
    }
}

void Usage(name)
     char *name;
{
    (void) fprintf(stderr,"\n\
usage:\n\
%s [-w file][-b baud][-d dev][-k kind][-p][-num password][-v][-help]\n\
\n\
	-r	: read from cellular\n\
	-w file : write file data to cellular [default is read]\n\
	-vr	: read vodafone mail address\n\
	-vw file 	: write vodafone mail address\n\
	-vw2 file	: write vodafone mail address(method 2)\n\
	-vfile file	: send file to vodafone\n\
	-kr		: read KDDI mail address\n\
	-kw file	: write KDDI mail address\n\
	-kfile file	: send file to KDDI\n\
        -b baud : baud rate (600,2400,9600) [default:9600 bps]\n\
        -d dev  : serial device [default: /dev/ttyS0]\n\
	-k kind : kind of cellular\n\
	-p      : use default password\n\
	-num pw : password for cellular [NOT RECOMMEND]\n\
	-yomilen len : restrict yomi length\n\
	-kanjilen len : restrict kanji length\n\
	-nogroup: don't write group data\n\
	-v	: display version\n\
	-V	: not verbose\n\
	-help	: display this message\n\
\n\
",name);

    ListKind();
}


void process_script(fname)
     char *fname;
{
    FILE *fp;
    int eol = 0;
    unsigned char *p, *q;
    int n, curarg, newarg;

    if ((fp = fopen(fname,"r")) == NULL){
	(void) fprintf(stderr,"Can't open [%s].\n", fname);
	exit(1);
    }

    while (!feof(fp)){
	(void) file_get_token(fp,0); /* command , ignore error(EOF) */
	if (!strcmp(buf, "ESTABLISH")) {
	    printf("establish_connection();\n");
	} else if (!strcmp(buf, "msg")) {
	    while (!file_get_token(fp,0)) {
		(void) printf("%s ",buf);
	    }
	} else if (!strcmp(buf, "sleep")) {
	    (void) file_get_token(fp,0);
	    (void) sscanf(buf, "%d", &n);
	    printf("sleep(n);%d\n",n);
	} else if (!strcmp(buf, "alarmrcv")) {
	    (void) file_get_token(fp,0);
	    n = ascii2hex(buf);
	    printf("ALARMW {RcvMsgMask(1,n,0x7f);}%x\n",n);
	} else if (!strcmp(buf, "baud")) {
	    (void) file_get_token(fp,0);
	    (void) sscanf(buf,"%d",&n);
	    printf("change_baud_code(n);%d\n",n);
	} else if (!strcmp(buf, "wait")) {
	    curarg = 0;
	    n = 0;
	    p = NULL;
	    while(!file_get_token(fp,0)) {
		if (n>= curarg) {
		    newarg = curarg + ARGSIZE;
		    q = (unsigned char *) malloc(newarg);
		    if (p) {
			memcpy(q, p, curarg);
			free(p);
		    }
		    curarg = newarg;
		    p = q;
		}
		p[n] = ascii2hex(buf);
		printf("%02x ",p[n]);
		n++;
	    }
	    printf("WaitHex(n, p);%d\n",n);
	    free(p);
	} else if (!strcmp(buf, "R")) {
	    (void) file_get_token(fp,0);
	    (void) sscanf(buf,"%d",&n);
	    printf("RcvBuf(n);%d\n",n);
	} else if (!strcmp(buf, "S")) {
	    while(!file_get_token(fp,0)) {
		n = ascii2hex(buf);
		printf("SendHex(n);%02x\n",n);
	    }
	} else {
	    (void) fprintf(stderr,"unknown command [%s]\n", buf);
	    exit (-1);
	}
    }

    fclose(fp);
}

void SwitchMode(mode,passwd)
     int mode;
     UCHAR *passwd;
{
    switch (mode) {
     case MODE_WRITE:
	 if (read_mem_num == 0) {
	     (void) fprintf(stderr, "You must read file.\n");
	     exit(-1);
	 }
	 StoreCellular();
	 break;
     case MODE_READ:
	 if (passwd == NULL) {
	     passwd = input_passwd();
	 }
	 ReadCellular(passwd);
	 break;

     case MODE_VODA_SMS_READ:
	 if (passwd == NULL) {
	     passwd = input_passwd();
	 }

	 ReadMail2(passwd);

	 break;

     case MODE_VODA_SMS_READ2:
	 if (passwd == NULL) {
	     passwd = input_passwd();
	 }

	 ReadMail3(passwd);

	 break;

     case MODE_VODA_SMS_WRITE:
	 WriteMail2();
	 break;

     case MODE_VODA_SEND_FILE:
	 if (passwd == NULL) {
	     passwd = input_passwd();
	 }
	 voda_file(passwd);
	 break;

    case MODE_KDDI_BIN_READ:
	if (passwd == NULL) {
	    passwd = input_passwd();
	}
	kddi_bin_read(passwd);
	break;

    case MODE_KDDI_BIN_WRITE:
	if (passwd == NULL) {
	    passwd = input_passwd();
	}
	kddi_bin_write(passwd);
	break;

    case MODE_KDDI_SEND_FILE:
	if (passwd == NULL) {
	    passwd = input_passwd();
	}
	kddi_file(passwd);
	break;

     case MODE_SCRIPT:
	 process_script(passwd);
	 break;
    }
}

#ifndef EXP
#define EXP
#else
#include "exp.c"
#endif

int main(argc,argv)
     int argc;
     char **argv;
{
    int mode;
    UCHAR *passwd = NULL;
    char *appname = argv[0];
    int i;
    int valid;

    signal(SIGINT, h_signal);

    mode = MODE_READ;
    baud = 9600;

    /***** analyze command line *****/
    SWITCH_OPT
	EXP
	CASE_OPT("-w"){
	mode = MODE_WRITE;
	ADVANCE_OPT;
	read_file(CURRENT_OPT);
    }
    CASE_OPT("-r"){
	mode = MODE_READ;
    }
    CASE_OPT("-d"){
	ADVANCE_OPT;
	device = CURRENT_OPT;
    }
    CASE_OPT("-num"){
	ADVANCE_OPT;
	passwd = (UCHAR *) CURRENT_OPT;
    }
    CASE_OPT("-yomilen"){
	ADVANCE_OPT;
	(void) sscanf(CURRENT_OPT, "%d", &yomi_len);
    }
    CASE_OPT("-kanjilen"){
	ADVANCE_OPT;
	(void) sscanf(CURRENT_OPT, "%d", &kanji_len);
    }
    CASE_OPT("-nogroup"){
	ignore_group = 1;
    }
    CASE_OPT("-p"){
	passwd = (UCHAR *) PASSCODE;
    }
    CASE_OPT("-kanjicode"){
	ADVANCE_OPT;
	(void) sscanf(CURRENT_OPT, "%d", &kanjicode);
    }
    CASE_OPT("-k"){
	ADVANCE_OPT;
	for(i=0; i<KIND_NUM; i++){
	    if (!strcmp(CURRENT_OPT, cel_kind[i].str)){
		kind = cel_kind[i].num;
	    }
	}
	if (kind == 0) {
	    (void) fprintf(stderr,"Unknown kind of cellular [%s].\n",
			   CURRENT_OPT);
	    ListKind();
	    exit(-1);
	}
    }
    CASE_OPT("-b"){
	ADVANCE_OPT;
	(void) sscanf(CURRENT_OPT, "%d", &baud);
	force_baud = baud;
	valid = 0;
	for(i=0; i<NUM_BAUD; i++){
	    if (valid_baud[i] == baud) {
		valid = 1;
	    }
	}
	if (!valid) {
	    (void) fprintf(stderr,"Invalid baud rate %d.\n", baud);
	    (void) fprintf(stderr,"Valid baud rates are\n");
	    for(i=0; i<NUM_BAUD; i++){
		(void) fprintf(stderr,"%d, ", valid_baud[i]);
	    }
	    (void) fprintf(stderr,"\n");
	    exit(1);
	}
    }
    CASE_OPT("-v"){
	(void) fprintf(stderr,"%s version %s\n",
		       appname,VERSION);
	exit(0);
    }
    CASE_OPT("-V"){
	verbose = 0;
    }
    CASE_OPT("-vr"){
	mode = MODE_VODA_SMS_READ;
    }
    CASE_OPT("-vr2"){
	mode = MODE_VODA_SMS_READ2;
    }
    CASE_OPT("-vw"){
	mode = MODE_VODA_SMS_WRITE;
	ADVANCE_OPT;
	read_file(CURRENT_OPT);
    }
    CASE_OPT("-vfile"){
	mode = MODE_VODA_SEND_FILE;
	ADVANCE_OPT;
	binary_fname = CURRENT_OPT;
    }
    CASE_OPT("-kr"){
	mode = MODE_KDDI_BIN_READ;
    }
    CASE_OPT("-kw"){
	mode = MODE_KDDI_BIN_WRITE;
	ADVANCE_OPT;
	read_file(CURRENT_OPT);
    }
    CASE_OPT("-kfile"){
	mode = MODE_KDDI_SEND_FILE;
	ADVANCE_OPT;
	binary_fname = CURRENT_OPT;
    }
    CASE_OPT("-f"){
	mode = MODE_SCRIPT;
	ADVANCE_OPT;
	passwd = CURRENT_OPT;
    }
    ELSE_OPT {
	Usage(appname);
	exit(1);
    }
    END_OPT;

    OpenDevice();

    SwitchMode(mode,passwd);

    /* reset DoCoMo */
    VaSendHex (0x1f, 0x07, 0x0d, EOL);

    CloseDevice();

    return 0;
}
