/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.util.StringList;
import org.bouncycastle.util.Strings;

public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable = new byte[128];
    private boolean detectMissingChecksum = false;
    InputStream in;
    boolean start = true;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    CRC24 crc = new CRC24();
    boolean crcFound = false;
    boolean hasHeaders = true;
    String header = null;
    boolean newLineFound = false;
    boolean clearText = false;
    boolean restart = false;
    StringList headerList = Strings.newList();
    int lastC = 0;
    boolean isEndOfStream;

    private static int decode(int n, int n2, int n3, int n4, int[] nArray) throws IOException {
        if (n4 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (n3 == 61) {
            int n5 = decodingTable[n] & 0xFF;
            int n6 = decodingTable[n2] & 0xFF;
            if ((n5 | n6) < 0) {
                throw new IOException("invalid armor");
            }
            nArray[2] = (n5 << 2 | n6 >> 4) & 0xFF;
            return 2;
        }
        if (n4 == 61) {
            byte by = decodingTable[n];
            byte by2 = decodingTable[n2];
            byte by3 = decodingTable[n3];
            if ((by | by2 | by3) < 0) {
                throw new IOException("invalid armor");
            }
            nArray[1] = (by << 2 | by2 >> 4) & 0xFF;
            nArray[2] = (by2 << 4 | by3 >> 2) & 0xFF;
            return 1;
        }
        byte by = decodingTable[n];
        byte by4 = decodingTable[n2];
        byte by5 = decodingTable[n3];
        byte by6 = decodingTable[n4];
        if ((by | by4 | by5 | by6) < 0) {
            throw new IOException("invalid armor");
        }
        nArray[0] = (by << 2 | by4 >> 4) & 0xFF;
        nArray[1] = (by4 << 4 | by5 >> 2) & 0xFF;
        nArray[2] = (by5 << 6 | by6) & 0xFF;
        return 0;
    }

    public ArmoredInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public ArmoredInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.in = inputStream;
        this.hasHeaders = bl;
        if (bl) {
            this.parseHeaders();
        }
        this.start = false;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseHeaders() throws IOException {
        block13: {
            this.header = null;
            var2_1 = 0;
            var3_2 = false;
            this.headerList = Strings.newList();
            if (!this.restart) ** GOTO lbl12
            var3_2 = true;
            break block13;
lbl-1000:
            // 1 sources

            {
                if (var1_3 == 45 && (var2_1 == 0 || var2_1 == 10 || var2_1 == 13)) {
                    var3_2 = true;
                    break;
                }
                var2_1 = var1_3;
lbl12:
                // 2 sources

                ** while ((var1_3 = this.in.read()) >= 0)
            }
        }
        if (var3_2) {
            var4_4 = false;
            var5_5 = false;
            var6_6 = new ByteArrayOutputStream();
            var6_6.write(45);
            if (this.restart) {
                var6_6.write(45);
            }
            while ((var1_3 = this.in.read()) >= 0) {
                if (var2_1 == 13 && var1_3 == 10) {
                    var5_5 = true;
                }
                if (var4_4 && var2_1 != 13 && var1_3 == 10 || var4_4 && var1_3 == 13) break;
                if (var1_3 == 13 || var2_1 != 13 && var1_3 == 10) {
                    var7_7 = Strings.fromUTF8ByteArray((byte[])var6_6.toByteArray());
                    if (var7_7.trim().length() == 0) break;
                    if (this.headerList.size() != 0 && var7_7.indexOf(58) < 0) {
                        throw new IOException("invalid armor header");
                    }
                    this.headerList.add(var7_7);
                    var6_6.reset();
                }
                if (var1_3 != 10 && var1_3 != 13) {
                    var6_6.write(var1_3);
                    var4_4 = false;
                } else if (var1_3 == 13 || var2_1 != 13 && var1_3 == 10) {
                    var4_4 = true;
                }
                var2_1 = var1_3;
            }
            if (var5_5 && (var7_8 = this.in.read()) != 10) {
                throw new IOException("inconsistent line endings in headers");
            }
        }
        if (this.headerList.size() > 0) {
            this.header = this.headerList.get(0);
        }
        this.clearText = "-----BEGIN PGP SIGNED MESSAGE-----".equals(this.header);
        this.newLineFound = true;
        return var3_2;
    }

    public boolean isClearText() {
        return this.clearText;
    }

    public boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    public String getArmorHeaderLine() {
        return this.header;
    }

    public String[] getArmorHeaders() {
        if (this.headerList.size() <= 1) {
            return null;
        }
        return this.headerList.toStringArray(1, this.headerList.size());
    }

    private int readIgnoreSpace() throws IOException {
        int n = this.in.read();
        while (n == 32 || n == 9 || n == 12 || n == 11) {
            n = this.in.read();
        }
        if (n >= 128) {
            throw new IOException("invalid armor");
        }
        return n;
    }

    public int read() throws IOException {
        int n;
        if (this.start) {
            if (this.hasHeaders) {
                this.parseHeaders();
            }
            this.crc.reset();
            this.start = false;
        }
        if (this.clearText) {
            int n2 = this.in.read();
            if (n2 == 13 || n2 == 10 && this.lastC != 13) {
                this.newLineFound = true;
            } else if (this.newLineFound && n2 == 45) {
                n2 = this.in.read();
                if (n2 == 45) {
                    this.clearText = false;
                    this.start = true;
                    this.restart = true;
                } else {
                    n2 = this.in.read();
                }
                this.newLineFound = false;
            } else if (n2 != 10 && this.lastC != 13) {
                this.newLineFound = false;
            }
            this.lastC = n2;
            if (n2 < 0) {
                this.isEndOfStream = true;
            }
            return n2;
        }
        if (this.bufPtr > 2 || this.crcFound) {
            n = this.readIgnoreSpace();
            if (n == 13 || n == 10) {
                n = this.readIgnoreSpace();
                while (n == 10 || n == 13) {
                    n = this.readIgnoreSpace();
                }
                if (n < 0) {
                    this.isEndOfStream = true;
                    return -1;
                }
                if (n == 61) {
                    this.bufPtr = ArmoredInputStream.decode(this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
                    if (this.bufPtr == 0) {
                        int n3 = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF;
                        this.crcFound = true;
                        if (n3 != this.crc.getValue()) {
                            throw new IOException("crc check failed in armored message.");
                        }
                        return this.read();
                    }
                    if (this.detectMissingChecksum) {
                        throw new IOException("no crc found in armored message");
                    }
                } else {
                    if (n == 45) {
                        while ((n = this.in.read()) >= 0) {
                            if (n == 10 || n == 13) break;
                        }
                        if (!this.crcFound && this.detectMissingChecksum) {
                            throw new IOException("crc check not found");
                        }
                        this.crcFound = false;
                        this.start = true;
                        this.bufPtr = 3;
                        if (n < 0) {
                            this.isEndOfStream = true;
                        }
                        return -1;
                    }
                    this.bufPtr = ArmoredInputStream.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
                }
            } else if (n >= 0) {
                this.bufPtr = ArmoredInputStream.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else {
                this.isEndOfStream = true;
                return -1;
            }
        }
        n = this.outBuf[this.bufPtr++];
        this.crc.update(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkIndexSize(byArray.length, n, n2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        while (n4 < n2) {
            n3 = this.read();
            if (n3 == -1) break;
            byArray[n + n4] = (byte)n3;
            ++n4;
        }
        return n4;
    }

    private void checkIndexSize(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException("Offset and length cannot be negative.");
        }
        if (n2 > n - n3) {
            throw new IndexOutOfBoundsException("Invalid offset and length.");
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void setDetectMissingCRC(boolean bl) {
        this.detectMissingChecksum = bl;
    }

    static {
        int n = 0;
        while (n < decodingTable.length) {
            ArmoredInputStream.decodingTable[n] = -1;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            ArmoredInputStream.decodingTable[n2] = (byte)(n2 - 65);
            ++n2;
        }
        int n3 = 97;
        while (n3 <= 122) {
            ArmoredInputStream.decodingTable[n3] = (byte)(n3 - 97 + 26);
            ++n3;
        }
        int n4 = 48;
        while (n4 <= 57) {
            ArmoredInputStream.decodingTable[n4] = (byte)(n4 - 48 + 52);
            ++n4;
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }
}

