/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        super(bCPGInputStream);
        this.format = bCPGInputStream.read();
        int n = bCPGInputStream.read();
        this.fileName = new byte[n];
        int n2 = 0;
        while (n2 != this.fileName.length) {
            int n3 = bCPGInputStream.read();
            if (n3 < 0) {
                throw new IOException("literal data truncated in header");
            }
            this.fileName[n2] = (byte)n3;
            ++n2;
        }
        this.modDate = (long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
        if (this.modDate < 0L) {
            throw new IOException("literal data truncated in header");
        }
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate * 1000L;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray((byte[])this.fileName);
    }

    public byte[] getRawFileName() {
        return Arrays.clone((byte[])this.fileName);
    }
}

