/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16, 31};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List keySigs = new ArrayList();
    List ids = new ArrayList();
    List idTrusts = new ArrayList();
    List idSigs = new ArrayList();
    List subSigs = null;
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;

    private void init(KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        BCPGKey bCPGKey = this.publicPk.getKey();
        this.fingerprint = keyFingerPrintCalculator.calculateFingerprint(this.publicPk);
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyID = rSAPublicBCPGKey.getModulus().longValue();
            this.keyStrength = rSAPublicBCPGKey.getModulus().bitLength();
        } else {
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (bCPGKey instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)bCPGKey).getModulus().bitLength();
            } else if (bCPGKey instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ECPublicBCPGKey) {
                X9ECParametersHolder x9ECParametersHolder;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ((ECPublicBCPGKey)bCPGKey).getCurveOID();
                this.keyStrength = aSN1ObjectIdentifier.equals((ASN1Primitive)GNUObjectIdentifiers.Ed25519) || aSN1ObjectIdentifier.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) ? 256 : ((x9ECParametersHolder = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier)) != null ? x9ECParametersHolder.getCurve().getFieldSize() : -1);
            }
        }
    }

    public PGPPublicKey(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList();
        this.idSigs = new ArrayList();
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List list, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List list) {
        this.publicPk = pGPPublicKey.publicPk;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey) {
        this.publicPk = pGPPublicKey.publicPk;
        this.keySigs = new ArrayList(pGPPublicKey.keySigs);
        this.ids = new ArrayList(pGPPublicKey.ids);
        this.idTrusts = new ArrayList(pGPPublicKey.idTrusts);
        this.idSigs = new ArrayList(pGPPublicKey.idSigs.size());
        int n = 0;
        while (n != pGPPublicKey.idSigs.size()) {
            this.idSigs.add(new ArrayList((ArrayList)pGPPublicKey.idSigs.get(n)));
            ++n;
        }
        if (pGPPublicKey.subSigs != null) {
            this.subSigs = new ArrayList(pGPPublicKey.subSigs.size());
            int n2 = 0;
            while (n2 != pGPPublicKey.subSigs.size()) {
                this.subSigs.add(pGPPublicKey.subSigs.get(n2));
                ++n2;
            }
        }
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List list, List list2, List list3, List list4, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List list, List list2, List list3, List list4) throws PGPException {
        this.publicPk = pGPPublicKey.publicPk;
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyStrength = pGPPublicKey.keyStrength;
        this.keyID = pGPPublicKey.keyID;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            long l = this.getValidSeconds() % 86400L;
            int n = (int)(this.getValidSeconds() / 86400L);
            if (l > 0L && n == 0) {
                return 1;
            }
            return n;
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone((byte[])this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                int n = 0;
                while (n != MASTER_KEY_CERTIFICATION_TYPES.length) {
                    long l = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[n]);
                    if (l >= 0L) {
                        return l;
                    }
                    ++n;
                }
            } else {
                long l = this.getExpirationTimeFromSig(false, 24);
                if (l >= 0L) {
                    return l;
                }
                l = this.getExpirationTimeFromSig(false, 31);
                if (l >= 0L) {
                    return l;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean bl, int n) {
        Iterator iterator = this.getSignaturesOfType(n);
        long l = -1L;
        long l2 = -1L;
        while (iterator.hasNext()) {
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector;
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (bl && pGPSignature.getKeyID() != this.getKeyID() || (pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets()) == null || !pGPSignatureSubpacketVector.hasSubpacket(9)) continue;
            long l3 = pGPSignatureSubpacketVector.getKeyExpirationTime();
            if (pGPSignature.getKeyID() == this.getKeyID()) {
                if (pGPSignature.getCreationTime().getTime() <= l2) continue;
                l2 = pGPSignature.getCreationTime().getTime();
                l = l3;
                continue;
            }
            if (l3 != 0L && l3 <= l) continue;
            l = l3;
        }
        return l;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] byArray = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isEncryptionKey() {
        int n = this.publicPk.getAlgorithm();
        return n == 1 || n == 2 || n == 16 || n == 20 || n == 21 || n == 18;
    }

    public boolean isMasterKey() {
        return !(this.publicPk instanceof PublicSubkeyPacket) && (!this.isEncryptionKey() || this.publicPk.getAlgorithm() == 1);
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public Iterator getUserIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof UserIDPacket) {
                arrayList.add(((UserIDPacket)this.ids.get(n)).getID());
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator getRawUserIDs() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof UserIDPacket) {
                arrayList.add(((UserIDPacket)this.ids.get(n)).getRawID());
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof PGPUserAttributeSubpacketVector) {
                arrayList.add(this.ids.get(n));
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator getSignaturesForID(String string) {
        return this.getSignaturesForID(new UserIDPacket(string));
    }

    public Iterator getSignaturesForID(byte[] byArray) {
        return this.getSignaturesForID(new UserIDPacket(byArray));
    }

    public Iterator getSignaturesForKeyID(long l) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getKeyID() != l) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    private Iterator getSignaturesForID(UserIDPacket userIDPacket) {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        int n = 0;
        while (n != this.ids.size()) {
            if (userIDPacket.equals(this.ids.get(n))) {
                bl = true;
                arrayList.addAll((List)this.idSigs.get(n));
            }
            ++n;
        }
        return bl ? arrayList.iterator() : null;
    }

    public Iterator getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        int n = 0;
        while (n != this.ids.size()) {
            if (pGPUserAttributeSubpacketVector.equals(this.ids.get(n))) {
                bl = true;
                arrayList.addAll((List)this.idSigs.get(n));
            }
            ++n;
        }
        return bl ? arrayList.iterator() : null;
    }

    public Iterator getSignaturesOfType(int n) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getSignatureType() != n) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    public Iterator getSignatures() {
        if (this.subSigs == null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.keySigs);
            int n = 0;
            while (n != this.idSigs.size()) {
                arrayList.addAll((Collection)this.idSigs.get(n));
                ++n;
            }
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public Iterator getKeySignatures() {
        if (this.subSigs == null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.keySigs);
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicPk;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, false);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        if (!bl && this.trustPk != null) {
            bCPGOutputStream.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int n = 0;
            while (n != this.keySigs.size()) {
                ((PGPSignature)this.keySigs.get(n)).encode(bCPGOutputStream);
                ++n;
            }
            int n2 = 0;
            while (n2 != this.ids.size()) {
                Object object;
                if (this.ids.get(n2) instanceof UserIDPacket) {
                    object = (UserIDPacket)this.ids.get(n2);
                    bCPGOutputStream.writePacket((ContainedPacket)object);
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n2);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (!bl && this.idTrusts.get(n2) != null) {
                    bCPGOutputStream.writePacket((ContainedPacket)this.idTrusts.get(n2));
                }
                object = (List)this.idSigs.get(n2);
                int n3 = 0;
                while (n3 != object.size()) {
                    ((PGPSignature)object.get(n3)).encode(bCPGOutputStream, bl);
                    ++n3;
                }
                ++n2;
            }
        } else {
            int n = 0;
            while (n != this.subSigs.size()) {
                ((PGPSignature)this.subSigs.get(n)).encode(bCPGOutputStream, bl);
                ++n;
            }
        }
    }

    public boolean isRevoked() {
        return this.hasRevocation();
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasRevocation() {
        block2: {
            var1_1 = 0;
            var2_2 = false;
            if (!this.isMasterKey()) ** GOTO lbl11
            while (!var2_2 && var1_1 < this.keySigs.size()) {
                if (((PGPSignature)this.keySigs.get(var1_1++)).getSignatureType() != 32) continue;
                var2_2 = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (((PGPSignature)this.subSigs.get(var1_1++)).getSignatureType() != 40) continue;
                var2_2 = true;
lbl11:
                // 3 sources

                ** while (!var2_2 && var1_1 < this.subSigs.size())
            }
        }
        return var2_2;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, byte[] byArray, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, new UserIDPacket(byArray), pGPSignature);
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, new UserIDPacket(string), pGPSignature);
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
    }

    private static PGPPublicKey addCert(PGPPublicKey pGPPublicKey, Object object, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List<PGPSignature> list = null;
        int n = 0;
        while (n != pGPPublicKey2.ids.size()) {
            if (object.equals(pGPPublicKey2.ids.get(n))) {
                list = (List)pGPPublicKey2.idSigs.get(n);
            }
            ++n;
        }
        if (list != null) {
            list.add(pGPSignature);
        } else {
            list = new ArrayList<PGPSignature>();
            list.add(pGPSignature);
            pGPPublicKey2.ids.add(object);
            pGPPublicKey2.idTrusts.add(null);
            pGPPublicKey2.idSigs.add(list);
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        return PGPPublicKey.removeCert(pGPPublicKey, pGPUserAttributeSubpacketVector);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(string));
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, byte[] byArray) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(byArray));
    }

    private static PGPPublicKey removeCert(PGPPublicKey pGPPublicKey, Object object) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        int n = 0;
        while (n < pGPPublicKey2.ids.size()) {
            if (object.equals(pGPPublicKey2.ids.get(n))) {
                bl = true;
                pGPPublicKey2.ids.remove(n);
                pGPPublicKey2.idTrusts.remove(n);
                pGPPublicKey2.idSigs.remove(n);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, byte[] byArray, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(byArray), pGPSignature);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(string), pGPSignature);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
    }

    private static PGPPublicKey removeCert(PGPPublicKey pGPPublicKey, Object object, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        int n = 0;
        while (n < pGPPublicKey2.ids.size()) {
            if (object.equals(pGPPublicKey2.ids.get(n))) {
                bl = ((List)pGPPublicKey2.idSigs.get(n)).remove(pGPSignature);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        if (pGPPublicKey.isMasterKey()) {
            if (pGPSignature.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (pGPSignature.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        if (pGPPublicKey2.subSigs != null) {
            pGPPublicKey2.subSigs.add(pGPSignature);
        } else {
            pGPPublicKey2.keySigs.add(pGPSignature);
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = pGPPublicKey2.subSigs != null ? pGPPublicKey2.subSigs.remove(pGPSignature) : pGPPublicKey2.keySigs.remove(pGPSignature);
        if (!bl) {
            Object object;
            Object object2;
            Iterator iterator = pGPPublicKey.getRawUserIDs();
            while (iterator.hasNext()) {
                object2 = (byte[])iterator.next();
                object = pGPPublicKey.getSignaturesForID((byte[])object2);
                while (object.hasNext()) {
                    if (pGPSignature != object.next()) continue;
                    bl = true;
                    pGPPublicKey2 = PGPPublicKey.removeCertification(pGPPublicKey2, (byte[])object2, pGPSignature);
                }
            }
            if (!bl) {
                object2 = pGPPublicKey.getUserAttributes();
                while (object2.hasNext()) {
                    object = (PGPUserAttributeSubpacketVector)object2.next();
                    Iterator iterator2 = pGPPublicKey.getSignaturesForUserAttribute((PGPUserAttributeSubpacketVector)object);
                    while (iterator2.hasNext()) {
                        if (pGPSignature != iterator2.next()) continue;
                        bl = true;
                        pGPPublicKey2 = PGPPublicKey.removeCertification(pGPPublicKey2, (PGPUserAttributeSubpacketVector)object, pGPSignature);
                    }
                }
            }
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey join(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2, boolean bl, boolean bl2) throws PGPException {
        int n;
        Object object;
        ArrayList<PGPSignature> arrayList;
        if (pGPPublicKey.getKeyID() != pGPPublicKey2.getKeyID()) {
            throw new IllegalArgumentException("Key-ID mismatch.");
        }
        TrustPacket trustPacket = pGPPublicKey.trustPk;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(pGPPublicKey.keySigs);
        ArrayList arrayList3 = new ArrayList(pGPPublicKey.ids);
        ArrayList<Object> arrayList4 = new ArrayList<Object>(pGPPublicKey.idTrusts);
        ArrayList arrayList5 = new ArrayList(pGPPublicKey.idSigs);
        ArrayList<PGPSignature> arrayList6 = arrayList = pGPPublicKey.subSigs == null ? null : new ArrayList<PGPSignature>(pGPPublicKey.subSigs);
        if (bl && pGPPublicKey2.trustPk != null) {
            trustPacket = pGPPublicKey2.trustPk;
        }
        Iterator iterator = pGPPublicKey2.keySigs.iterator();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                object = (PGPSignature)arrayList2.get(n2);
                if (PGPSignature.isSignatureEncodingEqual((PGPSignature)object, pGPSignature)) {
                    bl3 = true;
                    object = PGPSignature.join((PGPSignature)object, pGPSignature);
                    arrayList2.remove(n2);
                    arrayList2.add(n2, object);
                    break;
                }
                ++n2;
            }
            if (bl3) break;
            arrayList2.add(pGPSignature);
        }
        int n3 = 0;
        while (n3 < pGPPublicKey2.ids.size()) {
            Object object2;
            Object e = pGPPublicKey2.ids.get(n3);
            ArrayList arrayList7 = new ArrayList((List)pGPPublicKey2.idSigs.get(n3));
            object = (TrustPacket)pGPPublicKey2.idTrusts.get(n3);
            n = -1;
            int n4 = 0;
            while (n4 < arrayList3.size()) {
                object2 = arrayList3.get(n4);
                if (object2.equals(e)) {
                    n = n4;
                    break;
                }
                ++n4;
            }
            if (n == -1) {
                arrayList3.add(e);
                arrayList5.add(arrayList7);
                if (bl) {
                    arrayList4.add(object);
                } else {
                    arrayList4.add(null);
                }
            } else {
                if (bl && object != null && ((object2 = (TrustPacket)arrayList4.get(n)) == null || Arrays.areEqual((byte[])((TrustPacket)object).getLevelAndTrustAmount(), (byte[])((TrustPacket)object2).getLevelAndTrustAmount()))) {
                    arrayList4.remove(n);
                    arrayList4.add(n, object);
                }
                object2 = (List)arrayList5.get(n);
                Iterator iterator2 = arrayList7.iterator();
                while (iterator2.hasNext()) {
                    PGPSignature pGPSignature = (PGPSignature)iterator2.next();
                    boolean bl4 = false;
                    int n5 = 0;
                    while (n5 < object2.size()) {
                        PGPSignature pGPSignature2 = (PGPSignature)object2.get(n5);
                        if (PGPSignature.isSignatureEncodingEqual(pGPSignature, pGPSignature2)) {
                            bl4 = true;
                            pGPSignature2 = PGPSignature.join(pGPSignature2, pGPSignature);
                            object2.remove(n5);
                            object2.add(n5, pGPSignature2);
                            break;
                        }
                        ++n5;
                    }
                    if (bl4) continue;
                    object2.add(pGPSignature);
                }
            }
            ++n3;
        }
        if (pGPPublicKey2.subSigs != null) {
            if (arrayList == null && bl2) {
                arrayList = new ArrayList(pGPPublicKey2.subSigs);
            } else {
                Iterator iterator3 = pGPPublicKey2.subSigs.iterator();
                while (iterator3.hasNext()) {
                    PGPSignature pGPSignature = (PGPSignature)iterator3.next();
                    boolean bl5 = false;
                    n = 0;
                    while (n < arrayList.size()) {
                        PGPSignature pGPSignature3 = (PGPSignature)arrayList.get(n);
                        if (PGPSignature.isSignatureEncodingEqual(pGPSignature3, pGPSignature)) {
                            bl5 = true;
                            pGPSignature3 = PGPSignature.join(pGPSignature3, pGPSignature);
                            arrayList.remove(n);
                            arrayList.add(n, pGPSignature3);
                            break;
                        }
                        ++n;
                    }
                    if (bl5) continue;
                    arrayList.add(pGPSignature);
                }
            }
        }
        PGPPublicKey pGPPublicKey3 = new PGPPublicKey(pGPPublicKey, trustPacket, arrayList2, arrayList3, arrayList4, arrayList5);
        pGPPublicKey3.subSigs = arrayList;
        return pGPPublicKey3;
    }
}

