/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;

public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable {
    List keys;

    public PGPPublicKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    private static List checkKeys(List list) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(list.size());
        int n = 0;
        while (n != list.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)list.get(n);
            if (n == 0) {
                if (!pGPPublicKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPPublicKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPPublicKey);
            ++n;
        }
        return arrayList;
    }

    public PGPPublicKeyRing(List list) {
        this.keys = PGPPublicKeyRing.checkKeys(list);
    }

    public PGPPublicKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream bCPGInputStream = PGPKeyRing.wrap(inputStream);
        int n = bCPGInputStream.skipMarkerPackets();
        if (n != 6 && n != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(n));
        }
        PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
        TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        try {
            this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator));
            while (bCPGInputStream.nextPacketTag() == 14) {
                this.keys.add(PGPPublicKeyRing.readSubkey(bCPGInputStream, keyFingerPrintCalculator));
            }
        }
        catch (PGPException pGPException) {
            throw new IOException("processing exception: " + pGPException.toString());
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long l) {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            if (l == pGPPublicKey.getKeyID()) {
                return pGPPublicKey;
            }
            ++n;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] byArray) {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            if (Arrays.areEqual((byte[])byArray, (byte[])pGPPublicKey.getFingerprint())) {
                return pGPPublicKey;
            }
            ++n;
        }
        return null;
    }

    public Iterator getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            Iterator iterator = pGPPublicKey.getSignaturesForKeyID(l);
            if (iterator.hasNext()) {
                arrayList.add(pGPPublicKey);
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public Iterator iterator() {
        return this.getPublicKeys();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            pGPPublicKey.encode(outputStream, bl);
            ++n;
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPPublicKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n != arrayList.size()) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(n);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.set(n, pGPPublicKey);
            }
            if (pGPPublicKey2.isMasterKey()) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl) {
            if (pGPPublicKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPPublicKey);
            } else {
                arrayList.add(pGPPublicKey);
            }
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList arrayList = new ArrayList(pGPPublicKeyRing.keys);
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(n);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.remove(n);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return new PGPPublicKeyRing(arrayList);
    }

    static PublicKeyPacket readPublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof PublicKeyPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (PublicKeyPacket)packet;
    }

    static PGPPublicKey readSubkey(BCPGInputStream bCPGInputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
        TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPKeyRing.readSignaturesAndTrust(bCPGInputStream);
        return new PGPPublicKey(publicKeyPacket, trustPacket, list, keyFingerPrintCalculator);
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKeyRing pGPPublicKeyRing2) throws PGPException {
        return PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2, false, false);
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKeyRing pGPPublicKeyRing2, boolean bl, boolean bl2) throws PGPException {
        Object object;
        Object object2;
        if (!Arrays.areEqual((byte[])pGPPublicKeyRing.getPublicKey().getFingerprint(), (byte[])pGPPublicKeyRing2.getPublicKey().getFingerprint())) {
            throw new IllegalArgumentException("Cannot merge certificates with differing primary keys.");
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        Iterator iterator = pGPPublicKeyRing2.iterator();
        while (iterator.hasNext()) {
            object2 = (PGPPublicKey)iterator.next();
            hashSet.add(Longs.valueOf((long)((PGPPublicKey)object2).getKeyID()));
        }
        object2 = new ArrayList();
        Iterator iterator2 = pGPPublicKeyRing.iterator();
        while (iterator2.hasNext()) {
            object = (PGPPublicKey)iterator2.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing2.getPublicKey(((PGPPublicKey)object).getKeyID());
            if (pGPPublicKey != null) {
                object2.add(PGPPublicKey.join((PGPPublicKey)object, pGPPublicKey, bl, bl2));
                hashSet.remove(Longs.valueOf((long)((PGPPublicKey)object).getKeyID()));
                continue;
            }
            object2.add(object);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            long l = (Long)object.next();
            object2.add(pGPPublicKeyRing2.getPublicKey(l));
        }
        return new PGPPublicKeyRing((List)object2);
    }
}

