/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.util.encoders.Hex;

public class PGPSessionKey {
    private final int algorithm;
    private final byte[] sessionKey;

    public PGPSessionKey(int n, byte[] byArray) {
        this.algorithm = n;
        this.sessionKey = byArray;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        byte[] byArray = new byte[this.sessionKey.length];
        System.arraycopy(this.sessionKey, 0, byArray, 0, this.sessionKey.length);
        return byArray;
    }

    public String toString() {
        return this.algorithm + ":" + this.sessionKey;
    }

    public static PGPSessionKey fromAsciiRepresentation(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("Provided ascii encoding does not match expected format  : ");
        }
        return new PGPSessionKey(Integer.parseInt(string.substring(0, n)), Hex.decode((String)string.substring(n + 1)));
    }
}

