/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPUtil;

public abstract class PBEDataDecryptorFactory
implements PGPDataDecryptorFactory {
    private char[] passPhrase;
    private PGPDigestCalculatorProvider calculatorProvider;

    protected PBEDataDecryptorFactory(char[] cArray, PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.passPhrase = cArray;
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public byte[] makeKeyFromPassPhrase(int n, S2K s2K) throws PGPException {
        return PGPUtil.makeKeyFromPassPhrase(this.calculatorProvider, n, s2K, this.passPhrase);
    }

    public abstract byte[] recoverSessionData(int var1, byte[] var2, byte[] var3) throws PGPException;

    public abstract PGPDataDecryptor createDataDecryptor(boolean var1, int var2, byte[] var3) throws PGPException;
}

