/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private int version;
    private int rounds;
    private int wordSize;
    private byte[] iv;

    public RC5ParameterSpec(int n, int n2, int n3) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        this.iv = null;
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, 0);
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray, int n4) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        this.iv = new byte[2 * (n3 / 8)];
        System.arraycopy(byArray, n4, this.iv, 0, this.iv.length);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)object;
        if (this.version != rC5ParameterSpec.version) {
            return false;
        }
        if (this.rounds != rC5ParameterSpec.rounds) {
            return false;
        }
        if (this.wordSize != rC5ParameterSpec.wordSize) {
            return false;
        }
        if (this.iv != null) {
            if (rC5ParameterSpec.iv == null || rC5ParameterSpec.iv.length != this.iv.length) {
                return false;
            }
            int n = 0;
            while (n != this.iv.length) {
                if (this.iv[n] != rC5ParameterSpec.iv[n]) {
                    return false;
                }
                ++n;
            }
        } else if (rC5ParameterSpec.iv != null) {
            return false;
        }
        return true;
    }

    public byte[] getIV() {
        if (this.iv == null) {
            return null;
        }
        byte[] byArray = new byte[this.iv.length];
        System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
        return byArray;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public int hashCode() {
        int n = this.version ^ this.rounds ^ this.wordSize;
        if (this.iv != null) {
            int n2 = 0;
            while (n2 != this.iv.length) {
                n ^= this.iv[n2] << 8 * (n2 % 4);
                ++n2;
            }
        }
        return n;
    }
}

