/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(class$org$bouncycastle$asn1$ASN1Set != null ? class$org$bouncycastle$asn1$ASN1Set : (class$org$bouncycastle$asn1$ASN1Set = ASN1Set.class$("org.bouncycastle.asn1.ASN1Set")), 17){

        ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.toASN1Set();
        }
    };
    protected final ASN1Encodable[] elements;
    protected final boolean isSorted;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1Set;

    protected ASN1Set() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
        this.isSorted = true;
    }

    protected ASN1Set(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null) {
            throw new NullPointerException("'element' cannot be null");
        }
        this.elements = new ASN1Encodable[]{aSN1Encodable};
        this.isSorted = true;
    }

    protected ASN1Set(ASN1EncodableVector aSN1EncodableVector, boolean bl) {
        ASN1Encodable[] aSN1EncodableArray;
        if (aSN1EncodableVector == null) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        if (bl && aSN1EncodableVector.size() >= 2) {
            aSN1EncodableArray = aSN1EncodableVector.copyElements();
            ASN1Set.sort(aSN1EncodableArray);
        } else {
            aSN1EncodableArray = aSN1EncodableVector.takeElements();
        }
        this.elements = aSN1EncodableArray;
        this.isSorted = bl || aSN1EncodableArray.length < 2;
    }

    ASN1Set(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        this.elements = aSN1EncodableArray;
        this.isSorted = bl || aSN1EncodableArray.length < 2;
    }

    protected ASN1Set(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        if (Arrays.isNullOrContainsNull(aSN1EncodableArray)) {
            throw new NullPointerException("'elements' cannot be null, or contain null");
        }
        ASN1Encodable[] aSN1EncodableArray2 = ASN1EncodableVector.cloneElements(aSN1EncodableArray);
        if (bl && aSN1EncodableArray2.length >= 2) {
            ASN1Set.sort(aSN1EncodableArray2);
        }
        this.elements = aSN1EncodableArray2;
        this.isSorted = bl || aSN1EncodableArray2.length < 2;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)aSN1Primitive;
        int n = this.size();
        if (aSN1Set.size() != n) {
            return false;
        }
        DERSet dERSet = (DERSet)this.toDERObject();
        DERSet dERSet2 = (DERSet)aSN1Set.toDERObject();
        int n2 = 0;
        while (n2 < n) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = dERSet.elements[n2].toASN1Primitive();
            if (aSN1Primitive3 != (aSN1Primitive2 = dERSet2.elements[n2].toASN1Primitive()) && !aSN1Primitive3.asn1Equals(aSN1Primitive2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    boolean encodeConstructed() {
        return true;
    }

    private static byte[] getDEREncoded(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    public static ASN1Set getInstance(Object object) {
        if (object == null || object instanceof ASN1Set) {
            return (ASN1Set)object;
        }
        if (object instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Set) {
                return (ASN1Set)aSN1Primitive;
            }
        } else if (object instanceof byte[]) {
            try {
                return (ASN1Set)TYPE.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1Set)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    public ASN1Encodable getObjectAt(int n) {
        return this.elements[n];
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            private int pos = 0;

            public boolean hasMoreElements() {
                return this.pos < ASN1Set.this.elements.length;
            }

            public Object nextElement() {
                if (this.pos < ASN1Set.this.elements.length) {
                    return ASN1Set.this.elements[this.pos++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public int hashCode() {
        int n = this.elements.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 += this.elements[n].toASN1Primitive().hashCode();
        }
        return n2;
    }

    public Iterator iterator() {
        return new Arrays.Iterator(this.toArray());
    }

    private static boolean lessThanOrEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray[0] & 0xFFFFFFDF;
        int n2 = byArray2[0] & 0xFFFFFFDF;
        if (n != n2) {
            return n < n2;
        }
        int n3 = Math.min(byArray.length, byArray2.length) - 1;
        int n4 = 1;
        while (n4 < n3) {
            if (byArray[n4] != byArray2[n4]) {
                return (byArray[n4] & 0xFF) < (byArray2[n4] & 0xFF);
            }
            ++n4;
        }
        return (byArray[n3] & 0xFF) <= (byArray2[n3] & 0xFF);
    }

    public ASN1SetParser parser() {
        final int n = this.size();
        return new ASN1SetParser(){
            private int pos = 0;

            public ASN1Primitive getLoadedObject() {
                return this;
            }

            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable aSN1Encodable;
                if (n == this.pos) {
                    return null;
                }
                if ((aSN1Encodable = elements[this.pos++]) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            public ASN1Primitive toASN1Primitive() {
                return this;
            }
        };
    }

    public int size() {
        return this.elements.length;
    }

    private static void sort(ASN1Encodable[] aSN1EncodableArray) {
        Object object;
        int n = aSN1EncodableArray.length;
        if (n < 2) {
            return;
        }
        Object object2 = aSN1EncodableArray[0];
        Object object3 = aSN1EncodableArray[1];
        byte[] byArray = ASN1Set.getDEREncoded((ASN1Encodable)object2);
        byte[] byArray2 = ASN1Set.getDEREncoded((ASN1Encodable)object3);
        if (ASN1Set.lessThanOrEqual(byArray2, byArray)) {
            ASN1Encodable aSN1Encodable = object3;
            object3 = object2;
            object2 = aSN1Encodable;
            object = byArray2;
            byArray2 = byArray;
            byArray = object;
        }
        int n2 = 2;
        while (n2 < n) {
            object = aSN1EncodableArray[n2];
            byte[] byArray3 = ASN1Set.getDEREncoded((ASN1Encodable)object);
            if (ASN1Set.lessThanOrEqual(byArray2, byArray3)) {
                aSN1EncodableArray[n2 - 2] = object2;
                object2 = object3;
                byArray = byArray2;
                object3 = object;
                byArray2 = byArray3;
            } else if (ASN1Set.lessThanOrEqual(byArray, byArray3)) {
                aSN1EncodableArray[n2 - 2] = object2;
                object2 = object;
                byArray = byArray3;
            } else {
                int n3 = n2 - 1;
                while (--n3 > 0) {
                    ASN1Encodable aSN1Encodable = aSN1EncodableArray[n3 - 1];
                    byte[] byArray4 = ASN1Set.getDEREncoded(aSN1Encodable);
                    if (ASN1Set.lessThanOrEqual(byArray4, byArray3)) break;
                    aSN1EncodableArray[n3] = aSN1Encodable;
                }
                aSN1EncodableArray[n3] = object;
            }
            ++n2;
        }
        aSN1EncodableArray[n - 2] = object2;
        aSN1EncodableArray[n - 1] = object3;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.cloneElements(this.elements);
    }

    ASN1Primitive toDERObject() {
        ASN1Encodable[] aSN1EncodableArray;
        if (this.isSorted) {
            aSN1EncodableArray = this.elements;
        } else {
            aSN1EncodableArray = (ASN1Encodable[])this.elements.clone();
            ASN1Set.sort(aSN1EncodableArray);
        }
        return new DERSet(true, aSN1EncodableArray);
    }

    ASN1Primitive toDLObject() {
        return new DLSet(this.isSorted, this.elements);
    }

    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = 0;
        while (true) {
            stringBuffer.append(this.elements[n2]);
            if (++n2 >= n) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

