/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectDescriptor;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1RelativeOID;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class EqualsAndHashCodeTest
implements Test {
    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] stringArray) {
        EqualsAndHashCodeTest equalsAndHashCodeTest = new EqualsAndHashCodeTest();
        TestResult testResult = equalsAndHashCodeTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        byte[] byArray = new byte[7];
        byArray[1] = 1;
        byArray[3] = 1;
        byArray[6] = 1;
        byte[] byArray2 = byArray;
        ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[]{new BEROctetString(byArray2), new BERSequence(new DERPrintableString("hello world")), new BERSet(new DERPrintableString("hello world")), new BERTaggedObject(0, new DERPrintableString("hello world")), new DERApplicationSpecific(0, byArray2), new DERBitString(byArray2), new DERBMPString("hello world"), ASN1Boolean.getInstance(true), ASN1Boolean.getInstance(false), new ASN1Enumerated(100), new DERGeneralizedTime("20070315173729Z"), new DERGeneralString("hello world"), new DERIA5String("hello"), new ASN1Integer(1000L), DERNull.INSTANCE, new DERNumericString("123456"), new ASN1ObjectIdentifier("1.1.1.10000.1"), new ASN1RelativeOID("3.2.0.123456"), new ASN1ObjectDescriptor(new DERGraphicString(Hex.decode("feedface"))), new DEROctetString(byArray2), new DERPrintableString("hello world"), new DERSequence(new DERPrintableString("hello world")), new DERSet(new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, new DERPrintableString("hello world")), new DERUniversalString(byArray2), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world"), new DERGraphicString(Hex.decode("deadbeef")), new DERVideotexString(Strings.toByteArray("Hello World"))};
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream);
            int n = 0;
            while (n != aSN1PrimitiveArray.length) {
                aSN1OutputStream.writeObject(aSN1PrimitiveArray[n]);
                ++n;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            int n2 = 0;
            while (n2 != aSN1PrimitiveArray.length) {
                ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
                if (!aSN1Primitive.equals(aSN1PrimitiveArray[n2])) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed equality test for " + aSN1Primitive.getClass());
                }
                if (aSN1Primitive.hashCode() != aSN1PrimitiveArray[n2].hashCode()) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed hashCode test for " + aSN1Primitive.getClass());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

