/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.util.test.SimpleTest;

public class MonetaryValueUnitTest
extends SimpleTest {
    private static final int TEST_AMOUNT = 100;
    private static final int ZERO_EXPONENT = 0;
    private static final String CURRENCY_CODE = "AUD";

    private void checkValues(MonetaryValue monetaryValue, int n, int n2) {
        Iso4217CurrencyCode iso4217CurrencyCode;
        if (monetaryValue.getAmount().intValue() != n) {
            this.fail("amounts don't match.");
        }
        if (monetaryValue.getExponent().intValue() != n2) {
            this.fail("exponents don't match.");
        }
        if (!(iso4217CurrencyCode = monetaryValue.getCurrency()).getAlphabetic().equals(CURRENCY_CODE)) {
            this.fail("currency code wrong");
        }
    }

    public String getName() {
        return "MonetaryValue";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new MonetaryValueUnitTest());
    }

    public void performTest() throws Exception {
        MonetaryValue monetaryValue = new MonetaryValue(new Iso4217CurrencyCode(CURRENCY_CODE), 100, 0);
        this.checkValues(monetaryValue, 100, 0);
        monetaryValue = MonetaryValue.getInstance(monetaryValue);
        this.checkValues(monetaryValue, 100, 0);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(monetaryValue.toASN1Primitive().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        monetaryValue = MonetaryValue.getInstance(aSN1Sequence);
        this.checkValues(monetaryValue, 100, 0);
        monetaryValue = MonetaryValue.getInstance(null);
        if (monetaryValue != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            MonetaryValue.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

