/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import org.bouncycastle.util.test.SimpleTest;

public class SemanticsInformationUnitTest
extends SimpleTest {
    private void checkConstruction(SemanticsInformation semanticsInformation, ASN1ObjectIdentifier aSN1ObjectIdentifier, GeneralName[] generalNameArray) throws Exception {
        this.checkStatement(semanticsInformation, aSN1ObjectIdentifier, generalNameArray);
        semanticsInformation = SemanticsInformation.getInstance(semanticsInformation);
        this.checkStatement(semanticsInformation, aSN1ObjectIdentifier, generalNameArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(semanticsInformation.toASN1Primitive().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        semanticsInformation = SemanticsInformation.getInstance(aSN1Sequence);
        this.checkStatement(semanticsInformation, aSN1ObjectIdentifier, generalNameArray);
    }

    private void checkStatement(SemanticsInformation semanticsInformation, ASN1ObjectIdentifier aSN1ObjectIdentifier, GeneralName[] generalNameArray) {
        if (aSN1ObjectIdentifier != null) {
            if (!semanticsInformation.getSemanticsIdentifier().equals(aSN1ObjectIdentifier)) {
                this.fail("ids don't match.");
            }
        } else if (semanticsInformation.getSemanticsIdentifier() != null) {
            this.fail("statementId found when none expected.");
        }
        if (generalNameArray != null) {
            GeneralName[] generalNameArray2 = semanticsInformation.getNameRegistrationAuthorities();
            int n = 0;
            while (n != generalNameArray2.length) {
                if (!generalNameArray[n].equals(generalNameArray2[n])) {
                    this.fail("name registration authorities don't match.");
                }
                ++n;
            }
        } else if (semanticsInformation.getNameRegistrationAuthorities() != null) {
            this.fail("name registration authorities found when none expected.");
        }
    }

    public String getName() {
        return "SemanticsInformation";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SemanticsInformationUnitTest());
    }

    public void performTest() throws Exception {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.1");
        SemanticsInformation semanticsInformation = new SemanticsInformation(aSN1ObjectIdentifier);
        this.checkConstruction(semanticsInformation, aSN1ObjectIdentifier, null);
        GeneralName[] generalNameArray = new GeneralName[]{new GeneralName(1, "test@test.org"), new GeneralName(new X500Name("cn=test"))};
        semanticsInformation = new SemanticsInformation(aSN1ObjectIdentifier, generalNameArray);
        this.checkConstruction(semanticsInformation, aSN1ObjectIdentifier, generalNameArray);
        semanticsInformation = new SemanticsInformation(generalNameArray);
        this.checkConstruction(semanticsInformation, null, generalNameArray);
        semanticsInformation = SemanticsInformation.getInstance(null);
        if (semanticsInformation != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            SemanticsInformation.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            SemanticsInformation.getInstance(new DERSequence(aSN1EncodableVector));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

