/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithSBox;

public class GOST28147Mac
implements Mac {
    private int blockSize = 8;
    private int macSize = 4;
    private int bufOff;
    private byte[] buf;
    private byte[] mac;
    private boolean firstStep = true;
    private int[] workingKey = null;
    private byte[] macIV = null;
    private byte[] S;

    public GOST28147Mac() {
        byte[] byArray = new byte[128];
        byArray[0] = 9;
        byArray[1] = 6;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 8;
        byArray[5] = 11;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[8] = 10;
        byArray[9] = 4;
        byArray[10] = 14;
        byArray[11] = 15;
        byArray[12] = 12;
        byArray[14] = 13;
        byArray[15] = 5;
        byArray[16] = 3;
        byArray[17] = 7;
        byArray[18] = 14;
        byArray[19] = 9;
        byArray[20] = 8;
        byArray[21] = 10;
        byArray[22] = 15;
        byArray[24] = 5;
        byArray[25] = 2;
        byArray[26] = 6;
        byArray[27] = 12;
        byArray[28] = 11;
        byArray[29] = 4;
        byArray[30] = 13;
        byArray[31] = 1;
        byArray[32] = 14;
        byArray[33] = 4;
        byArray[34] = 6;
        byArray[35] = 2;
        byArray[36] = 11;
        byArray[37] = 3;
        byArray[38] = 13;
        byArray[39] = 8;
        byArray[40] = 12;
        byArray[41] = 15;
        byArray[42] = 5;
        byArray[43] = 10;
        byArray[45] = 7;
        byArray[46] = 1;
        byArray[47] = 9;
        byArray[48] = 14;
        byArray[49] = 7;
        byArray[50] = 10;
        byArray[51] = 12;
        byArray[52] = 13;
        byArray[53] = 1;
        byArray[54] = 3;
        byArray[55] = 9;
        byArray[57] = 2;
        byArray[58] = 11;
        byArray[59] = 4;
        byArray[60] = 15;
        byArray[61] = 8;
        byArray[62] = 5;
        byArray[63] = 6;
        byArray[64] = 11;
        byArray[65] = 5;
        byArray[66] = 1;
        byArray[67] = 9;
        byArray[68] = 8;
        byArray[69] = 13;
        byArray[70] = 15;
        byArray[72] = 14;
        byArray[73] = 4;
        byArray[74] = 2;
        byArray[75] = 3;
        byArray[76] = 12;
        byArray[77] = 7;
        byArray[78] = 10;
        byArray[79] = 6;
        byArray[80] = 3;
        byArray[81] = 10;
        byArray[82] = 13;
        byArray[83] = 12;
        byArray[84] = 1;
        byArray[85] = 2;
        byArray[87] = 11;
        byArray[88] = 7;
        byArray[89] = 5;
        byArray[90] = 9;
        byArray[91] = 4;
        byArray[92] = 8;
        byArray[93] = 15;
        byArray[94] = 14;
        byArray[95] = 6;
        byArray[96] = 1;
        byArray[97] = 13;
        byArray[98] = 2;
        byArray[99] = 9;
        byArray[100] = 7;
        byArray[101] = 10;
        byArray[102] = 6;
        byArray[104] = 8;
        byArray[105] = 12;
        byArray[106] = 4;
        byArray[107] = 5;
        byArray[108] = 15;
        byArray[109] = 3;
        byArray[110] = 11;
        byArray[111] = 14;
        byArray[112] = 11;
        byArray[113] = 10;
        byArray[114] = 15;
        byArray[115] = 5;
        byArray[117] = 12;
        byArray[118] = 14;
        byArray[119] = 8;
        byArray[120] = 6;
        byArray[121] = 2;
        byArray[122] = 3;
        byArray[123] = 9;
        byArray[124] = 1;
        byArray[125] = 7;
        byArray[126] = 13;
        byArray[127] = 4;
        this.S = byArray;
        this.mac = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
        this.bufOff = 0;
    }

    private byte[] CM5func(byte[] byArray, int n, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray3, 0, byArray2.length);
        int n2 = 0;
        while (n2 != byArray2.length) {
            byArray3[n2] = (byte)(byArray3[n2] ^ byArray2[n2]);
            ++n2;
        }
        return byArray3;
    }

    private int bytesToint(byte[] byArray, int n) {
        return (byArray[n + 3] << 24 & 0xFF000000) + (byArray[n + 2] << 16 & 0xFF0000) + (byArray[n + 1] << 8 & 0xFF00) + (byArray[n] & 0xFF);
    }

    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        while (this.bufOff < this.blockSize) {
            this.buf[this.bufOff] = 0;
            ++this.bufOff;
        }
        byte[] byArray2 = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, byArray2, 0, this.mac.length);
        if (this.firstStep) {
            this.firstStep = false;
        } else {
            byArray2 = this.CM5func(this.buf, 0, this.mac);
        }
        this.gost28147MacFunc(this.workingKey, byArray2, 0, this.mac, 0);
        System.arraycopy(this.mac, this.mac.length / 2 - this.macSize, byArray, n, this.macSize);
        this.reset();
        return this.macSize;
    }

    private int[] generateWorkingKey(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
        }
        int[] nArray = new int[8];
        int n = 0;
        while (n != 8) {
            nArray[n] = this.bytesToint(byArray, n * 4);
            ++n;
        }
        return nArray;
    }

    public String getAlgorithmName() {
        return "GOST28147Mac";
    }

    public int getMacSize() {
        return this.macSize;
    }

    private void gost28147MacFunc(int[] nArray, byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToint(byArray, n);
        int n4 = this.bytesToint(byArray, n + 4);
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < 8) {
                int n7 = n3;
                n3 = n4 ^ this.gost28147_mainStep(n3, nArray[n6]);
                n4 = n7;
                ++n6;
            }
            ++n5;
        }
        this.intTobytes(n3, byArray2, n2);
        this.intTobytes(n4, byArray2, n2 + 4);
    }

    private int gost28147_mainStep(int n, int n2) {
        int n3 = n2 + n;
        int n4 = this.S[n3 & 0xF];
        n4 += this.S[16 + (n3 >> 4 & 0xF)] << 4;
        n4 += this.S[32 + (n3 >> 8 & 0xF)] << 8;
        n4 += this.S[48 + (n3 >> 12 & 0xF)] << 12;
        n4 += this.S[64 + (n3 >> 16 & 0xF)] << 16;
        n4 += this.S[80 + (n3 >> 20 & 0xF)] << 20;
        n4 += this.S[96 + (n3 >> 24 & 0xF)] << 24;
        return (n4 += this.S[112 + (n3 >> 28 & 0xF)] << 28) << 11 | n4 >>> 21;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        this.reset();
        this.buf = new byte[this.blockSize];
        this.macIV = null;
        this.recursiveInit(cipherParameters);
    }

    private void intTobytes(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n >>> 24);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2] = (byte)n;
    }

    private void recursiveInit(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters == null) {
            return;
        }
        CipherParameters cipherParameters2 = null;
        if (cipherParameters instanceof ParametersWithSBox) {
            ParametersWithSBox parametersWithSBox = (ParametersWithSBox)cipherParameters;
            System.arraycopy(parametersWithSBox.getSBox(), 0, this.S, 0, parametersWithSBox.getSBox().length);
            cipherParameters2 = parametersWithSBox.getParameters();
        } else if (cipherParameters instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey());
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            System.arraycopy(parametersWithIV.getIV(), 0, this.mac, 0, this.mac.length);
            this.macIV = parametersWithIV.getIV();
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameter passed to GOST28147 init - " + cipherParameters.getClass().getName());
        }
        this.recursiveInit(cipherParameters2);
    }

    public void reset() {
        int n = 0;
        while (n < this.buf.length) {
            this.buf[n] = 0;
            ++n;
        }
        this.bufOff = 0;
        this.firstStep = true;
    }

    public void update(byte by) throws IllegalStateException {
        if (this.bufOff == this.buf.length) {
            byte[] byArray = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, byArray, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
                if (this.macIV != null) {
                    byArray = this.CM5func(this.buf, 0, this.macIV);
                }
            } else {
                byArray = this.CM5func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(this.workingKey, byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
    }

    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n3 = this.blockSize - this.bufOff;
        if (n2 > n3) {
            System.arraycopy(byArray, n, this.buf, this.bufOff, n3);
            byte[] byArray2 = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, byArray2, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
                if (this.macIV != null) {
                    byArray2 = this.CM5func(this.buf, 0, this.macIV);
                }
            } else {
                byArray2 = this.CM5func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(this.workingKey, byArray2, 0, this.mac, 0);
            this.bufOff = 0;
            n2 -= n3;
            n += n3;
            while (n2 > this.blockSize) {
                byArray2 = this.CM5func(byArray, n, this.mac);
                this.gost28147MacFunc(this.workingKey, byArray2, 0, this.mac, 0);
                n2 -= this.blockSize;
                n += this.blockSize;
            }
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
    }
}

