/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.OldCTSBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class CTSTest
extends SimpleTest {
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    public String getName() {
        return "CTS";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new CTSTest());
    }

    public void performTest() throws Exception {
        byte[] byArray = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] byArray2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.testCTS(1, new DESEngine(), new KeyParameter(byArray), in1, out1);
        this.testCTS(2, new CBCBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(byArray), byArray3), in1, out2);
        this.testCTS(3, new CBCBlockCipher(new SkipjackEngine()), new ParametersWithIV(new KeyParameter(byArray2), byArray3), in2, out3);
        byte[] byArray4 = Hex.decode("636869636b656e207465726979616b69");
        byte[] byArray5 = Hex.decode("4920776f756c64206c696b652074686520");
        byte[] byArray6 = Hex.decode("c6353568f2bf8cb4d8a580362da7ff7f97");
        byte[] byArray7 = Hex.decode("4920776f756c64206c696b65207468652047656e6572616c20476175277320");
        byte[] byArray8 = Hex.decode("fc00783e0efdb2c1d445d4c8eff7ed2297687268d6ecccc0c07b25e25ecfe5");
        byte[] byArray9 = Hex.decode("4920776f756c64206c696b65207468652047656e6572616c2047617527732043");
        byte[] byArray10 = Hex.decode("39312523a78662d5be7fcbcc98ebf5a897687268d6ecccc0c07b25e25ecfe584");
        this.testCTS(4, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray5, byArray6);
        this.testCTS(5, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray7, byArray8);
        this.testCTS(6, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray9, byArray10);
        this.testOldCTS(4, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray5, byArray6);
        this.testOldCTS(5, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray7, byArray8);
        this.testOldCTS(6, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray9, byArray10);
        byte[] byArray11 = Hex.decode("4920776f756c64206c696b6520746865");
        byte[] byArray12 = Hex.decode("e7664c13ff28c965b0d2a0e7ec353706");
        byte[] byArray13 = Hex.decode("97687268d6ecccc0c07b25e25ecfe584");
        byte[] byArray14 = Hex.decode("571f5108c53fe95ab52df783df933fa3");
        this.testCTS(7, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray11, byArray13);
        this.testCTS(8, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), byArray11), byArray11, byArray14);
        this.testOldCTS(9, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray4), new byte[16]), byArray11, byArray12);
        byte[] byArray15 = Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f6");
        byte[] byArray16 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byte[] byArray17 = Hex.decode("6db2f802d99e1ef0a5940f306079e083cf87f4d8bb9d1abb36cdd9f44ead7d04");
        this.testCTS(10, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(byArray15), Hex.decode("aafd12f659cae63489b479e5076ddec2")), byArray16, byArray17);
        this.testExceptions();
    }

    private void testCTS(int n, BlockCipher blockCipher, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[byArray.length];
        CTSBlockCipher cTSBlockCipher = new CTSBlockCipher(blockCipher);
        cTSBlockCipher.init(true, cipherParameters);
        int n2 = ((BufferedBlockCipher)cTSBlockCipher).processBytes(byArray, 0, byArray.length, byArray3, 0);
        ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray3, n2);
        if (!this.areEqual(byArray2, byArray3)) {
            this.fail("failed encryption expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        cTSBlockCipher.init(false, cipherParameters);
        n2 = ((BufferedBlockCipher)cTSBlockCipher).processBytes(byArray2, 0, byArray2.length, byArray3, 0);
        ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray3, n2);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("failed decryption expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
        }
    }

    private void testExceptions() throws InvalidCipherTextException {
        CTSBlockCipher cTSBlockCipher = new CTSBlockCipher(new DESEngine());
        KeyParameter keyParameter = new KeyParameter(new byte[cTSBlockCipher.getBlockSize()]);
        cTSBlockCipher.init(true, keyParameter);
        byte[] byArray = new byte[((BufferedBlockCipher)cTSBlockCipher).getOutputSize(cTSBlockCipher.getBlockSize())];
        ((BufferedBlockCipher)cTSBlockCipher).processBytes(new byte[cTSBlockCipher.getBlockSize() - 1], 0, cTSBlockCipher.getBlockSize() - 1, byArray, 0);
        try {
            ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray, 0);
            this.fail("Expected CTS encrypt error on < 1 block input");
        }
        catch (DataLengthException dataLengthException) {}
        cTSBlockCipher.init(true, keyParameter);
        ((BufferedBlockCipher)cTSBlockCipher).processBytes(new byte[cTSBlockCipher.getBlockSize()], 0, cTSBlockCipher.getBlockSize(), byArray, 0);
        try {
            ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray, 0);
        }
        catch (DataLengthException dataLengthException) {
            this.fail("Unexpected CTS encrypt error on == 1 block input");
        }
        cTSBlockCipher.init(false, keyParameter);
        ((BufferedBlockCipher)cTSBlockCipher).processBytes(new byte[cTSBlockCipher.getBlockSize() - 1], 0, cTSBlockCipher.getBlockSize() - 1, byArray, 0);
        try {
            ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray, 0);
            this.fail("Expected CTS decrypt error on < 1 block input");
        }
        catch (DataLengthException dataLengthException) {}
        cTSBlockCipher.init(false, keyParameter);
        ((BufferedBlockCipher)cTSBlockCipher).processBytes(new byte[cTSBlockCipher.getBlockSize()], 0, cTSBlockCipher.getBlockSize(), byArray, 0);
        try {
            ((BufferedBlockCipher)cTSBlockCipher).doFinal(byArray, 0);
        }
        catch (DataLengthException dataLengthException) {
            this.fail("Unexpected CTS decrypt error on == 1 block input");
        }
        try {
            new CTSBlockCipher(new SICBlockCipher(new AESEngine()));
            this.fail("Expected CTS construction error - only ECB/CBC supported.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void testOldCTS(int n, BlockCipher blockCipher, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[byArray.length];
        OldCTSBlockCipher oldCTSBlockCipher = new OldCTSBlockCipher(blockCipher);
        oldCTSBlockCipher.init(true, cipherParameters);
        int n2 = ((BufferedBlockCipher)oldCTSBlockCipher).processBytes(byArray, 0, byArray.length, byArray3, 0);
        ((BufferedBlockCipher)oldCTSBlockCipher).doFinal(byArray3, n2);
        if (!this.areEqual(byArray2, byArray3)) {
            this.fail("failed encryption expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        oldCTSBlockCipher.init(false, cipherParameters);
        n2 = ((BufferedBlockCipher)oldCTSBlockCipher).processBytes(byArray2, 0, byArray2.length, byArray3, 0);
        ((BufferedBlockCipher)oldCTSBlockCipher).doFinal(byArray3, n2);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("failed decryption expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
        }
    }
}

