/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.test.SimpleTest;

public abstract class CipherTest
extends SimpleTest {
    private SimpleTest[] _tests;
    private BlockCipher _engine;
    private KeyParameter _validKey;

    protected CipherTest(SimpleTest[] simpleTestArray, BlockCipher blockCipher, KeyParameter keyParameter) {
        this._tests = simpleTestArray;
        this._engine = blockCipher;
        this._validKey = keyParameter;
    }

    private void bufferSizeCheck(BlockCipher blockCipher) {
        byte[] byArray = new byte[blockCipher.getBlockSize()];
        byte[] byArray2 = new byte[byArray.length / 2];
        blockCipher.init(true, this._validKey);
        try {
            blockCipher.processBlock(byArray2, 0, byArray, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            blockCipher.processBlock(byArray, 0, byArray2, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {}
        blockCipher.init(false, this._validKey);
        try {
            blockCipher.processBlock(byArray2, 0, byArray, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {}
        try {
            blockCipher.processBlock(byArray, 0, byArray2, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {}
    }

    public abstract String getName();

    public void performTest() throws Exception {
        int n = 0;
        while (n != this._tests.length) {
            this._tests[n].performTest();
            ++n;
        }
        if (this._engine != null) {
            byte[] byArray = new byte[128];
            try {
                this._engine.processBlock(byArray, 0, byArray, 0);
                this.fail("failed initialisation check");
            }
            catch (IllegalStateException illegalStateException) {}
            this.bufferSizeCheck(this._engine);
        }
    }
}

