/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DHValidationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.GOST3410ValidationParameters;
import org.bouncycastle.crypto.test.DHTestKeyParameters;
import org.bouncycastle.crypto.test.ElGamalTestKeyParameters;
import org.bouncycastle.util.test.SimpleTest;

public class EqualsHashCodeTest
extends SimpleTest {
    private static Object OTHER = new Object();

    private void dhTest() {
        BigInteger bigInteger = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
        BigInteger bigInteger2 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
        DHParameters dHParameters = new DHParameters(bigInteger2, bigInteger);
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHPublicKeyParameters dHPublicKeyParameters2 = new DHPublicKeyParameters(dHPublicKeyParameters.getY(), dHPublicKeyParameters.getParameters());
        DHPrivateKeyParameters dHPrivateKeyParameters2 = new DHPrivateKeyParameters(dHPrivateKeyParameters.getX(), dHPrivateKeyParameters.getParameters());
        DHPublicKeyParameters dHPublicKeyParameters3 = new DHPublicKeyParameters(dHPrivateKeyParameters.getX(), dHPublicKeyParameters.getParameters());
        DHPrivateKeyParameters dHPrivateKeyParameters3 = new DHPrivateKeyParameters(dHPublicKeyParameters.getY(), dHPublicKeyParameters.getParameters());
        this.doTest(dHPublicKeyParameters, dHPublicKeyParameters2, dHPublicKeyParameters3);
        this.doTest(dHPrivateKeyParameters, dHPrivateKeyParameters2, dHPrivateKeyParameters3);
        DHParameters dHParameters2 = dHPublicKeyParameters.getParameters();
        DHParameters dHParameters3 = new DHParameters(dHParameters2.getP(), dHParameters2.getG(), dHParameters2.getQ(), dHParameters2.getM(), dHParameters2.getL(), dHParameters2.getJ(), dHParameters2.getValidationParameters());
        DHParameters dHParameters4 = new DHParameters(dHParameters2.getG(), dHParameters2.getP(), dHParameters2.getQ(), dHParameters2.getM(), dHParameters2.getL(), dHParameters2.getJ(), dHParameters2.getValidationParameters());
        this.doTest(dHParameters2, dHParameters3, dHParameters4);
        dHParameters4 = new DHParameters(dHParameters2.getG(), dHParameters2.getP(), null, dHParameters2.getM(), dHParameters2.getL(), dHParameters2.getJ(), dHParameters2.getValidationParameters());
        this.doTest(dHParameters2, dHParameters3, dHParameters4);
        dHPublicKeyParameters2 = new DHPublicKeyParameters(dHPublicKeyParameters.getY(), dHParameters3);
        dHPrivateKeyParameters2 = new DHPrivateKeyParameters(dHPrivateKeyParameters.getX(), dHParameters3);
        this.doTest(dHPublicKeyParameters, dHPublicKeyParameters2, dHPublicKeyParameters3);
        this.doTest(dHPrivateKeyParameters, dHPrivateKeyParameters2, dHPrivateKeyParameters3);
        DHValidationParameters dHValidationParameters = new DHValidationParameters(new byte[20], 1024);
        DHValidationParameters dHValidationParameters2 = new DHValidationParameters(new byte[20], 1024);
        DHValidationParameters dHValidationParameters3 = new DHValidationParameters(new byte[24], 1024);
        this.doTest(dHValidationParameters, dHValidationParameters, dHValidationParameters3);
        this.doTest(dHValidationParameters, dHValidationParameters2, dHValidationParameters3);
        byte[] byArray = new byte[20];
        byArray[0] = 1;
        dHValidationParameters3 = new DHValidationParameters(byArray, 1024);
        this.doTest(dHValidationParameters, dHValidationParameters2, dHValidationParameters3);
        dHValidationParameters3 = new DHValidationParameters(new byte[20], 2048);
        this.doTest(dHValidationParameters, dHValidationParameters2, dHValidationParameters3);
        DHTestKeyParameters dHTestKeyParameters = new DHTestKeyParameters(false, null);
        DHTestKeyParameters dHTestKeyParameters2 = new DHTestKeyParameters(false, null);
        DHTestKeyParameters dHTestKeyParameters3 = new DHTestKeyParameters(false, dHPublicKeyParameters.getParameters());
        this.doTest(dHTestKeyParameters, dHTestKeyParameters2, dHTestKeyParameters3);
    }

    private void doTest(Object object, Object object2, Object object3) {
        if (object.equals(null)) {
            this.fail("a equaled null");
        }
        if (!object.equals(object2) || !object2.equals(object)) {
            this.fail("equality failed");
        }
        if (object.equals(OTHER)) {
            this.fail("other inequality failed");
        }
        if (object.equals(object3) || object3.equals(object)) {
            this.fail("inequality failed");
        }
        if (object.hashCode() != object2.hashCode()) {
            this.fail("hashCode equality failed");
        }
    }

    private void dsaTest() {
        BigInteger bigInteger = BigInteger.valueOf(1L);
        BigInteger bigInteger2 = BigInteger.valueOf(2L);
        BigInteger bigInteger3 = BigInteger.valueOf(3L);
        DSAParameters dSAParameters = new DSAParameters(bigInteger, bigInteger2, bigInteger3);
        DSAParameters dSAParameters2 = new DSAParameters(bigInteger, bigInteger2, bigInteger3);
        DSAParameters dSAParameters3 = new DSAParameters(bigInteger2, bigInteger3, bigInteger);
        this.doTest(dSAParameters, dSAParameters2, dSAParameters3);
        DSAValidationParameters dSAValidationParameters = new DSAValidationParameters(new byte[20], 1024);
        DSAValidationParameters dSAValidationParameters2 = new DSAValidationParameters(new byte[20], 1024);
        DSAValidationParameters dSAValidationParameters3 = new DSAValidationParameters(new byte[24], 1024);
        this.doTest(dSAValidationParameters, dSAValidationParameters, dSAValidationParameters3);
        this.doTest(dSAValidationParameters, dSAValidationParameters2, dSAValidationParameters3);
        byte[] byArray = new byte[20];
        byArray[0] = 1;
        dSAValidationParameters3 = new DSAValidationParameters(byArray, 1024);
        this.doTest(dSAValidationParameters, dSAValidationParameters2, dSAValidationParameters3);
        dSAValidationParameters3 = new DSAValidationParameters(new byte[20], 2048);
        this.doTest(dSAValidationParameters, dSAValidationParameters2, dSAValidationParameters3);
    }

    private void elGamalTest() {
        BigInteger bigInteger = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
        BigInteger bigInteger2 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
        ElGamalParameters elGamalParameters = new ElGamalParameters(bigInteger2, bigInteger);
        ElGamalKeyGenerationParameters elGamalKeyGenerationParameters = new ElGamalKeyGenerationParameters(new SecureRandom(), elGamalParameters);
        ElGamalKeyPairGenerator elGamalKeyPairGenerator = new ElGamalKeyPairGenerator();
        elGamalKeyPairGenerator.init(elGamalKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = elGamalKeyPairGenerator.generateKeyPair();
        ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        ElGamalPublicKeyParameters elGamalPublicKeyParameters2 = new ElGamalPublicKeyParameters(elGamalPublicKeyParameters.getY(), elGamalPublicKeyParameters.getParameters());
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters2 = new ElGamalPrivateKeyParameters(elGamalPrivateKeyParameters.getX(), elGamalPrivateKeyParameters.getParameters());
        ElGamalPublicKeyParameters elGamalPublicKeyParameters3 = new ElGamalPublicKeyParameters(elGamalPrivateKeyParameters.getX(), elGamalPublicKeyParameters.getParameters());
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters3 = new ElGamalPrivateKeyParameters(elGamalPublicKeyParameters.getY(), elGamalPublicKeyParameters.getParameters());
        this.doTest(elGamalPublicKeyParameters, elGamalPublicKeyParameters2, elGamalPublicKeyParameters3);
        this.doTest(elGamalPrivateKeyParameters, elGamalPrivateKeyParameters2, elGamalPrivateKeyParameters3);
        ElGamalParameters elGamalParameters2 = elGamalPublicKeyParameters.getParameters();
        ElGamalParameters elGamalParameters3 = new ElGamalParameters(elGamalParameters2.getP(), elGamalParameters2.getG());
        ElGamalParameters elGamalParameters4 = new ElGamalParameters(elGamalParameters2.getG(), elGamalParameters2.getP());
        this.doTest(elGamalParameters2, elGamalParameters3, elGamalParameters4);
        elGamalPublicKeyParameters2 = new ElGamalPublicKeyParameters(elGamalPublicKeyParameters.getY(), elGamalParameters3);
        elGamalPrivateKeyParameters2 = new ElGamalPrivateKeyParameters(elGamalPrivateKeyParameters.getX(), elGamalParameters3);
        this.doTest(elGamalPublicKeyParameters, elGamalPublicKeyParameters2, elGamalPublicKeyParameters3);
        this.doTest(elGamalPrivateKeyParameters, elGamalPrivateKeyParameters2, elGamalPrivateKeyParameters3);
        ElGamalTestKeyParameters elGamalTestKeyParameters = new ElGamalTestKeyParameters(false, null);
        ElGamalTestKeyParameters elGamalTestKeyParameters2 = new ElGamalTestKeyParameters(false, null);
        ElGamalTestKeyParameters elGamalTestKeyParameters3 = new ElGamalTestKeyParameters(false, elGamalPublicKeyParameters.getParameters());
        this.doTest(elGamalTestKeyParameters, elGamalTestKeyParameters2, elGamalTestKeyParameters3);
    }

    public String getName() {
        return "EqualsHashCode";
    }

    private void gost3410Test() {
        BigInteger bigInteger = BigInteger.valueOf(1L);
        BigInteger bigInteger2 = BigInteger.valueOf(2L);
        BigInteger bigInteger3 = BigInteger.valueOf(3L);
        GOST3410Parameters gOST3410Parameters = new GOST3410Parameters(bigInteger, bigInteger2, bigInteger3);
        GOST3410Parameters gOST3410Parameters2 = new GOST3410Parameters(bigInteger, bigInteger2, bigInteger3);
        GOST3410Parameters gOST3410Parameters3 = new GOST3410Parameters(bigInteger, bigInteger3, bigInteger3);
        this.doTest(gOST3410Parameters, gOST3410Parameters2, gOST3410Parameters3);
        GOST3410ValidationParameters gOST3410ValidationParameters = new GOST3410ValidationParameters(100, 1);
        GOST3410ValidationParameters gOST3410ValidationParameters2 = new GOST3410ValidationParameters(100, 1);
        GOST3410ValidationParameters gOST3410ValidationParameters3 = new GOST3410ValidationParameters(101, 1);
        this.doTest(gOST3410ValidationParameters, gOST3410ValidationParameters2, gOST3410ValidationParameters3);
        gOST3410ValidationParameters3 = new GOST3410ValidationParameters(100, 2);
        this.doTest(gOST3410ValidationParameters, gOST3410ValidationParameters2, gOST3410ValidationParameters3);
        gOST3410ValidationParameters = new GOST3410ValidationParameters(100L, 1L);
        gOST3410ValidationParameters2 = new GOST3410ValidationParameters(100L, 1L);
        gOST3410ValidationParameters3 = new GOST3410ValidationParameters(101L, 1L);
        this.doTest(gOST3410ValidationParameters, gOST3410ValidationParameters2, gOST3410ValidationParameters3);
        gOST3410ValidationParameters3 = new GOST3410ValidationParameters(100L, 2L);
        this.doTest(gOST3410ValidationParameters, gOST3410ValidationParameters2, gOST3410ValidationParameters3);
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new EqualsHashCodeTest());
    }

    public void performTest() throws Exception {
        this.dhTest();
        this.elGamalTest();
        this.gost3410Test();
        this.dsaTest();
    }
}

