/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GOST28147Test
extends CipherTest {
    static String input1 = "0000000000000000";
    static String output1 = "1b0bbc32cebcab42";
    static String input2 = "bc350e71aac5f5c2";
    static String output2 = "d35ab653493b49f5";
    static String input3 = "bc350e71aa11345709acde";
    static String output3 = "8824c124c4fd14301fb1e8";
    static String input4 = "000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f";
    static String output4 = "29b7083e0a6d955ca0ec5b04fdb4ea41949f1dd2efdf17baffc1780b031f3934";
    static byte[] TestSBox;
    static byte[] TestSBox_1;
    static SimpleTest[] tests;
    private static final int GOST28147_KEY_LENGTH = 32;

    static {
        byte[] byArray = new byte[128];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 15;
        byArray[17] = 14;
        byArray[18] = 13;
        byArray[19] = 12;
        byArray[20] = 11;
        byArray[21] = 10;
        byArray[22] = 9;
        byArray[23] = 8;
        byArray[24] = 7;
        byArray[25] = 6;
        byArray[26] = 5;
        byArray[27] = 4;
        byArray[28] = 3;
        byArray[29] = 2;
        byArray[30] = 1;
        byArray[33] = 1;
        byArray[34] = 2;
        byArray[35] = 3;
        byArray[36] = 4;
        byArray[37] = 5;
        byArray[38] = 6;
        byArray[39] = 7;
        byArray[40] = 8;
        byArray[41] = 9;
        byArray[42] = 10;
        byArray[43] = 11;
        byArray[44] = 12;
        byArray[45] = 13;
        byArray[46] = 14;
        byArray[47] = 15;
        byArray[48] = 15;
        byArray[49] = 14;
        byArray[50] = 13;
        byArray[51] = 12;
        byArray[52] = 11;
        byArray[53] = 10;
        byArray[54] = 9;
        byArray[55] = 8;
        byArray[56] = 7;
        byArray[57] = 6;
        byArray[58] = 5;
        byArray[59] = 4;
        byArray[60] = 3;
        byArray[61] = 2;
        byArray[62] = 1;
        byArray[65] = 1;
        byArray[66] = 2;
        byArray[67] = 3;
        byArray[68] = 4;
        byArray[69] = 5;
        byArray[70] = 6;
        byArray[71] = 7;
        byArray[72] = 8;
        byArray[73] = 9;
        byArray[74] = 10;
        byArray[75] = 11;
        byArray[76] = 12;
        byArray[77] = 13;
        byArray[78] = 14;
        byArray[79] = 15;
        byArray[80] = 15;
        byArray[81] = 14;
        byArray[82] = 13;
        byArray[83] = 12;
        byArray[84] = 11;
        byArray[85] = 10;
        byArray[86] = 9;
        byArray[87] = 8;
        byArray[88] = 7;
        byArray[89] = 6;
        byArray[90] = 5;
        byArray[91] = 4;
        byArray[92] = 3;
        byArray[93] = 2;
        byArray[94] = 1;
        byArray[97] = 1;
        byArray[98] = 2;
        byArray[99] = 3;
        byArray[100] = 4;
        byArray[101] = 5;
        byArray[102] = 6;
        byArray[103] = 7;
        byArray[104] = 8;
        byArray[105] = 9;
        byArray[106] = 10;
        byArray[107] = 11;
        byArray[108] = 12;
        byArray[109] = 13;
        byArray[110] = 14;
        byArray[111] = 15;
        byArray[112] = 15;
        byArray[113] = 14;
        byArray[114] = 13;
        byArray[115] = 12;
        byArray[116] = 11;
        byArray[117] = 10;
        byArray[118] = 9;
        byArray[119] = 8;
        byArray[120] = 7;
        byArray[121] = 6;
        byArray[122] = 5;
        byArray[123] = 4;
        byArray[124] = 3;
        byArray[125] = 2;
        byArray[126] = 1;
        TestSBox = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[0] = 14;
        byArray2[1] = 3;
        byArray2[2] = 12;
        byArray2[3] = 13;
        byArray2[4] = 1;
        byArray2[5] = 15;
        byArray2[6] = 10;
        byArray2[7] = 9;
        byArray2[8] = 11;
        byArray2[9] = 6;
        byArray2[10] = 2;
        byArray2[11] = 7;
        byArray2[12] = 5;
        byArray2[14] = 8;
        byArray2[15] = 4;
        byArray2[16] = 13;
        byArray2[17] = 9;
        byArray2[19] = 4;
        byArray2[20] = 7;
        byArray2[21] = 1;
        byArray2[22] = 3;
        byArray2[23] = 11;
        byArray2[24] = 6;
        byArray2[25] = 12;
        byArray2[26] = 2;
        byArray2[27] = 10;
        byArray2[28] = 15;
        byArray2[29] = 14;
        byArray2[30] = 5;
        byArray2[31] = 8;
        byArray2[32] = 8;
        byArray2[33] = 11;
        byArray2[34] = 10;
        byArray2[35] = 7;
        byArray2[36] = 1;
        byArray2[37] = 13;
        byArray2[38] = 5;
        byArray2[39] = 12;
        byArray2[40] = 6;
        byArray2[41] = 3;
        byArray2[42] = 9;
        byArray2[44] = 15;
        byArray2[45] = 14;
        byArray2[46] = 2;
        byArray2[47] = 4;
        byArray2[48] = 13;
        byArray2[49] = 7;
        byArray2[50] = 12;
        byArray2[51] = 9;
        byArray2[52] = 15;
        byArray2[54] = 5;
        byArray2[55] = 8;
        byArray2[56] = 10;
        byArray2[57] = 2;
        byArray2[58] = 11;
        byArray2[59] = 6;
        byArray2[60] = 4;
        byArray2[61] = 3;
        byArray2[62] = 1;
        byArray2[63] = 14;
        byArray2[64] = 11;
        byArray2[65] = 4;
        byArray2[66] = 6;
        byArray2[67] = 5;
        byArray2[69] = 15;
        byArray2[70] = 1;
        byArray2[71] = 12;
        byArray2[72] = 9;
        byArray2[73] = 14;
        byArray2[74] = 13;
        byArray2[75] = 8;
        byArray2[76] = 3;
        byArray2[77] = 7;
        byArray2[78] = 10;
        byArray2[79] = 2;
        byArray2[80] = 13;
        byArray2[81] = 15;
        byArray2[82] = 9;
        byArray2[83] = 4;
        byArray2[84] = 2;
        byArray2[85] = 12;
        byArray2[86] = 5;
        byArray2[87] = 10;
        byArray2[88] = 6;
        byArray2[90] = 3;
        byArray2[91] = 8;
        byArray2[92] = 7;
        byArray2[93] = 14;
        byArray2[94] = 1;
        byArray2[95] = 11;
        byArray2[96] = 15;
        byArray2[97] = 14;
        byArray2[98] = 9;
        byArray2[99] = 5;
        byArray2[100] = 11;
        byArray2[101] = 2;
        byArray2[102] = 1;
        byArray2[103] = 8;
        byArray2[104] = 6;
        byArray2[106] = 13;
        byArray2[107] = 3;
        byArray2[108] = 4;
        byArray2[109] = 7;
        byArray2[110] = 12;
        byArray2[111] = 10;
        byArray2[112] = 10;
        byArray2[113] = 3;
        byArray2[114] = 14;
        byArray2[115] = 2;
        byArray2[117] = 1;
        byArray2[118] = 4;
        byArray2[119] = 6;
        byArray2[120] = 11;
        byArray2[121] = 8;
        byArray2[122] = 12;
        byArray2[123] = 7;
        byArray2[124] = 13;
        byArray2[125] = 5;
        byArray2[126] = 15;
        byArray2[127] = 9;
        TestSBox_1 = byArray2;
        tests = new SimpleTest[]{new BlockCipherVectorTest(1, new GOST28147Engine(), new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(2, new CBCBlockCipher(new GOST28147Engine()), new ParametersWithIV(new KeyParameter(Hex.decode("00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF")), Hex.decode("1234567890abcdef")), input2, output2), new BlockCipherVectorTest(3, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new KeyParameter(Hex.decode("0011223344556677889900112233445566778899001122334455667788990011")), Hex.decode("1234567890abcdef")), input3, output3), new BlockCipherVectorTest(4, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new KeyParameter(Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5")), Hex.decode("aafd12f659cae634")), input4, output4), new BlockCipherVectorTest(5, new GOST28147Engine(), new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(6, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("D-Test")), Hex.decode("1234567890abcdef")), "0000000000000000", "b587f7a0814c911d"), new BlockCipherVectorTest(7, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-Test")), Hex.decode("1234567890abcdef")), "0000000000000000", "e8287f53f991d52b"), new BlockCipherVectorTest(8, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef")), "0000000000000000", "c41009dba22ebe35"), new BlockCipherVectorTest(9, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-B")), Hex.decode("1234567890abcdef")), "0000000000000000", "80d8723fcd3aba28"), new BlockCipherVectorTest(10, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-C")), Hex.decode("1234567890abcdef")), "0000000000000000", "739f6f95068499b5"), new BlockCipherVectorTest(11, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-D")), Hex.decode("1234567890abcdef")), "0000000000000000", "4663f720f4340f57"), new BlockCipherVectorTest(12, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("D-A")), Hex.decode("1234567890abcdef")), "0000000000000000", "5bb0a31d218ed564"), new BlockCipherVectorTest(13, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), TestSBox), Hex.decode("1234567890abcdef")), "0000000000000000", "c3af96ef788667c5"), new BlockCipherVectorTest(14, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("4ef72b778f0b0bebeef4f077551cb74a927b470ad7d7f2513454569a247e989d")), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef")), "bc350e71aa11345709acde", "1bcc2282707c676fb656dc"), new BlockCipherVectorTest(15, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("8001069080010690")), "094C912C5EFDD703D42118971694580B", "2707B58DF039D1A64460735FFE76D55F"), new BlockCipherVectorTest(16, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("800107A0800107A0")), "FE780800E0690083F20C010CF00C0329", "9AF623DFF948B413B53171E8D546188D"), new BlockCipherVectorTest(17, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("8001114080011140")), "D1088FD8C0A86EE8F1DCD1088FE8C058", "62A6B64D12253BCD8241A4BB0CFD3E7C"), new BlockCipherVectorTest(18, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("80011A3080011A30")), "D431FACD011C502C501B500A12921090", "07313C89D302FF73234B4A0506AB00F3")};
    }

    GOST28147Test() {
        super(tests, new GOST28147Engine(), new KeyParameter(new byte[32]));
    }

    private byte[] generateKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        GOST3411Digest gOST3411Digest = new GOST3411Digest();
        gOST3411Digest.update(byArray, 0, byArray.length);
        gOST3411Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public String getName() {
        return "GOST28147";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GOST28147Test());
    }

    public void performTest() throws Exception {
        super.performTest();
        byte[] byArray = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
        byte[] byArray2 = Hex.decode("8ad3c8f56b27ff1fbd46409359bdc796bc350e71aac5f5c0");
        byte[] byArray3 = new byte[byArray.length];
        byte[] byArray4 = this.generateKey(Hex.decode("0123456789abcdef"));
        CipherParameters cipherParameters = new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A"));
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(new GOST28147Engine());
        bufferedBlockCipher.init(true, cipherParameters);
        int n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n);
        }
        catch (CryptoException cryptoException) {
            this.fail("failed - exception " + cryptoException.toString(), cryptoException);
        }
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        int n2 = 0;
        while (n2 != byArray3.length) {
            if (byArray3[n2] != byArray2[n2]) {
                this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
            }
            ++n2;
        }
        byArray = Hex.decode("bc350e71aac5f5c2");
        byArray2 = Hex.decode("0ebbbafcf38f14a5");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode("0123456789abcdef"));
        cipherParameters = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef"));
        bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        bufferedBlockCipher.init(true, cipherParameters);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n);
        }
        catch (CryptoException cryptoException) {
            this.fail("failed - exception " + cryptoException.toString(), cryptoException);
        }
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        int n3 = 0;
        while (n3 != byArray3.length) {
            if (byArray3[n3] != byArray2[n3]) {
                this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
            }
            ++n3;
        }
        byArray = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byArray2 = Hex.decode("64988982819f0a1655e226e19ecad79d10cc73bac95c5d7da034786c12294225");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5"));
        cipherParameters = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A")), Hex.decode("aafd12f659cae634"));
        bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        bufferedBlockCipher.init(true, cipherParameters);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        bufferedBlockCipher.doFinal(byArray3, n);
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        int n4 = 0;
        while (n4 != byArray3.length) {
            if (byArray3[n4] != byArray2[n4]) {
                this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
            }
            ++n4;
        }
        byArray = Hex.decode("bc350e71aa11345709acde");
        byArray2 = Hex.decode("1bcc2282707c676fb656dc");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode("0123456789abcdef"));
        cipherParameters = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray4), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef"));
        bufferedBlockCipher = new BufferedBlockCipher(new GOFBBlockCipher(new GOST28147Engine()));
        bufferedBlockCipher.init(true, cipherParameters);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        bufferedBlockCipher.doFinal(byArray3, n);
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        int n5 = 0;
        while (n5 != byArray3.length) {
            if (byArray3[n5] != byArray2[n5]) {
                this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
            }
            ++n5;
        }
        cipherParameters = new ParametersWithIV(null, Hex.decode("1234567890abcdef"));
        bufferedBlockCipher.init(true, cipherParameters);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        bufferedBlockCipher.doFinal(byArray3, n);
        if (byArray3.length != byArray2.length) {
            this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
        }
        int n6 = 0;
        while (n6 != byArray3.length) {
            if (byArray3[n6] != byArray2[n6]) {
                this.fail("failed - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
            }
            ++n6;
        }
    }
}

