/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.GOST3410KeyPairGenerator;
import org.bouncycastle.crypto.generators.GOST3410ParametersGenerator;
import org.bouncycastle.crypto.params.ECGOST3410Parameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.GOST3410Signer;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.NumberParsing;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestRandomData;
import org.bouncycastle.util.test.TestResult;

public class GOST3410Test
implements Test {
    byte[] hashmessage = Hex.decode("3042453136414534424341374533364339313734453431443642453241453435");
    Test[] tests = new Test[]{new GOST3410EncodingDecoding(), new GOST3410_TEST1_512(), new GOST3410_TEST2_512(), new GOST3410_TEST1_1024(), new GOST3410_TEST2_1024(), new GOST3410_AParam(), new GOST3410_BParam(), new GOST3410_CParam(), new GOST3410_DParam(), new GOST3410_AExParam(), new GOST3410_BExParam(), new GOST3410_CExParam()};

    private static ECNamedDomainParameters getECNamedDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = ECGOST3410NamedCurves.getByOIDX9(aSN1ObjectIdentifier);
        return new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters);
    }

    public String getName() {
        return "GOST3410";
    }

    public static void main(String[] stringArray) {
        GOST3410Test gOST3410Test = new GOST3410Test();
        TestResult testResult = gOST3410Test.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        int n = 0;
        while (n != this.tests.length) {
            TestResult testResult = this.tests[n].perform();
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            ++n;
        }
        return new SimpleTestResult(true, "GOST3410: Okay");
    }

    private byte[] zeroTwo(int n) {
        byte[] byArray = new byte[n];
        byArray[byArray.length - 1] = 2;
        return byArray;
    }

    private class GOST3410EncodingDecoding
    implements Test {
        GOST3410EncodingDecoding() {
        }

        private SimpleTestResult decodeJCEPrivate() {
            byte[] byArray = Hex.decode("304a020100302106082a85030701010101301506092a850307010201010106082a8503070101020204220420fe75ba328d5439ed4859e6dc7e6ca2e9aab0818f094eddeb0d57d1c16a90762b");
            try {
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)PrivateKeyFactory.createKey(byArray);
                if (!eCPrivateKeyParameters.isPrivate()) {
                    return new SimpleTestResult(false, "isPrivate should be true");
                }
                if (!Arrays.areEqual(Hex.decode("2b76906ac1d1570debdd4e098f81b0aae9a26c7edce65948ed39548d32ba75fe"), eCPrivateKeyParameters.getD().toByteArray())) {
                    return new SimpleTestResult(false, "D does not match");
                }
                if (!((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getPublicKeyParamSet().toString().equals("1.2.643.7.1.2.1.1.1")) {
                    return new SimpleTestResult(false, "PublicKeyParamSet does not match");
                }
                if (!((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getDigestParamSet().toString().equals("1.2.643.7.1.1.2.2")) {
                    return new SimpleTestResult(false, "DigestParamSet does not match");
                }
                if (((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getEncryptionParamSet() != null) {
                    return new SimpleTestResult(false, "EncryptionParamSet is not null");
                }
                byte[] byArray2 = Hex.decode("306a020100302106082a85030701010102301506092a850307010201020106082a85030701010203044204402fc35576152f6e873236608b592b4b98d0793bf5184f8dc4a99512be703716991a96061ef46aceeae5319b5c69e6fcbfa7e339207878597ce50f9b7cbf857ff1");
                eCPrivateKeyParameters = (ECPrivateKeyParameters)PrivateKeyFactory.createKey(byArray2);
                if (!eCPrivateKeyParameters.isPrivate()) {
                    return new SimpleTestResult(false, "isPrivate should be true");
                }
                if (!Arrays.areEqual(Hex.decode("00f17f85bf7c9b0fe57c5978782039e3a7bffce6695c9b31e5eace6af41e06961a99163770be1295a9c48d4f18f53b79d0984b2b598b603632876e2f157655c32f"), eCPrivateKeyParameters.getD().toByteArray())) {
                    return new SimpleTestResult(false, "D does not match");
                }
                if (!((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getPublicKeyParamSet().toString().equals("1.2.643.7.1.2.1.2.1")) {
                    return new SimpleTestResult(false, "PublicKeyParamSet does not match");
                }
                if (!((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getDigestParamSet().toString().equals("1.2.643.7.1.1.2.3")) {
                    return new SimpleTestResult(false, "DigestParamSet does not match");
                }
                if (((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getEncryptionParamSet() != null) {
                    return new SimpleTestResult(false, "EncryptionParamSet is not null");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
            return new SimpleTestResult(true, null);
        }

        private SimpleTestResult decodeJCEPublic() {
            byte[] byArray = Hex.decode("3068302106082a85030701010101301506092a850307010201010106082a850307010102020343000440292335c87d892510c35a033819a13e2b0dc606d911676af2bad8872d74a4b7bae6c729e98ace04c3dee626343f794731e1489edb7bc26f1c8c56e1448c96501a");
            try {
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)PublicKeyFactory.createKey(byArray);
                if (eCPublicKeyParameters.isPrivate()) {
                    return new SimpleTestResult(false, "isPrivate should be false");
                }
                if (!Arrays.areEqual(eCPublicKeyParameters.getQ().getEncoded(true), Hex.decode("02bab7a4742d87d8baf26a6711d906c60d2b3ea11938035ac31025897dc8352329"))) {
                    return new SimpleTestResult(false, "Q does not match");
                }
                if (!((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getPublicKeyParamSet().toString().equals("1.2.643.7.1.2.1.1.1")) {
                    return new SimpleTestResult(false, "PublicKeyParamSet does not match");
                }
                if (!((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getDigestParamSet().toString().equals("1.2.643.7.1.1.2.2")) {
                    return new SimpleTestResult(false, "DigestParamSet does not match");
                }
                if (((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getEncryptionParamSet() != null) {
                    return new SimpleTestResult(false, "EncryptionParamSet is not null");
                }
                byte[] byArray2 = Hex.decode("3081aa302106082a85030701010102301506092a850307010201020106082a850307010102030381840004818043ccc22692ee8a1870c7c9de0566d7e3a494cf0e3c80f9e8852a3d1ec10d2a829d357253e0864aee2eaacd5e2d327578dee771f62f24decfd6358e06199efe540e7912db43c4c80fe0fd31f7f67a862f9d44fd0075cfee6e3d638c7520063d26311ef962547e8129fb8c5b194e129370cd30313884b4a60872254a10772fe595");
                eCPublicKeyParameters = (ECPublicKeyParameters)PublicKeyFactory.createKey(byArray2);
                if (eCPublicKeyParameters.isPrivate()) {
                    return new SimpleTestResult(false, "isPrivate should be true");
                }
                if (!Arrays.areEqual(eCPublicKeyParameters.getQ().getEncoded(true), Hex.decode("0254fe9e19068e35d6cfde242ff671e7de7875322d5ecdaa2eee4a86e05372359d822a0dc11e3d2a85e8f9803c0ecf94a4e3d76605dec9c770188aee9226c2cc43"))) {
                    return new SimpleTestResult(false, "Q does not match");
                }
                if (!((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getPublicKeyParamSet().toString().equals("1.2.643.7.1.2.1.2.1")) {
                    return new SimpleTestResult(false, "PublicKeyParamSet does not match");
                }
                if (!((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getDigestParamSet().toString().equals("1.2.643.7.1.1.2.3")) {
                    return new SimpleTestResult(false, "DigestParamSet does not match");
                }
                if (((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getEncryptionParamSet() != null) {
                    return new SimpleTestResult(false, "EncryptionParamSet is not null");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
            return new SimpleTestResult(true, null);
        }

        private SimpleTestResult encodeDecodePrivateLW(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
            try {
                boolean bl;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ECGOST3410NamedCurves.getOID(string);
                ECNamedDomainParameters eCNamedDomainParameters = GOST3410Test.getECNamedDomainParameters(aSN1ObjectIdentifier2);
                ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(eCNamedDomainParameters, aSN1ObjectIdentifier2, aSN1ObjectIdentifier);
                ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCGOST3410Parameters, new SecureRandom());
                ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
                eCKeyPairGenerator.init(eCKeyGenerationParameters);
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(eCPrivateKeyParameters);
                ECPrivateKeyParameters eCPrivateKeyParameters2 = (ECPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
                ECGOST3410Parameters eCGOST3410Parameters2 = (ECGOST3410Parameters)eCPrivateKeyParameters.getParameters();
                ECGOST3410Parameters eCGOST3410Parameters3 = (ECGOST3410Parameters)eCPrivateKeyParameters2.getParameters();
                boolean bl2 = bl = this.safeEquals(eCGOST3410Parameters2.getDigestParamSet(), eCGOST3410Parameters3.getDigestParamSet()) && this.safeEquals(eCGOST3410Parameters2.getEncryptionParamSet(), eCGOST3410Parameters3.getEncryptionParamSet()) && this.safeEquals(eCGOST3410Parameters2.getPublicKeyParamSet(), eCGOST3410Parameters3.getPublicKeyParamSet());
                if (!bl) {
                    return new SimpleTestResult(false, "GOST parameters does not match");
                }
                if (eCPrivateKeyParameters2.isPrivate() != eCPrivateKeyParameters.isPrivate()) {
                    return new SimpleTestResult(false, "isPrivate does not match");
                }
                if (!((ECGOST3410Parameters)eCPrivateKeyParameters2.getParameters()).getName().equals(((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getName())) {
                    return new SimpleTestResult(false, "Name does not match");
                }
                if (!eCPrivateKeyParameters2.getD().equals(eCPrivateKeyParameters.getD())) {
                    return new SimpleTestResult(false, "D does not match");
                }
                if (!eCPrivateKeyParameters2.getParameters().getCurve().equals(eCPrivateKeyParameters.getParameters().getCurve())) {
                    return new SimpleTestResult(false, "Curve does not match");
                }
                if (!Arrays.areEqual(eCPrivateKeyParameters2.getParameters().getG().getEncoded(true), eCPrivateKeyParameters.getParameters().getG().getEncoded(true))) {
                    return new SimpleTestResult(false, "G does not match");
                }
                if (!eCPrivateKeyParameters2.getParameters().getH().equals(eCPrivateKeyParameters.getParameters().getH())) {
                    return new SimpleTestResult(false, "H does not match");
                }
                if (!eCPrivateKeyParameters2.getParameters().getHInv().equals(eCPrivateKeyParameters.getParameters().getHInv())) {
                    return new SimpleTestResult(false, "Hinv does not match");
                }
                if (!eCPrivateKeyParameters2.getParameters().getN().equals(eCPrivateKeyParameters.getParameters().getN())) {
                    return new SimpleTestResult(false, "N does not match");
                }
                if (!Arrays.areEqual(eCPrivateKeyParameters2.getParameters().getSeed(), eCPrivateKeyParameters.getParameters().getSeed())) {
                    return new SimpleTestResult(false, "Seed does not match");
                }
                return new SimpleTestResult(true, null);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
        }

        private SimpleTestResult encodeDecodePublicLW(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
            try {
                boolean bl;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ECGOST3410NamedCurves.getOID(string);
                ECNamedDomainParameters eCNamedDomainParameters = GOST3410Test.getECNamedDomainParameters(aSN1ObjectIdentifier2);
                ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(eCNamedDomainParameters, aSN1ObjectIdentifier2, aSN1ObjectIdentifier);
                ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCGOST3410Parameters, new SecureRandom());
                ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
                eCKeyPairGenerator.init(eCKeyGenerationParameters);
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(eCPublicKeyParameters);
                ECPublicKeyParameters eCPublicKeyParameters2 = (ECPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
                ECGOST3410Parameters eCGOST3410Parameters2 = (ECGOST3410Parameters)eCPublicKeyParameters.getParameters();
                ECGOST3410Parameters eCGOST3410Parameters3 = (ECGOST3410Parameters)eCPublicKeyParameters2.getParameters();
                boolean bl2 = bl = this.safeEquals(eCGOST3410Parameters2.getDigestParamSet(), eCGOST3410Parameters3.getDigestParamSet()) && this.safeEquals(eCGOST3410Parameters2.getEncryptionParamSet(), eCGOST3410Parameters3.getEncryptionParamSet()) && this.safeEquals(eCGOST3410Parameters2.getPublicKeyParamSet(), eCGOST3410Parameters3.getPublicKeyParamSet());
                if (!bl) {
                    return new SimpleTestResult(false, "GOST parameters does not match");
                }
                if (!((ECGOST3410Parameters)eCPublicKeyParameters2.getParameters()).getName().equals(((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getName())) {
                    return new SimpleTestResult(false, "Name does not match");
                }
                if (eCPublicKeyParameters2.isPrivate() != eCPublicKeyParameters.isPrivate()) {
                    return new SimpleTestResult(false, "isPrivate does not match");
                }
                if (!Arrays.areEqual(eCPublicKeyParameters2.getQ().getEncoded(true), eCPublicKeyParameters.getQ().getEncoded(true))) {
                    return new SimpleTestResult(false, "Q does not match");
                }
                if (!eCPublicKeyParameters2.getParameters().getCurve().equals(eCPublicKeyParameters.getParameters().getCurve())) {
                    return new SimpleTestResult(false, "Curve does not match");
                }
                if (!Arrays.areEqual(eCPublicKeyParameters2.getParameters().getG().getEncoded(true), eCPublicKeyParameters.getParameters().getG().getEncoded(true))) {
                    return new SimpleTestResult(false, "G does not match");
                }
                if (!eCPublicKeyParameters2.getParameters().getH().equals(eCPublicKeyParameters.getParameters().getH())) {
                    return new SimpleTestResult(false, "H does not match");
                }
                if (!eCPublicKeyParameters2.getParameters().getHInv().equals(eCPublicKeyParameters.getParameters().getHInv())) {
                    return new SimpleTestResult(false, "Hinv does not match");
                }
                if (!eCPublicKeyParameters2.getParameters().getN().equals(eCPublicKeyParameters.getParameters().getN())) {
                    return new SimpleTestResult(false, "N does not match");
                }
                if (!Arrays.areEqual(eCPublicKeyParameters2.getParameters().getSeed(), eCPublicKeyParameters.getParameters().getSeed())) {
                    return new SimpleTestResult(false, "Seed does not match");
                }
                return new SimpleTestResult(true, null);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
        }

        private SimpleTestResult encodeRecodePrivateKey() {
            try {
                ECPrivateKeyParameters eCPrivateKeyParameters;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID("Tc26-Gost-3410-12-512-paramSetA");
                ECNamedDomainParameters eCNamedDomainParameters = GOST3410Test.getECNamedDomainParameters(aSN1ObjectIdentifier);
                ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(eCNamedDomainParameters, aSN1ObjectIdentifier, RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512);
                ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCGOST3410Parameters, new SecureRandom());
                ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
                eCKeyPairGenerator.init(eCKeyGenerationParameters);
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
                ECPrivateKeyParameters eCPrivateKeyParameters2 = eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
                int n = 0;
                while (n < 3) {
                    boolean bl;
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(eCPrivateKeyParameters2);
                    eCPrivateKeyParameters2 = (ECPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
                    ECGOST3410Parameters eCGOST3410Parameters2 = (ECGOST3410Parameters)eCPrivateKeyParameters.getParameters();
                    ECGOST3410Parameters eCGOST3410Parameters3 = (ECGOST3410Parameters)eCPrivateKeyParameters2.getParameters();
                    boolean bl2 = bl = this.safeEquals(eCGOST3410Parameters2.getDigestParamSet(), eCGOST3410Parameters3.getDigestParamSet()) && this.safeEquals(eCGOST3410Parameters2.getEncryptionParamSet(), eCGOST3410Parameters3.getEncryptionParamSet()) && this.safeEquals(eCGOST3410Parameters2.getPublicKeyParamSet(), eCGOST3410Parameters3.getPublicKeyParamSet());
                    if (!bl) {
                        return new SimpleTestResult(false, "GOST parameters does not match");
                    }
                    if (eCPrivateKeyParameters2.isPrivate() != eCPrivateKeyParameters.isPrivate()) {
                        return new SimpleTestResult(false, "isPrivate does not match");
                    }
                    if (!eCPrivateKeyParameters2.getD().equals(eCPrivateKeyParameters.getD())) {
                        return new SimpleTestResult(false, "D does not match");
                    }
                    if (!((ECGOST3410Parameters)eCPrivateKeyParameters2.getParameters()).getName().equals(((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getName())) {
                        return new SimpleTestResult(false, "Name does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getCurve().equals(eCPrivateKeyParameters.getParameters().getCurve())) {
                        return new SimpleTestResult(false, "Curve does not match");
                    }
                    if (!Arrays.areEqual(eCPrivateKeyParameters2.getParameters().getG().getEncoded(true), eCPrivateKeyParameters.getParameters().getG().getEncoded(true))) {
                        return new SimpleTestResult(false, "G does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getH().equals(eCPrivateKeyParameters.getParameters().getH())) {
                        return new SimpleTestResult(false, "H does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getHInv().equals(eCPrivateKeyParameters.getParameters().getHInv())) {
                        return new SimpleTestResult(false, "Hinv does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getN().equals(eCPrivateKeyParameters.getParameters().getN())) {
                        return new SimpleTestResult(false, "N does not match");
                    }
                    if (!Arrays.areEqual(eCPrivateKeyParameters2.getParameters().getSeed(), eCPrivateKeyParameters.getParameters().getSeed())) {
                        return new SimpleTestResult(false, "Seed does not match");
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
            return new SimpleTestResult(true, null);
        }

        private SimpleTestResult encodeRecodePrivateKeyGost2006() {
            try {
                ECPrivateKeyParameters eCPrivateKeyParameters;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID("GostR3410-2001-CryptoPro-A");
                ECNamedDomainParameters eCNamedDomainParameters = GOST3410Test.getECNamedDomainParameters(aSN1ObjectIdentifier);
                ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(eCNamedDomainParameters, aSN1ObjectIdentifier, CryptoProObjectIdentifiers.gostR3411);
                ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCGOST3410Parameters, new SecureRandom());
                ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
                eCKeyPairGenerator.init(eCKeyGenerationParameters);
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
                ECPrivateKeyParameters eCPrivateKeyParameters2 = eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
                int n = 0;
                while (n < 3) {
                    boolean bl;
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(eCPrivateKeyParameters2);
                    eCPrivateKeyParameters2 = (ECPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
                    ECGOST3410Parameters eCGOST3410Parameters2 = (ECGOST3410Parameters)eCPrivateKeyParameters.getParameters();
                    ECGOST3410Parameters eCGOST3410Parameters3 = (ECGOST3410Parameters)eCPrivateKeyParameters2.getParameters();
                    boolean bl2 = bl = this.safeEquals(eCGOST3410Parameters2.getDigestParamSet(), eCGOST3410Parameters3.getDigestParamSet()) && this.safeEquals(eCGOST3410Parameters2.getEncryptionParamSet(), eCGOST3410Parameters3.getEncryptionParamSet()) && this.safeEquals(eCGOST3410Parameters2.getPublicKeyParamSet(), eCGOST3410Parameters3.getPublicKeyParamSet());
                    if (!bl) {
                        return new SimpleTestResult(false, "GOST parameters does not match");
                    }
                    if (eCPrivateKeyParameters2.isPrivate() != eCPrivateKeyParameters.isPrivate()) {
                        return new SimpleTestResult(false, "isPrivate does not match");
                    }
                    if (!eCPrivateKeyParameters2.getD().equals(eCPrivateKeyParameters.getD())) {
                        return new SimpleTestResult(false, "D does not match");
                    }
                    if (!((ECGOST3410Parameters)eCPrivateKeyParameters2.getParameters()).getName().equals(((ECGOST3410Parameters)eCPrivateKeyParameters.getParameters()).getName())) {
                        return new SimpleTestResult(false, "Name does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getCurve().equals(eCPrivateKeyParameters.getParameters().getCurve())) {
                        return new SimpleTestResult(false, "Curve does not match");
                    }
                    if (!Arrays.areEqual(eCPrivateKeyParameters2.getParameters().getG().getEncoded(true), eCPrivateKeyParameters.getParameters().getG().getEncoded(true))) {
                        return new SimpleTestResult(false, "G does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getH().equals(eCPrivateKeyParameters.getParameters().getH())) {
                        return new SimpleTestResult(false, "H does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getHInv().equals(eCPrivateKeyParameters.getParameters().getHInv())) {
                        return new SimpleTestResult(false, "Hinv does not match");
                    }
                    if (!eCPrivateKeyParameters2.getParameters().getN().equals(eCPrivateKeyParameters.getParameters().getN())) {
                        return new SimpleTestResult(false, "N does not match");
                    }
                    if (!Arrays.areEqual(eCPrivateKeyParameters2.getParameters().getSeed(), eCPrivateKeyParameters.getParameters().getSeed())) {
                        return new SimpleTestResult(false, "Seed does not match");
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
            return new SimpleTestResult(true, null);
        }

        public SimpleTestResult encodeRecodePublicKey() {
            ECPublicKeyParameters eCPublicKeyParameters;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID("Tc26-Gost-3410-12-512-paramSetA");
            ECNamedDomainParameters eCNamedDomainParameters = GOST3410Test.getECNamedDomainParameters(aSN1ObjectIdentifier);
            ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(eCNamedDomainParameters, aSN1ObjectIdentifier, RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512);
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCGOST3410Parameters, new SecureRandom());
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters2 = eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            try {
                int n = 0;
                while (n < 3) {
                    boolean bl;
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(eCPublicKeyParameters2);
                    eCPublicKeyParameters2 = (ECPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
                    ECGOST3410Parameters eCGOST3410Parameters2 = (ECGOST3410Parameters)eCPublicKeyParameters.getParameters();
                    ECGOST3410Parameters eCGOST3410Parameters3 = (ECGOST3410Parameters)eCPublicKeyParameters2.getParameters();
                    boolean bl2 = bl = this.safeEquals(eCGOST3410Parameters2.getDigestParamSet(), eCGOST3410Parameters3.getDigestParamSet()) && this.safeEquals(eCGOST3410Parameters2.getEncryptionParamSet(), eCGOST3410Parameters3.getEncryptionParamSet()) && this.safeEquals(eCGOST3410Parameters2.getPublicKeyParamSet(), eCGOST3410Parameters3.getPublicKeyParamSet());
                    if (!bl) {
                        return new SimpleTestResult(false, "GOST parameters does not match");
                    }
                    if (!((ECGOST3410Parameters)eCPublicKeyParameters2.getParameters()).getName().equals(((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getName())) {
                        return new SimpleTestResult(false, "Name does not match");
                    }
                    if (eCPublicKeyParameters2.isPrivate() != eCPublicKeyParameters.isPrivate()) {
                        return new SimpleTestResult(false, "isPrivate does not match");
                    }
                    if (!Arrays.areEqual(eCPublicKeyParameters2.getQ().getEncoded(true), eCPublicKeyParameters.getQ().getEncoded(true))) {
                        return new SimpleTestResult(false, "Q does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getCurve().equals(eCPublicKeyParameters.getParameters().getCurve())) {
                        return new SimpleTestResult(false, "Curve does not match");
                    }
                    if (!Arrays.areEqual(eCPublicKeyParameters2.getParameters().getG().getEncoded(true), eCPublicKeyParameters.getParameters().getG().getEncoded(true))) {
                        return new SimpleTestResult(false, "G does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getH().equals(eCPublicKeyParameters.getParameters().getH())) {
                        return new SimpleTestResult(false, "H does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getHInv().equals(eCPublicKeyParameters.getParameters().getHInv())) {
                        return new SimpleTestResult(false, "Hinv does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getN().equals(eCPublicKeyParameters.getParameters().getN())) {
                        return new SimpleTestResult(false, "N does not match");
                    }
                    if (!Arrays.areEqual(eCPublicKeyParameters2.getParameters().getSeed(), eCPublicKeyParameters.getParameters().getSeed())) {
                        return new SimpleTestResult(false, "Seed does not match");
                    }
                    ++n;
                }
                return new SimpleTestResult(true, null);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
        }

        public SimpleTestResult encodeRecodePublicKeyGost2006() {
            ECPublicKeyParameters eCPublicKeyParameters;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID("GostR3410-2001-CryptoPro-A");
            ECNamedDomainParameters eCNamedDomainParameters = GOST3410Test.getECNamedDomainParameters(aSN1ObjectIdentifier);
            ECGOST3410Parameters eCGOST3410Parameters = new ECGOST3410Parameters(eCNamedDomainParameters, aSN1ObjectIdentifier, CryptoProObjectIdentifiers.gostR3411);
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCGOST3410Parameters, new SecureRandom());
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init(eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters2 = eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            try {
                int n = 0;
                while (n < 3) {
                    boolean bl;
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(eCPublicKeyParameters2);
                    eCPublicKeyParameters2 = (ECPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
                    ECGOST3410Parameters eCGOST3410Parameters2 = (ECGOST3410Parameters)eCPublicKeyParameters.getParameters();
                    ECGOST3410Parameters eCGOST3410Parameters3 = (ECGOST3410Parameters)eCPublicKeyParameters2.getParameters();
                    boolean bl2 = bl = this.safeEquals(eCGOST3410Parameters2.getDigestParamSet(), eCGOST3410Parameters3.getDigestParamSet()) && this.safeEquals(eCGOST3410Parameters2.getEncryptionParamSet(), eCGOST3410Parameters3.getEncryptionParamSet()) && this.safeEquals(eCGOST3410Parameters2.getPublicKeyParamSet(), eCGOST3410Parameters3.getPublicKeyParamSet());
                    if (!bl) {
                        return new SimpleTestResult(false, "GOST parameters does not match");
                    }
                    if (!((ECGOST3410Parameters)eCPublicKeyParameters2.getParameters()).getName().equals(((ECGOST3410Parameters)eCPublicKeyParameters.getParameters()).getName())) {
                        return new SimpleTestResult(false, "Name does not match");
                    }
                    if (eCPublicKeyParameters2.isPrivate() != eCPublicKeyParameters.isPrivate()) {
                        return new SimpleTestResult(false, "isPrivate does not match");
                    }
                    if (!Arrays.areEqual(eCPublicKeyParameters2.getQ().getEncoded(true), eCPublicKeyParameters.getQ().getEncoded(true))) {
                        return new SimpleTestResult(false, "Q does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getCurve().equals(eCPublicKeyParameters.getParameters().getCurve())) {
                        return new SimpleTestResult(false, "Curve does not match");
                    }
                    if (!Arrays.areEqual(eCPublicKeyParameters2.getParameters().getG().getEncoded(true), eCPublicKeyParameters.getParameters().getG().getEncoded(true))) {
                        return new SimpleTestResult(false, "G does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getH().equals(eCPublicKeyParameters.getParameters().getH())) {
                        return new SimpleTestResult(false, "H does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getHInv().equals(eCPublicKeyParameters.getParameters().getHInv())) {
                        return new SimpleTestResult(false, "Hinv does not match");
                    }
                    if (!eCPublicKeyParameters2.getParameters().getN().equals(eCPublicKeyParameters.getParameters().getN())) {
                        return new SimpleTestResult(false, "N does not match");
                    }
                    if (!Arrays.areEqual(eCPublicKeyParameters2.getParameters().getSeed(), eCPublicKeyParameters.getParameters().getSeed())) {
                        return new SimpleTestResult(false, "Seed does not match");
                    }
                    ++n;
                }
                return new SimpleTestResult(true, null);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, exception.getMessage(), exception);
            }
        }

        public String getName() {
            return "GOST3410ParameterEncodeDecode";
        }

        public TestResult perform() {
            SimpleTestResult simpleTestResult = this.encodeDecodePublicLW("Tc26-Gost-3410-12-512-paramSetA", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512);
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeDecodePrivateLW("Tc26-Gost-3410-12-512-paramSetA", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512);
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeDecodePublicLW("Tc26-Gost-3410-12-256-paramSetA", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256);
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeDecodePrivateLW("Tc26-Gost-3410-12-256-paramSetA", RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256);
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.decodeJCEPrivate();
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.decodeJCEPublic();
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeRecodePrivateKey();
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeRecodePublicKey();
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeRecodePublicKeyGost2006();
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            simpleTestResult = this.encodeRecodePrivateKeyGost2006();
            if (!simpleTestResult.isSuccessful()) {
                return simpleTestResult;
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }

        private boolean safeEquals(Object object, Object object2) {
            if (object == null || object2 == null) {
                return object == null && object2 == null;
            }
            return object.equals(object2);
        }
    }

    private class GOST3410_TEST1_512
    implements Test {
        FixedSecureRandom init_random;
        FixedSecureRandom random;
        FixedSecureRandom keyRandom;
        BigInteger pValue;
        BigInteger qValue;

        GOST3410_TEST1_512() {
            this.init_random = new FixedSecureRandom(new FixedSecureRandom.Source[]{new FixedSecureRandom.Data(Hex.decode("00005EC900007341")), new FixedSecureRandom.Data(GOST3410Test.this.zeroTwo(64))});
            this.random = new TestRandomData(Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A"));
            this.keyRandom = new TestRandomData(Hex.decode("3036314538303830343630454235324435324234314132373832433138443046"));
            this.pValue = new BigInteger("EE8172AE8996608FB69359B89EB82A69854510E2977A4D63BC97322CE5DC3386EA0A12B343E9190F23177539845839786BB0C345D165976EF2195EC9B1C379E3", 16);
            this.qValue = new BigInteger("98915E7EC8265EDFCDA31E88F24809DDB064BDC7285DD50D7289F0AC6F49DD2D", 16);
        }

        public String getName() {
            return "GOST3410-TEST1-512";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("3e5f895e276d81d2d52c0763270a458157b784c57abdbd807bc44fd43a32ac06", 16);
            BigInteger bigInteger2 = new BigInteger("3f0dd5d4400d47c08e4ce505ff7434b6dbf729592e37c74856dab85115a60955", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(512, 1, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (gOST3410Parameters.getValidationParameters() == null) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + "validation parameters wrong");
            }
            if (gOST3410Parameters.getValidationParameters().getC() != 29505 || gOST3410Parameters.getValidationParameters().getX0() != 24265) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + "validation parameters values wrong");
            }
            if (!this.init_random.isExhausted()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": unexpected number of bytes used from 'init_random'.");
            }
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters((SecureRandom)this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            if (!this.keyRandom.isExhausted()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": unexpected number of bytes used from 'keyRandom'.");
            }
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!this.random.isExhausted()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": unexpected number of bytes used from 'random'.");
            }
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_TEST2_512
    implements Test {
        FixedSecureRandom init_random;
        FixedSecureRandom random;
        FixedSecureRandom keyRandom;
        BigInteger pValue;
        BigInteger qValue;

        GOST3410_TEST2_512() {
            this.init_random = new FixedSecureRandom(new FixedSecureRandom.Source[]{new FixedSecureRandom.Data(Hex.decode("000000003DFC46F1000000000000000D")), new FixedSecureRandom.Data(GOST3410Test.this.zeroTwo(64))});
            this.random = new TestRandomData(Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A"));
            this.keyRandom = new TestRandomData(Hex.decode("3036314538303830343630454235324435324234314132373832433138443046"));
            this.pValue = new BigInteger("8b08eb135af966aab39df294538580c7da26765d6d38d30cf1c06aae0d1228c3316a0e29198460fad2b19dc381c15c888c6dfd0fc2c565abb0bf1faff9518f85", 16);
            this.qValue = new BigInteger("931a58fb6f0dcdf2fe7549bc3f19f4724b56898f7f921a076601edb18c93dc75", 16);
        }

        public String getName() {
            return "GOST3410-TEST2-512";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("7c07c8cf035c2a1cb2b7fae5807ac7cd623dfca7a1a68f6d858317822f1ea00d", 16);
            BigInteger bigInteger2 = new BigInteger("7e9e036a6ff87dbf9b004818252b1f6fc310bdd4d17cb8c37d9c36c7884de60c", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(512, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.init_random.isExhausted()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": unexpected number of bytes used from 'init_random'.");
            }
            if (gOST3410Parameters.getValidationParameters() == null) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": validation parameters wrong");
            }
            if (gOST3410Parameters.getValidationParameters().getCL() != 13L || gOST3410Parameters.getValidationParameters().getX0L() != 1039943409L) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": validation parameters values wrong");
            }
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters((SecureRandom)this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            if (!this.keyRandom.isExhausted()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": unexpected number of bytes used from 'keyRandom'.");
            }
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!this.random.isExhausted()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": unexpected number of bytes used from 'random'.");
            }
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_TEST1_1024
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstInt;
            {
                this.firstInt = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("02");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public int nextInt() {
                String string = "0xA565";
                String string2 = "0x538B";
                if (this.firstInt) {
                    this.firstInt = false;
                    return NumberParsing.decodeIntFromHex(string);
                }
                return NumberParsing.decodeIntFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("ab8f37938356529e871514c1f48c5cbce77b2f4fc9a2673ac2c1653da8984090c0ac73775159a26bef59909d4c9846631270e16653a6234668f2a52a01a39b921490e694c0f104b58d2e14970fccb478f98d01e975a1028b9536d912de5236d2dd2fc396b77153594d4178780e5f16f718471e2111c8ce64a7d7e196fa57142d", 16);
        BigInteger qValue = new BigInteger("bcc02ca0ce4f0753ec16105ee5d530aa00d39f3171842ab2c334a26b5f576e0f", 16);

        GOST3410_TEST1_1024() {
        }

        public String getName() {
            return "GOST3410-TEST1-1024";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("a8790aabbd5a998ff524bad048ac69cd1faff2dab048265c8d60d1471c44a9ee", 16);
            BigInteger bigInteger2 = new BigInteger("30df5ba32ac77170b9632559bef7d37620017756dff3fea1088b4267db0944b8", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 1, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_TEST2_1024
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("02");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x3DFC46F1";
                String string2 = "0xD";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("e2c4191c4b5f222f9ac2732562f6d9b4f18e7fb67a290ea1e03d750f0b9806755fc730d975bf3faa606d05c218b35a6c3706919aab92e0c58b1de4531c8fa8e7af43c2bff016251e21b2870897f6a27ac4450bca235a5b748ad386e4a0e4dfcb09152435abcfe48bd0b126a8122c7382f285a9864615c66decddf6afd355dfb7", 16);
        BigInteger qValue = new BigInteger("931a58fb6f0dcdf2fe7549bc3f19f4724b56898f7f921a076601edb18c93dc75", 16);

        GOST3410_TEST2_1024() {
        }

        public String getName() {
            return "GOST3410-TEST2-1024";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("81d69a192e9c7ac21fc07da41bd07e230ba6a94eb9f3c1fd104c7bd976733ca5", 16);
            BigInteger bigInteger2 = new BigInteger("315c879c8414f35feb4deb15e7cc0278c48e6ca1596325d6959338d860b0c47a", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_AParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("02");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x520874F5";
                String string2 = "0xEE39ADB3";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("b4e25efb018e3c8b87505e2a67553c5edc56c2914b7e4f89d23f03f03377e70a2903489dd60e78418d3d851edb5317c4871e40b04228c3b7902963c4b7d85d52b9aa88f2afdbeb28da8869d6df846a1d98924e925561bd69300b9ddd05d247b5922d967cbb02671881c57d10e5ef72d3e6dad4223dc82aa1f7d0294651a480df", 16);
        BigInteger qValue = new BigInteger("972432a437178b30bd96195b773789ab2fff15594b176dd175b63256ee5af2cf", 16);

        GOST3410_AParam() {
        }

        public String getName() {
            return "GOST3410-AParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("64a8856628e5669d85f62cd763dd4a99bc56d33dc0e1859122855d141e9e4774", 16);
            BigInteger bigInteger2 = new BigInteger("319ebac97092b288d469a4b988248794f60c865bc97858d9a3135c6d1a1bf2dd", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_BParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("bc3cbbdb7e6f848286e19ad9a27a8e297e5b71c53dd974cdf60f937356df69cbc97a300ccc71685c553046147f11568c4fddf363d9d886438345a62c3b75963d6546adfabf31b31290d12cae65ecb8309ef66782");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x5B977CDB";
                String string2 = "0x6E9692DD";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("c6971fc57524b30c9018c5e621de15499736854f56a6f8aee65a7a404632b3540f09020f67f04dc2e6783b141dceffd21a703035b7d0187c6e12cb4229922bafdb2225b73e6b23a0de36e20047065aea000c1a374283d0ad8dc1981e3995f0bb8c72526041fcb98ae6163e1e71a669d8364e9c4c3188f673c5f8ee6fadb41abf", 16);
        BigInteger qValue = new BigInteger("b09d634c10899cd7d4c3a7657403e05810b07c61a688bab2c37f475e308b0607", 16);

        GOST3410_BParam() {
        }

        public String getName() {
            return "GOST3410-BParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("860d82c60e9502cd00c0e9e1f6563feafec304801974d745c5e02079946f729e", 16);
            BigInteger bigInteger2 = new BigInteger("7ef49264ef022801aaa03033cd97915235fbab4c823ed936b0f360c22114688a", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_CParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("7F575E8194BC5BDF");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x43848744";
                String string2 = "0xB50A826D";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("9d88e6d7fe3313bd2e745c7cdd2ab9ee4af3c8899e847de74a33783ea68bc30588ba1f738c6aaf8ab350531f1854c3837cc3c860ffd7e2e106c3f63b3d8a4c034ce73942a6c3d585b599cf695ed7a3c4a93b2b947b7157bb1a1c043ab41ec8566c6145e938a611906de0d32e562494569d7e999a0dda5c879bdd91fe124df1e9", 16);
        BigInteger qValue = new BigInteger("fadd197abd19a1b4653eecf7eca4d6a22b1f7f893b641f901641fbb555354faf", 16);

        GOST3410_CParam() {
        }

        public String getName() {
            return "GOST3410-CParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("4deb95a0b35e7ed7edebe9bef5a0f93739e16b7ff27fe794d989d0c13159cfbc", 16);
            BigInteger bigInteger2 = new BigInteger("e1d0d30345c24cfeb33efde3deee5fbbda78ddc822b719d860cd0ba1fb6bd43b", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_DParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("41ab97857f42614355d32db0b1069f109a4da283676c7c53a68185b4");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x13DA8B9D";
                String string2 = "0xA0E9DE4B";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("80f102d32b0fd167d069c27a307adad2c466091904dbaa55d5b8cc7026f2f7a1919b890cb652c40e054e1e9306735b43d7b279eddf9102001cd9e1a831fe8a163eed89ab07cf2abe8242ac9dedddbf98d62cddd1ea4f5f15d3a42a6677bdd293b24260c0f27c0f1d15948614d567b66fa902baa11a69ae3bceadbb83e399c9b5", 16);
        BigInteger qValue = new BigInteger("f0f544c418aac234f683f033511b65c21651a6078bda2d69bb9f732867502149", 16);

        GOST3410_DParam() {
        }

        public String getName() {
            return "GOST3410-DParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("712592d285b792e33b8a9a11e8e6c4f512ddf0042972bbfd1abb0a93e8fc6f54", 16);
            BigInteger bigInteger2 = new BigInteger("2cf26758321258b130d5612111339f09ceb8668241f3482e38baa56529963f07", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_AExParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("35ab875399cda33c146ca629660e5a5e5c07714ca326db032dd6751995cdb90a612b9228932d8302704ec24a5def7739c5813d83");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0xD05E9F14";
                String string2 = "0x46304C5F";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("ca3b3f2eee9fd46317d49595a9e7518e6c63d8f4eb4d22d10d28af0b8839f079f8289e603b03530784b9bb5a1e76859e4850c670c7b71c0df84ca3e0d6c177fe9f78a9d8433230a883cd82a2b2b5c7a3306980278570cdb79bf01074a69c9623348824b0c53791d53c6a78cab69e1cfb28368611a397f50f541e16db348dbe5f", 16);
        BigInteger qValue = new BigInteger("cae4d85f80c147704b0ca48e85fb00a9057aa4acc44668e17f1996d7152690d9", 16);

        GOST3410_AExParam() {
        }

        public String getName() {
            return "GOST3410-AExParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("90892707282f433398488f19d31ac48523a8e2ded68944e0da91c6895ee7045e", 16);
            BigInteger bigInteger2 = new BigInteger("3be4620ee88f1ee8f9dd63c7d145b7e554839feeca125049118262ea4651e9de", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_BExParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("7ec123d161477762838c2bea9dbdf33074af6d41d108a066a1e7a07ab3048de2");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x7A007804";
                String string2 = "0xD31A4FF7";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("9286dbda91eccfc3060aa5598318e2a639f5ba90a4ca656157b2673fb191cd0589ee05f4cef1bd13508408271458c30851ce7a4ef534742bfb11f4743c8f787b11193ba304c0e6bca25701bf88af1cb9b8fd4711d89f88e32b37d95316541bf1e5dbb4989b3df13659b88c0f97a3c1087b9f2d5317d557dcd4afc6d0a754e279", 16);
        BigInteger qValue = new BigInteger("c966e9b3b8b7cdd82ff0f83af87036c38f42238ec50a876cd390e43d67b6013f", 16);

        GOST3410_BExParam() {
        }

        public String getName() {
            return "GOST3410-BExParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("8f79a582513df84dc247bcb624340cc0e5a34c4324a20ce7fe3ab8ff38a9db71", 16);
            BigInteger bigInteger2 = new BigInteger("7508d22fd6cbb45efd438cb875e43f137247088d0f54b29a7c91f68a65b5fa85", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }

    private class GOST3410_CExParam
    implements Test {
        SecureRandom init_random = new SecureRandom(){
            boolean firstLong;
            {
                this.firstLong = true;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("ca82cce78a738bc46f103d53b9bf809745ec845e4f6da462606c51f60ecf302e31204b81");
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            }

            public long nextLong() {
                String string = "0x162AB910";
                String string2 = "0x93F828D3";
                if (this.firstLong) {
                    this.firstLong = false;
                    return NumberParsing.decodeLongFromHex(string);
                }
                return NumberParsing.decodeLongFromHex(string2);
            }
        };
        SecureRandom random = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("90F3A564439242F5186EBB224C8E223811B7105C64E4F5390807E6362DF4C72A");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        SecureRandom keyRandom = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = Hex.decode("3036314538303830343630454235324435324234314132373832433138443046");
                int n = 0;
                while (n < byArray.length - byArray2.length) {
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
                if (n > byArray.length) {
                    System.arraycopy(byArray2, 0, byArray, n - byArray2.length, byArray.length - (n - byArray2.length));
                } else {
                    System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
                }
            }
        };
        BigInteger pValue = new BigInteger("b194036ace14139d36d64295ae6c50fc4b7d65d8b340711366ca93f383653908ee637be428051d86612670ad7b402c09b820fa77d9da29c8111a8496da6c261a53ed252e4d8a69a20376e6addb3bdcd331749a491a184b8fda6d84c31cf05f9119b5ed35246ea4562d85928ba1136a8d0e5a7e5c764ba8902029a1336c631a1d", 16);
        BigInteger qValue = new BigInteger("96120477df0f3896628e6f4a88d83c93204c210ff262bccb7dae450355125259", 16);

        GOST3410_CExParam() {
        }

        public String getName() {
            return "GOST3410-CExParam";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("169fdb2dc09f690b71332432bfec806042e258fa9a21dafe73c6abfbc71407d9", 16);
            BigInteger bigInteger2 = new BigInteger("9002551808ae40d19f6f31fb67e4563101243cf07cffd5f2f8ff4c537b0c9866", 16);
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            gOST3410ParametersGenerator.init(1024, 2, this.init_random);
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            if (!this.pValue.equals(gOST3410Parameters.getP()) || !this.qValue.equals(gOST3410Parameters.getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": p or q wrong");
            }
            GOST3410KeyPairGenerator gOST3410KeyPairGenerator = new GOST3410KeyPairGenerator();
            GOST3410KeyGenerationParameters gOST3410KeyGenerationParameters = new GOST3410KeyGenerationParameters(this.keyRandom, gOST3410Parameters);
            gOST3410KeyPairGenerator.init(gOST3410KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = gOST3410KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), this.random);
            GOST3410Signer gOST3410Signer = new GOST3410Signer();
            gOST3410Signer.init(true, parametersWithRandom);
            BigInteger[] bigIntegerArray = gOST3410Signer.generateSignature(GOST3410Test.this.hashmessage);
            if (!bigInteger.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": r component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[0].toString(16));
            }
            if (!bigInteger2.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": s component wrong." + Strings.lineSeparator() + " expecting: " + bigInteger2.toString(16) + Strings.lineSeparator() + " got      : " + bigIntegerArray[1].toString(16));
            }
            gOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (gOST3410Signer.verifySignature(GOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": verification fails");
        }
    }
}

