/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import org.bouncycastle.internal.asn1.cms.CCMParameters;
import org.bouncycastle.internal.asn1.cms.GCMParameters;

public class CipherFactory {
    private static final short[] rc2Ekb;

    static {
        short[] sArray = new short[256];
        sArray[0] = 93;
        sArray[1] = 190;
        sArray[2] = 155;
        sArray[3] = 139;
        sArray[4] = 17;
        sArray[5] = 153;
        sArray[6] = 110;
        sArray[7] = 77;
        sArray[8] = 89;
        sArray[9] = 243;
        sArray[10] = 133;
        sArray[11] = 166;
        sArray[12] = 63;
        sArray[13] = 183;
        sArray[14] = 131;
        sArray[15] = 197;
        sArray[16] = 228;
        sArray[17] = 115;
        sArray[18] = 107;
        sArray[19] = 58;
        sArray[20] = 104;
        sArray[21] = 90;
        sArray[22] = 192;
        sArray[23] = 71;
        sArray[24] = 160;
        sArray[25] = 100;
        sArray[26] = 52;
        sArray[27] = 12;
        sArray[28] = 241;
        sArray[29] = 208;
        sArray[30] = 82;
        sArray[31] = 165;
        sArray[32] = 185;
        sArray[33] = 30;
        sArray[34] = 150;
        sArray[35] = 67;
        sArray[36] = 65;
        sArray[37] = 216;
        sArray[38] = 212;
        sArray[39] = 44;
        sArray[40] = 219;
        sArray[41] = 248;
        sArray[42] = 7;
        sArray[43] = 119;
        sArray[44] = 42;
        sArray[45] = 202;
        sArray[46] = 235;
        sArray[47] = 239;
        sArray[48] = 16;
        sArray[49] = 28;
        sArray[50] = 22;
        sArray[51] = 13;
        sArray[52] = 56;
        sArray[53] = 114;
        sArray[54] = 47;
        sArray[55] = 137;
        sArray[56] = 193;
        sArray[57] = 249;
        sArray[58] = 128;
        sArray[59] = 196;
        sArray[60] = 109;
        sArray[61] = 174;
        sArray[62] = 48;
        sArray[63] = 61;
        sArray[64] = 206;
        sArray[65] = 32;
        sArray[66] = 99;
        sArray[67] = 254;
        sArray[68] = 230;
        sArray[69] = 26;
        sArray[70] = 199;
        sArray[71] = 184;
        sArray[72] = 80;
        sArray[73] = 232;
        sArray[74] = 36;
        sArray[75] = 23;
        sArray[76] = 252;
        sArray[77] = 37;
        sArray[78] = 111;
        sArray[79] = 187;
        sArray[80] = 106;
        sArray[81] = 163;
        sArray[82] = 68;
        sArray[83] = 83;
        sArray[84] = 217;
        sArray[85] = 162;
        sArray[86] = 1;
        sArray[87] = 171;
        sArray[88] = 188;
        sArray[89] = 182;
        sArray[90] = 31;
        sArray[91] = 152;
        sArray[92] = 238;
        sArray[93] = 154;
        sArray[94] = 167;
        sArray[95] = 45;
        sArray[96] = 79;
        sArray[97] = 158;
        sArray[98] = 142;
        sArray[99] = 172;
        sArray[100] = 224;
        sArray[101] = 198;
        sArray[102] = 73;
        sArray[103] = 70;
        sArray[104] = 41;
        sArray[105] = 244;
        sArray[106] = 148;
        sArray[107] = 138;
        sArray[108] = 175;
        sArray[109] = 225;
        sArray[110] = 91;
        sArray[111] = 195;
        sArray[112] = 179;
        sArray[113] = 123;
        sArray[114] = 87;
        sArray[115] = 209;
        sArray[116] = 124;
        sArray[117] = 156;
        sArray[118] = 237;
        sArray[119] = 135;
        sArray[120] = 64;
        sArray[121] = 140;
        sArray[122] = 226;
        sArray[123] = 203;
        sArray[124] = 147;
        sArray[125] = 20;
        sArray[126] = 201;
        sArray[127] = 97;
        sArray[128] = 46;
        sArray[129] = 229;
        sArray[130] = 204;
        sArray[131] = 246;
        sArray[132] = 94;
        sArray[133] = 168;
        sArray[134] = 92;
        sArray[135] = 214;
        sArray[136] = 117;
        sArray[137] = 141;
        sArray[138] = 98;
        sArray[139] = 149;
        sArray[140] = 88;
        sArray[141] = 105;
        sArray[142] = 118;
        sArray[143] = 161;
        sArray[144] = 74;
        sArray[145] = 181;
        sArray[146] = 85;
        sArray[147] = 9;
        sArray[148] = 120;
        sArray[149] = 51;
        sArray[150] = 130;
        sArray[151] = 215;
        sArray[152] = 221;
        sArray[153] = 121;
        sArray[154] = 245;
        sArray[155] = 27;
        sArray[156] = 11;
        sArray[157] = 222;
        sArray[158] = 38;
        sArray[159] = 33;
        sArray[160] = 40;
        sArray[161] = 116;
        sArray[162] = 4;
        sArray[163] = 151;
        sArray[164] = 86;
        sArray[165] = 223;
        sArray[166] = 60;
        sArray[167] = 240;
        sArray[168] = 55;
        sArray[169] = 57;
        sArray[170] = 220;
        sArray[171] = 255;
        sArray[172] = 6;
        sArray[173] = 164;
        sArray[174] = 234;
        sArray[175] = 66;
        sArray[176] = 8;
        sArray[177] = 218;
        sArray[178] = 180;
        sArray[179] = 113;
        sArray[180] = 176;
        sArray[181] = 207;
        sArray[182] = 18;
        sArray[183] = 122;
        sArray[184] = 78;
        sArray[185] = 250;
        sArray[186] = 108;
        sArray[187] = 29;
        sArray[188] = 132;
        sArray[190] = 200;
        sArray[191] = 127;
        sArray[192] = 145;
        sArray[193] = 69;
        sArray[194] = 170;
        sArray[195] = 43;
        sArray[196] = 194;
        sArray[197] = 177;
        sArray[198] = 143;
        sArray[199] = 213;
        sArray[200] = 186;
        sArray[201] = 242;
        sArray[202] = 173;
        sArray[203] = 25;
        sArray[204] = 178;
        sArray[205] = 103;
        sArray[206] = 54;
        sArray[207] = 247;
        sArray[208] = 15;
        sArray[209] = 10;
        sArray[210] = 146;
        sArray[211] = 125;
        sArray[212] = 227;
        sArray[213] = 157;
        sArray[214] = 233;
        sArray[215] = 144;
        sArray[216] = 62;
        sArray[217] = 35;
        sArray[218] = 39;
        sArray[219] = 102;
        sArray[220] = 19;
        sArray[221] = 236;
        sArray[222] = 129;
        sArray[223] = 21;
        sArray[224] = 189;
        sArray[225] = 34;
        sArray[226] = 191;
        sArray[227] = 159;
        sArray[228] = 126;
        sArray[229] = 169;
        sArray[230] = 81;
        sArray[231] = 75;
        sArray[232] = 76;
        sArray[233] = 251;
        sArray[234] = 2;
        sArray[235] = 211;
        sArray[236] = 112;
        sArray[237] = 134;
        sArray[238] = 49;
        sArray[239] = 231;
        sArray[240] = 59;
        sArray[241] = 5;
        sArray[242] = 3;
        sArray[243] = 84;
        sArray[244] = 96;
        sArray[245] = 72;
        sArray[246] = 101;
        sArray[247] = 24;
        sArray[248] = 210;
        sArray[249] = 205;
        sArray[250] = 95;
        sArray[251] = 50;
        sArray[252] = 136;
        sArray[253] = 14;
        sArray[254] = 53;
        sArray[255] = 253;
        rc2Ekb = sArray;
    }

    private static AEADBlockCipher createAEADCipher(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (NISTObjectIdentifiers.id_aes128_GCM.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes192_GCM.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes256_GCM.equals(aSN1ObjectIdentifier)) {
            return new GCMBlockCipher(new AESEngine());
        }
        if (NISTObjectIdentifiers.id_aes128_CCM.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes192_CCM.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes256_CCM.equals(aSN1ObjectIdentifier)) {
            return new CCMBlockCipher(new AESEngine());
        }
        throw new IllegalArgumentException("cannot recognise cipher: " + aSN1ObjectIdentifier);
    }

    private static BufferedBlockCipher createCipher(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IllegalArgumentException {
        CBCBlockCipher cBCBlockCipher;
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes192_CBC.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_aes256_CBC.equals(aSN1ObjectIdentifier)) {
            cBCBlockCipher = new CBCBlockCipher(new AESEngine());
        } else if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(aSN1ObjectIdentifier)) {
            cBCBlockCipher = new CBCBlockCipher(new DESedeEngine());
        } else if (OIWObjectIdentifiers.desCBC.equals(aSN1ObjectIdentifier)) {
            cBCBlockCipher = new CBCBlockCipher(new DESEngine());
        } else if (PKCSObjectIdentifiers.RC2_CBC.equals(aSN1ObjectIdentifier)) {
            cBCBlockCipher = new CBCBlockCipher(new RC2Engine());
        } else if (MiscObjectIdentifiers.cast5CBC.equals(aSN1ObjectIdentifier)) {
            cBCBlockCipher = new CBCBlockCipher(new CAST5Engine());
        } else {
            throw new IllegalArgumentException("cannot recognise cipher: " + aSN1ObjectIdentifier);
        }
        return new PaddedBufferedBlockCipher(cBCBlockCipher, new PKCS7Padding());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createContentCipher(boolean bl, CipherParameters cipherParameters, AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.rc4)) {
            RC4Engine rC4Engine = new RC4Engine();
            rC4Engine.init(bl, cipherParameters);
            return rC4Engine;
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes128_GCM) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes192_GCM) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes256_GCM)) {
            AEADBlockCipher aEADBlockCipher = CipherFactory.createAEADCipher(algorithmIdentifier.getAlgorithm());
            GCMParameters gCMParameters = GCMParameters.getInstance(algorithmIdentifier.getParameters());
            if (!(cipherParameters instanceof KeyParameter)) {
                throw new IllegalArgumentException("key data must be accessible for GCM operation");
            }
            AEADParameters aEADParameters = new AEADParameters((KeyParameter)cipherParameters, gCMParameters.getIcvLen() * 8, gCMParameters.getNonce());
            aEADBlockCipher.init(bl, aEADParameters);
            return aEADBlockCipher;
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes128_CCM) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes192_CCM) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
            AEADBlockCipher aEADBlockCipher = CipherFactory.createAEADCipher(algorithmIdentifier.getAlgorithm());
            CCMParameters cCMParameters = CCMParameters.getInstance(algorithmIdentifier.getParameters());
            if (!(cipherParameters instanceof KeyParameter)) {
                throw new IllegalArgumentException("key data must be accessible for GCM operation");
            }
            AEADParameters aEADParameters = new AEADParameters((KeyParameter)cipherParameters, cCMParameters.getIcvLen() * 8, cCMParameters.getNonce());
            aEADBlockCipher.init(bl, aEADParameters);
            return aEADBlockCipher;
        }
        BufferedBlockCipher bufferedBlockCipher = CipherFactory.createCipher(algorithmIdentifier.getAlgorithm());
        ASN1Primitive aSN1Primitive = algorithmIdentifier.getParameters().toASN1Primitive();
        if (aSN1Primitive != null && !(aSN1Primitive instanceof ASN1Null)) {
            if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.des_EDE3_CBC) || aSN1ObjectIdentifier.equals(AlgorithmIdentifierFactory.IDEA_CBC) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes128_CBC) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes192_CBC) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_aes256_CBC) || aSN1ObjectIdentifier.equals(NTTObjectIdentifiers.id_camellia128_cbc) || aSN1ObjectIdentifier.equals(NTTObjectIdentifiers.id_camellia192_cbc) || aSN1ObjectIdentifier.equals(NTTObjectIdentifiers.id_camellia256_cbc) || aSN1ObjectIdentifier.equals(KISAObjectIdentifiers.id_seedCBC) || aSN1ObjectIdentifier.equals(OIWObjectIdentifiers.desCBC)) {
                bufferedBlockCipher.init(bl, new ParametersWithIV(cipherParameters, ASN1OctetString.getInstance(aSN1Primitive).getOctets()));
                return bufferedBlockCipher;
            } else if (aSN1ObjectIdentifier.equals(AlgorithmIdentifierFactory.CAST5_CBC)) {
                CAST5CBCParameters cAST5CBCParameters = CAST5CBCParameters.getInstance(aSN1Primitive);
                bufferedBlockCipher.init(bl, new ParametersWithIV(cipherParameters, cAST5CBCParameters.getIV()));
                return bufferedBlockCipher;
            } else {
                if (!aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.RC2_CBC)) throw new IllegalArgumentException("cannot match parameters");
                RC2CBCParameter rC2CBCParameter = RC2CBCParameter.getInstance(aSN1Primitive);
                bufferedBlockCipher.init(bl, new ParametersWithIV(new RC2Parameters(((KeyParameter)cipherParameters).getKey(), rc2Ekb[rC2CBCParameter.getRC2ParameterVersion().intValue()]), rC2CBCParameter.getIV()));
            }
            return bufferedBlockCipher;
        } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.des_EDE3_CBC) || aSN1ObjectIdentifier.equals(AlgorithmIdentifierFactory.IDEA_CBC) || aSN1ObjectIdentifier.equals(AlgorithmIdentifierFactory.CAST5_CBC)) {
            bufferedBlockCipher.init(bl, new ParametersWithIV(cipherParameters, new byte[8]));
            return bufferedBlockCipher;
        } else {
            bufferedBlockCipher.init(bl, cipherParameters);
        }
        return bufferedBlockCipher;
    }

    public static CipherOutputStream createOutputStream(OutputStream outputStream, Object object) {
        if (object instanceof BufferedBlockCipher) {
            return new CipherOutputStream(outputStream, (BufferedBlockCipher)object);
        }
        if (object instanceof StreamCipher) {
            return new CipherOutputStream(outputStream, (StreamCipher)object);
        }
        if (object instanceof AEADBlockCipher) {
            return new CipherOutputStream(outputStream, (AEADBlockCipher)object);
        }
        throw new IllegalArgumentException("unknown cipher object: " + object);
    }
}

