/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.frodo;

import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n, int n2) {
        this.n = n;
        this.q = n2;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16 * this.n / 8];
            short s = 0;
            while (s < this.n) {
                byte[] byArray3 = Arrays.concatenate(Pack.shortToLittleEndian(s), byArray);
                SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
                sHAKEDigest.update(byArray3, 0, byArray3.length);
                sHAKEDigest.doFinal(byArray2, 0, byArray2.length);
                int n = 0;
                while (n < this.n) {
                    sArray[s * this.n + n] = (short)(Pack.littleEndianToShort(byArray2, 2 * n) % this.q);
                    n = (short)(n + 1);
                }
                s = (short)(s + 1);
            }
            return sArray;
        }
    }

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        BufferedBlockCipher cipher = new BufferedBlockCipher(new AESEngine());

        public Aes128MatrixGenerator(int n, int n2) {
            super(n, n2);
        }

        void aes128(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            try {
                KeyParameter keyParameter = new KeyParameter(byArray2);
                this.cipher.init(true, keyParameter);
                int n = this.cipher.processBytes(byArray3, 0, byArray3.length, byArray, 0);
                this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw Exceptions.illegalStateException(invalidCipherTextException.toString(), invalidCipherTextException);
            }
        }

        short[] genMatrix(byte[] byArray) {
            short[] sArray = new short[this.n * this.n];
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[16];
            int n = 0;
            while (n < this.n) {
                int n2 = 0;
                while (n2 < this.n) {
                    System.arraycopy(Pack.shortToLittleEndian((short)(n & 0xFFFF)), 0, byArray2, 0, 2);
                    System.arraycopy(Pack.shortToLittleEndian((short)(n2 & 0xFFFF)), 0, byArray2, 2, 2);
                    this.aes128(byArray3, byArray, byArray2);
                    int n3 = 0;
                    while (n3 < 8) {
                        sArray[n * this.n + n2 + n3] = (short)(Pack.littleEndianToShort(byArray3, 2 * n3) % this.q);
                        ++n3;
                    }
                    n2 += 8;
                }
                ++n;
            }
            return sArray;
        }
    }
}

