/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle.util.encoders.Hex;

public class GMSSRootSig {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[] privateKeyOTS;
    private byte[] hash;
    private byte[] sign;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int k;
    private int r;
    private int test;
    private int counter;
    private int ii;
    private long test8;
    private long big8;
    private int steps;
    private int checksum;
    private int height;
    private byte[] seed;

    public GMSSRootSig(Digest digest, int n, int n2) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.w = n;
        this.height = n2;
        this.k = (1 << n) - 1;
        int n3 = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)n3 / (double)n);
    }

    public GMSSRootSig(Digest digest, byte[][] byArray, int[] nArray) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.counter = nArray[0];
        this.test = nArray[1];
        this.ii = nArray[2];
        this.r = nArray[3];
        this.steps = nArray[4];
        this.keysize = nArray[5];
        this.height = nArray[6];
        this.w = nArray[7];
        this.checksum = nArray[8];
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.k = (1 << this.w) - 1;
        int n = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)n / (double)this.w);
        this.privateKeyOTS = byArray[0];
        this.seed = byArray[1];
        this.hash = byArray[2];
        this.sign = byArray[3];
        this.test8 = (long)(byArray[4][0] & 0xFF) | (long)(byArray[4][1] & 0xFF) << 8 | (long)(byArray[4][2] & 0xFF) << 16 | (long)(byArray[4][3] & 0xFF) << 24 | (long)(byArray[4][4] & 0xFF) << 32 | (long)(byArray[4][5] & 0xFF) << 40 | (long)(byArray[4][6] & 0xFF) << 48 | (long)(byArray[4][7] & 0xFF) << 56;
        this.big8 = (long)(byArray[4][8] & 0xFF) | (long)(byArray[4][9] & 0xFF) << 8 | (long)(byArray[4][10] & 0xFF) << 16 | (long)(byArray[4][11] & 0xFF) << 24 | (long)(byArray[4][12] & 0xFF) << 32 | (long)(byArray[4][13] & 0xFF) << 40 | (long)(byArray[4][14] & 0xFF) << 48 | (long)(byArray[4][15] & 0xFF) << 56;
    }

    public int getLog(int n) {
        int n2 = 1;
        int n3 = 2;
        while (n3 < n) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public byte[] getSig() {
        return this.sign;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[5][this.mdsize];
        byArray[0] = this.privateKeyOTS;
        byArray[1] = this.seed;
        byArray[2] = this.hash;
        byArray[3] = this.sign;
        byArray[4] = this.getStatLong();
        return byArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[]{this.counter, this.test, this.ii, this.r, this.steps, this.keysize, this.height, this.w, this.checksum};
        return nArray;
    }

    public byte[] getStatLong() {
        byte[] byArray = new byte[]{(byte)(this.test8 & 0xFFL), (byte)(this.test8 >> 8 & 0xFFL), (byte)(this.test8 >> 16 & 0xFFL), (byte)(this.test8 >> 24 & 0xFFL), (byte)(this.test8 >> 32 & 0xFFL), (byte)(this.test8 >> 40 & 0xFFL), (byte)(this.test8 >> 48 & 0xFFL), (byte)(this.test8 >> 56 & 0xFFL), (byte)(this.big8 & 0xFFL), (byte)(this.big8 >> 8 & 0xFFL), (byte)(this.big8 >> 16 & 0xFFL), (byte)(this.big8 >> 24 & 0xFFL), (byte)(this.big8 >> 32 & 0xFFL), (byte)(this.big8 >> 40 & 0xFFL), (byte)(this.big8 >> 48 & 0xFFL), (byte)(this.big8 >> 56 & 0xFFL)};
        return byArray;
    }

    public void initSign(byte[] byArray, byte[] byArray2) {
        this.hash = new byte[this.mdsize];
        this.messDigestOTS.update(byArray2, 0, byArray2.length);
        this.hash = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(this.hash, 0);
        byte[] byArray3 = new byte[this.mdsize];
        System.arraycopy(this.hash, 0, byArray3, 0, this.mdsize);
        int n = 0;
        int n2 = 0;
        int n3 = this.getLog((this.messagesize << this.w) + 1);
        if (8 % this.w == 0) {
            int n4;
            int n5 = 8 / this.w;
            int n6 = 0;
            while (n6 < this.mdsize) {
                n4 = 0;
                while (n4 < n5) {
                    n2 += byArray3[n6] & this.k;
                    byArray3[n6] = (byte)(byArray3[n6] >>> this.w);
                    ++n4;
                }
                ++n6;
            }
            n = this.checksum = (this.messagesize << this.w) - n2;
            n4 = 0;
            while (n4 < n3) {
                n2 += n & this.k;
                n >>>= this.w;
                n4 += this.w;
            }
        } else if (this.w < 8) {
            int n7;
            int n8;
            long l;
            int n9 = 0;
            int n10 = this.mdsize / this.w;
            int n11 = 0;
            while (n11 < n10) {
                l = 0L;
                n8 = 0;
                while (n8 < this.w) {
                    l ^= (long)((byArray3[n9] & 0xFF) << (n8 << 3));
                    ++n9;
                    ++n8;
                }
                n7 = 0;
                while (n7 < 8) {
                    n2 += (int)(l & (long)this.k);
                    l >>>= this.w;
                    ++n7;
                }
                ++n11;
            }
            n10 = this.mdsize % this.w;
            l = 0L;
            n8 = 0;
            while (n8 < n10) {
                l ^= (long)((byArray3[n9] & 0xFF) << (n8 << 3));
                ++n9;
                ++n8;
            }
            n10 <<= 3;
            n7 = 0;
            while (n7 < n10) {
                n2 += (int)(l & (long)this.k);
                l >>>= this.w;
                n7 += this.w;
            }
            n = this.checksum = (this.messagesize << this.w) - n2;
            int n12 = 0;
            while (n12 < n3) {
                n2 += n & this.k;
                n >>>= this.w;
                n12 += this.w;
            }
        } else if (this.w < 57) {
            int n13;
            int n14;
            long l;
            int n15;
            int n16;
            int n17 = 0;
            while (n17 <= (this.mdsize << 3) - this.w) {
                n16 = n17 >>> 3;
                n15 = n17 % 8;
                int n18 = (n17 += this.w) + 7 >>> 3;
                l = 0L;
                n14 = 0;
                n13 = n16;
                while (n13 < n18) {
                    l ^= (long)((byArray3[n13] & 0xFF) << (n14 << 3));
                    ++n14;
                    ++n13;
                }
                n2 = (int)((long)n2 + ((l >>>= n15) & (long)this.k));
            }
            n16 = n17 >>> 3;
            if (n16 < this.mdsize) {
                n15 = n17 % 8;
                l = 0L;
                n14 = 0;
                n13 = n16;
                while (n13 < this.mdsize) {
                    l ^= (long)((byArray3[n13] & 0xFF) << (n14 << 3));
                    ++n14;
                    ++n13;
                }
                n2 = (int)((long)n2 + ((l >>>= n15) & (long)this.k));
            }
            n = this.checksum = (this.messagesize << this.w) - n2;
            n13 = 0;
            while (n13 < n3) {
                n2 += n & this.k;
                n >>>= this.w;
                n13 += this.w;
            }
        }
        this.keysize = this.messagesize + (int)Math.ceil((double)n3 / (double)this.w);
        this.steps = (int)Math.ceil((double)(this.keysize + n2) / (double)(1 << this.height));
        this.sign = new byte[this.keysize * this.mdsize];
        this.counter = 0;
        this.test = 0;
        this.ii = 0;
        this.test8 = 0L;
        this.r = 0;
        this.privateKeyOTS = new byte[this.mdsize];
        this.seed = new byte[this.mdsize];
        System.arraycopy(byArray, 0, this.seed, 0, this.mdsize);
    }

    private void oneStep() {
        if (8 % this.w == 0) {
            if (this.test == 0) {
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
                if (this.ii < this.mdsize) {
                    this.test = this.hash[this.ii] & this.k;
                    this.hash[this.ii] = (byte)(this.hash[this.ii] >>> this.w);
                } else {
                    this.test = this.checksum & this.k;
                    this.checksum >>>= this.w;
                }
            } else if (this.test > 0) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test;
            }
            if (this.test == 0) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                ++this.counter;
                if (this.counter % (8 / this.w) == 0) {
                    ++this.ii;
                }
            }
        } else if (this.w < 8) {
            if (this.test == 0) {
                if (this.counter % 8 == 0 && this.ii < this.mdsize) {
                    this.big8 = 0L;
                    if (this.counter < this.mdsize / this.w << 3) {
                        int n = 0;
                        while (n < this.w) {
                            this.big8 ^= (long)((this.hash[this.ii] & 0xFF) << (n << 3));
                            ++this.ii;
                            ++n;
                        }
                    } else {
                        int n = 0;
                        while (n < this.mdsize % this.w) {
                            this.big8 ^= (long)((this.hash[this.ii] & 0xFF) << (n << 3));
                            ++this.ii;
                            ++n;
                        }
                    }
                }
                if (this.counter == this.messagesize) {
                    this.big8 = this.checksum;
                }
                this.test = (int)(this.big8 & (long)this.k);
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (this.test > 0) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test;
            }
            if (this.test == 0) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                this.big8 >>>= this.w;
                ++this.counter;
            }
        } else if (this.w < 57) {
            if (this.test8 == 0L) {
                this.big8 = 0L;
                this.ii = 0;
                int n = this.r % 8;
                int n2 = this.r >>> 3;
                if (n2 < this.mdsize) {
                    int n3;
                    if (this.r <= (this.mdsize << 3) - this.w) {
                        this.r += this.w;
                        n3 = this.r + 7 >>> 3;
                    } else {
                        n3 = this.mdsize;
                        this.r += this.w;
                    }
                    int n4 = n2;
                    while (n4 < n3) {
                        this.big8 ^= (long)((this.hash[n4] & 0xFF) << (this.ii << 3));
                        ++this.ii;
                        ++n4;
                    }
                    this.big8 >>>= n;
                    this.test8 = this.big8 & (long)this.k;
                } else {
                    this.test8 = this.checksum & this.k;
                    this.checksum >>>= this.w;
                }
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (this.test8 > 0L) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test8;
            }
            if (this.test8 == 0L) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                ++this.counter;
            }
        }
    }

    public String toString() {
        String string = this.big8 + "  ";
        int[] nArray = new int[9];
        nArray = this.getStatInt();
        byte[][] byArray = new byte[5][this.mdsize];
        byArray = this.getStatByte();
        int n = 0;
        while (n < 9) {
            string = String.valueOf(string) + nArray[n] + " ";
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            string = String.valueOf(string) + new String(Hex.encode(byArray[n2])) + " ";
            ++n2;
        }
        return string;
    }

    public boolean updateSign() {
        int n = 0;
        while (n < this.steps) {
            if (this.counter < this.keysize) {
                this.oneStep();
            }
            if (this.counter == this.keysize) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

