/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.newhope;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.ExchangePair;
import org.bouncycastle.pqc.crypto.newhope.NHAgreement;
import org.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import org.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class NHSecretKeyProcessor {
    private final Xof xof = new SHAKEDigest(256);

    /* synthetic */ NHSecretKeyProcessor(1 var1_1, byte[] byArray, byte[] byArray2) {
        this(byArray, byArray2);
    }

    private NHSecretKeyProcessor(byte[] byArray, byte[] byArray2) {
        this.xof.update(byArray, 0, byArray.length);
        if (byArray2 != null) {
            this.xof.update(byArray2, 0, byArray2.length);
        }
        Arrays.fill(byArray, (byte)0);
    }

    public byte[] processKey(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        this.xof.doFinal(byArray2, 0, byArray2.length);
        NHSecretKeyProcessor.xor(byArray, byArray2);
        Arrays.fill(byArray2, (byte)0);
        return byArray;
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n != byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
            ++n;
        }
    }

    public static class PartyUBuilder {
        private final AsymmetricCipherKeyPair aKp;
        private final NHAgreement agreement = new NHAgreement();
        private byte[] sharedInfo = null;
        private boolean used = false;

        public PartyUBuilder(SecureRandom secureRandom) {
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(new KeyGenerationParameters(secureRandom, 2048));
            this.aKp = nHKeyPairGenerator.generateKeyPair();
            this.agreement.init(this.aKp.getPrivate());
        }

        public NHSecretKeyProcessor build(byte[] byArray) {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            class Org_bouncycastle_pqc_crypto_newhope_NHSecretKeyProcessor$1 {
                /* synthetic */ Org_bouncycastle_pqc_crypto_newhope_NHSecretKeyProcessor$1() {
                }
            }
            return new NHSecretKeyProcessor(null, this.agreement.calculateAgreement(new NHPublicKeyParameters(byArray)), this.sharedInfo);
        }

        public byte[] getPartA() {
            return ((NHPublicKeyParameters)this.aKp.getPublic()).getPubData();
        }

        public PartyUBuilder withSharedInfo(byte[] byArray) {
            this.sharedInfo = Arrays.clone(byArray);
            return this;
        }
    }

    public static class PartyVBuilder {
        protected final SecureRandom random;
        private byte[] sharedInfo = null;
        private byte[] sharedSecret = null;
        private boolean used = false;

        public PartyVBuilder(SecureRandom secureRandom) {
            this.random = secureRandom;
        }

        public NHSecretKeyProcessor build() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return new NHSecretKeyProcessor(null, this.sharedSecret, this.sharedInfo);
        }

        public byte[] getPartB(byte[] byArray) {
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(this.random);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(new NHPublicKeyParameters(byArray));
            this.sharedSecret = exchangePair.getSharedValue();
            return ((NHPublicKeyParameters)exchangePair.getPublicKey()).getPubData();
        }

        public PartyVBuilder withSharedInfo(byte[] byArray) {
            this.sharedInfo = Arrays.clone(byArray);
            return this;
        }
    }
}

