/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import org.bouncycastle.util.Arrays;

public class GF2Polynomial {
    private int len;
    private int blocks;
    private int[] value;
    private static Random rand = new Random();
    private static final boolean[] parity;
    private static final short[] squaringTable;
    private static final int[] bitMask;
    private static final int[] reverseRightMask;

    static {
        boolean[] blArray = new boolean[256];
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[11] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[16] = true;
        blArray[19] = true;
        blArray[21] = true;
        blArray[22] = true;
        blArray[25] = true;
        blArray[26] = true;
        blArray[28] = true;
        blArray[31] = true;
        blArray[32] = true;
        blArray[35] = true;
        blArray[37] = true;
        blArray[38] = true;
        blArray[41] = true;
        blArray[42] = true;
        blArray[44] = true;
        blArray[47] = true;
        blArray[49] = true;
        blArray[50] = true;
        blArray[52] = true;
        blArray[55] = true;
        blArray[56] = true;
        blArray[59] = true;
        blArray[61] = true;
        blArray[62] = true;
        blArray[64] = true;
        blArray[67] = true;
        blArray[69] = true;
        blArray[70] = true;
        blArray[73] = true;
        blArray[74] = true;
        blArray[76] = true;
        blArray[79] = true;
        blArray[81] = true;
        blArray[82] = true;
        blArray[84] = true;
        blArray[87] = true;
        blArray[88] = true;
        blArray[91] = true;
        blArray[93] = true;
        blArray[94] = true;
        blArray[97] = true;
        blArray[98] = true;
        blArray[100] = true;
        blArray[103] = true;
        blArray[104] = true;
        blArray[107] = true;
        blArray[109] = true;
        blArray[110] = true;
        blArray[112] = true;
        blArray[115] = true;
        blArray[117] = true;
        blArray[118] = true;
        blArray[121] = true;
        blArray[122] = true;
        blArray[124] = true;
        blArray[127] = true;
        blArray[128] = true;
        blArray[131] = true;
        blArray[133] = true;
        blArray[134] = true;
        blArray[137] = true;
        blArray[138] = true;
        blArray[140] = true;
        blArray[143] = true;
        blArray[145] = true;
        blArray[146] = true;
        blArray[148] = true;
        blArray[151] = true;
        blArray[152] = true;
        blArray[155] = true;
        blArray[157] = true;
        blArray[158] = true;
        blArray[161] = true;
        blArray[162] = true;
        blArray[164] = true;
        blArray[167] = true;
        blArray[168] = true;
        blArray[171] = true;
        blArray[173] = true;
        blArray[174] = true;
        blArray[176] = true;
        blArray[179] = true;
        blArray[181] = true;
        blArray[182] = true;
        blArray[185] = true;
        blArray[186] = true;
        blArray[188] = true;
        blArray[191] = true;
        blArray[193] = true;
        blArray[194] = true;
        blArray[196] = true;
        blArray[199] = true;
        blArray[200] = true;
        blArray[203] = true;
        blArray[205] = true;
        blArray[206] = true;
        blArray[208] = true;
        blArray[211] = true;
        blArray[213] = true;
        blArray[214] = true;
        blArray[217] = true;
        blArray[218] = true;
        blArray[220] = true;
        blArray[223] = true;
        blArray[224] = true;
        blArray[227] = true;
        blArray[229] = true;
        blArray[230] = true;
        blArray[233] = true;
        blArray[234] = true;
        blArray[236] = true;
        blArray[239] = true;
        blArray[241] = true;
        blArray[242] = true;
        blArray[244] = true;
        blArray[247] = true;
        blArray[248] = true;
        blArray[251] = true;
        blArray[253] = true;
        blArray[254] = true;
        parity = blArray;
        short[] sArray = new short[256];
        sArray[1] = 1;
        sArray[2] = 4;
        sArray[3] = 5;
        sArray[4] = 16;
        sArray[5] = 17;
        sArray[6] = 20;
        sArray[7] = 21;
        sArray[8] = 64;
        sArray[9] = 65;
        sArray[10] = 68;
        sArray[11] = 69;
        sArray[12] = 80;
        sArray[13] = 81;
        sArray[14] = 84;
        sArray[15] = 85;
        sArray[16] = 256;
        sArray[17] = 257;
        sArray[18] = 260;
        sArray[19] = 261;
        sArray[20] = 272;
        sArray[21] = 273;
        sArray[22] = 276;
        sArray[23] = 277;
        sArray[24] = 320;
        sArray[25] = 321;
        sArray[26] = 324;
        sArray[27] = 325;
        sArray[28] = 336;
        sArray[29] = 337;
        sArray[30] = 340;
        sArray[31] = 341;
        sArray[32] = 1024;
        sArray[33] = 1025;
        sArray[34] = 1028;
        sArray[35] = 1029;
        sArray[36] = 1040;
        sArray[37] = 1041;
        sArray[38] = 1044;
        sArray[39] = 1045;
        sArray[40] = 1088;
        sArray[41] = 1089;
        sArray[42] = 1092;
        sArray[43] = 1093;
        sArray[44] = 1104;
        sArray[45] = 1105;
        sArray[46] = 1108;
        sArray[47] = 1109;
        sArray[48] = 1280;
        sArray[49] = 1281;
        sArray[50] = 1284;
        sArray[51] = 1285;
        sArray[52] = 1296;
        sArray[53] = 1297;
        sArray[54] = 1300;
        sArray[55] = 1301;
        sArray[56] = 1344;
        sArray[57] = 1345;
        sArray[58] = 1348;
        sArray[59] = 1349;
        sArray[60] = 1360;
        sArray[61] = 1361;
        sArray[62] = 1364;
        sArray[63] = 1365;
        sArray[64] = 4096;
        sArray[65] = 4097;
        sArray[66] = 4100;
        sArray[67] = 4101;
        sArray[68] = 4112;
        sArray[69] = 4113;
        sArray[70] = 4116;
        sArray[71] = 4117;
        sArray[72] = 4160;
        sArray[73] = 4161;
        sArray[74] = 4164;
        sArray[75] = 4165;
        sArray[76] = 4176;
        sArray[77] = 4177;
        sArray[78] = 4180;
        sArray[79] = 4181;
        sArray[80] = 4352;
        sArray[81] = 4353;
        sArray[82] = 4356;
        sArray[83] = 4357;
        sArray[84] = 4368;
        sArray[85] = 4369;
        sArray[86] = 4372;
        sArray[87] = 4373;
        sArray[88] = 4416;
        sArray[89] = 4417;
        sArray[90] = 4420;
        sArray[91] = 4421;
        sArray[92] = 4432;
        sArray[93] = 4433;
        sArray[94] = 4436;
        sArray[95] = 4437;
        sArray[96] = 5120;
        sArray[97] = 5121;
        sArray[98] = 5124;
        sArray[99] = 5125;
        sArray[100] = 5136;
        sArray[101] = 5137;
        sArray[102] = 5140;
        sArray[103] = 5141;
        sArray[104] = 5184;
        sArray[105] = 5185;
        sArray[106] = 5188;
        sArray[107] = 5189;
        sArray[108] = 5200;
        sArray[109] = 5201;
        sArray[110] = 5204;
        sArray[111] = 5205;
        sArray[112] = 5376;
        sArray[113] = 5377;
        sArray[114] = 5380;
        sArray[115] = 5381;
        sArray[116] = 5392;
        sArray[117] = 5393;
        sArray[118] = 5396;
        sArray[119] = 5397;
        sArray[120] = 5440;
        sArray[121] = 5441;
        sArray[122] = 5444;
        sArray[123] = 5445;
        sArray[124] = 5456;
        sArray[125] = 5457;
        sArray[126] = 5460;
        sArray[127] = 5461;
        sArray[128] = 16384;
        sArray[129] = 16385;
        sArray[130] = 16388;
        sArray[131] = 16389;
        sArray[132] = 16400;
        sArray[133] = 16401;
        sArray[134] = 16404;
        sArray[135] = 16405;
        sArray[136] = 16448;
        sArray[137] = 16449;
        sArray[138] = 16452;
        sArray[139] = 16453;
        sArray[140] = 16464;
        sArray[141] = 16465;
        sArray[142] = 16468;
        sArray[143] = 16469;
        sArray[144] = 16640;
        sArray[145] = 16641;
        sArray[146] = 16644;
        sArray[147] = 16645;
        sArray[148] = 16656;
        sArray[149] = 16657;
        sArray[150] = 16660;
        sArray[151] = 16661;
        sArray[152] = 16704;
        sArray[153] = 16705;
        sArray[154] = 16708;
        sArray[155] = 16709;
        sArray[156] = 16720;
        sArray[157] = 16721;
        sArray[158] = 16724;
        sArray[159] = 16725;
        sArray[160] = 17408;
        sArray[161] = 17409;
        sArray[162] = 17412;
        sArray[163] = 17413;
        sArray[164] = 17424;
        sArray[165] = 17425;
        sArray[166] = 17428;
        sArray[167] = 17429;
        sArray[168] = 17472;
        sArray[169] = 17473;
        sArray[170] = 17476;
        sArray[171] = 17477;
        sArray[172] = 17488;
        sArray[173] = 17489;
        sArray[174] = 17492;
        sArray[175] = 17493;
        sArray[176] = 17664;
        sArray[177] = 17665;
        sArray[178] = 17668;
        sArray[179] = 17669;
        sArray[180] = 17680;
        sArray[181] = 17681;
        sArray[182] = 17684;
        sArray[183] = 17685;
        sArray[184] = 17728;
        sArray[185] = 17729;
        sArray[186] = 17732;
        sArray[187] = 17733;
        sArray[188] = 17744;
        sArray[189] = 17745;
        sArray[190] = 17748;
        sArray[191] = 17749;
        sArray[192] = 20480;
        sArray[193] = 20481;
        sArray[194] = 20484;
        sArray[195] = 20485;
        sArray[196] = 20496;
        sArray[197] = 20497;
        sArray[198] = 20500;
        sArray[199] = 20501;
        sArray[200] = 20544;
        sArray[201] = 20545;
        sArray[202] = 20548;
        sArray[203] = 20549;
        sArray[204] = 20560;
        sArray[205] = 20561;
        sArray[206] = 20564;
        sArray[207] = 20565;
        sArray[208] = 20736;
        sArray[209] = 20737;
        sArray[210] = 20740;
        sArray[211] = 20741;
        sArray[212] = 20752;
        sArray[213] = 20753;
        sArray[214] = 20756;
        sArray[215] = 20757;
        sArray[216] = 20800;
        sArray[217] = 20801;
        sArray[218] = 20804;
        sArray[219] = 20805;
        sArray[220] = 20816;
        sArray[221] = 20817;
        sArray[222] = 20820;
        sArray[223] = 20821;
        sArray[224] = 21504;
        sArray[225] = 21505;
        sArray[226] = 21508;
        sArray[227] = 21509;
        sArray[228] = 21520;
        sArray[229] = 21521;
        sArray[230] = 21524;
        sArray[231] = 21525;
        sArray[232] = 21568;
        sArray[233] = 21569;
        sArray[234] = 21572;
        sArray[235] = 21573;
        sArray[236] = 21584;
        sArray[237] = 21585;
        sArray[238] = 21588;
        sArray[239] = 21589;
        sArray[240] = 21760;
        sArray[241] = 21761;
        sArray[242] = 21764;
        sArray[243] = 21765;
        sArray[244] = 21776;
        sArray[245] = 21777;
        sArray[246] = 21780;
        sArray[247] = 21781;
        sArray[248] = 21824;
        sArray[249] = 21825;
        sArray[250] = 21828;
        sArray[251] = 21829;
        sArray[252] = 21840;
        sArray[253] = 21841;
        sArray[254] = 21844;
        sArray[255] = 21845;
        squaringTable = sArray;
        int[] nArray = new int[33];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 16;
        nArray[5] = 32;
        nArray[6] = 64;
        nArray[7] = 128;
        nArray[8] = 256;
        nArray[9] = 512;
        nArray[10] = 1024;
        nArray[11] = 2048;
        nArray[12] = 4096;
        nArray[13] = 8192;
        nArray[14] = 16384;
        nArray[15] = 32768;
        nArray[16] = 65536;
        nArray[17] = 131072;
        nArray[18] = 262144;
        nArray[19] = 524288;
        nArray[20] = 0x100000;
        nArray[21] = 0x200000;
        nArray[22] = 0x400000;
        nArray[23] = 0x800000;
        nArray[24] = 0x1000000;
        nArray[25] = 0x2000000;
        nArray[26] = 0x4000000;
        nArray[27] = 0x8000000;
        nArray[28] = 0x10000000;
        nArray[29] = 0x20000000;
        nArray[30] = 0x40000000;
        nArray[31] = Integer.MIN_VALUE;
        bitMask = nArray;
        int[] nArray2 = new int[33];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 7;
        nArray2[4] = 15;
        nArray2[5] = 31;
        nArray2[6] = 63;
        nArray2[7] = 127;
        nArray2[8] = 255;
        nArray2[9] = 511;
        nArray2[10] = 1023;
        nArray2[11] = 2047;
        nArray2[12] = 4095;
        nArray2[13] = 8191;
        nArray2[14] = 16383;
        nArray2[15] = Short.MAX_VALUE;
        nArray2[16] = 65535;
        nArray2[17] = 131071;
        nArray2[18] = 262143;
        nArray2[19] = 524287;
        nArray2[20] = 1048575;
        nArray2[21] = 0x1FFFFF;
        nArray2[22] = 0x3FFFFF;
        nArray2[23] = 0x7FFFFF;
        nArray2[24] = 0xFFFFFF;
        nArray2[25] = 0x1FFFFFF;
        nArray2[26] = 0x3FFFFFF;
        nArray2[27] = 0x7FFFFFF;
        nArray2[28] = 0xFFFFFFF;
        nArray2[29] = 0x1FFFFFFF;
        nArray2[30] = 0x3FFFFFFF;
        nArray2[31] = Integer.MAX_VALUE;
        nArray2[32] = -1;
        reverseRightMask = nArray2;
    }

    public GF2Polynomial(int n) {
        int n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.blocks = (n2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = n2;
    }

    public GF2Polynomial(int n, String string) {
        int n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.blocks = (n2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = n2;
        if (string.equalsIgnoreCase("ZERO")) {
            this.assignZero();
        } else if (string.equalsIgnoreCase("ONE")) {
            this.assignOne();
        } else if (string.equalsIgnoreCase("RANDOM")) {
            this.randomize();
        } else if (string.equalsIgnoreCase("X")) {
            this.assignX();
        } else if (string.equalsIgnoreCase("ALL")) {
            this.assignAll();
        } else {
            throw new IllegalArgumentException("Error: GF2Polynomial was called using " + string + " as value!");
        }
    }

    public GF2Polynomial(int n, BigInteger bigInteger) {
        int n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.blocks = (n2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = n2;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        int n3 = byArray.length & 3;
        int n4 = (byArray.length - 1 >> 2) + 1;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n4 - 1;
            this.value[n6] = this.value[n6] | (byArray[n5] & 0xFF) << (n3 - 1 - n5 << 3);
            ++n5;
        }
        int n7 = 0;
        n5 = 0;
        while (n5 <= byArray.length - 4 >> 2) {
            n7 = byArray.length - 1 - (n5 << 2);
            this.value[n5] = byArray[n7] & 0xFF;
            int n8 = n5;
            this.value[n8] = this.value[n8] | byArray[n7 - 1] << 8 & 0xFF00;
            int n9 = n5;
            this.value[n9] = this.value[n9] | byArray[n7 - 2] << 16 & 0xFF0000;
            int n10 = n5++;
            this.value[n10] = this.value[n10] | byArray[n7 - 3] << 24 & 0xFF000000;
        }
        if ((this.len & 0x1F) != 0) {
            int n11 = this.blocks - 1;
            this.value[n11] = this.value[n11] & reverseRightMask[this.len & 0x1F];
        }
        this.reduceN();
    }

    public GF2Polynomial(int n, Random random) {
        int n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.blocks = (n2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = n2;
        this.randomize(random);
    }

    public GF2Polynomial(int n, byte[] byArray) {
        int n2;
        int n3 = n;
        if (n3 < 1) {
            n3 = 1;
        }
        this.blocks = (n3 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = n3;
        int n4 = Math.min((byArray.length - 1 >> 2) + 1, this.blocks);
        int n5 = 0;
        while (n5 < n4 - 1) {
            n2 = byArray.length - (n5 << 2) - 1;
            this.value[n5] = byArray[n2] & 0xFF;
            int n6 = n5;
            this.value[n6] = this.value[n6] | byArray[n2 - 1] << 8 & 0xFF00;
            int n7 = n5;
            this.value[n7] = this.value[n7] | byArray[n2 - 2] << 16 & 0xFF0000;
            int n8 = n5++;
            this.value[n8] = this.value[n8] | byArray[n2 - 3] << 24 & 0xFF000000;
        }
        n5 = n4 - 1;
        n2 = byArray.length - (n5 << 2) - 1;
        this.value[n5] = byArray[n2] & 0xFF;
        if (n2 > 0) {
            int n9 = n5;
            this.value[n9] = this.value[n9] | byArray[n2 - 1] << 8 & 0xFF00;
        }
        if (n2 > 1) {
            int n10 = n5;
            this.value[n10] = this.value[n10] | byArray[n2 - 2] << 16 & 0xFF0000;
        }
        if (n2 > 2) {
            int n11 = n5;
            this.value[n11] = this.value[n11] | byArray[n2 - 3] << 24 & 0xFF000000;
        }
        this.zeroUnusedBits();
        this.reduceN();
    }

    public GF2Polynomial(int n, int[] nArray) {
        int n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.blocks = (n2 - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = n2;
        int n3 = Math.min(this.blocks, nArray.length);
        System.arraycopy(nArray, 0, this.value, 0, n3);
        this.zeroUnusedBits();
    }

    public GF2Polynomial(GF2Polynomial gF2Polynomial) {
        this.len = gF2Polynomial.len;
        this.blocks = gF2Polynomial.blocks;
        this.value = IntUtils.clone(gF2Polynomial.value);
    }

    public GF2Polynomial add(GF2Polynomial gF2Polynomial) {
        return this.xor(gF2Polynomial);
    }

    public void addToThis(GF2Polynomial gF2Polynomial) {
        this.expandN(gF2Polynomial.len);
        this.xorThisBy(gF2Polynomial);
    }

    public void assignAll() {
        int n = 0;
        while (n < this.blocks) {
            this.value[n] = -1;
            ++n;
        }
        this.zeroUnusedBits();
    }

    public void assignOne() {
        int n = 1;
        while (n < this.blocks) {
            this.value[n] = 0;
            ++n;
        }
        this.value[0] = 1;
    }

    public void assignX() {
        int n = 1;
        while (n < this.blocks) {
            this.value[n] = 0;
            ++n;
        }
        this.value[0] = 2;
    }

    public void assignZero() {
        int n = 0;
        while (n < this.blocks) {
            this.value[n] = 0;
            ++n;
        }
    }

    public Object clone() {
        return new GF2Polynomial(this);
    }

    public GF2Polynomial[] divide(GF2Polynomial gF2Polynomial) throws RuntimeException {
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[2];
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.len);
        GF2Polynomial gF2Polynomial3 = new GF2Polynomial(this);
        GF2Polynomial gF2Polynomial4 = new GF2Polynomial(gF2Polynomial);
        if (gF2Polynomial4.isZero()) {
            throw new RuntimeException();
        }
        gF2Polynomial3.reduceN();
        gF2Polynomial4.reduceN();
        if (gF2Polynomial3.len < gF2Polynomial4.len) {
            gF2PolynomialArray[0] = new GF2Polynomial(0);
            gF2PolynomialArray[1] = gF2Polynomial3;
            return gF2PolynomialArray;
        }
        int n = gF2Polynomial3.len - gF2Polynomial4.len;
        gF2Polynomial2.expandN(n + 1);
        while (n >= 0) {
            GF2Polynomial gF2Polynomial5 = gF2Polynomial4.shiftLeft(n);
            gF2Polynomial3.subtractFromThis(gF2Polynomial5);
            gF2Polynomial3.reduceN();
            gF2Polynomial2.xorBit(n);
            n = gF2Polynomial3.len - gF2Polynomial4.len;
        }
        gF2PolynomialArray[0] = gF2Polynomial2;
        gF2PolynomialArray[1] = gF2Polynomial3;
        return gF2PolynomialArray;
    }

    private void doShiftBlocksLeft(int n) {
        if (this.blocks <= this.value.length) {
            int n2 = this.blocks - 1;
            while (n2 >= n) {
                this.value[n2] = this.value[n2 - n];
                --n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.value[n2] = 0;
                ++n2;
            }
        } else {
            int[] nArray = new int[this.blocks];
            System.arraycopy(this.value, 0, nArray, n, this.blocks - n);
            this.value = null;
            this.value = nArray;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2Polynomial)) {
            return false;
        }
        GF2Polynomial gF2Polynomial = (GF2Polynomial)object;
        if (this.len != gF2Polynomial.len) {
            return false;
        }
        int n = 0;
        while (n < this.blocks) {
            if (this.value[n] != gF2Polynomial.value[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void expandN(int n) {
        if (this.len >= n) {
            return;
        }
        this.len = n;
        int n2 = (n - 1 >>> 5) + 1;
        if (this.blocks >= n2) {
            return;
        }
        if (this.value.length >= n2) {
            int n3 = this.blocks;
            while (n3 < n2) {
                this.value[n3] = 0;
                ++n3;
            }
            this.blocks = n2;
            return;
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.value, 0, nArray, 0, this.blocks);
        this.blocks = n2;
        this.value = null;
        this.value = nArray;
    }

    public GF2Polynomial gcd(GF2Polynomial gF2Polynomial) throws RuntimeException {
        if (this.isZero() && gF2Polynomial.isZero()) {
            throw new ArithmeticException("Both operands of gcd equal zero.");
        }
        if (this.isZero()) {
            return new GF2Polynomial(gF2Polynomial);
        }
        if (gF2Polynomial.isZero()) {
            return new GF2Polynomial(this);
        }
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this);
        GF2Polynomial gF2Polynomial3 = new GF2Polynomial(gF2Polynomial);
        while (!gF2Polynomial3.isZero()) {
            GF2Polynomial gF2Polynomial4 = gF2Polynomial2.remainder(gF2Polynomial3);
            gF2Polynomial2 = gF2Polynomial3;
            gF2Polynomial3 = gF2Polynomial4;
        }
        return gF2Polynomial2;
    }

    public int getBit(int n) {
        if (n < 0) {
            throw new RuntimeException();
        }
        if (n > this.len - 1) {
            return 0;
        }
        return (this.value[n >>> 5] & bitMask[n & 0x1F]) != 0 ? 1 : 0;
    }

    public int getLength() {
        return this.len;
    }

    public int hashCode() {
        return this.len + Arrays.hashCode(this.value);
    }

    public GF2Polynomial increase() {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this);
        gF2Polynomial.increaseThis();
        return gF2Polynomial;
    }

    public void increaseThis() {
        this.xorBit(0);
    }

    public boolean isIrreducible() {
        if (this.isZero()) {
            return false;
        }
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this);
        gF2Polynomial.reduceN();
        int n = gF2Polynomial.len - 1;
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(gF2Polynomial.len, "X");
        int n2 = 1;
        while (n2 <= n >> 1) {
            gF2Polynomial2.squareThisPreCalc();
            gF2Polynomial2 = gF2Polynomial2.remainder(gF2Polynomial);
            GF2Polynomial gF2Polynomial3 = gF2Polynomial2.add(new GF2Polynomial(32, "X"));
            if (!gF2Polynomial3.isZero()) {
                GF2Polynomial gF2Polynomial4 = gF2Polynomial.gcd(gF2Polynomial3);
                if (!gF2Polynomial4.isOne()) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isOne() {
        int n = 1;
        while (n < this.blocks) {
            if (this.value[n] != 0) {
                return false;
            }
            ++n;
        }
        return this.value[0] == 1;
    }

    public boolean isZero() {
        if (this.len == 0) {
            return true;
        }
        int n = 0;
        while (n < this.blocks) {
            if (this.value[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private GF2Polynomial karaMult(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.len << 1);
        if (this.len <= 32) {
            gF2Polynomial2.value = GF2Polynomial.mult32(this.value[0], gF2Polynomial.value[0]);
            return gF2Polynomial2;
        }
        if (this.len <= 64) {
            gF2Polynomial2.value = GF2Polynomial.mult64(this.value, gF2Polynomial.value);
            return gF2Polynomial2;
        }
        if (this.len <= 128) {
            gF2Polynomial2.value = GF2Polynomial.mult128(this.value, gF2Polynomial.value);
            return gF2Polynomial2;
        }
        if (this.len <= 256) {
            gF2Polynomial2.value = GF2Polynomial.mult256(this.value, gF2Polynomial.value);
            return gF2Polynomial2;
        }
        if (this.len <= 512) {
            gF2Polynomial2.value = GF2Polynomial.mult512(this.value, gF2Polynomial.value);
            return gF2Polynomial2;
        }
        int n = IntegerFunctions.floorLog(this.len - 1);
        n = bitMask[n];
        GF2Polynomial gF2Polynomial3 = this.lower((n - 1 >> 5) + 1);
        GF2Polynomial gF2Polynomial4 = this.upper((n - 1 >> 5) + 1);
        GF2Polynomial gF2Polynomial5 = gF2Polynomial.lower((n - 1 >> 5) + 1);
        GF2Polynomial gF2Polynomial6 = gF2Polynomial.upper((n - 1 >> 5) + 1);
        GF2Polynomial gF2Polynomial7 = gF2Polynomial4.karaMult(gF2Polynomial6);
        GF2Polynomial gF2Polynomial8 = gF2Polynomial3.karaMult(gF2Polynomial5);
        gF2Polynomial3.addToThis(gF2Polynomial4);
        gF2Polynomial5.addToThis(gF2Polynomial6);
        GF2Polynomial gF2Polynomial9 = gF2Polynomial3.karaMult(gF2Polynomial5);
        gF2Polynomial2.shiftLeftAddThis(gF2Polynomial7, n << 1);
        gF2Polynomial2.shiftLeftAddThis(gF2Polynomial7, n);
        gF2Polynomial2.shiftLeftAddThis(gF2Polynomial9, n);
        gF2Polynomial2.shiftLeftAddThis(gF2Polynomial8, n);
        gF2Polynomial2.addToThis(gF2Polynomial8);
        return gF2Polynomial2;
    }

    private GF2Polynomial lower(int n) {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(n << 5);
        System.arraycopy(this.value, 0, gF2Polynomial.value, 0, Math.min(n, this.blocks));
        return gF2Polynomial;
    }

    private static int[] mult128(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int[] nArray4 = new int[8];
        int[] nArray5 = new int[2];
        System.arraycopy(nArray, 0, nArray5, 0, Math.min(2, nArray.length));
        int[] nArray6 = new int[2];
        if (nArray.length > 2) {
            System.arraycopy(nArray, 2, nArray6, 0, Math.min(2, nArray.length - 2));
        }
        int[] nArray7 = new int[2];
        System.arraycopy(nArray2, 0, nArray7, 0, Math.min(2, nArray2.length));
        int[] nArray8 = new int[2];
        if (nArray2.length > 2) {
            System.arraycopy(nArray2, 2, nArray8, 0, Math.min(2, nArray2.length - 2));
        }
        if (nArray6[1] == 0 && nArray8[1] == 0) {
            if (nArray6[0] != 0 || nArray8[0] != 0) {
                nArray3 = GF2Polynomial.mult32(nArray6[0], nArray8[0]);
                nArray4[5] = nArray4[5] ^ nArray3[1];
                nArray4[4] = nArray4[4] ^ nArray3[0];
                nArray4[3] = nArray4[3] ^ nArray3[1];
                nArray4[2] = nArray4[2] ^ nArray3[0];
            }
        } else {
            nArray3 = GF2Polynomial.mult64(nArray6, nArray8);
            nArray4[7] = nArray4[7] ^ nArray3[3];
            nArray4[6] = nArray4[6] ^ nArray3[2];
            nArray4[5] = nArray4[5] ^ (nArray3[1] ^ nArray3[3]);
            nArray4[4] = nArray4[4] ^ (nArray3[0] ^ nArray3[2]);
            nArray4[3] = nArray4[3] ^ nArray3[1];
            nArray4[2] = nArray4[2] ^ nArray3[0];
        }
        nArray6[0] = nArray6[0] ^ nArray5[0];
        nArray6[1] = nArray6[1] ^ nArray5[1];
        nArray8[0] = nArray8[0] ^ nArray7[0];
        nArray8[1] = nArray8[1] ^ nArray7[1];
        if (nArray6[1] == 0 && nArray8[1] == 0) {
            nArray3 = GF2Polynomial.mult32(nArray6[0], nArray8[0]);
            nArray4[3] = nArray4[3] ^ nArray3[1];
            nArray4[2] = nArray4[2] ^ nArray3[0];
        } else {
            nArray3 = GF2Polynomial.mult64(nArray6, nArray8);
            nArray4[5] = nArray4[5] ^ nArray3[3];
            nArray4[4] = nArray4[4] ^ nArray3[2];
            nArray4[3] = nArray4[3] ^ nArray3[1];
            nArray4[2] = nArray4[2] ^ nArray3[0];
        }
        if (nArray5[1] == 0 && nArray7[1] == 0) {
            nArray3 = GF2Polynomial.mult32(nArray5[0], nArray7[0]);
            nArray4[3] = nArray4[3] ^ nArray3[1];
            nArray4[2] = nArray4[2] ^ nArray3[0];
            nArray4[1] = nArray4[1] ^ nArray3[1];
            nArray4[0] = nArray4[0] ^ nArray3[0];
        } else {
            nArray3 = GF2Polynomial.mult64(nArray5, nArray7);
            nArray4[5] = nArray4[5] ^ nArray3[3];
            nArray4[4] = nArray4[4] ^ nArray3[2];
            nArray4[3] = nArray4[3] ^ (nArray3[1] ^ nArray3[3]);
            nArray4[2] = nArray4[2] ^ (nArray3[0] ^ nArray3[2]);
            nArray4[1] = nArray4[1] ^ nArray3[1];
            nArray4[0] = nArray4[0] ^ nArray3[0];
        }
        return nArray4;
    }

    private static int[] mult256(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int[] nArray4 = new int[16];
        int[] nArray5 = new int[4];
        System.arraycopy(nArray, 0, nArray5, 0, Math.min(4, nArray.length));
        int[] nArray6 = new int[4];
        if (nArray.length > 4) {
            System.arraycopy(nArray, 4, nArray6, 0, Math.min(4, nArray.length - 4));
        }
        int[] nArray7 = new int[4];
        System.arraycopy(nArray2, 0, nArray7, 0, Math.min(4, nArray2.length));
        int[] nArray8 = new int[4];
        if (nArray2.length > 4) {
            System.arraycopy(nArray2, 4, nArray8, 0, Math.min(4, nArray2.length - 4));
        }
        if (nArray6[3] == 0 && nArray6[2] == 0 && nArray8[3] == 0 && nArray8[2] == 0) {
            if (nArray6[1] == 0 && nArray8[1] == 0) {
                if (nArray6[0] != 0 || nArray8[0] != 0) {
                    nArray3 = GF2Polynomial.mult32(nArray6[0], nArray8[0]);
                    nArray4[9] = nArray4[9] ^ nArray3[1];
                    nArray4[8] = nArray4[8] ^ nArray3[0];
                    nArray4[5] = nArray4[5] ^ nArray3[1];
                    nArray4[4] = nArray4[4] ^ nArray3[0];
                }
            } else {
                nArray3 = GF2Polynomial.mult64(nArray6, nArray8);
                nArray4[11] = nArray4[11] ^ nArray3[3];
                nArray4[10] = nArray4[10] ^ nArray3[2];
                nArray4[9] = nArray4[9] ^ nArray3[1];
                nArray4[8] = nArray4[8] ^ nArray3[0];
                nArray4[7] = nArray4[7] ^ nArray3[3];
                nArray4[6] = nArray4[6] ^ nArray3[2];
                nArray4[5] = nArray4[5] ^ nArray3[1];
                nArray4[4] = nArray4[4] ^ nArray3[0];
            }
        } else {
            nArray3 = GF2Polynomial.mult128(nArray6, nArray8);
            nArray4[15] = nArray4[15] ^ nArray3[7];
            nArray4[14] = nArray4[14] ^ nArray3[6];
            nArray4[13] = nArray4[13] ^ nArray3[5];
            nArray4[12] = nArray4[12] ^ nArray3[4];
            nArray4[11] = nArray4[11] ^ (nArray3[3] ^ nArray3[7]);
            nArray4[10] = nArray4[10] ^ (nArray3[2] ^ nArray3[6]);
            nArray4[9] = nArray4[9] ^ (nArray3[1] ^ nArray3[5]);
            nArray4[8] = nArray4[8] ^ (nArray3[0] ^ nArray3[4]);
            nArray4[7] = nArray4[7] ^ nArray3[3];
            nArray4[6] = nArray4[6] ^ nArray3[2];
            nArray4[5] = nArray4[5] ^ nArray3[1];
            nArray4[4] = nArray4[4] ^ nArray3[0];
        }
        nArray6[0] = nArray6[0] ^ nArray5[0];
        nArray6[1] = nArray6[1] ^ nArray5[1];
        nArray6[2] = nArray6[2] ^ nArray5[2];
        nArray6[3] = nArray6[3] ^ nArray5[3];
        nArray8[0] = nArray8[0] ^ nArray7[0];
        nArray8[1] = nArray8[1] ^ nArray7[1];
        nArray8[2] = nArray8[2] ^ nArray7[2];
        nArray8[3] = nArray8[3] ^ nArray7[3];
        nArray3 = GF2Polynomial.mult128(nArray6, nArray8);
        nArray4[11] = nArray4[11] ^ nArray3[7];
        nArray4[10] = nArray4[10] ^ nArray3[6];
        nArray4[9] = nArray4[9] ^ nArray3[5];
        nArray4[8] = nArray4[8] ^ nArray3[4];
        nArray4[7] = nArray4[7] ^ nArray3[3];
        nArray4[6] = nArray4[6] ^ nArray3[2];
        nArray4[5] = nArray4[5] ^ nArray3[1];
        nArray4[4] = nArray4[4] ^ nArray3[0];
        int[] nArray9 = GF2Polynomial.mult128(nArray5, nArray7);
        nArray4[11] = nArray4[11] ^ nArray9[7];
        nArray4[10] = nArray4[10] ^ nArray9[6];
        nArray4[9] = nArray4[9] ^ nArray9[5];
        nArray4[8] = nArray4[8] ^ nArray9[4];
        nArray4[7] = nArray4[7] ^ (nArray9[3] ^ nArray9[7]);
        nArray4[6] = nArray4[6] ^ (nArray9[2] ^ nArray9[6]);
        nArray4[5] = nArray4[5] ^ (nArray9[1] ^ nArray9[5]);
        nArray4[4] = nArray4[4] ^ (nArray9[0] ^ nArray9[4]);
        nArray4[3] = nArray4[3] ^ nArray9[3];
        nArray4[2] = nArray4[2] ^ nArray9[2];
        nArray4[1] = nArray4[1] ^ nArray9[1];
        nArray4[0] = nArray4[0] ^ nArray9[0];
        return nArray4;
    }

    private static int[] mult32(int n, int n2) {
        int[] nArray = new int[2];
        if (n == 0 || n2 == 0) {
            return nArray;
        }
        long l = n2;
        l &= 0xFFFFFFFFL;
        long l2 = 0L;
        int n3 = 1;
        while (n3 <= 32) {
            if ((n & bitMask[n3 - 1]) != 0) {
                l2 ^= l;
            }
            l <<= 1;
            ++n3;
        }
        nArray[1] = (int)(l2 >>> 32);
        nArray[0] = (int)(l2 & 0xFFFFFFFFL);
        return nArray;
    }

    private static int[] mult512(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[32];
        int[] nArray4 = new int[8];
        System.arraycopy(nArray, 0, nArray4, 0, Math.min(8, nArray.length));
        int[] nArray5 = new int[8];
        if (nArray.length > 8) {
            System.arraycopy(nArray, 8, nArray5, 0, Math.min(8, nArray.length - 8));
        }
        int[] nArray6 = new int[8];
        System.arraycopy(nArray2, 0, nArray6, 0, Math.min(8, nArray2.length));
        int[] nArray7 = new int[8];
        if (nArray2.length > 8) {
            System.arraycopy(nArray2, 8, nArray7, 0, Math.min(8, nArray2.length - 8));
        }
        int[] nArray8 = GF2Polynomial.mult256(nArray5, nArray7);
        nArray3[31] = nArray3[31] ^ nArray8[15];
        nArray3[30] = nArray3[30] ^ nArray8[14];
        nArray3[29] = nArray3[29] ^ nArray8[13];
        nArray3[28] = nArray3[28] ^ nArray8[12];
        nArray3[27] = nArray3[27] ^ nArray8[11];
        nArray3[26] = nArray3[26] ^ nArray8[10];
        nArray3[25] = nArray3[25] ^ nArray8[9];
        nArray3[24] = nArray3[24] ^ nArray8[8];
        nArray3[23] = nArray3[23] ^ (nArray8[7] ^ nArray8[15]);
        nArray3[22] = nArray3[22] ^ (nArray8[6] ^ nArray8[14]);
        nArray3[21] = nArray3[21] ^ (nArray8[5] ^ nArray8[13]);
        nArray3[20] = nArray3[20] ^ (nArray8[4] ^ nArray8[12]);
        nArray3[19] = nArray3[19] ^ (nArray8[3] ^ nArray8[11]);
        nArray3[18] = nArray3[18] ^ (nArray8[2] ^ nArray8[10]);
        nArray3[17] = nArray3[17] ^ (nArray8[1] ^ nArray8[9]);
        nArray3[16] = nArray3[16] ^ (nArray8[0] ^ nArray8[8]);
        nArray3[15] = nArray3[15] ^ nArray8[7];
        nArray3[14] = nArray3[14] ^ nArray8[6];
        nArray3[13] = nArray3[13] ^ nArray8[5];
        nArray3[12] = nArray3[12] ^ nArray8[4];
        nArray3[11] = nArray3[11] ^ nArray8[3];
        nArray3[10] = nArray3[10] ^ nArray8[2];
        nArray3[9] = nArray3[9] ^ nArray8[1];
        nArray3[8] = nArray3[8] ^ nArray8[0];
        nArray5[0] = nArray5[0] ^ nArray4[0];
        nArray5[1] = nArray5[1] ^ nArray4[1];
        nArray5[2] = nArray5[2] ^ nArray4[2];
        nArray5[3] = nArray5[3] ^ nArray4[3];
        nArray5[4] = nArray5[4] ^ nArray4[4];
        nArray5[5] = nArray5[5] ^ nArray4[5];
        nArray5[6] = nArray5[6] ^ nArray4[6];
        nArray5[7] = nArray5[7] ^ nArray4[7];
        nArray7[0] = nArray7[0] ^ nArray6[0];
        nArray7[1] = nArray7[1] ^ nArray6[1];
        nArray7[2] = nArray7[2] ^ nArray6[2];
        nArray7[3] = nArray7[3] ^ nArray6[3];
        nArray7[4] = nArray7[4] ^ nArray6[4];
        nArray7[5] = nArray7[5] ^ nArray6[5];
        nArray7[6] = nArray7[6] ^ nArray6[6];
        nArray7[7] = nArray7[7] ^ nArray6[7];
        int[] nArray9 = GF2Polynomial.mult256(nArray5, nArray7);
        nArray3[23] = nArray3[23] ^ nArray9[15];
        nArray3[22] = nArray3[22] ^ nArray9[14];
        nArray3[21] = nArray3[21] ^ nArray9[13];
        nArray3[20] = nArray3[20] ^ nArray9[12];
        nArray3[19] = nArray3[19] ^ nArray9[11];
        nArray3[18] = nArray3[18] ^ nArray9[10];
        nArray3[17] = nArray3[17] ^ nArray9[9];
        nArray3[16] = nArray3[16] ^ nArray9[8];
        nArray3[15] = nArray3[15] ^ nArray9[7];
        nArray3[14] = nArray3[14] ^ nArray9[6];
        nArray3[13] = nArray3[13] ^ nArray9[5];
        nArray3[12] = nArray3[12] ^ nArray9[4];
        nArray3[11] = nArray3[11] ^ nArray9[3];
        nArray3[10] = nArray3[10] ^ nArray9[2];
        nArray3[9] = nArray3[9] ^ nArray9[1];
        nArray3[8] = nArray3[8] ^ nArray9[0];
        int[] nArray10 = GF2Polynomial.mult256(nArray4, nArray6);
        nArray3[23] = nArray3[23] ^ nArray10[15];
        nArray3[22] = nArray3[22] ^ nArray10[14];
        nArray3[21] = nArray3[21] ^ nArray10[13];
        nArray3[20] = nArray3[20] ^ nArray10[12];
        nArray3[19] = nArray3[19] ^ nArray10[11];
        nArray3[18] = nArray3[18] ^ nArray10[10];
        nArray3[17] = nArray3[17] ^ nArray10[9];
        nArray3[16] = nArray3[16] ^ nArray10[8];
        nArray3[15] = nArray3[15] ^ (nArray10[7] ^ nArray10[15]);
        nArray3[14] = nArray3[14] ^ (nArray10[6] ^ nArray10[14]);
        nArray3[13] = nArray3[13] ^ (nArray10[5] ^ nArray10[13]);
        nArray3[12] = nArray3[12] ^ (nArray10[4] ^ nArray10[12]);
        nArray3[11] = nArray3[11] ^ (nArray10[3] ^ nArray10[11]);
        nArray3[10] = nArray3[10] ^ (nArray10[2] ^ nArray10[10]);
        nArray3[9] = nArray3[9] ^ (nArray10[1] ^ nArray10[9]);
        nArray3[8] = nArray3[8] ^ (nArray10[0] ^ nArray10[8]);
        nArray3[7] = nArray3[7] ^ nArray10[7];
        nArray3[6] = nArray3[6] ^ nArray10[6];
        nArray3[5] = nArray3[5] ^ nArray10[5];
        nArray3[4] = nArray3[4] ^ nArray10[4];
        nArray3[3] = nArray3[3] ^ nArray10[3];
        nArray3[2] = nArray3[2] ^ nArray10[2];
        nArray3[1] = nArray3[1] ^ nArray10[1];
        nArray3[0] = nArray3[0] ^ nArray10[0];
        return nArray3;
    }

    private static int[] mult64(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int[] nArray4 = new int[4];
        int n = nArray[0];
        int n2 = 0;
        if (nArray.length > 1) {
            n2 = nArray[1];
        }
        int n3 = nArray2[0];
        int n4 = 0;
        if (nArray2.length > 1) {
            n4 = nArray2[1];
        }
        if (n2 != 0 || n4 != 0) {
            nArray3 = GF2Polynomial.mult32(n2, n4);
            nArray4[3] = nArray4[3] ^ nArray3[1];
            nArray4[2] = nArray4[2] ^ (nArray3[0] ^ nArray3[1]);
            nArray4[1] = nArray4[1] ^ nArray3[0];
        }
        nArray3 = GF2Polynomial.mult32(n ^ n2, n3 ^ n4);
        nArray4[2] = nArray4[2] ^ nArray3[1];
        nArray4[1] = nArray4[1] ^ nArray3[0];
        int[] nArray5 = GF2Polynomial.mult32(n, n3);
        nArray4[2] = nArray4[2] ^ nArray5[1];
        nArray4[1] = nArray4[1] ^ (nArray5[0] ^ nArray5[1]);
        nArray4[0] = nArray4[0] ^ nArray5[0];
        return nArray4;
    }

    public GF2Polynomial multiply(GF2Polynomial gF2Polynomial) {
        int n = Math.max(this.len, gF2Polynomial.len);
        this.expandN(n);
        gF2Polynomial.expandN(n);
        return this.karaMult(gF2Polynomial);
    }

    public GF2Polynomial multiplyClassic(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(Math.max(this.len, gF2Polynomial.len) << 1);
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[32];
        gF2PolynomialArray[0] = new GF2Polynomial(this);
        int n = 1;
        while (n <= 31) {
            gF2PolynomialArray[n] = gF2PolynomialArray[n - 1].shiftLeft();
            ++n;
        }
        n = 0;
        while (n < gF2Polynomial.blocks) {
            int n2 = 0;
            while (n2 <= 31) {
                if ((gF2Polynomial.value[n] & bitMask[n2]) != 0) {
                    gF2Polynomial2.xorThisBy(gF2PolynomialArray[n2]);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 <= 31) {
                gF2PolynomialArray[n2].shiftBlocksLeft();
                ++n2;
            }
            ++n;
        }
        return gF2Polynomial2;
    }

    public GF2Polynomial quotient(GF2Polynomial gF2Polynomial) throws RuntimeException {
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.len);
        GF2Polynomial gF2Polynomial3 = new GF2Polynomial(this);
        GF2Polynomial gF2Polynomial4 = new GF2Polynomial(gF2Polynomial);
        if (gF2Polynomial4.isZero()) {
            throw new RuntimeException();
        }
        gF2Polynomial3.reduceN();
        gF2Polynomial4.reduceN();
        if (gF2Polynomial3.len < gF2Polynomial4.len) {
            return new GF2Polynomial(0);
        }
        int n = gF2Polynomial3.len - gF2Polynomial4.len;
        gF2Polynomial2.expandN(n + 1);
        while (n >= 0) {
            GF2Polynomial gF2Polynomial5 = gF2Polynomial4.shiftLeft(n);
            gF2Polynomial3.subtractFromThis(gF2Polynomial5);
            gF2Polynomial3.reduceN();
            gF2Polynomial2.xorBit(n);
            n = gF2Polynomial3.len - gF2Polynomial4.len;
        }
        return gF2Polynomial2;
    }

    public void randomize() {
        int n = 0;
        while (n < this.blocks) {
            this.value[n] = rand.nextInt();
            ++n;
        }
        this.zeroUnusedBits();
    }

    public void randomize(Random random) {
        int n = 0;
        while (n < this.blocks) {
            this.value[n] = random.nextInt();
            ++n;
        }
        this.zeroUnusedBits();
    }

    public void reduceN() {
        int n = this.blocks - 1;
        while (this.value[n] == 0 && n > 0) {
            --n;
        }
        int n2 = this.value[n];
        int n3 = 0;
        while (n2 != 0) {
            n2 >>>= 1;
            ++n3;
        }
        this.len = (n << 5) + n3;
        this.blocks = n + 1;
    }

    void reducePentanomial(int n, int[] nArray) {
        long l;
        int n2 = n >>> 5;
        int n3 = 32 - (n & 0x1F);
        int n4 = n - nArray[0] >>> 5;
        int n5 = 32 - (n - nArray[0] & 0x1F);
        int n6 = n - nArray[1] >>> 5;
        int n7 = 32 - (n - nArray[1] & 0x1F);
        int n8 = n - nArray[2] >>> 5;
        int n9 = 32 - (n - nArray[2] & 0x1F);
        int n10 = (n << 1) - 2 >>> 5;
        int n11 = n2;
        int n12 = n10;
        while (n12 > n11) {
            l = (long)this.value[n12] & 0xFFFFFFFFL;
            int n13 = n12 - n2 - 1;
            this.value[n13] = this.value[n13] ^ (int)(l << n3);
            int n14 = n12 - n2;
            this.value[n14] = (int)((long)this.value[n14] ^ l >>> 32 - n3);
            int n15 = n12 - n4 - 1;
            this.value[n15] = this.value[n15] ^ (int)(l << n5);
            int n16 = n12 - n4;
            this.value[n16] = (int)((long)this.value[n16] ^ l >>> 32 - n5);
            int n17 = n12 - n6 - 1;
            this.value[n17] = this.value[n17] ^ (int)(l << n7);
            int n18 = n12 - n6;
            this.value[n18] = (int)((long)this.value[n18] ^ l >>> 32 - n7);
            int n19 = n12 - n8 - 1;
            this.value[n19] = this.value[n19] ^ (int)(l << n9);
            int n20 = n12 - n8;
            this.value[n20] = (int)((long)this.value[n20] ^ l >>> 32 - n9);
            this.value[n12] = 0;
            --n12;
        }
        l = (long)this.value[n11] & 0xFFFFFFFFL & 0xFFFFFFFFL << (n & 0x1F);
        this.value[0] = (int)((long)this.value[0] ^ l >>> 32 - n3);
        if (n11 - n4 - 1 >= 0) {
            int n21 = n11 - n4 - 1;
            this.value[n21] = this.value[n21] ^ (int)(l << n5);
        }
        int n22 = n11 - n4;
        this.value[n22] = (int)((long)this.value[n22] ^ l >>> 32 - n5);
        if (n11 - n6 - 1 >= 0) {
            int n23 = n11 - n6 - 1;
            this.value[n23] = this.value[n23] ^ (int)(l << n7);
        }
        int n24 = n11 - n6;
        this.value[n24] = (int)((long)this.value[n24] ^ l >>> 32 - n7);
        if (n11 - n8 - 1 >= 0) {
            int n25 = n11 - n8 - 1;
            this.value[n25] = this.value[n25] ^ (int)(l << n9);
        }
        int n26 = n11 - n8;
        this.value[n26] = (int)((long)this.value[n26] ^ l >>> 32 - n9);
        int n27 = n11;
        this.value[n27] = this.value[n27] & reverseRightMask[n & 0x1F];
        this.blocks = (n - 1 >>> 5) + 1;
        this.len = n;
    }

    void reduceTrinomial(int n, int n2) {
        long l;
        int n3 = n >>> 5;
        int n4 = 32 - (n & 0x1F);
        int n5 = n - n2 >>> 5;
        int n6 = 32 - (n - n2 & 0x1F);
        int n7 = (n << 1) - 2 >>> 5;
        int n8 = n3;
        int n9 = n7;
        while (n9 > n8) {
            l = (long)this.value[n9] & 0xFFFFFFFFL;
            int n10 = n9 - n3 - 1;
            this.value[n10] = this.value[n10] ^ (int)(l << n4);
            int n11 = n9 - n3;
            this.value[n11] = (int)((long)this.value[n11] ^ l >>> 32 - n4);
            int n12 = n9 - n5 - 1;
            this.value[n12] = this.value[n12] ^ (int)(l << n6);
            int n13 = n9 - n5;
            this.value[n13] = (int)((long)this.value[n13] ^ l >>> 32 - n6);
            this.value[n9] = 0;
            --n9;
        }
        l = (long)this.value[n8] & 0xFFFFFFFFL & 0xFFFFFFFFL << (n & 0x1F);
        this.value[0] = (int)((long)this.value[0] ^ l >>> 32 - n4);
        if (n8 - n5 - 1 >= 0) {
            int n14 = n8 - n5 - 1;
            this.value[n14] = this.value[n14] ^ (int)(l << n6);
        }
        int n15 = n8 - n5;
        this.value[n15] = (int)((long)this.value[n15] ^ l >>> 32 - n6);
        int n16 = n8;
        this.value[n16] = this.value[n16] & reverseRightMask[n & 0x1F];
        this.blocks = (n - 1 >>> 5) + 1;
        this.len = n;
    }

    public GF2Polynomial remainder(GF2Polynomial gF2Polynomial) throws RuntimeException {
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this);
        GF2Polynomial gF2Polynomial3 = new GF2Polynomial(gF2Polynomial);
        if (gF2Polynomial3.isZero()) {
            throw new RuntimeException();
        }
        gF2Polynomial2.reduceN();
        gF2Polynomial3.reduceN();
        if (gF2Polynomial2.len < gF2Polynomial3.len) {
            return gF2Polynomial2;
        }
        int n = gF2Polynomial2.len - gF2Polynomial3.len;
        while (n >= 0) {
            GF2Polynomial gF2Polynomial4 = gF2Polynomial3.shiftLeft(n);
            gF2Polynomial2.subtractFromThis(gF2Polynomial4);
            gF2Polynomial2.reduceN();
            n = gF2Polynomial2.len - gF2Polynomial3.len;
        }
        return gF2Polynomial2;
    }

    public void resetBit(int n) throws RuntimeException {
        if (n < 0) {
            throw new RuntimeException();
        }
        if (n > this.len - 1) {
            return;
        }
        int n2 = n >>> 5;
        this.value[n2] = this.value[n2] & ~bitMask[n & 0x1F];
    }

    public void setBit(int n) throws RuntimeException {
        if (n < 0 || n > this.len - 1) {
            throw new RuntimeException();
        }
        int n2 = n >>> 5;
        this.value[n2] = this.value[n2] | bitMask[n & 0x1F];
    }

    void shiftBlocksLeft() {
        ++this.blocks;
        this.len += 32;
        if (this.blocks <= this.value.length) {
            int n = this.blocks - 1;
            while (n >= 1) {
                this.value[n] = this.value[n - 1];
                --n;
            }
            this.value[0] = 0;
        } else {
            int[] nArray = new int[this.blocks];
            System.arraycopy(this.value, 0, nArray, 1, this.blocks - 1);
            this.value = null;
            this.value = nArray;
        }
    }

    public GF2Polynomial shiftLeft() {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.len + 1, this.value);
        int n = gF2Polynomial.blocks - 1;
        while (n >= 1) {
            int n2 = n;
            gF2Polynomial.value[n2] = gF2Polynomial.value[n2] << 1;
            int n3 = n;
            gF2Polynomial.value[n3] = gF2Polynomial.value[n3] | gF2Polynomial.value[n - 1] >>> 31;
            --n;
        }
        gF2Polynomial.value[0] = gF2Polynomial.value[0] << 1;
        return gF2Polynomial;
    }

    public GF2Polynomial shiftLeft(int n) {
        int n2;
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.len + n, this.value);
        if (n >= 32) {
            gF2Polynomial.doShiftBlocksLeft(n >>> 5);
        }
        if ((n2 = n & 0x1F) != 0) {
            int n3 = gF2Polynomial.blocks - 1;
            while (n3 >= 1) {
                int n4 = n3;
                gF2Polynomial.value[n4] = gF2Polynomial.value[n4] << n2;
                int n5 = n3;
                gF2Polynomial.value[n5] = gF2Polynomial.value[n5] | gF2Polynomial.value[n3 - 1] >>> 32 - n2;
                --n3;
            }
            gF2Polynomial.value[0] = gF2Polynomial.value[0] << n2;
        }
        return gF2Polynomial;
    }

    public void shiftLeftAddThis(GF2Polynomial gF2Polynomial, int n) {
        if (n == 0) {
            this.addToThis(gF2Polynomial);
            return;
        }
        this.expandN(gF2Polynomial.len + n);
        int n2 = n >>> 5;
        int n3 = gF2Polynomial.blocks - 1;
        while (n3 >= 0) {
            if (n3 + n2 + 1 < this.blocks && (n & 0x1F) != 0) {
                int n4 = n3 + n2 + 1;
                this.value[n4] = this.value[n4] ^ gF2Polynomial.value[n3] >>> 32 - (n & 0x1F);
            }
            int n5 = n3 + n2;
            this.value[n5] = this.value[n5] ^ gF2Polynomial.value[n3] << (n & 0x1F);
            --n3;
        }
    }

    public void shiftLeftThis() {
        if ((this.len & 0x1F) == 0) {
            ++this.len;
            ++this.blocks;
            if (this.blocks > this.value.length) {
                int[] nArray = new int[this.blocks];
                System.arraycopy(this.value, 0, nArray, 0, this.value.length);
                this.value = null;
                this.value = nArray;
            }
            int n = this.blocks - 1;
            while (n >= 1) {
                int n2 = n;
                this.value[n2] = this.value[n2] | this.value[n - 1] >>> 31;
                int n3 = n - 1;
                this.value[n3] = this.value[n3] << 1;
                --n;
            }
        } else {
            ++this.len;
            int n = this.blocks - 1;
            while (n >= 1) {
                int n4 = n;
                this.value[n4] = this.value[n4] << 1;
                int n5 = n;
                this.value[n5] = this.value[n5] | this.value[n - 1] >>> 31;
                --n;
            }
            this.value[0] = this.value[0] << 1;
        }
    }

    public GF2Polynomial shiftRight() {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.len - 1);
        System.arraycopy(this.value, 0, gF2Polynomial.value, 0, gF2Polynomial.blocks);
        int n = 0;
        while (n <= gF2Polynomial.blocks - 2) {
            int n2 = n;
            gF2Polynomial.value[n2] = gF2Polynomial.value[n2] >>> 1;
            int n3 = n;
            gF2Polynomial.value[n3] = gF2Polynomial.value[n3] | gF2Polynomial.value[n + 1] << 31;
            ++n;
        }
        int n4 = gF2Polynomial.blocks - 1;
        gF2Polynomial.value[n4] = gF2Polynomial.value[n4] >>> 1;
        if (gF2Polynomial.blocks < this.blocks) {
            int n5 = gF2Polynomial.blocks - 1;
            gF2Polynomial.value[n5] = gF2Polynomial.value[n5] | this.value[gF2Polynomial.blocks] << 31;
        }
        return gF2Polynomial;
    }

    public void shiftRightThis() {
        --this.len;
        this.blocks = (this.len - 1 >>> 5) + 1;
        int n = 0;
        while (n <= this.blocks - 2) {
            int n2 = n;
            this.value[n2] = this.value[n2] >>> 1;
            int n3 = n;
            this.value[n3] = this.value[n3] | this.value[n + 1] << 31;
            ++n;
        }
        int n4 = this.blocks - 1;
        this.value[n4] = this.value[n4] >>> 1;
        if ((this.len & 0x1F) == 0) {
            int n5 = this.blocks - 1;
            this.value[n5] = this.value[n5] | this.value[this.blocks] << 31;
        }
    }

    public void squareThisBitwise() {
        if (this.isZero()) {
            return;
        }
        int[] nArray = new int[this.blocks << 1];
        int n = this.blocks - 1;
        while (n >= 0) {
            int n2 = this.value[n];
            int n3 = 1;
            int n4 = 0;
            while (n4 < 16) {
                if ((n2 & 1) != 0) {
                    int n5 = n << 1;
                    nArray[n5] = nArray[n5] | n3;
                }
                if ((n2 & 0x10000) != 0) {
                    int n6 = (n << 1) + 1;
                    nArray[n6] = nArray[n6] | n3;
                }
                n3 <<= 2;
                n2 >>>= 1;
                ++n4;
            }
            --n;
        }
        this.value = null;
        this.value = nArray;
        this.blocks = nArray.length;
        this.len = (this.len << 1) - 1;
    }

    public void squareThisPreCalc() {
        if (this.isZero()) {
            return;
        }
        if (this.value.length >= this.blocks << 1) {
            int n = this.blocks - 1;
            while (n >= 0) {
                this.value[(n << 1) + 1] = squaringTable[(this.value[n] & 0xFF0000) >>> 16] | squaringTable[(this.value[n] & 0xFF000000) >>> 24] << 16;
                this.value[n << 1] = squaringTable[this.value[n] & 0xFF] | squaringTable[(this.value[n] & 0xFF00) >>> 8] << 16;
                --n;
            }
            this.blocks <<= 1;
            this.len = (this.len << 1) - 1;
        } else {
            int[] nArray = new int[this.blocks << 1];
            int n = 0;
            while (n < this.blocks) {
                nArray[n << 1] = squaringTable[this.value[n] & 0xFF] | squaringTable[(this.value[n] & 0xFF00) >>> 8] << 16;
                nArray[(n << 1) + 1] = squaringTable[(this.value[n] & 0xFF0000) >>> 16] | squaringTable[(this.value[n] & 0xFF000000) >>> 24] << 16;
                ++n;
            }
            this.value = null;
            this.value = nArray;
            this.blocks <<= 1;
            this.len = (this.len << 1) - 1;
        }
    }

    public GF2Polynomial subtract(GF2Polynomial gF2Polynomial) {
        return this.xor(gF2Polynomial);
    }

    public void subtractFromThis(GF2Polynomial gF2Polynomial) {
        this.expandN(gF2Polynomial.len);
        this.xorThisBy(gF2Polynomial);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new RuntimeException();
        }
        if (n > this.len - 1) {
            return false;
        }
        return (this.value[n >>> 5] & bitMask[n & 0x1F]) != 0;
    }

    public byte[] toByteArray() {
        int n;
        int n2 = (this.len - 1 >> 3) + 1;
        int n3 = n2 & 3;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n4 < n2 >> 2) {
            n = n2 - (n4 << 2) - 1;
            byArray[n] = (byte)(this.value[n4] & 0xFF);
            byArray[n - 1] = (byte)((this.value[n4] & 0xFF00) >>> 8);
            byArray[n - 2] = (byte)((this.value[n4] & 0xFF0000) >>> 16);
            byArray[n - 3] = (byte)((this.value[n4] & 0xFF000000) >>> 24);
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            n = n3 - n4 - 1 << 3;
            byArray[n4] = (byte)((this.value[this.blocks - 1] & 255 << n) >>> n);
            ++n4;
        }
        return byArray;
    }

    public BigInteger toFlexiBigInt() {
        if (this.len == 0 || this.isZero()) {
            return new BigInteger(0, new byte[0]);
        }
        return new BigInteger(1, this.toByteArray());
    }

    public int[] toIntegerArray() {
        int[] nArray = new int[this.blocks];
        System.arraycopy(this.value, 0, nArray, 0, this.blocks);
        return nArray;
    }

    public String toString(int n) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        String[] stringArray = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
        String string = new String();
        if (n == 16) {
            int n2 = this.blocks - 1;
            while (n2 >= 0) {
                string = String.valueOf(string) + cArray[this.value[n2] >>> 28 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] >>> 24 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] >>> 20 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] >>> 16 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] >>> 12 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] >>> 8 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] >>> 4 & 0xF];
                string = String.valueOf(string) + cArray[this.value[n2] & 0xF];
                string = String.valueOf(string) + " ";
                --n2;
            }
        } else {
            int n3 = this.blocks - 1;
            while (n3 >= 0) {
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 28 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 24 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 20 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 16 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 12 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 8 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] >>> 4 & 0xF];
                string = String.valueOf(string) + stringArray[this.value[n3] & 0xF];
                string = String.valueOf(string) + " ";
                --n3;
            }
        }
        return string;
    }

    private GF2Polynomial upper(int n) {
        int n2 = Math.min(n, this.blocks - n);
        GF2Polynomial gF2Polynomial = new GF2Polynomial(n2 << 5);
        if (this.blocks >= n) {
            System.arraycopy(this.value, n, gF2Polynomial.value, 0, n2);
        }
        return gF2Polynomial;
    }

    public boolean vectorMult(GF2Polynomial gF2Polynomial) throws RuntimeException {
        boolean bl = false;
        if (this.len != gF2Polynomial.len) {
            throw new RuntimeException();
        }
        int n = 0;
        while (n < this.blocks) {
            int n2 = this.value[n] & gF2Polynomial.value[n];
            bl ^= parity[n2 & 0xFF];
            bl ^= parity[n2 >>> 8 & 0xFF];
            bl ^= parity[n2 >>> 16 & 0xFF];
            bl ^= parity[n2 >>> 24 & 0xFF];
            ++n;
        }
        return bl;
    }

    public GF2Polynomial xor(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        int n = Math.min(this.blocks, gF2Polynomial.blocks);
        if (this.len >= gF2Polynomial.len) {
            gF2Polynomial2 = new GF2Polynomial(this);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                gF2Polynomial2.value[n3] = gF2Polynomial2.value[n3] ^ gF2Polynomial.value[n2];
                ++n2;
            }
        } else {
            gF2Polynomial2 = new GF2Polynomial(gF2Polynomial);
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4;
                gF2Polynomial2.value[n5] = gF2Polynomial2.value[n5] ^ this.value[n4];
                ++n4;
            }
        }
        gF2Polynomial2.zeroUnusedBits();
        return gF2Polynomial2;
    }

    public void xorBit(int n) throws RuntimeException {
        if (n < 0 || n > this.len - 1) {
            throw new RuntimeException();
        }
        int n2 = n >>> 5;
        this.value[n2] = this.value[n2] ^ bitMask[n & 0x1F];
    }

    public void xorThisBy(GF2Polynomial gF2Polynomial) {
        int n = 0;
        while (n < Math.min(this.blocks, gF2Polynomial.blocks)) {
            int n2 = n;
            this.value[n2] = this.value[n2] ^ gF2Polynomial.value[n];
            ++n;
        }
        this.zeroUnusedBits();
    }

    private void zeroUnusedBits() {
        if ((this.len & 0x1F) != 0) {
            int n = this.blocks - 1;
            this.value[n] = this.value[n] & reverseRightMask[this.len & 0x1F];
        }
    }
}

