/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.BigEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public final class IntUtils {
    private IntUtils() {
    }

    public static int[] clone(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        boolean bl = true;
        int n = nArray.length - 1;
        while (n >= 0) {
            bl &= nArray[n] == nArray2[n];
            --n;
        }
        return bl;
    }

    public static void fill(int[] nArray, int n) {
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            nArray[n2] = n;
            --n2;
        }
    }

    private static int partition(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = nArray[n3];
        nArray[n3] = nArray[n2];
        nArray[n2] = n5;
        int n6 = n;
        int n7 = n;
        while (n7 < n2) {
            if (nArray[n7] <= n5) {
                n4 = nArray[n6];
                nArray[n6] = nArray[n7];
                nArray[n7] = n4;
                ++n6;
            }
            ++n7;
        }
        n4 = nArray[n6];
        nArray[n6] = nArray[n2];
        nArray[n2] = n4;
        return n6;
    }

    public static void quicksort(int[] nArray) {
        IntUtils.quicksort(nArray, 0, nArray.length - 1);
    }

    public static void quicksort(int[] nArray, int n, int n2) {
        if (n2 > n) {
            int n3 = IntUtils.partition(nArray, n, n2, n2);
            IntUtils.quicksort(nArray, n, n3 - 1);
            IntUtils.quicksort(nArray, n3 + 1, n2);
        }
    }

    public static int[] subArray(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2 - n];
        System.arraycopy(nArray, n, nArray2, 0, n2 - n);
        return nArray2;
    }

    public static String toHexString(int[] nArray) {
        return ByteUtils.toHexString(BigEndianConversions.toByteArray(nArray));
    }

    public static String toString(int[] nArray) {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = String.valueOf(string) + nArray[n] + " ";
            ++n;
        }
        return string;
    }
}

