/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;

public class Integers {
    public static final int BYTES = 4;
    public static final int SIZE = 32;
    private static final byte[] DEBRUIJN_TZ;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 31;
        byArray[2] = 27;
        byArray[3] = 1;
        byArray[4] = 28;
        byArray[5] = 13;
        byArray[6] = 23;
        byArray[7] = 2;
        byArray[8] = 29;
        byArray[9] = 21;
        byArray[10] = 19;
        byArray[11] = 14;
        byArray[12] = 24;
        byArray[13] = 16;
        byArray[14] = 3;
        byArray[15] = 7;
        byArray[16] = 30;
        byArray[17] = 26;
        byArray[18] = 12;
        byArray[19] = 22;
        byArray[20] = 20;
        byArray[21] = 18;
        byArray[22] = 15;
        byArray[23] = 6;
        byArray[24] = 25;
        byArray[25] = 11;
        byArray[26] = 17;
        byArray[27] = 5;
        byArray[28] = 10;
        byArray[29] = 4;
        byArray[30] = 9;
        byArray[31] = 8;
        DEBRUIJN_TZ = byArray;
    }

    public static int numberOfLeadingZeros(int n) {
        if (n <= 0) {
            return ~n >>> 26 & 0x20;
        }
        int n2 = 1;
        if (n >>> 16 == 0) {
            n2 += 16;
            n <<= 16;
        }
        if (n >>> 24 == 0) {
            n2 += 8;
            n <<= 8;
        }
        if (n >>> 28 == 0) {
            n2 += 4;
            n <<= 4;
        }
        if (n >>> 30 == 0) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    public static int numberOfTrailingZeros(int n) {
        byte by = DEBRUIJN_TZ[(n & -n) * 251226722 >>> 27];
        int n2 = (n & 0xFFFF | n >>> 16) - 1 >> 31;
        return by - n2;
    }

    public static int reverse(int n) {
        n = Bits.bitPermuteStepSimple(n, 0x55555555, 1);
        n = Bits.bitPermuteStepSimple(n, 0x33333333, 2);
        n = Bits.bitPermuteStepSimple(n, 0xF0F0F0F, 4);
        return Integers.reverseBytes(n);
    }

    public static int reverseBytes(int n) {
        return Integers.rotateLeft(n & 0xFF00FF00, 8) | Integers.rotateLeft(n & 0xFF00FF, 24);
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 ^ n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n >>> n2 ^ n << -n2;
    }

    public static Integer valueOf(int n) {
        return new Integer(n);
    }
}

