/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.path.test;

import java.security.Provider;
import java.security.Security;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ContentVerifierProviderBuilder;
import org.bouncycastle.cert.path.CertPath;
import org.bouncycastle.cert.path.CertPathValidation;
import org.bouncycastle.cert.path.CertPathValidationResult;
import org.bouncycastle.cert.path.validations.BasicConstraintsValidation;
import org.bouncycastle.cert.path.validations.KeyUsageValidation;
import org.bouncycastle.cert.path.validations.ParentCertIssuedValidation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class BasicConstraintsTest
extends SimpleTest {
    private static final byte[] ROOT_CA = Base64.decode((String)"MIIDVzCCAj+gAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwOjELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxEDAOBgNVBAMMB1Jvb3QgQ0EwIhgPMjAwMDAxMDEwMDAwMDBaGA8yNTAwMDEwMTAwMDAwMFowOjELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxEDAOBgNVBAMMB1Jvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC2kPDLm90ACXhVf3M7blnC/lNC42NSjukq67+JbBWDKXyxm4tjV+qR4GbqCDYLK00hxQ1if1Qle3eYUwnEB356P/CoH3NDlNPhy7m01H6Z6q2BDILT3OHSLX4dTMnrqCw7AsqVLP9nIb2ZH0yTGF5wAo+TMvHf88G51d05r2S21UEiG8/FC/idMbwqCn4NHrJqK1w+v6wh7Hd3FxelcZsfKLlOY9xHTwpWqCiQ97EoJ1RpBbyOWfBTnOX777LR4fil72eIEb6zsmq2694Xi9/TXTnMTcoZg7kBFDOdpB8+ImfHOpMaxIXeYBRUmOV23fKWnL1p8eQCI24RyoX2/lBrAgMBAAGjYzBhMB0GA1UdDgQWBBQoBOAp7AB+2f7NcYXlUgvFIdBmEzAfBgNVHSMEGDAWgBQoBOAp7AB+2f7NcYXlUgvFIdBmEzAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEAZca2ZPVBRS5U6QOWNiis88N/T5dAHKFXGHt4LxMXpzcL5G3B5eqIKgxzYCjPq7ssEoPQmnOdZbtwhPq2o9eoosTyt7iEjCpaRsF4YxWL+RaKf1ZcY1G2gC0Q0RPbiK2h27jtYVNpElx/lDW396srRwYWTDRSTuWReCQCJ08jzwuANHbJreEnQReLBMn/smwpBge270+9iVQ5Vvb1M0egDh/LOYHcD86XvBcPZ2Pzdg4Tz1CpzA/gyfLEZ9VQvVJgcHPGBaV+Vb42Wl9CIo3iW8ppVVsqhqAu7JPKb9+zm6Bf6RlKMurjhBw8duEfAFJRqRDxW4d2GUuoy7Pzkm5lUA==");
    public static final byte[] INTERMEDIATE_WITH_PATHLEN_0 = Base64.decode((String)"MIIDXTCCAkWgAwIBAgICEAIwDQYJKoZIhvcNAQELBQAwOjELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxEDAOBgNVBAMMB1Jvb3QgQ0EwIhgPMjAwMDAxMDEwMDAwMDBaGA8yMTAwMDEwMTAwMDAwMFowPTELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxEzARBgNVBAMMCkxhenkgQWRtaW4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDLMxhjZ34ybAIt8tRRbej7NYRP7cxA3GwTkl66zp+UoS4zyW11vi8xqpCEcvDXqZJba/39iwdZY1urtCGdbWTvOkTNPUaYiw0swXaTDe4ypI2895RRJhD34I/jCrcRXvA3uS12qIIeRXeYf5avC/hZcKIb9n2TKUqMvw91jylgxTnadgBAy/meGlmPS7GdLAdRu6Iy01X7yMMagWsICTmNm5EOwRIgCkihvYaI9xbZddfMD2hlJcMrSbs71fgOGjgmFkVJk+12UUtN48fwy4d7PniH3lxaasMdVVdGIh9F9+FyTRgd/jWOrSLAORJTsvdk2x0wOoqsZhU8YzNEhr+rAgMBAAGjZjBkMB0GA1UdDgQWBBQSn/hs/IrjHLu9DgFd+BScdoLKVDAfBgNVHSMEGDAWgBQoBOAp7AB+2f7NcYXlUgvFIdBmEzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEAtUhPwgwEfE1/1+0ZdRt6Mi6Ys9jkWy6xdvbxLJZIYs/D6w1qlAMxYxy/+UL6KFSmhszbXRwiUcGa7ogWtG++HYSwzvP6lZoW94d9F3hEtcR4abccwLlzY/2Na2KL7oG+/EjK1HKBptuwfaCrY7dyta1ZZmQ/X1OFYmW6XwKyEb7OBArp8cGfrAaEvAyZy9P07NwJ6rAcuBf0lOzGf30QiV1GMlqpDztvzWcu4QqogbQ7WvYyHTpdKBADq/aDLhWkRMxZSXUBVWhXs5n+psVBUcpAI0Bd+2dOw7wEM98CxLCgBCCLQ/afTZ4t+JbTO0rFxp9iL6Ry6dYpRKhzcu40hQ==");
    private static final byte[] SECOND_INTERMEDIATE = Base64.decode((String)"MIIDaTCCAlGgAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwPTELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxEzARBgNVBAMMCkxhenkgQWRtaW4wIhgPMjAwMDAxMDEwMDAwMDBaGA8yMTAwMDEwMTAwMDAwMFowSTELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxHzAdBgNVBAMMFlNoYWRvdyBJbnRlcm1lZGlhdGUgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC+mDkqD8PmUk2UFfGR5xrEXXR3ZbMc0lXGyu9CQ8xO407YTXaqC8Fq+aKfWi2jG7ELe1/7z0PHmizuOYsliB6IuamBmudH4mgDwrJ/TGERM9K9XqpT7wsILiOnGFpAFKZd8HDHhWrK4OqEq2NVfCk/AJnBeo0/8aubNIa7wZo0tSx5tktXm4Y3GEc1d29qQ5ssYvHBt0UolvTs3a1CYXkaf2eCdMtUHHHSmenp7TIicpF/2R8mG5BfSBk9lC5JDt+IEgU0+qrXfrnrBCF9vDv+H7f+2bPvFWoXTJzVkp9TXDfiB9fxGar4Rjm/n404fyQ1w+NTEf9ZZfOdsnG3Hkf5AgMBAAGjYzBhMB0GA1UdDgQWBBR71YnxSE32AVQLtqtkIrCTNcd/0jAfBgNVHSMEGDAWgBQSn/hs/IrjHLu9DgFd+BScdoLKVDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEAh9YuQktc51W7SFx9iBAjT4itBqb14ENPmg4irACNKP7XljYv+a4DIPfcTZ7TuznSeIeBzJ7SrvNM0PY0XJPBUuvMiGWJ/r/8EcOuoPmJUdvDeB8C864PM/ukC0RIBPvK/A+dFaEOe+hxpTsrDY8x+UrEcwgoKbpKFfH5ZWmt9p3IZWOdad+wSu1TbNC1iPkbNKQyIBb4K4eG0tb1Hn9MOV5oNN0BilN+O9eqMdswVpLSvuTF3vTuzlsuH8K8rKeoB5r8QU2CDmgp9LxIILlxc0WZxwSRj2iYRJTsfx/Ipmlhd5CLhylh5pG8r8/7K1TKLJv9tEi9KRbT1E8wUD674g==");
    private static final byte[] LEAF = Base64.decode((String)"MIIDVzCCAj+gAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwSTELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxHzAdBgNVBAMMFlNoYWRvdyBJbnRlcm1lZGlhdGUgQ0EwIhgPMjAwMDAxMDEwMDAwMDBaGA8yMTAwMDEwMTAwMDAwMFowPDELMAkGA1UEBhMCQkUxGTAXBgNVBAoMEEJhZCBQcmFjdGljZSBJbmMxEjAQBgNVBAMMCVNvbWUgRHVkZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMts+SnvA1CY+Yb16qulKPA/MnQY3+qLVHXsFoK8sAemFRls8PawxIE5hchYIGAgLQRQIDE2EaW6UBBturG/ZRkIZV29PM0v+nWVSnF3yXiJ8UayUQ6scdGy0Jgf4JvtLkVZqudv1w3bqpiGAzzk7nam49zkR+kGmKBCHddQs1DgMhTYfgB6xiqYJLBN3yK/o/GH0Wz5F/tzBfEWl6qmGgFMHEbfOzTKumELsIp36qzMNhULVlGfJj97/jS2T6FGDloUPo/y8ghcZCGEGKGDF6W5m5XS/eDkf9d8sRHBqx+KXIF96UQaoR4HgBQ+HepiChlU+EQ8u8fnkkqdQoYUK00CAwEAAaNSMFAwHQYDVR0OBBYEFElgP4sTTZUauvPVJ4B9IxXN9G+jMB8GA1UdIwQYMBaAFHvVifFITfYBVAu2q2QisJM1x3/SMA4GA1UdDwEB/wQEAwIGwDANBgkqhkiG9w0BAQsFAAOCAQEAKOvEO/leSCnh7yKk6gtOpC6oxnG54orCgrklHbePC86I6Mnx09UZ3L+SDWHdR+Nk1nEieyXyL7W9uv/f0J73O4dphigaVNDisWQFZB6h7wRoYkrW3oRTGLHSjHnJzdHj/4l+1ApZbOi+zFppAUiuASwUMU1aA9lcrKDzB47kBm5tRDp17wfwA1oG0z4RCkQYBNhBmUnnx23rhq+wwKjYD8d6ITpXp/LGKp08nJbdJJQ0HW5iJvu9j4R5Us/tQ74MW1Zlvk0TWcJ+Ms2vlwm4kl8tUBFj04XkVRIM+wjuaORO34k4Fe4ICVfCg2r9IhFTIOIWo8IdJ9hzTuhlaG9ooQ==");

    public String getName() {
        return "BasicConstraintsTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new BasicConstraintsTest());
    }

    public void performTest() throws Exception {
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(ROOT_CA);
        X509CertificateHolder x509CertificateHolder2 = new X509CertificateHolder(INTERMEDIATE_WITH_PATHLEN_0);
        X509CertificateHolder x509CertificateHolder3 = new X509CertificateHolder(SECOND_INTERMEDIATE);
        X509CertificateHolder x509CertificateHolder4 = new X509CertificateHolder(LEAF);
        CertPath certPath = new CertPath(new X509CertificateHolder[]{x509CertificateHolder4, x509CertificateHolder3, x509CertificateHolder2, x509CertificateHolder});
        JcaX509ContentVerifierProviderBuilder jcaX509ContentVerifierProviderBuilder = new JcaX509ContentVerifierProviderBuilder();
        CertPathValidation[] certPathValidationArray = new CertPathValidation[]{new ParentCertIssuedValidation(jcaX509ContentVerifierProviderBuilder), new BasicConstraintsValidation(), new KeyUsageValidation()};
        CertPathValidationResult certPathValidationResult = certPath.evaluate(certPathValidationArray);
        this.isTrue("Bad chain was accepted", certPathValidationResult.isValid() ^ true);
    }
}

