/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.path.test;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ContentVerifierProviderBuilder;
import org.bouncycastle.cert.path.CertPath;
import org.bouncycastle.cert.path.CertPathValidation;
import org.bouncycastle.cert.path.CertPathValidationResult;
import org.bouncycastle.cert.path.validations.BasicConstraintsValidation;
import org.bouncycastle.cert.path.validations.KeyUsageValidation;
import org.bouncycastle.cert.path.validations.ParentCertIssuedValidation;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PKITSBasicConstraintsTest
extends SimpleTest {
    public static final String PKITS_DATA_RESOURCE_PREFIX = "org/bouncycastle/cert/PKITS/certs/";
    static /* synthetic */ Class class$org$bouncycastle$cert$path$test$PKITSBasicConstraintsTest;

    private static CertPathValidationResult checkPKITSPath(String string, String[] stringArray) throws IOException {
        CertPath certPath = PKITSBasicConstraintsTest.readPKITSPath(string, stringArray);
        JcaX509ContentVerifierProviderBuilder jcaX509ContentVerifierProviderBuilder = new JcaX509ContentVerifierProviderBuilder();
        CertPathValidation[] certPathValidationArray = new CertPathValidation[]{new BasicConstraintsValidation(), new KeyUsageValidation(), new ParentCertIssuedValidation(jcaX509ContentVerifierProviderBuilder)};
        return certPath.validate(certPathValidationArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void expectBCValidationFailure(String string, String[] stringArray, String string2) throws IOException {
        CertPathValidationResult certPathValidationResult = PKITSBasicConstraintsTest.checkPKITSPath(string, stringArray);
        this.isTrue("Invalid path was accepted", certPathValidationResult.isValid() ^ true);
        String string3 = certPathValidationResult.getCause().getMessage();
        this.isEquals("Rejection reasons do not match: expected " + string2 + ", got " + string3, string2, string3);
    }

    private void expectBCValidationSuccess(String string, String[] stringArray) throws IOException {
        CertPathValidationResult certPathValidationResult = PKITSBasicConstraintsTest.checkPKITSPath(string, stringArray);
        this.isTrue("Valid path was rejected", certPathValidationResult.isValid());
    }

    public String getName() {
        return "PKITSBasicConstraintsTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PKITSBasicConstraintsTest());
    }

    public void performTest() throws Exception {
        this.expectBCValidationFailure("InvalidMissingbasicConstraintsTest1EE.crt", new String[]{"MissingbasicConstraintsCACert.crt"}, "Basic constraints violated: issuer is not a CA");
        CertPath certPath = PKITSBasicConstraintsTest.readPKITSPath("InvalidMissingbasicConstraintsTest1EE.crt", new String[]{"MissingbasicConstraintsCACert.crt"});
        CertPathValidation[] certPathValidationArray = new CertPathValidation[]{new BasicConstraintsValidation(false), new KeyUsageValidation(), new ParentCertIssuedValidation(new JcaX509ContentVerifierProviderBuilder())};
        this.isTrue(certPath.validate(certPathValidationArray).isValid());
        this.expectBCValidationFailure("InvalidcAFalseTest2EE.crt", new String[]{"basicConstraintsCriticalcAFalseCACert.crt"}, "Basic constraints violated: issuer is not a CA");
        this.expectBCValidationFailure("InvalidcAFalseTest3EE.crt", new String[]{"basicConstraintsNotCriticalcAFalseCACert.crt"}, "Basic constraints violated: issuer is not a CA");
        this.expectBCValidationSuccess("ValidbasicConstraintsNotCriticalTest4EE.crt", new String[]{"basicConstraintsNotCriticalCACert.crt"});
        this.expectBCValidationFailure("InvalidpathLenConstraintTest5EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0subCACert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest6EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0subCACert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationSuccess("ValidpathLenConstraintTest7EE.crt", new String[]{"pathLenConstraint0CACert.crt"});
        this.expectBCValidationSuccess("ValidpathLenConstraintTest8EE.crt", new String[]{"pathLenConstraint0CACert.crt"});
        this.expectBCValidationFailure("InvalidpathLenConstraintTest9EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA0Cert.crt", "pathLenConstraint6subsubCA00Cert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest10EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA0Cert.crt", "pathLenConstraint6subsubCA00Cert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest11EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA1Cert.crt", "pathLenConstraint6subsubCA11Cert.crt", "pathLenConstraint6subsubsubCA11XCert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationFailure("InvalidpathLenConstraintTest12EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA1Cert.crt", "pathLenConstraint6subsubCA11Cert.crt", "pathLenConstraint6subsubsubCA11XCert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationSuccess("ValidpathLenConstraintTest13EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA4Cert.crt", "pathLenConstraint6subsubCA41Cert.crt", "pathLenConstraint6subsubsubCA41XCert.crt"});
        this.expectBCValidationSuccess("ValidpathLenConstraintTest14EE.crt", new String[]{"pathLenConstraint6CACert.crt", "pathLenConstraint6subCA4Cert.crt", "pathLenConstraint6subsubCA41Cert.crt", "pathLenConstraint6subsubsubCA41XCert.crt"});
        this.expectBCValidationSuccess("ValidSelfIssuedpathLenConstraintTest15EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0SelfIssuedCACert.crt"});
        this.expectBCValidationFailure("InvalidSelfIssuedpathLenConstraintTest16EE.crt", new String[]{"pathLenConstraint0CACert.crt", "pathLenConstraint0SelfIssuedCACert.crt", "pathLenConstraint0subCA2Cert.crt"}, "Basic constraints violated: path length exceeded");
        this.expectBCValidationSuccess("ValidSelfIssuedpathLenConstraintTest17EE.crt", new String[]{"pathLenConstraint1CACert.crt", "pathLenConstraint1SelfIssuedCACert.crt", "pathLenConstraint1subCACert.crt", "pathLenConstraint1SelfIssuedsubCACert.crt"});
    }

    private static X509CertificateHolder readPKITSCert(String string) throws IOException {
        ClassLoader classLoader = (class$org$bouncycastle$cert$path$test$PKITSBasicConstraintsTest != null ? class$org$bouncycastle$cert$path$test$PKITSBasicConstraintsTest : (class$org$bouncycastle$cert$path$test$PKITSBasicConstraintsTest = PKITSBasicConstraintsTest.class$("org.bouncycastle.cert.path.test.PKITSBasicConstraintsTest"))).getClassLoader();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(classLoader.getResourceAsStream(PKITS_DATA_RESOURCE_PREFIX + string));
        return new X509CertificateHolder(Certificate.getInstance((Object)aSN1InputStream.readObject()));
    }

    private static CertPath readPKITSPath(String string, String[] stringArray) throws IOException {
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[stringArray.length + 2];
        x509CertificateHolderArray[x509CertificateHolderArray.length - 1] = PKITSBasicConstraintsTest.readPKITSCert("TrustAnchorRootCertificate.crt");
        x509CertificateHolderArray[0] = PKITSBasicConstraintsTest.readPKITSCert(string);
        int n = 0;
        while (n < stringArray.length) {
            x509CertificateHolderArray[x509CertificateHolderArray.length - 2 - n] = PKITSBasicConstraintsTest.readPKITSCert(stringArray[n]);
            ++n;
        }
        return new CertPath(x509CertificateHolderArray);
    }
}

