/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.operator.DigestCalculator;

class SHA256DigestCalculator
implements DigestCalculator {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    SHA256DigestCalculator() {
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
    }

    public byte[] getDigest() {
        byte[] byArray = this.bOut.toByteArray();
        this.bOut.reset();
        SHA256Digest sHA256Digest = new SHA256Digest();
        sHA256Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA256Digest.getDigestSize()];
        sHA256Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public OutputStream getOutputStream() {
        return this.bOut;
    }
}

