/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedData;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(cMSTypedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        Object object;
        RecipientInfoGenerator recipientInfoGenerator;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = this.recipientInfoGenerators.iterator();
        while (iterator.hasNext()) {
            recipientInfoGenerator = (RecipientInfoGenerator)iterator.next();
            aSN1EncodableVector.add((ASN1Encodable)recipientInfoGenerator.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString dEROctetString;
            OutputStream outputStream;
            BEROctetString bEROctetString;
            TeeOutputStream teeOutputStream;
            try {
                object = new ByteArrayOutputStream();
                teeOutputStream = new TeeOutputStream(digestCalculator.getOutputStream(), (OutputStream)object);
                cMSTypedData.write((OutputStream)teeOutputStream);
                teeOutputStream.close();
                bEROctetString = new BEROctetString(((ByteArrayOutputStream)object).toByteArray());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform digest calculation: " + iOException.getMessage(), iOException);
            }
            object = Collections.unmodifiableMap(this.getBaseParameters(cMSTypedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), macCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest()));
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            teeOutputStream = new DERSet(this.authGen.getAttributes((Map)object).toASN1EncodableVector());
            try {
                outputStream = macCalculator.getOutputStream();
                outputStream.write(teeOutputStream.getEncoded("DER"));
                outputStream.close();
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform MAC calculation: " + iOException.getMessage(), iOException);
            }
            outputStream = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes((Map)object).toASN1EncodableVector()) : null;
            ContentInfo contentInfo = new ContentInfo(cMSTypedData.getContentType(), (ASN1Encodable)bEROctetString);
            recipientInfoGenerator = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), contentInfo, (ASN1Set)teeOutputStream, (ASN1OctetString)dEROctetString, (ASN1Set)outputStream);
        } else {
            DEROctetString dEROctetString;
            BEROctetString bEROctetString;
            TeeOutputStream teeOutputStream;
            try {
                object = new ByteArrayOutputStream();
                teeOutputStream = new TeeOutputStream((OutputStream)object, macCalculator.getOutputStream());
                cMSTypedData.write((OutputStream)teeOutputStream);
                teeOutputStream.close();
                bEROctetString = new BEROctetString(((ByteArrayOutputStream)object).toByteArray());
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform MAC calculation: " + iOException.getMessage(), iOException);
            }
            object = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(new HashMap()).toASN1EncodableVector()) : null;
            teeOutputStream = new ContentInfo(cMSTypedData.getContentType(), (ASN1Encodable)bEROctetString);
            recipientInfoGenerator = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), null, (ContentInfo)teeOutputStream, null, (ASN1OctetString)dEROctetString, (ASN1Set)object);
        }
        object = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (ASN1Encodable)recipientInfoGenerator);
        return new CMSAuthenticatedData((ContentInfo)object, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }
}

