/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;

public class PKCS7ProcessableObject
implements CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final ASN1Encodable structure;

    public PKCS7ProcessableObject(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.type = aSN1ObjectIdentifier;
        this.structure = aSN1Encodable;
    }

    public Object getContent() {
        return this.structure;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        if (this.structure instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)this.structure);
            Iterator iterator = aSN1Sequence.iterator();
            while (iterator.hasNext()) {
                ASN1Encodable aSN1Encodable = (ASN1Encodable)iterator.next();
                outputStream.write(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            }
        } else {
            byte[] byArray = this.structure.toASN1Primitive().getEncoded("DER");
            int n = 1;
            while ((byArray[n] & 0xFF) > 127) {
                ++n;
            }
            outputStream.write(byArray, ++n, byArray.length - n);
        }
    }
}

