/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.util.Iterable;

public class RecipientInformationStore
implements Iterable {
    private final List all;
    private final Map table = new HashMap();

    public RecipientInformationStore(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            RecipientId recipientId = recipientInformation.getRID();
            ArrayList<RecipientInformation> arrayList = (ArrayList<RecipientInformation>)this.table.get(recipientId);
            if (arrayList == null) {
                arrayList = new ArrayList<RecipientInformation>(1);
                this.table.put(recipientId, arrayList);
            }
            arrayList.add(recipientInformation);
        }
        this.all = new ArrayList(collection);
    }

    public RecipientInformationStore(RecipientInformation recipientInformation) {
        this.all = new ArrayList(1);
        this.all.add(recipientInformation);
        RecipientId recipientId = recipientInformation.getRID();
        this.table.put(recipientId, this.all);
    }

    public RecipientInformation get(RecipientId recipientId) {
        Collection collection = this.getRecipients(recipientId);
        return collection.size() == 0 ? null : (RecipientInformation)collection.iterator().next();
    }

    public Collection getRecipients() {
        return new ArrayList(this.all);
    }

    public Collection getRecipients(RecipientId recipientId) {
        Object object;
        if (recipientId instanceof KeyTransRecipientId) {
            object = (KeyTransRecipientId)recipientId;
            X500Name x500Name = ((KeyTransRecipientId)object).getIssuer();
            byte[] byArray = ((KeyTransRecipientId)object).getSubjectKeyIdentifier();
            if (x500Name != null && byArray != null) {
                Collection collection;
                ArrayList arrayList = new ArrayList();
                Collection collection2 = this.getRecipients(new KeyTransRecipientId(x500Name, ((KeyTransRecipientId)object).getSerialNumber()));
                if (collection2 != null) {
                    arrayList.addAll(collection2);
                }
                if ((collection = this.getRecipients(new KeyTransRecipientId(byArray))) != null) {
                    arrayList.addAll(collection);
                }
                return arrayList;
            }
        }
        return (object = (ArrayList)this.table.get(recipientId)) == null ? new ArrayList() : new ArrayList(object);
    }

    public Iterator iterator() {
        return this.getRecipients().iterator();
    }

    public int size() {
        return this.all.size();
    }
}

