/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.jcajce;

import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jcajce.CompositePublicKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RawContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.io.TeeOutputStream;

public class JcaContentVerifierProviderBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public ContentVerifierProvider build(final PublicKey publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public ContentVerifier get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)MiscObjectIdentifiers.id_alg_composite)) {
                    return this.createCompositeVerifier(algorithmIdentifier, publicKey);
                }
                if (publicKey instanceof CompositePublicKey) {
                    List list = ((CompositePublicKey)publicKey).getPublicKeys();
                    int n = 0;
                    while (n != list.size()) {
                        try {
                            Signature signature = this.createSignature(algorithmIdentifier, (PublicKey)list.get(n));
                            Signature signature2 = this.createRawSig(algorithmIdentifier, (PublicKey)list.get(n));
                            if (signature2 != null) {
                                return new RawSigVerifier(algorithmIdentifier, signature, signature2);
                            }
                            return new SigVerifier(algorithmIdentifier, signature);
                        }
                        catch (OperatorCreationException operatorCreationException) {
                            ++n;
                        }
                    }
                    throw new OperatorCreationException("no matching algorithm found for key");
                }
                Signature signature = this.createSignature(algorithmIdentifier, publicKey);
                Signature signature3 = this.createRawSig(algorithmIdentifier, publicKey);
                if (signature3 != null) {
                    return new RawSigVerifier(algorithmIdentifier, signature, signature3);
                }
                return new SigVerifier(algorithmIdentifier, signature);
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public boolean hasAssociatedCertificate() {
                return false;
            }
        };
    }

    public ContentVerifierProvider build(final X509Certificate x509Certificate) throws OperatorCreationException {
        JcaX509CertificateHolder jcaX509CertificateHolder;
        try {
            jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new OperatorCreationException("cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        return new ContentVerifierProvider(){

            public ContentVerifier get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                Signature signature;
                if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)MiscObjectIdentifiers.id_alg_composite)) {
                    return this.createCompositeVerifier(algorithmIdentifier, x509Certificate.getPublicKey());
                }
                try {
                    signature = helper.createSignature(algorithmIdentifier);
                    signature.initVerify(x509Certificate.getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
                }
                Signature signature2 = this.createRawSig(algorithmIdentifier, x509Certificate.getPublicKey());
                if (signature2 != null) {
                    return new RawSigVerifier(algorithmIdentifier, signature, signature2);
                }
                return new SigVerifier(algorithmIdentifier, signature);
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return jcaX509CertificateHolder;
            }

            public boolean hasAssociatedCertificate() {
                return true;
            }
        };
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return this.build(this.helper.convertPublicKey(subjectPublicKeyInfo));
    }

    public ContentVerifierProvider build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.helper.convertCertificate(x509CertificateHolder));
    }

    private ContentVerifier createCompositeVerifier(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        if (publicKey instanceof CompositePublicKey) {
            List list = ((CompositePublicKey)publicKey).getPublicKeys();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)algorithmIdentifier.getParameters());
            Signature[] signatureArray = new Signature[aSN1Sequence.size()];
            int n = 0;
            while (n != aSN1Sequence.size()) {
                AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(n));
                signatureArray[n] = list.get(n) != null ? this.createSignature(algorithmIdentifier2, (PublicKey)list.get(n)) : null;
                ++n;
            }
            return new CompositeVerifier(signatureArray);
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)algorithmIdentifier.getParameters());
        Signature[] signatureArray = new Signature[aSN1Sequence.size()];
        int n = 0;
        while (n != aSN1Sequence.size()) {
            AlgorithmIdentifier algorithmIdentifier3 = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(n));
            try {
                signatureArray[n] = this.createSignature(algorithmIdentifier3, publicKey);
            }
            catch (Exception exception) {
                signatureArray[n] = null;
            }
            ++n;
        }
        return new CompositeVerifier(signatureArray);
    }

    private Signature createRawSig(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        Signature signature;
        try {
            signature = this.helper.createRawSignature(algorithmIdentifier);
            if (signature != null) {
                signature.initVerify(publicKey);
            }
        }
        catch (Exception exception) {
            signature = null;
        }
        return signature;
    }

    private Signature createSignature(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature signature = this.helper.createSignature(algorithmIdentifier);
            signature.initVerify(publicKey);
            return signature;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
        }
    }

    public JcaContentVerifierProviderBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    private class SigVerifier
    implements ContentVerifier {
        private final AlgorithmIdentifier algorithm;
        private final Signature signature;
        protected final OutputStream stream;

        SigVerifier(AlgorithmIdentifier algorithmIdentifier, Signature signature) {
            this.algorithm = algorithmIdentifier;
            this.signature = signature;
            this.stream = OutputStreamFactory.createStream((Signature)signature);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        public boolean verify(byte[] byArray) {
            try {
                return this.signature.verify(byArray);
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
            }
        }
    }

    private class RawSigVerifier
    extends SigVerifier
    implements RawContentVerifier {
        private Signature rawSignature;

        RawSigVerifier(AlgorithmIdentifier algorithmIdentifier, Signature signature, Signature signature2) {
            super(algorithmIdentifier, signature);
            this.rawSignature = signature2;
        }

        public boolean verify(byte[] byArray) {
            boolean bl;
            try {
                bl = super.verify(byArray);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.rawSignature.verify(byArray);
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                this.rawSignature.verify(byArray);
            }
            catch (Exception exception) {}
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean verify(byte[] byArray, byte[] byArray2) {
            boolean bl;
            try {
                try {
                    this.rawSignature.update(byArray);
                    bl = this.rawSignature.verify(byArray2);
                    Object var5_4 = null;
                }
                catch (SignatureException signatureException) {
                    throw new RuntimeOperatorException("exception obtaining raw signature: " + signatureException.getMessage(), signatureException);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    this.rawSignature.verify(byArray2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {}
            this.rawSignature.verify(byArray2);
            return bl;
        }
    }

    private class CompositeVerifier
    implements ContentVerifier {
        private Signature[] sigs;
        private OutputStream stream;

        public CompositeVerifier(Signature[] signatureArray) throws OperatorCreationException {
            this.sigs = signatureArray;
            int n = 0;
            while (n < signatureArray.length && signatureArray[n] == null) {
                ++n;
            }
            if (n == signatureArray.length) {
                throw new OperatorCreationException("no matching signature found in composite");
            }
            this.stream = OutputStreamFactory.createStream((Signature)signatureArray[n]);
            int n2 = n + 1;
            while (n2 != signatureArray.length) {
                if (signatureArray[n2] != null) {
                    this.stream = new TeeOutputStream(this.stream, OutputStreamFactory.createStream((Signature)signatureArray[n2]));
                }
                ++n2;
            }
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(MiscObjectIdentifiers.id_alg_composite);
        }

        public OutputStream getOutputStream() {
            return this.stream;
        }

        public boolean verify(byte[] byArray) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)byArray);
                boolean bl = false;
                int n = 0;
                while (n != aSN1Sequence.size()) {
                    if (this.sigs[n] != null && !this.sigs[n].verify(ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(n)).getBytes())) {
                        bl = true;
                    }
                    ++n;
                }
                return bl ^ true;
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
            }
        }
    }
}

