/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.ers.BinaryTreeRootCalculator;
import org.bouncycastle.tsp.ers.ERSArchiveTimeStamp;
import org.bouncycastle.tsp.ers.ERSData;
import org.bouncycastle.tsp.ers.ERSDataGroup;
import org.bouncycastle.tsp.ers.ERSException;
import org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.util.Arrays;

public class ERSArchiveTimeStampGenerator {
    private final DigestCalculator digCalc;
    private List dataObjects = new ArrayList();
    private ERSRootNodeCalculator rootNodeCalculator = new BinaryTreeRootCalculator();

    public ERSArchiveTimeStampGenerator(DigestCalculator digestCalculator) {
        this.digCalc = digestCalculator;
    }

    public void addAllData(List list) {
        this.dataObjects.addAll(list);
    }

    public void addData(ERSData eRSData) {
        this.dataObjects.add(eRSData);
    }

    public ERSArchiveTimeStamp generateArchiveTimeStamp(TimeStampResponse timeStampResponse) throws TSPException, ERSException {
        PartialHashtree[] partialHashtreeArray = this.getPartialHashtrees();
        byte[] byArray = this.rootNodeCalculator.computeRootHash(this.digCalc, partialHashtreeArray);
        TSTInfo tSTInfo = timeStampResponse.getTimeStampToken().getTimeStampInfo().toASN1Structure();
        if (!tSTInfo.getMessageImprint().getHashAlgorithm().equals((Object)this.digCalc.getAlgorithmIdentifier())) {
            throw new ERSException("time stamp imprint for wrong algorithm");
        }
        if (!Arrays.areEqual((byte[])tSTInfo.getMessageImprint().getHashedMessage(), (byte[])byArray)) {
            throw new ERSException("time stamp imprint for wrong root hash");
        }
        ArchiveTimeStamp archiveTimeStamp = partialHashtreeArray.length == 1 ? new ArchiveTimeStamp(null, null, timeStampResponse.getTimeStampToken().toCMSSignedData().toASN1Structure()) : new ArchiveTimeStamp(this.digCalc.getAlgorithmIdentifier(), partialHashtreeArray, timeStampResponse.getTimeStampToken().toCMSSignedData().toASN1Structure());
        return new ERSArchiveTimeStamp(archiveTimeStamp, this.digCalc, this.rootNodeCalculator);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator timeStampRequestGenerator) throws TSPException, IOException {
        PartialHashtree[] partialHashtreeArray = this.getPartialHashtrees();
        byte[] byArray = this.rootNodeCalculator.computeRootHash(this.digCalc, partialHashtreeArray);
        return timeStampRequestGenerator.generate(this.digCalc.getAlgorithmIdentifier(), byArray);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator timeStampRequestGenerator, BigInteger bigInteger) throws TSPException, IOException {
        PartialHashtree[] partialHashtreeArray = this.getPartialHashtrees();
        byte[] byArray = this.rootNodeCalculator.computeRootHash(this.digCalc, partialHashtreeArray);
        return timeStampRequestGenerator.generate(this.digCalc.getAlgorithmIdentifier(), byArray, bigInteger);
    }

    private PartialHashtree[] getPartialHashtrees() {
        List list = ERSUtil.buildHashList(this.digCalc, this.dataObjects);
        PartialHashtree[] partialHashtreeArray = new PartialHashtree[list.size()];
        HashSet<ERSDataGroup> hashSet = new HashSet<ERSDataGroup>();
        int n = 0;
        while (n != this.dataObjects.size()) {
            if (this.dataObjects.get(n) instanceof ERSDataGroup) {
                hashSet.add((ERSDataGroup)this.dataObjects.get(n));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 != list.size()) {
            byte[] byArray = (byte[])list.get(n2);
            ERSDataGroup eRSDataGroup = null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ERSDataGroup eRSDataGroup2 = (ERSDataGroup)iterator.next();
                byte[] byArray2 = eRSDataGroup2.getHash(this.digCalc);
                if (!Arrays.areEqual((byte[])byArray2, (byte[])byArray)) continue;
                List list2 = eRSDataGroup2.getHashes(this.digCalc);
                partialHashtreeArray[n2] = new PartialHashtree((byte[][])list2.toArray((T[])new byte[list2.size()][]));
                eRSDataGroup = eRSDataGroup2;
                break;
            }
            if (eRSDataGroup == null) {
                partialHashtreeArray[n2] = new PartialHashtree(byArray);
            } else {
                hashSet.remove(eRSDataGroup);
            }
            ++n2;
        }
        return partialHashtreeArray;
    }
}

