/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSSVerifier;

public class BcTlsDSAVerifier
extends BcTlsDSSVerifier {
    public BcTlsDSAVerifier(BcTlsCrypto crypto, DSAPublicKeyParameters publicKey) {
        super(crypto, (AsymmetricKeyParameter)publicKey);
    }

    @Override
    protected DSA createDSAImpl(int cryptoHashAlgorithm) {
        return new DSASigner((DSAKCalculator)new HMacDSAKCalculator(this.crypto.createDigest(cryptoHashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 2;
    }
}

