/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsEd448Verifier
extends BcTlsVerifier {
    public BcTlsEd448Verifier(BcTlsCrypto crypto, Ed448PublicKeyParameters publicKey) {
        super(crypto, (AsymmetricKeyParameter)publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != 2056) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        Ed448Signer verifier = new Ed448Signer(TlsUtils.EMPTY_BYTES);
        verifier.init(false, (CipherParameters)this.publicKey);
        return new BcTlsStreamVerifier((Signer)verifier, signature.getSignature());
    }
}

