/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private Signature rawVerifier = null;

    public JcaTlsRSAVerifier(JcaTlsCrypto crypto, PublicKey publicKey) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) throws IOException {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive() && this.isSunMSCAPIRawVerifier()) {
            return this.crypto.createStreamVerifier(signature, this.publicKey);
        }
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws IOException {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        try {
            Signature verifier = this.getRawVerifier();
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException("Invalid algorithm: " + algorithm);
                }
                AlgorithmIdentifier algID = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE);
                byte[] digestInfo = new DigestInfo(algID, hash).getEncoded();
                verifier.update(digestInfo, 0, digestInfo.length);
            } else {
                verifier.update(hash, 0, hash.length);
            }
            return verifier.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }

    protected Signature getRawVerifier() throws GeneralSecurityException {
        if (this.rawVerifier == null) {
            this.rawVerifier = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawVerifier.initVerify(this.publicKey);
        }
        return this.rawVerifier;
    }

    protected boolean isSunMSCAPIRawVerifier() throws IOException {
        try {
            Signature rawVerifier = this.getRawVerifier();
            return JcaUtils.isSunMSCAPIProvider(rawVerifier.getProvider());
        }
        catch (GeneralSecurityException e) {
            return true;
        }
    }
}

