/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final byte[] ZEROES = new byte[15];
    protected final Cipher cipher;
    protected final Mac mac;
    protected final int cipherMode;
    protected SecretKey cipherKey;
    protected byte[] additionalData;

    public JceChaCha20Poly1305(JcaJceHelper helper, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = helper.createCipher("ChaCha7539");
        this.mac = helper.createMac("Poly1305");
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        try {
            boolean badMac;
            if (this.cipherMode == 1) {
                int ciphertextLength = inputLength;
                byte[] tmp = new byte[64 + ciphertextLength];
                System.arraycopy(input, inputOffset, tmp, 64, inputLength);
                this.runCipher(tmp);
                System.arraycopy(tmp, 64, output, outputOffset, ciphertextLength);
                this.initMAC(tmp);
                this.updateMAC(this.additionalData, 0, this.additionalData.length);
                this.updateMAC(tmp, 64, ciphertextLength);
                byte[] lengths = new byte[16];
                Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])lengths, (int)0);
                Pack.longToLittleEndian((long)((long)ciphertextLength & 0xFFFFFFFFL), (byte[])lengths, (int)8);
                this.mac.update(lengths, 0, 16);
                this.mac.doFinal(output, outputOffset + ciphertextLength);
                return ciphertextLength + 16;
            }
            int ciphertextLength = inputLength - 16;
            byte[] tmp = new byte[64 + ciphertextLength];
            System.arraycopy(input, inputOffset, tmp, 64, ciphertextLength);
            this.runCipher(tmp);
            this.initMAC(tmp);
            this.updateMAC(this.additionalData, 0, this.additionalData.length);
            this.updateMAC(input, inputOffset, ciphertextLength);
            byte[] expectedMac = new byte[16];
            Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])expectedMac, (int)0);
            Pack.longToLittleEndian((long)((long)ciphertextLength & 0xFFFFFFFFL), (byte[])expectedMac, (int)8);
            this.mac.update(expectedMac, 0, 16);
            this.mac.doFinal(expectedMac, 0);
            boolean bl = badMac = !TlsUtils.constantTimeAreEqual(16, expectedMac, 0, input, inputOffset + ciphertextLength);
            if (badMac) {
                throw new TlsFatalAlert(20);
            }
            System.arraycopy(tmp, 64, output, outputOffset, ciphertextLength);
            return ciphertextLength;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getOutputSize(int inputLength) {
        return this.cipherMode == 1 ? inputLength + 16 : inputLength - 16;
    }

    @Override
    public void init(byte[] nonce, int macSize, byte[] additionalData) throws IOException {
        if (nonce == null || nonce.length != 12 || macSize != 16) {
            throw new TlsFatalAlert(80);
        }
        try {
            this.cipher.init(this.cipherMode, (Key)this.cipherKey, new IvParameterSpec(nonce), null);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.additionalData = additionalData;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) throws IOException {
        this.cipherKey = new SecretKeySpec(key, keyOff, keyLen, "ChaCha7539");
    }

    protected void initMAC(byte[] firstBlock) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(firstBlock, 0, 32, "Poly1305"));
        for (int i = 0; i < 64; ++i) {
            firstBlock[i] = 0;
        }
    }

    protected void runCipher(byte[] buf) throws GeneralSecurityException {
        if (buf.length != this.cipher.doFinal(buf, 0, buf.length, buf, 0)) {
            throw new IllegalStateException();
        }
    }

    protected void updateMAC(byte[] buf, int off, int len) {
        this.mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            this.mac.update(ZEROES, 0, 16 - partial);
        }
    }
}

