/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.jcajce;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.jce.PrincipalUtil;

public class JcaX500NameUtil {
    public static X500Name getIssuer(X509Certificate x509Certificate) {
        try {
            return X500Name.getInstance((Object)PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate).getEncoded());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    public static X500Name getSubject(X509Certificate x509Certificate) {
        try {
            return X500Name.getInstance((Object)PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate).getEncoded());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    public static X500Name getIssuer(X500NameStyle x500NameStyle, X509Certificate x509Certificate) {
        try {
            return X500Name.getInstance((X500NameStyle)x500NameStyle, (Object)PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate).getEncoded());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    public static X500Name getSubject(X500NameStyle x500NameStyle, X509Certificate x509Certificate) {
        try {
            return X500Name.getInstance((X500NameStyle)x500NameStyle, (Object)PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate).getEncoded());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }
}

