/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();
    private boolean isDefiniteLength = false;

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        super(digestAlgorithmIdentifierFinder);
    }

    public void setDefiniteLengthEncoding(boolean bl) {
        this.isDefiniteLength = bl;
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData) throws CMSException {
        return this.generate(cMSTypedData, false);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData, boolean bl) throws CMSException {
        Object object;
        SignerInfo signerInfo;
        Object object2;
        Object object3;
        Object object4;
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.digests.clear();
        Iterator iterator = this._signers.iterator();
        while (iterator.hasNext()) {
            object4 = (SignerInformation)iterator.next();
            CMSUtils.addDigestAlgs(hashSet, (SignerInformation)object4, this.digestAlgIdFinder);
            aSN1EncodableVector.add((ASN1Encodable)((SignerInformation)object4).toASN1Structure());
        }
        object4 = cMSTypedData.getContentType();
        Object object5 = null;
        if (cMSTypedData.getContent() != null) {
            object3 = null;
            if (bl) {
                object3 = new ByteArrayOutputStream();
            }
            object2 = CMSUtils.attachSignersToOutputStream(this.signerGens, object3);
            object2 = CMSUtils.getSafeOutputStream((OutputStream)object2);
            try {
                cMSTypedData.write((OutputStream)object2);
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                throw new CMSException("data processing exception: " + iOException.getMessage(), iOException);
            }
            if (bl) {
                object5 = this.isDefiniteLength ? new DEROctetString(((ByteArrayOutputStream)object3).toByteArray()) : new BEROctetString(((ByteArrayOutputStream)object3).toByteArray());
            }
        }
        object3 = this.signerGens.iterator();
        while (object3.hasNext()) {
            object2 = (SignerInfoGenerator)object3.next();
            signerInfo = ((SignerInfoGenerator)object2).generate((ASN1ObjectIdentifier)object4);
            hashSet.add(signerInfo.getDigestAlgorithm());
            aSN1EncodableVector.add((ASN1Encodable)signerInfo);
            object = ((SignerInfoGenerator)object2).getCalculatedDigest();
            if (object == null) continue;
            this.digests.put(signerInfo.getDigestAlgorithm().getAlgorithm().getId(), object);
        }
        object2 = null;
        if (this.certs.size() != 0) {
            object2 = this.isDefiniteLength ? CMSUtils.createDlSetFromList(this.certs) : CMSUtils.createBerSetFromList(this.certs);
        }
        signerInfo = null;
        if (this.crls.size() != 0) {
            signerInfo = this.isDefiniteLength ? CMSUtils.createDlSetFromList(this.crls) : CMSUtils.createBerSetFromList(this.crls);
        }
        object = new ContentInfo((ASN1ObjectIdentifier)object4, object5);
        SignedData signedData = new SignedData(CMSUtils.convertToDlSet(hashSet), object, (ASN1Set)object2, (ASN1Set)signerInfo, (ASN1Set)new DERSet(aSN1EncodableVector));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
        return new CMSSignedData((CMSProcessable)cMSTypedData, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signerInformation.getSignature()), false).getSignerInfos();
    }
}

