/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSStreamException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        super(digestAlgorithmIdentifierFinder);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl);
    }

    public OutputStream open(OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl, outputStream2);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl) throws IOException {
        return this.open(aSN1ObjectIdentifier, outputStream, bl, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        SignerInfoGenerator signerInfoGenerator;
        Object object;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((ASN1Primitive)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((ASN1Primitive)this.calculateVersion(aSN1ObjectIdentifier));
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
        Iterator iterator = this._signers.iterator();
        while (iterator.hasNext()) {
            object = (SignerInformation)iterator.next();
            CMSUtils.addDigestAlgs(hashSet, (SignerInformation)object, this.digestAlgIdFinder);
        }
        object = this.signerGens.iterator();
        while (object.hasNext()) {
            signerInfoGenerator = (SignerInfoGenerator)object.next();
            hashSet.add(signerInfoGenerator.getDigestAlgorithm());
        }
        bERSequenceGenerator2.getRawOutputStream().write(CMSUtils.convertToDlSet(hashSet).getEncoded());
        signerInfoGenerator = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        signerInfoGenerator.addObject((ASN1Primitive)aSN1ObjectIdentifier);
        OutputStream outputStream3 = bl ? CMSUtils.createBEROctetOutputStream(signerInfoGenerator.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream outputStream4 = CMSUtils.getSafeTeeOutputStream(outputStream2, outputStream3);
        OutputStream outputStream5 = CMSUtils.attachSignersToOutputStream(this.signerGens, outputStream4);
        return new CmsSignedDataOutputStream(outputStream5, aSN1ObjectIdentifier, bERSequenceGenerator, bERSequenceGenerator2, (BERSequenceGenerator)signerInfoGenerator);
    }

    public List getDigestAlgorithms() {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this._signers.iterator();
        while (iterator.hasNext()) {
            object2 = (SignerInformation)iterator.next();
            object = CMSSignedHelper.INSTANCE.fixDigestAlgID(((SignerInformation)object2).getDigestAlgorithmID(), this.digestAlgIdFinder);
            arrayList.add(object);
        }
        object2 = this.signerGens.iterator();
        while (object2.hasNext()) {
            object = (SignerInfoGenerator)object2.next();
            arrayList.add(((SignerInfoGenerator)object).getDigestAlgorithm());
        }
        return arrayList;
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Object e;
        Iterator iterator;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.certs != null) {
            iterator = this.certs.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new ASN1Integer(5L);
        }
        if (this.crls != null) {
            iterator = this.crls.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new ASN1Integer(5L);
        }
        if (bl4) {
            return new ASN1Integer(4L);
        }
        if (bl3) {
            return new ASN1Integer(3L);
        }
        if (this.checkForVersion3(this._signers, this.signerGens)) {
            return new ASN1Integer(3L);
        }
        if (!CMSObjectIdentifiers.data.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
            return new ASN1Integer(3L);
        }
        return new ASN1Integer(1L);
    }

    private boolean checkForVersion3(List list, List list2) {
        SignerInfo signerInfo;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            signerInfo = SignerInfo.getInstance((Object)((SignerInformation)iterator.next()).toASN1Structure());
            if (signerInfo.getVersion().intValueExact() != 3) continue;
            return true;
        }
        signerInfo = list2.iterator();
        while (signerInfo.hasNext()) {
            SignerInfoGenerator signerInfoGenerator = (SignerInfoGenerator)signerInfo.next();
            if (signerInfoGenerator.getGeneratedVersion() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, ASN1ObjectIdentifier aSN1ObjectIdentifier, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = aSN1ObjectIdentifier;
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            Object object;
            Object object2;
            ASN1Set aSN1Set;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (ASN1Encodable)aSN1Set).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (ASN1Encodable)aSN1Set).getEncoded());
            }
            aSN1Set = new ASN1EncodableVector();
            Iterator iterator = CMSSignedDataStreamGenerator.this.signerGens.iterator();
            while (iterator.hasNext()) {
                object2 = (SignerInfoGenerator)iterator.next();
                try {
                    aSN1Set.add((ASN1Encodable)((SignerInfoGenerator)object2).generate(this._contentOID));
                    object = ((SignerInfoGenerator)object2).getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(((SignerInfoGenerator)object2).getDigestAlgorithm().getAlgorithm().getId(), object);
                }
                catch (CMSException cMSException) {
                    throw new CMSStreamException("exception generating signers: " + cMSException.getMessage(), cMSException);
                }
            }
            object2 = CMSSignedDataStreamGenerator.this._signers.iterator();
            while (object2.hasNext()) {
                object = (SignerInformation)object2.next();
                aSN1Set.add((ASN1Encodable)((SignerInformation)object).toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet((ASN1EncodableVector)aSN1Set).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

