/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkix;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.math.Primes;
import org.bouncycastle.util.Strings;

public class SubjectPublicKeyInfoChecker {
    private static final Cache validatedQs = new Cache();
    private static final Cache validatedMods = new Cache();
    private static final BigInteger SMALL_PRIMES_PRODUCT = new BigInteger("8138e8a0fcf3a4e84a771d40fd305d7f4aa59306d7251de54d98af8fe95729a1f73d893fa424cd2edc8636a6c3285e022b0e3866a565ae8108eed8591cd4fe8d2ce86165a978d719ebf647f362d33fca29cd179fb42401cbaf3df0c614056f9c8f3cfd51e474afb6bc6974f78db8aba8e9e517fded658591ab7502bd41849462f", 16);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    public static void checkInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
            X962Parameters x962Parameters = X962Parameters.getInstance((Object)subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (x962Parameters.isImplicitlyCA() || x962Parameters.isNamedCurve()) {
                return;
            }
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)x962Parameters.getParameters());
            X9FieldID x9FieldID = X9FieldID.getInstance((Object)aSN1Sequence.getObjectAt(1));
            if (x9FieldID.getIdentifier().equals((ASN1Primitive)X9ObjectIdentifiers.prime_field)) {
                BigInteger bigInteger = ASN1Integer.getInstance((Object)x9FieldID.getParameters()).getValue();
                if (validatedQs.contains(bigInteger)) {
                    return;
                }
                int n = Properties.asInteger("org.bouncycastle.ec.fp_max_size", 1042);
                int n2 = Properties.asInteger("org.bouncycastle.ec.fp_certainty", 100);
                int n3 = bigInteger.bitLength();
                if (n < n3) {
                    throw new IllegalArgumentException("Fp q value out of range");
                }
                if (Primes.hasAnySmallFactors((BigInteger)bigInteger) || !Primes.isMRProbablePrime((BigInteger)bigInteger, (SecureRandom)CryptoServicesRegistrar.getSecureRandom(), (int)SubjectPublicKeyInfoChecker.getNumberOfIterations(n3, n2))) {
                    throw new IllegalArgumentException("Fp q value not prime");
                }
                validatedQs.add(bigInteger);
            }
        } else if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)aSN1ObjectIdentifier) || X509ObjectIdentifiers.id_ea_rsa.equals((ASN1Primitive)aSN1ObjectIdentifier) || PKCSObjectIdentifiers.id_RSAES_OAEP.equals((ASN1Primitive)aSN1ObjectIdentifier) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
            RSAPublicKey rSAPublicKey;
            try {
                rSAPublicKey = RSAPublicKey.getInstance((Object)subjectPublicKeyInfo.parsePublicKey());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to parse RSA key");
            }
            if ((rSAPublicKey.getPublicExponent().intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA publicExponent is even");
            }
            if (!validatedMods.contains(rSAPublicKey.getModulus())) {
                SubjectPublicKeyInfoChecker.validate(rSAPublicKey.getModulus());
                validatedMods.add(rSAPublicKey.getModulus());
            }
        }
    }

    private static void validate(BigInteger bigInteger) {
        int n;
        if ((bigInteger.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA modulus is even");
        }
        if (Properties.isOverrideSet("org.bouncycastle.rsa.allow_unsafe_mod")) {
            return;
        }
        int n2 = Properties.asInteger("org.bouncycastle.rsa.max_size", 15360);
        if (n2 < (n = bigInteger.bitLength())) {
            throw new IllegalArgumentException("modulus value out of range");
        }
        if (!bigInteger.gcd(SMALL_PRIMES_PRODUCT).equals(ONE)) {
            throw new IllegalArgumentException("RSA modulus has a small prime factor");
        }
        int n3 = bigInteger.bitLength() / 2;
        int n4 = n3 >= 1536 ? 3 : (n3 >= 1024 ? 4 : (n3 >= 512 ? 7 : 50));
        Primes.MROutput mROutput = Primes.enhancedMRProbablePrimeTest((BigInteger)bigInteger, (SecureRandom)CryptoServicesRegistrar.getSecureRandom(), (int)n4);
        if (!mROutput.isProvablyComposite()) {
            throw new IllegalArgumentException("RSA modulus is not composite");
        }
    }

    private static int getNumberOfIterations(int n, int n2) {
        if (n >= 1536) {
            return n2 <= 100 ? 3 : (n2 <= 128 ? 4 : 4 + (n2 - 128 + 1) / 2);
        }
        if (n >= 1024) {
            return n2 <= 100 ? 4 : (n2 <= 112 ? 5 : 5 + (n2 - 112 + 1) / 2);
        }
        if (n >= 512) {
            return n2 <= 80 ? 5 : (n2 <= 100 ? 7 : 7 + (n2 - 100 + 1) / 2);
        }
        return n2 <= 80 ? 40 : 40 + (n2 - 80 + 1) / 2;
    }

    public static boolean setThreadOverride(String string, boolean bl) {
        return Properties.setThreadOverride(string, bl);
    }

    public static boolean removeThreadOverride(String string) {
        return Properties.removeThreadOverride(string);
    }

    private static class Properties {
        private static final ThreadLocal threadProperties = new ThreadLocal();

        private Properties() {
        }

        static boolean isOverrideSet(String string) {
            try {
                return Properties.isSetTrue(Properties.getPropertyValue(string));
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }

        static boolean setThreadOverride(String string, boolean bl) {
            boolean bl2 = Properties.isOverrideSet(string);
            HashMap<String, String> hashMap = (HashMap<String, String>)threadProperties.get();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                threadProperties.set(hashMap);
            }
            hashMap.put(string, bl ? "true" : "false");
            return bl2;
        }

        static boolean removeThreadOverride(String string) {
            String string2;
            Map map = (Map)threadProperties.get();
            if (map != null && (string2 = (String)map.remove(string)) != null) {
                return "true".equals(Strings.toLowerCase((String)string2));
            }
            return false;
        }

        static int asInteger(String string, int n) {
            String string2 = Properties.getPropertyValue(string);
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
            return n;
        }

        static String getPropertyValue(final String string) {
            String string2;
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty(string);
                }
            });
            if (string3 != null) {
                return string3;
            }
            Map map = (Map)threadProperties.get();
            if (map != null && (string2 = (String)map.get(string)) != null) {
                return string2;
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction(string){
                private final /* synthetic */ String val$propertyName;
                {
                    this.val$propertyName = string;
                }

                public Object run() {
                    return System.getProperty(this.val$propertyName);
                }
            });
        }

        private static boolean isSetTrue(String string) {
            if (string == null || string.length() != 4) {
                return false;
            }
            return !(string.charAt(0) != 't' && string.charAt(0) != 'T' || string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E');
        }
    }

    private static class Cache {
        private final Map values = new WeakHashMap();
        private final BigInteger[] preserve = new BigInteger[8];
        private int preserveCounter = 0;

        private Cache() {
        }

        public synchronized void add(BigInteger bigInteger) {
            this.values.put(bigInteger, Boolean.TRUE);
            this.preserve[this.preserveCounter] = bigInteger;
            this.preserveCounter = (this.preserveCounter + 1) % this.preserve.length;
        }

        public synchronized boolean contains(BigInteger bigInteger) {
            return this.values.containsKey(bigInteger);
        }

        public synchronized int size() {
            return this.values.size();
        }

        public synchronized void clear() {
            this.values.clear();
            int n = 0;
            while (n != this.preserve.length) {
                this.preserve[n] = null;
                ++n;
            }
        }
    }
}

