/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.tsp.ers.ERSCachingData;
import org.bouncycastle.tsp.ers.ERSDataGroup;
import org.bouncycastle.tsp.ers.ERSFileData;

public class ERSDirectoryDataGroup
extends ERSDataGroup {
    public ERSDirectoryDataGroup(File file) throws FileNotFoundException {
        super(ERSDirectoryDataGroup.buildGroup(file));
    }

    private static List buildGroup(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            ArrayList<ERSCachingData> arrayList = new ArrayList<ERSCachingData>(fileArray.length);
            int n = 0;
            while (n != fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    if (fileArray[n].listFiles().length != 0) {
                        arrayList.add(new ERSDirectoryDataGroup(fileArray[n]));
                    }
                } else {
                    arrayList.add(new ERSFileData(fileArray[n]));
                }
                ++n;
            }
            return arrayList;
        }
        throw new IllegalArgumentException("file reference does not refer to directory");
    }

    public List getFiles() {
        ArrayList<ERSFileData> arrayList = new ArrayList<ERSFileData>();
        int n = 0;
        while (n != this.dataObjects.size()) {
            if (this.dataObjects.get(n) instanceof ERSFileData) {
                arrayList.add((ERSFileData)this.dataObjects.get(n));
            }
            ++n;
        }
        return arrayList;
    }

    public List getSubdirectories() {
        ArrayList<ERSDirectoryDataGroup> arrayList = new ArrayList<ERSDirectoryDataGroup>();
        int n = 0;
        while (n != this.dataObjects.size()) {
            if (this.dataObjects.get(n) instanceof ERSDirectoryDataGroup) {
                arrayList.add((ERSDirectoryDataGroup)this.dataObjects.get(n));
            }
            ++n;
        }
        return arrayList;
    }
}

