/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private Cipher c;
    private byte[] buf;
    private byte[] inBuf;
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private static final int INPUT_BUF_SIZE = 2048;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.c = cipher;
        this.buf = new byte[cipher.getOutputSize(2048)];
        this.inBuf = new byte[2048];
    }

    protected CipherInputStream(InputStream inputStream) {
        this(inputStream, new NullCipher());
    }

    private int nextChunk() throws IOException {
        int n = super.available();
        if (n <= 0) {
            n = 1;
        }
        if ((n = n > this.inBuf.length ? super.read(this.inBuf, 0, this.inBuf.length) : super.read(this.inBuf, 0, n)) < 0) {
            if (this.finalized) {
                return -1;
            }
            try {
                this.buf = this.c.doFinal();
            }
            catch (Exception exception) {
                throw new IOException("error processing stream: " + exception.toString());
            }
            this.bufOff = 0;
            this.maxBuf = this.buf != null ? this.buf.length : 0;
            this.finalized = true;
            if (this.bufOff == this.maxBuf) {
                return -1;
            }
        } else {
            this.bufOff = 0;
            try {
                this.maxBuf = this.c.update(this.inBuf, 0, n, this.buf, 0);
            }
            catch (Exception exception) {
                throw new IOException("error processing stream: " + exception.toString());
            }
            if (this.maxBuf == 0) {
                return this.nextChunk();
            }
        }
        return this.maxBuf;
    }

    public int read() throws IOException {
        if (this.bufOff == this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufOff == this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n3 = this.maxBuf - this.bufOff;
        if (n2 > n3) {
            System.arraycopy(this.buf, this.bufOff, byArray, n, n3);
            this.bufOff = this.maxBuf;
            return n3;
        }
        System.arraycopy(this.buf, this.bufOff, byArray, n, n2);
        this.bufOff += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.maxBuf - this.bufOff;
        if (l > (long)n) {
            this.bufOff = this.maxBuf;
            return n;
        }
        this.bufOff += (int)l;
        return (int)l;
    }

    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    public void close() throws IOException {
        if (!this.finalized) {
            this.finalized = true;
            try {
                this.c.doFinal();
            }
            catch (Exception exception) {
                throw new IOException("error processing stream: " + exception.toString());
            }
        }
        super.close();
    }

    public boolean markSupported() {
        return false;
    }
}

