/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DLOutputStream;

public class DLSet
extends ASN1Set {
    private int contentsLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DLSet(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector, false);
    }

    public DLSet(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray, false);
    }

    DLSet(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        super(bl, aSN1EncodableArray);
    }

    private int getContentsLength() throws IOException {
        if (this.contentsLength < 0) {
            int n = this.elements.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                ASN1Primitive aSN1Primitive = this.elements[n3].toASN1Primitive().toDLObject();
                n2 += aSN1Primitive.encodedLength(true);
                ++n3;
            }
            this.contentsLength = n2;
        }
        return this.contentsLength;
    }

    int encodedLength(boolean bl) throws IOException {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.getContentsLength());
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeIdentifier(bl, 49);
        DLOutputStream dLOutputStream = aSN1OutputStream.getDLSubStream();
        int n = this.elements.length;
        if (this.contentsLength >= 0 || n > 16) {
            aSN1OutputStream.writeDL(this.getContentsLength());
            int n2 = 0;
            while (n2 < n) {
                ((ASN1OutputStream)dLOutputStream).writePrimitive(this.elements[n2].toASN1Primitive(), true);
                ++n2;
            }
        } else {
            int n3 = 0;
            ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n];
            int n4 = 0;
            while (n4 < n) {
                ASN1Primitive aSN1Primitive;
                aSN1PrimitiveArray[n4] = aSN1Primitive = this.elements[n4].toASN1Primitive().toDLObject();
                n3 += aSN1Primitive.encodedLength(true);
                ++n4;
            }
            this.contentsLength = n3;
            aSN1OutputStream.writeDL(n3);
            int n5 = 0;
            while (n5 < n) {
                ((ASN1OutputStream)dLOutputStream).writePrimitive(aSN1PrimitiveArray[n5], true);
                ++n5;
            }
        }
    }

    ASN1Primitive toDLObject() {
        return this;
    }
}

