/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.x509;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.util.MessageDigestUtils;

class X509SignatureUtil {
    private static final Map algNames = new HashMap();
    private static final ASN1Null derNull;
    static /* synthetic */ Class class$java$security$spec$AlgorithmParameterSpec;

    X509SignatureUtil() {
    }

    static void setSignatureParameters(Signature signature, ASN1Encodable aSN1Encodable) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (aSN1Encodable != null && !derNull.equals(aSN1Encodable)) {
            AlgorithmParameters algorithmParameters;
            try {
                algorithmParameters = AlgorithmParameters.getInstance(signature.getAlgorithm(), signature.getProvider().getName());
                algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new SignatureException("exception decoding parameters: " + noSuchProviderException.getMessage());
            }
            catch (IOException iOException) {
                throw new SignatureException("IOException decoding parameters: " + iOException.getMessage());
            }
            if (signature.getAlgorithm().endsWith("MGF1")) {
                try {
                    signature.setParameter((AlgorithmParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = X509SignatureUtil.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SignatureException("Exception extracting parameters: " + generalSecurityException.getMessage());
                }
            }
        }
    }

    static String getSignatureName(AlgorithmIdentifier algorithmIdentifier) {
        String string;
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (aSN1Encodable != null && !derNull.equals(aSN1Encodable)) {
            if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
                RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(aSN1Encodable);
                return X509SignatureUtil.getDigestAlgName(rSASSAPSSparams.getHashAlgorithm().getAlgorithm()) + "withRSAandMGF1";
            }
            if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.ecdsa_with_SHA2)) {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Encodable);
                return X509SignatureUtil.getDigestAlgName((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)) + "withECDSA";
            }
        }
        if ((string = (String)algNames.get(algorithmIdentifier.getAlgorithm())) != null) {
            return string;
        }
        return X509SignatureUtil.findAlgName(algorithmIdentifier.getAlgorithm());
    }

    private static String getDigestAlgName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = MessageDigestUtils.getDigestName(aSN1ObjectIdentifier);
        int n = string.indexOf(45);
        if (n > 0 && !string.startsWith("SHA3")) {
            return string.substring(0, n) + string.substring(n + 1);
        }
        return MessageDigestUtils.getDigestName(aSN1ObjectIdentifier);
    }

    private static String findAlgName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Object object;
        Provider provider = Security.getProvider("BC");
        if (provider != null && (object = X509SignatureUtil.lookupAlg(provider, aSN1ObjectIdentifier)) != null) {
            return object;
        }
        object = Security.getProviders();
        int n = 0;
        while (n != ((Provider[])object).length) {
            String string;
            if (provider != object[n] && (string = X509SignatureUtil.lookupAlg(object[n], aSN1ObjectIdentifier)) != null) {
                return string;
            }
            ++n;
        }
        return aSN1ObjectIdentifier.getId();
    }

    private static String lookupAlg(Provider provider, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = ((Properties)provider).getProperty("Alg.Alias.Signature." + aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        string = ((Properties)provider).getProperty("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        algNames.put(EdECObjectIdentifiers.id_Ed25519, "Ed25519");
        algNames.put(EdECObjectIdentifiers.id_Ed448, "Ed448");
        algNames.put(OIWObjectIdentifiers.dsaWithSHA1, "SHA1withDSA");
        algNames.put(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1withDSA");
        derNull = DERNull.INSTANCE;
    }
}

