/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.keystore.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.jcajce.provider.util.DigestFactory;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

public class JKSKeyStoreSpi
extends KeyStoreSpi {
    private static final String NOT_IMPLEMENTED_MESSAGE = "BC JKS store is read-only and only supports certificate entries";
    private final Hashtable certificateEntries = new Hashtable();
    private final JcaJceHelper helper;

    public JKSKeyStoreSpi(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    public boolean engineProbe(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        return n == -17957139 && (n2 == 1 || n2 == 2);
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            BCJKSTrustedCertEntry bCJKSTrustedCertEntry = (BCJKSTrustedCertEntry)this.certificateEntries.get(string);
            if (bCJKSTrustedCertEntry != null) {
                Certificate certificate = bCJKSTrustedCertEntry.cert;
                return certificate;
            }
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            BCJKSTrustedCertEntry bCJKSTrustedCertEntry = (BCJKSTrustedCertEntry)this.certificateEntries.get(string);
            if (bCJKSTrustedCertEntry != null) {
                Date date = bCJKSTrustedCertEntry.date;
                return date;
            }
        }
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
    }

    public Enumeration engineAliases() {
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            Enumeration enumeration = this.certificateEntries.keys();
            return enumeration;
        }
    }

    public boolean engineContainsAlias(String string) {
        if (string == null) {
            throw new NullPointerException("alias value is null");
        }
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            boolean bl = this.certificateEntries.containsKey(string);
            return bl;
        }
    }

    public int engineSize() {
        return this.certificateEntries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            boolean bl = this.certificateEntries.containsKey(string);
            return bl;
        }
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            Map.Entry entry;
            Iterator iterator = this.certificateEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (!((BCJKSTrustedCertEntry)entry.getValue()).cert.equals(certificate)) continue;
                String string = (String)entry.getKey();
                return string;
            }
            entry = null;
            return entry;
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException(NOT_IMPLEMENTED_MESSAGE);
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream == null) {
            return;
        }
        ErasableByteStream erasableByteStream = this.validateStream(inputStream, cArray);
        Hashtable hashtable = this.certificateEntries;
        synchronized (hashtable) {
            try {
                DataInputStream dataInputStream = new DataInputStream(erasableByteStream);
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                if (n == -17957139) {
                    CertificateFactory certificateFactory = null;
                    Hashtable<String, CertificateFactory> hashtable2 = null;
                    switch (n2) {
                        case 1: {
                            certificateFactory = this.createCertFactory("X.509");
                            break;
                        }
                        case 2: {
                            hashtable2 = new Hashtable<String, CertificateFactory>();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unable to discern store version");
                        }
                    }
                    int n3 = dataInputStream.readInt();
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = dataInputStream.readInt();
                        switch (n5) {
                            case 1: {
                                throw new IOException(NOT_IMPLEMENTED_MESSAGE);
                            }
                            case 2: {
                                Object var20_20;
                                Certificate certificate;
                                String string = dataInputStream.readUTF();
                                Date date = new Date(dataInputStream.readLong());
                                if (n2 == 2) {
                                    String string2 = dataInputStream.readUTF();
                                    if (hashtable2.containsKey(string2)) {
                                        certificateFactory = (CertificateFactory)hashtable2.get(string2);
                                    } else {
                                        certificateFactory = this.createCertFactory(string2);
                                        hashtable2.put(string2, certificateFactory);
                                    }
                                }
                                int n6 = dataInputStream.readInt();
                                byte[] byArray = new byte[n6];
                                dataInputStream.readFully(byArray);
                                ErasableByteStream erasableByteStream2 = new ErasableByteStream(byArray, 0, byArray.length);
                                try {
                                    certificate = certificateFactory.generateCertificate(erasableByteStream2);
                                    if (erasableByteStream2.available() != 0) {
                                        throw new IOException("password incorrect or store tampered with");
                                    }
                                    var20_20 = null;
                                    erasableByteStream2.erase();
                                }
                                catch (Throwable throwable) {
                                    var20_20 = null;
                                    erasableByteStream2.erase();
                                    throw throwable;
                                }
                                this.certificateEntries.put(string, new BCJKSTrustedCertEntry(date, certificate));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("unable to discern entry type");
                            }
                        }
                        ++n4;
                    }
                }
                if (erasableByteStream.available() != 0) {
                    throw new IOException("password incorrect or store tampered with");
                }
                Object var22_22 = null;
                erasableByteStream.erase();
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                erasableByteStream.erase();
                throw throwable;
            }
        }
    }

    private CertificateFactory createCertFactory(String string) throws CertificateException {
        if (this.helper != null) {
            try {
                return this.helper.createCertificateFactory(string);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new CertificateException(noSuchProviderException.toString());
            }
        }
        return CertificateFactory.getInstance(string);
    }

    private void addPassword(Digest digest, char[] cArray) throws IOException {
        int n = 0;
        while (n < cArray.length) {
            digest.update((byte)(cArray[n] >> 8));
            digest.update((byte)cArray[n]);
            ++n;
        }
        digest.update(Strings.toByteArray("Mighty Aphrodite"), 0, 16);
    }

    private ErasableByteStream validateStream(InputStream inputStream, char[] cArray) throws IOException {
        Digest digest = DigestFactory.getDigest("SHA-1");
        byte[] byArray = Streams.readAll(inputStream);
        if (cArray != null) {
            this.addPassword(digest, cArray);
            digest.update(byArray, 0, byArray.length - digest.getDigestSize());
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.doFinal(byArray2, 0);
            byte[] byArray3 = new byte[byArray2.length];
            System.arraycopy(byArray, byArray.length - byArray2.length, byArray3, 0, byArray2.length);
            if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
                Arrays.fill(byArray, (byte)0);
                throw new IOException("password incorrect or store tampered with");
            }
            return new ErasableByteStream(byArray, 0, byArray.length - byArray2.length);
        }
        return new ErasableByteStream(byArray, 0, byArray.length - digest.getDigestSize());
    }

    private static final class ErasableByteStream
    extends ByteArrayInputStream {
        public ErasableByteStream(byte[] byArray, int n, int n2) {
            super(byArray, n, n2);
        }

        public void erase() {
            Arrays.fill(this.buf, (byte)0);
        }
    }

    private static final class BCJKSTrustedCertEntry {
        final Date date;
        final Certificate cert;

        public BCJKSTrustedCertEntry(Date date, Certificate certificate) {
            this.date = date;
            this.cert = certificate;
        }
    }
}

