/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertPathValidatorResult;
import org.bouncycastle.jce.cert.CertPathValidatorSpi;
import org.bouncycastle.jce.cert.CertUtil;

public class CertPathValidator {
    private CertPathValidatorSpi validatorSpi;
    private Provider provider;
    private String algorithm;

    protected CertPathValidator(CertPathValidatorSpi certPathValidatorSpi, Provider provider, String string) {
        this.validatorSpi = certPathValidatorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static CertPathValidator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathValidator", string, (String)null);
            if (implementation != null) {
                return new CertPathValidator((CertPathValidatorSpi)implementation.getEngine(), implementation.getProvider(), string);
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        throw new NoSuchAlgorithmException("can't find algorithm " + string);
    }

    public static CertPathValidator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathValidator", string, string2);
        if (implementation != null) {
            return new CertPathValidator((CertPathValidatorSpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new NoSuchAlgorithmException("can't find algorithm " + string);
    }

    public static CertPathValidator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathValidator", string, provider);
        if (implementation != null) {
            return new CertPathValidator((CertPathValidatorSpi)implementation.getEngine(), provider, string);
        }
        throw new NoSuchAlgorithmException("can't find algorithm " + string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final CertPathValidatorResult validate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        return this.validatorSpi.engineValidate(certPath, certPathParameters);
    }

    public static final String getDefaultType() {
        String string = null;
        string = Security.getProperty("certpathvalidator.type");
        if (string == null || string.length() <= 0) {
            return "PKIX";
        }
        return string;
    }
}

