/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.FixedPointUtil;
import org.bouncycastle.math.raw.Nat;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        int n2 = fixedPointPreCompInfo.getWidth();
        int n3 = (n + n2 - 1) / n2;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n4 = n3 * n2;
        int[] nArray = Nat.fromBigInteger(n4, bigInteger);
        int n5 = n4 - 1;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            int n8 = n5 - n6;
            while (n8 >= 0) {
                int n9 = nArray[n8 >>> 5] >>> (n8 & 0x1F);
                n7 ^= n9 >>> 1;
                n7 <<= 1;
                n7 ^= n9;
                n8 -= n3;
            }
            ECPoint eCPoint3 = eCLookupTable.lookup(n7);
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
            ++n6;
        }
        return eCPoint2.add(fixedPointPreCompInfo.getOffset());
    }
}

