/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;

public final class BigIntUtils {
    private BigIntUtils() {
    }

    public static boolean equals(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        int n = 0;
        if (bigIntegerArray.length != bigIntegerArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < bigIntegerArray.length) {
            n |= bigIntegerArray[n2].compareTo(bigIntegerArray2[n2]);
            ++n2;
        }
        return n == 0;
    }

    public static void fill(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        int n = bigIntegerArray.length - 1;
        while (n >= 0) {
            bigIntegerArray[n] = bigInteger;
            --n;
        }
    }

    public static BigInteger[] subArray(BigInteger[] bigIntegerArray, int n, int n2) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n2 - n];
        System.arraycopy(bigIntegerArray, n, bigIntegerArray2, 0, n2 - n);
        return bigIntegerArray2;
    }

    public static int[] toIntArray(BigInteger[] bigIntegerArray) {
        int[] nArray = new int[bigIntegerArray.length];
        int n = 0;
        while (n < bigIntegerArray.length) {
            nArray[n] = bigIntegerArray[n].intValue();
            ++n;
        }
        return nArray;
    }

    public static int[] toIntArrayModQ(int n, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.valueOf(n);
        int[] nArray = new int[bigIntegerArray.length];
        int n2 = 0;
        while (n2 < bigIntegerArray.length) {
            nArray[n2] = bigIntegerArray[n2].mod(bigInteger).intValue();
            ++n2;
        }
        return nArray;
    }

    public static byte[] toMinimalByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 || (bigInteger.bitLength() & 7) != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() >> 3];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

